// For Library Version: 1.120.20

declare module "sap/fe/macros/library" {}

declare module "sap/fe/macros/MacroAPI" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { IFormContent } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base API control for building blocks.
   */
  export default class MacroAPI extends Control implements IFormContent {
    __implements__sap_ui_core_IFormContent: boolean;

    constructor();
  }
  /**
   * Describes the settings that can be provided to the MacroAPI constructor.
   */
  export interface $MacroAPISettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/chart/ChartAPI" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import Context from "sap/ui/model/odata/v4/Context";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a chart based on the metadata provided by OData V4.
   *
   *
   * Usually, a contextPath and metaPath is expected.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Chart id="Mychart" contextPath="/RootEntity" metaPath="@com.sap.vocabularies.UI.v1.Chart" />
   * ```
   */
  export default class Chart extends MacroAPI {
    constructor();

    /**
     * Gets contexts from the chart that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
  }
  /**
   * Definition of a custom action to be used in the chart toolbar
   */
  export type Action = {
    /**
     * Reference to the key of another action already displayed in the toolbar to properly place this one
     */
    anchor: string;
    /**
     * Enables or disables the action
     */
    enabled: boolean;
    /**
     * Unique identifier of the action
     */
    key: string;
    /**
     * Defines where this action should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * Event handler to be called when the user chooses the action
     */
    press: string;
    /**
     * Defines if the action requires a selection.
     */
    requiresSelection: boolean;
    /**
     * The text that will be displayed for this action
     */
    text: string;
  };

  /**
   * Definition of a custom action group to be used inside the chart toolbar
   */
  export type ActionGroup = {
    /**
     * Defines nested actions
     */
    actions: Action[];
    /**
     * Reference to the key of another action or action group already displayed in the toolbar to properly place
     * this one
     */
    anchor: string;
    /**
     * Unique identifier of the action
     */
    key: string;
    /**
     * Defines where this action group should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * The text that will be displayed for this action group
     */
    text: string;
  };

  /**
   * Describes the settings that can be provided to the Chart constructor.
   */
  export interface $ChartSettings extends $MacroAPISettings {
    /**
     * Metadata path to the entitySet or navigationProperty
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * Id of the FilterBar building block associated with the chart.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Specifies the header text that is shown in the chart
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Metadata path to the presentation context (UI.Chart with or without a qualifier)
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the chart personalization dialog.
     * If it is set to `true`, all possible options for this kind of chart are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     *  - Sort
     *
     *  - Type
     *
     *  - Item
     *
     *  - Filter
     */
    personalization?: boolean | string | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the selection mode to be used by the chart.
     * Allowed values are `None`, `Single` or `Multiple`
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the chart.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the chart and the chart is linked
     * to this.
     *
     * If not set with any value, variant management control is not available for this chart.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Aggregate actions of the chart.
     */
    actions?: Action[] | Action | AggregationBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the Chart#selectionChange event.
   */
  export interface Chart$SelectionChangeEventParameters {}

  /**
   * Event object of the Chart#selectionChange event.
   */
  export type Chart$SelectionChangeEvent = Event<
    Chart$SelectionChangeEventParameters,
    Chart
  >;
}

declare module "sap/fe/macros/fcl/FlexibleColumnLayoutActions.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Building block for adding overflow toolbar buttons to integrate into the flexible column layout support
   * from Fiori elements.
   * Usage example:
   *
   * ```javascript
   *
   * <macro:FlexibleColumnLayoutActions />
   * ```
   *
   *
   *
   * @since 1.93.0
   */
  export default class FlexibleColumnLayoutActions extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the FlexibleColumnLayoutActions constructor.
   */
  export interface $FlexibleColumnLayoutActionsSettings
    extends $ControlSettings {}
}

declare module "sap/fe/macros/field/FieldAPI" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import { MessageType } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block for creating a field based on the metadata provided by OData V4.
   *
   *
   * Usually, a DataField or DataPoint annotation is expected, but the field can also be used to display a
   * property from the entity type.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Field id="MyField" metaPath="MyProperty" />
   * ```
   */
  export default class Field extends MacroAPI {
    constructor();

    /**
     * Adds a message to the field.
     *
     *
     * @returns The id of the message
     */
    addMessage(
      /**
       * The parameters to create message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Type of the message
         */
        type?: MessageType;
      }
    ): string;
    /**
     * Retrieves the current value of the field.
     *
     *
     * @returns The current value of the field
     */
    getValue(): boolean | string;
    /**
     * Removes a message from the field.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
  }
  /**
   * Additional format options for the field.
   */
  export type FieldFormatOptions = {
    /**
     * Defines how the field value and associated text will be displayed together.
     *
     * Allowed values are "Value", "Description", "DescriptionValue" and "ValueDescription"
     */
    displayMode: string;
    /**
     * Defines if and how the field measure will be displayed.
     *
     * Allowed values are "Hidden" and "ReadOnly"
     */
    measureDisplayMode: string;
    /**
     * Defines if the date part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showDate: boolean;
    /**
     * Defines if the time part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showTime: boolean;
    /**
     * Defines if the timezone part of a date time with timezone field should be shown.
     *
     * The dateTimeOffset field must have a timezone annotation.
     * The default value is true.
     */
    showTimezone: boolean;
    /**
     * Defines how the full text will be displayed.
     *
     * Allowed values are "InPlace" and "Popover"
     */
    textExpandBehaviorDisplay: string;
    /**
     * Maximum number of lines for multiline texts in edit mode.
     */
    textLinesEdit: number;
    /**
     * Maximum number of characters from the beginning of the text field that are shown initially.
     */
    textMaxCharactersDisplay: number;
    /**
     * Defines the maximum number of characters for the multiline text value.
     *
     * If a multiline text exceeds the maximum number of allowed characters, the counter below the input field
     * displays the exact number.
     */
    textMaxLength: number;
    /**
     * Maximum number of lines that multiline texts in edit mode can grow to.
     */
    textMaxLines: number;
  };

  /**
   * Describes the settings that can be provided to the Field constructor.
   */
  export interface $FieldSettings extends $MacroAPISettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    formatOptions?: FieldFormatOptions | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * An expression that allows you to control the read-only state of the field.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Option to add semantic objects to a field.
     * Valid options are either a single semantic object, a stringified array of semantic objects
     * or a single binding expression returning either a single semantic object or an array of semantic objects
     */
    semanticObject?: string | PropertyBindingInfo;
  }

  /**
   * Parameters of the Field#change event.
   */
  export interface Field$ChangeEventParameters {}

  /**
   * Event object of the Field#change event.
   */
  export type Field$ChangeEvent = Event<Field$ChangeEventParameters, Field>;

  /**
   * Parameters of the Field#liveChange event.
   */
  export interface Field$LiveChangeEventParameters {}

  /**
   * Event object of the Field#liveChange event.
   */
  export type Field$LiveChangeEvent = Event<
    Field$LiveChangeEventParameters,
    Field
  >;
}

declare module "sap/fe/macros/filterBar/FilterBarAPI" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import SelectionVariant from "sap/fe/navigation/SelectionVariant";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block for creating a FilterBar based on the metadata provided by OData V4.
   *
   *
   * Usually, a SelectionFields annotation is expected.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:FilterBar id="MyFilterBar" metaPath="@com.sap.vocabularies.UI.v1.SelectionFields" />
   * ```
   */
  export default class FilterBar extends MacroAPI {
    constructor();

    /**
     * Get the Active Filters Text Summary for the filter bar.
     *
     *
     * @returns Active filters summary as text
     */
    getActiveFiltersText(): string;
    /**
     * Provides all the filters that are currently active
     * along with the search expression.
     *
     *
     * @returns An array of active filters and the search expression.
     */
    getFilters(): object;
    /**
     * Get the selection variant from the filter bar.
     *
     *
     * @returns A promise which resolves with a {@link sap.fe.navigation.SelectionVariant }
     */
    getSelectionVariant(): Promise<SelectionVariant>;
    /**
     * Set the filter values for the given property in the filter bar.
     * The filter values can be either a single value or an array of values.
     * Each filter value must be represented as a primitive value.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setFilterValues(
      /**
       * The path to the property as a condition path
       */
      sConditionPath: string,
      /**
       * The operator to be used (optional) - if not set, the default operator (EQ) will be used
       */
      sOperator: string | undefined,
      /**
       * The values to be applied
       */
      vValues?:
        | boolean
        | boolean[]
        | number
        | number[]
        | string
        | string[]
        | undefined
    ): Promise<void>;
    /**
     * Sets {@link sap.fe.navigation.SelectionVariant } to the filter bar. Note: setSelectionVariant will clear
     * existing filters and then apply the SelectionVariant values.
     *
     *
     * @returns A promise for asynchronous handling
     */
    setSelectionVariant(
      /**
       * The {@link sap.fe.navigation.SelectionVariant } to apply to the filter bar
       */
      selectionVariant: SelectionVariant
    ): Promise<unknown>;
    /**
     * Triggers the API search on the filter bar.
     *
     *
     * @returns Returns a promise which resolves if filter go is triggered successfully; otherwise gets rejected.
     */
    triggerSearch(): Promise<object | undefined>;
  }
  /**
   * Definition of a custom filter to be used inside the FilterBar.
   * The template for the FilterField has to be provided as the default aggregation
   */
  export type FilterField = {
    /**
     * Reference to the key of another filter already displayed in the table to properly place this one
     */
    anchor: string;
    /**
     * The property name of the FilterField
     */
    key: string;
    /**
     * The text that will be displayed for this FilterField
     */
    label: string;
    /**
     * Defines where this filter should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * If set, possible errors that occur during the search will be displayed in a message box.
     */
    showMessages: boolean;
  };

  /**
   * Describes the settings that can be provided to the FilterBar constructor.
   */
  export interface $FilterBarSettings extends $MacroAPISettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * If true, the search is triggered automatically when a filter value is changed.
     */
    liveMode?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Handles the visibility of the 'Clear' button on the FilterBar.
     */
    showClearButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Displays possible errors during the search in a message box
     */
    showMessages?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Parameter which sets the visibility of the FilterBar building block
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate filter fields of the FilterBar building block
     */
    filterFields?:
      | FilterField[]
      | FilterField
      | AggregationBindingInfo
      | `{${string}}`;
  }

  /**
   * Parameters of the FilterBar#afterClear event.
   */
  export interface FilterBar$AfterClearEventParameters {}

  /**
   * Event object of the FilterBar#afterClear event.
   */
  export type FilterBar$AfterClearEvent = Event<
    FilterBar$AfterClearEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#filterChanged event.
   */
  export interface FilterBar$FilterChangedEventParameters {}

  /**
   * Event object of the FilterBar#filterChanged event.
   */
  export type FilterBar$FilterChangedEvent = Event<
    FilterBar$FilterChangedEventParameters,
    FilterBar
  >;

  /**
   * Parameters of the FilterBar#search event.
   */
  export interface FilterBar$SearchEventParameters {}

  /**
   * Event object of the FilterBar#search event.
   */
  export type FilterBar$SearchEvent = Event<
    FilterBar$SearchEventParameters,
    FilterBar
  >;
}

declare module "sap/fe/macros/form/Form.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Context from "sap/ui/model/Context";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block for creating a Form based on the metadata provided by OData V4.
   *
   *
   * It is designed to work based on a FieldGroup annotation but can also work if you provide a ReferenceFacet
   * or a CollectionFacet
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Form id="MyForm" metaPath="@com.sap.vocabularies.UI.v1.FieldGroup#GeneralInformation" />
   * ```
   */
  export default class Form extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the Form constructor.
   */
  export interface $FormSettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * The title of the form control.
     */
    title?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/form/FormElement.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Context from "sap/ui/model/Context";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a form element based on the metadata provided by OData V4.
   *
   * @since 1.90.0
   */
  export default class FormElement extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the FormElement constructor.
   */
  export interface $FormElementSettings extends $ControlSettings {
    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Label shown for the field. If not set, the label from the annotations will be shown.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to false, the FormElement is not rendered.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Optional aggregation of controls that should be displayed inside the FormElement.
     * If not set, a default Field building block will be rendered
     */
    fields?: Control;
  }
}

declare module "sap/fe/macros/kpiTag/KPITag.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create a KPI tag.
   */
  export default class KPITag extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the KPITag constructor.
   */
  export interface $KPITagSettings extends $ControlSettings {
    /**
     * The Number to be displayed.
     */
    number?: number | PropertyBindingInfo | `{${string}}`;

    /**
     * An event is triggered when the KPI is pressed.
     */
    press?: string | PropertyBindingInfo;

    /**
     * Set it to `true` if the KPI should display its status icon.
     */
    showIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The Status to be displayed.
     */
    status?: string | PropertyBindingInfo;

    /**
     * The Text to be displayed.
     */
    text?: string | PropertyBindingInfo;

    /**
     * The Tooltip to be displayed.
     */
    tooltip?: string | PropertyBindingInfo;

    /**
     * The Unit of Measure of the number to be displayed.
     */
    unit?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/microchart/MicroChart.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Building block used to create a MicroChart based on the metadata provided by OData V4.
   *
   * @since 1.93.0
   */
  export default class MicroChart extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the MicroChart constructor.
   */
  export interface $MicroChartSettings extends $ControlSettings {}
}

declare module "sap/fe/macros/multiValueField/MultiValueField.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Context from "sap/ui/model/Context";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block for creating a MultiValueField based on the metadata provided by OData V4.
   *
   *
   * The MultiValueField can be used to display either a DataField or Property directly. It has to point to
   * a collection property.
   *
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:MultiValueField
   *   id="SomeUniqueIdentifier"
   *   contextPath="{entitySet>}"
   *   metaPath="{dataField>}"
   *  />
   * ```
   *
   *
   * @since 1.118.0
   * @experimental (since 1.118.0)
   */
  export default class MultiValueField extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the MultiValueField constructor.
   *
   * @experimental (since 1.118.0)
   */
  export interface $MultiValueFieldSettings extends $ControlSettings {
    /**
     * The context path provided for the MultiValueField
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative Metadata path to the MultiValueField.
     * The metaPath should point to a Property or DataField.
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * The readOnly flag
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/paginator/Paginator.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  /**
   * Building block used to create a paginator control.
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Paginator />
   * ```
   *
   *
   *
   * @since 1.94.0
   */
  export default class Paginator extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the Paginator constructor.
   */
  export interface $PaginatorSettings extends $ControlSettings {}
}

declare module "sap/fe/macros/richtexteditor/RichTextEditor.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block that exposes the RichTextEditor UI5 control.
   * It's used to enter formatted text, and uses the third-party component called TinyMCE.
   *
   *
   * @since 1.117.0
   */
  export default class RichTextEditor extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the RichTextEditor constructor.
   */
  export interface $RichTextEditorSettings extends $ControlSettings {
    /**
     * With the 'buttonGroups' attribute you can customize the buttons that are displayed on the toolbar of
     * the editor.
     */
    buttonGroups?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the readOnly attribute to override the edit flow of the page.
     * By setting 'readOnly' to true, a FormattedText will be displayed instead of the editor.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the 'required' attribute to make sure that the editor is filled with some text.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The value contained in the editor. You can use this attribute to set a default value.
     */
    value?: string | PropertyBindingInfo;
  }
}

declare module "sap/fe/macros/richtexteditor/RichTextEditorWithMetadata.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Context from "sap/ui/model/Context";

  /**
   * Metadata-driven building block that exposes the RichTextEditor UI5 control.
   * It's used to enter formatted text and uses the third-party component called TinyMCE.
   *
   *
   * @since 1.117.0
   */
  export default class RichTextEditorWithMetadata extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the RichTextEditorWithMetadata constructor.
   */
  export interface $RichTextEditorWithMetadataSettings
    extends $ControlSettings {
    /**
     * With the 'buttonGroups' attribute, you can customize the buttons that are displayed on the toolbar of
     * the editor.
     */
    buttonGroups?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The context path of the property displayed
     */
    contextPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * The metaPath of the displayed property
     */
    metaPath?: Context | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the readOnly attribute to override the edit flow of the page.
     * By setting 'readOnly' to true, a FormattedText is displayed instead of the editor.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Use the 'required' attribute, to make sure that the editor is filled with some text.
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/share/Share.block" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Building block used to create the ‘Share’ functionality.
   *
   *
   * Please note that the 'Share in SAP Jam' option is only available on platforms that are integrated with
   * SAP Jam.
   *
   *
   * If you are consuming this macro in an environment where the SAP Fiori launchpad is not available, then
   * the 'Save as Tile' option is not visible.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Share
   * 	id="someID"
   * visible="true"
   * />
   * ```
   *
   *
   *
   * @since 1.93.0
   */
  export default class Share extends Control {
    constructor();
  }
  /**
   * Describes the settings that can be provided to the Share constructor.
   */
  export interface $ShareSettings extends $ControlSettings {
    /**
     * Whether the share control should be visible on the screen.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/fe/macros/table/TableAPI" {
  import {
    default as MacroAPI,
    $MacroAPISettings,
  } from "sap/fe/macros/MacroAPI";

  import { MessageType } from "sap/ui/core/library";

  import Context from "sap/ui/model/odata/v4/Context";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Building block used to create a table based on the metadata provided by OData V4.
   *
   *
   * Usually, a LineItem or PresentationVariant annotation is expected, but the Table building block can also
   * be used to display an EntitySet.
   *
   * Usage example:
   *
   * ```javascript
   *
   * <macro:Table id="MyTable" metaPath="@com.sap.vocabularies.UI.v1.LineItem" />
   * ```
   */
  export default class Table extends MacroAPI {
    constructor();

    /**
     * Adds a message to the table.
     * The message applies to the whole table and not to an individual table row.
     *
     *
     *
     * @returns The ID of the message
     */
    addMessage(
      /**
       * The parameters to create the message
       */
      parameters: {
        /**
         * Message description
         */
        description?: string;
        /**
         * Message text
         */
        message?: string;
        /**
         * True if the message is persistent
         */
        persistent?: boolean;
        /**
         * Message type
         */
        type?: MessageType;
      }
    ): string;
    /**
     * Gets contexts from the table that have been selected by the user.
     *
     *
     * @returns Contexts of the rows selected by the user
     */
    getSelectedContexts(): Context[];
    /**
     * Requests a refresh of the table.
     */
    refresh(): void;
    /**
     * Removes a message from the table.
     */
    removeMessage(
      /**
       * The id of the message
       */
      id: string
    ): void;
  }
  /**
   * Definition of a custom action to be used inside the table toolbar
   */
  export type Action = {
    /**
     * Reference to the key of another action already displayed in the toolbar to properly place this one
     */
    anchor: string;
    /**
     * Enables or disables the action
     */
    enabled: boolean;
    /**
     * Unique identifier of the action
     */
    key: string;
    /**
     * Defines where this action should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * Event handler to be called when the user chooses the action
     */
    press: string;
    /**
     * Defines if the action requires a selection.
     */
    requiresSelection: boolean;
    /**
     * The text that will be displayed for this action
     */
    text: string;
  };

  /**
   * Definition of a custom ActionGroup to be used inside the table toolbar
   */
  export type ActionGroup = {
    /**
     * Defines nested actions
     */
    actions: Action[];
    /**
     * Reference to the key of another action or action group already displayed in the toolbar to properly place
     * this one
     */
    anchor: string;
    /**
     * Unique identifier of the ActionGroup
     */
    key: string;
    /**
     * Defines where this action group should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * The text that will be displayed for this action group
     */
    text: string;
  };

  /**
   * Definition of a custom column to be used inside the table.
   * The template for the column has to be provided as the default aggregation
   */
  export type Column = {
    /**
     * Reference to the key of another column already displayed in the table to properly place this one
     */
    anchor: string;
    /**
     * The text that will be displayed for this column header
     */
    header: string;
    /**
     * Aligns the header as well as the content horizontally
     */
    horizontalAlign: /* was: sap.fe.core.converters.ManifestSettings.HorizontalAlign */ any;
    /**
     * Defines the column importance.
     * You can define which columns should be automatically moved to the pop-in area based on their importance
     */
    importance: string;
    /**
     * Unique identifier of the column
     */
    key: string;
    /**
     * Defines where this column should be placed relative to the defined anchor
     * Allowed values are `Before` and `After`
     */
    placement: string;
    /**
     * Defines the column's width.
     * Allowed values are `auto`, `value` and `inherit` according to {@link sap.ui.core.CSSSize }
     */
    width: string;
    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader: boolean;
  };

  /**
   * Create options for the table.
   */
  export type TableCreationOptions = {
    /**
     * Specifies if the new entry should be created at the top or bottom of a table in case of creationMode
     * 'Inline'
     *
     * The default value is 'false'
     */
    createAtEnd: boolean;
    /**
     * Specifies if the new entry should be hidden in case of creationMode 'InlineCreationRows'. This only applies
     * to responsive tables.
     *
     * The default value is 'false'
     */
    inlineCreationRowsHiddenInEditMode: boolean;
    /**
     * Defines the creation mode to be used by the table.
     * Allowed values are `NewPage`, `Inline`, `InlineCreationsRows` or `External`.
     *
     *
     *
     * NewPage - the created document is shown in a new page, depending on whether metadata 'Sync', 'Async'
     * or 'Deferred' is used
     *
     * Inline - The creation is done inline
     *
     * InlineCreationsRows - The creation is done inline with an empty row
     *
     * External - The creation is done in a different application specified via the parameter 'outbound'
     * If not set with any value:
     *
     * if navigation is defined, the default value is 'NewPage'. Otherwise it is 'Inline'.
     */
    name: string;
    /**
     * The navigation target where the document is created in case of creationMode 'External'
     */
    outbound: string;
  };

  /**
   * Describes the settings that can be provided to the Table constructor.
   */
  export interface $TableSettings extends $MacroAPISettings {
    /**
     * An expression that allows you to control the 'busy' state of the table.
     */
    busy?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the path of the context used in the current page or block.
     * This setting is defined by the framework.
     */
    contextPath?: string | PropertyBindingInfo;

    /**
     * A set of options that can be configured.
     */
    creationMode?: TableCreationOptions | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if the column width is automatically calculated.
     */
    enableAutoColumnWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the export functionality of the table is enabled or not.
     */
    enableExport?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls whether the table can be opened in fullscreen mode or not.
     */
    enableFullScreen?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls if the paste functionality of the table is enabled or not.
     */
    enablePaste?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * ID of the FilterBar building block associated with the table.
     */
    filterBar?: string | PropertyBindingInfo;

    /**
     * Number of columns that are fixed on the left. Only columns which are not fixed can be scrolled horizontally.
     * This property is not relevant for responsive tables
     */
    frozenColumnCount?: number | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the header text that is shown in the table.
     */
    header?: string | PropertyBindingInfo;

    /**
     * Controls if the header text should be shown or not.
     */
    headerVisible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether to display the search action.
     */
    isSearchable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the relative path of the property in the metamodel, based on the current contextPath.
     */
    metaPath?: string | PropertyBindingInfo;

    /**
     * Controls which options should be enabled for the table personalization dialog.
     * If it is set to `true`, all possible options for this kind of table are enabled.
     *
     * If it is set to `false`, personalization is disabled.
     *
     *
     *
     * You can also provide a more granular control for the personalization by providing a comma-separated list
     * with the options you want to be available.
     *
     * Available options are:
     *
     *  - Sort
     *
     *  - Column
     *
     *  - Filter
     */
    personalization?: boolean | string | PropertyBindingInfo | `{${string}}`;

    /**
     * An expression that allows you to control the 'read-only' state of the table.
     * If you do not set any expression, SAP Fiori elements hooks into the standard lifecycle to determine the
     * current state.
     */
    readOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Number of rows to be displayed in the table. Does not apply to responsive tables.
     */
    rowCount?: number | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the table handles the visible rows. Does not apply to Responsive tables.
     * Allowed values are `Auto`, `Fixed`.
     *
     * - If set to `Fixed`, the table always has as many rows as defined in the rowCount property.
     *
     * - If set to `Auto`, the number of rows is changed by the table automatically. It will then adjust its
     *     row count to the space it is allowed to cover (limited by the surrounding container) but it cannot have
     *     less than defined in the `rowCount` property.
     */
    rowCountMode?: string | PropertyBindingInfo;

    /**
     * Defines the selection mode to be used by the table.
     * Allowed values are `None`, `Single`, `ForceSingle`, `Multi`, `ForceMulti` or `Auto`.
     * If set to 'Single', 'Multi' or 'Auto', SAP Fiori elements hooks into the standard lifecycle to determine
     * the consistent selection mode.
     * If set to 'ForceSingle' or 'ForceMulti' your choice will be respected but this might not respect the
     * Fiori guidelines.
     */
    selectionMode?: string | PropertyBindingInfo;

    /**
     * Defines the type of table that will be used by the building block to render the data.
     * Allowed values are `GridTable` and `ResponsiveTable`
     */
    type?: string | PropertyBindingInfo;

    /**
     * Controls the kind of variant management that should be enabled for the table.
     * Allowed value is `Control`.
     *
     * If set with value `Control`, a variant management control is seen within the table and the table is linked
     * to this.
     *
     * If not set with any value, control level variant management is not available for this table.
     */
    variantManagement?: string | PropertyBindingInfo;

    /**
     * Indicates if the column header should be a part of the width calculation.
     */
    widthIncludingColumnHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregate actions of the table.
     */
    actions?: Action[] | Action | AggregationBindingInfo | `{${string}}`;

    /**
     * Aggregate columns of the table.
     */
    columns?: Column[] | Column | AggregationBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the Table#rowPress event.
   */
  export interface Table$RowPressEventParameters {}

  /**
   * Event object of the Table#rowPress event.
   */
  export type Table$RowPressEvent = Event<Table$RowPressEventParameters, Table>;

  /**
   * Parameters of the Table#selectionChange event.
   */
  export interface Table$SelectionChangeEventParameters {}

  /**
   * Event object of the Table#selectionChange event.
   */
  export type Table$SelectionChangeEvent = Event<
    Table$SelectionChangeEventParameters,
    Table
  >;
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/fe/macros/chart/ChartAPI": undefined;

    "sap/fe/macros/fcl/FlexibleColumnLayoutActions.block": undefined;

    "sap/fe/macros/field/FieldAPI": undefined;

    "sap/fe/macros/filterBar/FilterBarAPI": undefined;

    "sap/fe/macros/form/Form.block": undefined;

    "sap/fe/macros/form/FormElement.block": undefined;

    "sap/fe/macros/kpiTag/KPITag.block": undefined;

    "sap/fe/macros/library": undefined;

    "sap/fe/macros/MacroAPI": undefined;

    "sap/fe/macros/microchart/MicroChart.block": undefined;

    "sap/fe/macros/multiValueField/MultiValueField.block": undefined;

    "sap/fe/macros/paginator/Paginator.block": undefined;

    "sap/fe/macros/richtexteditor/RichTextEditor.block": undefined;

    "sap/fe/macros/richtexteditor/RichTextEditorWithMetadata.block": undefined;

    "sap/fe/macros/share/Share.block": undefined;

    "sap/fe/macros/table/TableAPI": undefined;
  }
}
