import ts from "typescript";
import { getPropertyNameText } from "../linter/ui5Types/utils/utils.js";
export function findGreatestAccessExpression(node, matchPropertyAccess) {
    let scanNode = node;
    let propertyAccessChain = [];
    if (matchPropertyAccess) {
        propertyAccessChain = matchPropertyAccess.split(".");
        if (node.text !== "window" && node.text !== "globalThis" && node.text !== "self") {
            const firstPropAccess = propertyAccessChain.shift();
            if (node.text !== firstPropAccess) {
                throw new Error(`Expected node to be ${firstPropAccess} but got ${node.getText()}`);
            }
        }
    }
    while (ts.isPropertyAccessExpression(scanNode.parent) || ts.isElementAccessExpression(scanNode.parent)) {
        scanNode = scanNode.parent;
        if (matchPropertyAccess) {
            const nextPropertyAccess = propertyAccessChain.shift();
            let propName;
            if (ts.isPropertyAccessExpression(scanNode)) {
                propName = getPropertyNameText(scanNode.name);
            }
            else {
                if (ts.isStringLiteralLike(scanNode.argumentExpression) ||
                    ts.isNumericLiteral(scanNode.argumentExpression)) {
                    propName = scanNode.argumentExpression.text;
                }
                else {
                    propName = scanNode.argumentExpression.getText();
                }
            }
            if (propName !== nextPropertyAccess) {
                throw new Error(`Expected node to be ${nextPropertyAccess} but got ${propName}`);
            }
            if (!propertyAccessChain.length) {
                return scanNode;
            }
        }
    }
    return scanNode;
}
export function matchPropertyAccessExpression(node, match) {
    const propAccessChain = [];
    propAccessChain.push(node.expression.getText());
    let scanNode = node;
    while (ts.isPropertyAccessExpression(scanNode)) {
        propAccessChain.push(scanNode.name.getText());
        scanNode = scanNode.parent;
    }
    return propAccessChain.join(".") === match;
}
export function collectIdentifiers(node) {
    const declaredIdentifiers = new Set();
    const extractDestructIdentifiers = (name, identifiers) => {
        if (ts.isIdentifier(name)) {
            identifiers.add(name.text);
        }
        else if (ts.isObjectBindingPattern(name) || ts.isArrayBindingPattern(name)) {
            for (const element of name.elements) {
                if (ts.isBindingElement(element)) {
                    extractDestructIdentifiers(element.name, identifiers);
                }
            }
        }
    };
    const collectIdentifiers = (node) => {
        if (ts.isVariableDeclaration(node) ||
            ts.isFunctionDeclaration(node) ||
            ts.isClassDeclaration(node)) {
            if (node.name && ts.isIdentifier(node.name)) {
                declaredIdentifiers.add(node.name.text);
            }
        }
        if (ts.isParameter(node) || ts.isVariableDeclaration(node)) {
            extractDestructIdentifiers(node.name, declaredIdentifiers);
        }
        ts.forEachChild(node, collectIdentifiers);
    };
    ts.forEachChild(node, collectIdentifiers);
    return declaredIdentifiers;
}
//# sourceMappingURL=utils.js.map