import ts from "typescript";
import LinterContext, { RawLintMessage, ResourcePath } from "../linter/LinterContext.js";
import { ModuleDeclaration } from "../linter/ui5Types/amdTranspiler/parseModuleDeclaration.js";
import { RequireExpression } from "../linter/ui5Types/amdTranspiler/parseRequire.js";
import { Resource } from "@ui5/fs";
export interface AutofixResource {
    resource: Resource;
    messages: RawLintMessage[];
}
export interface AutofixOptions {
    rootDir: string;
    namespace?: string;
    resources: Map<ResourcePath, AutofixResource>;
    context: LinterContext;
}
export declare enum ChangeAction {
    INSERT = "insert",
    REPLACE = "replace",
    DELETE = "delete"
}
export type ChangeSet = InsertChange | ReplaceChange | DeleteChange;
interface AbstractChangeSet {
    action: ChangeAction;
    start: number;
}
interface InsertChange extends AbstractChangeSet {
    action: ChangeAction.INSERT;
    value: string;
}
interface ReplaceChange extends AbstractChangeSet {
    action: ChangeAction.REPLACE;
    end: number;
    value: string;
}
interface DeleteChange extends AbstractChangeSet {
    action: ChangeAction.DELETE;
    end: number;
}
export type AutofixResult = Map<ResourcePath, string>;
export interface Position {
    line: number;
    column: number;
    pos: number;
}
export interface GlobalPropertyAccessNodeInfo {
    globalVariableName: string;
    namespace: string;
    moduleName: string;
    exportName?: string;
    propertyAccess?: string;
    position: Position;
    node?: ts.Identifier | ts.PropertyAccessExpression | ts.ElementAccessExpression;
}
export interface DeprecatedApiAccessNode {
    apiName: string;
    position: Position;
    node?: ts.CallExpression | ts.Identifier | ts.PropertyAccessExpression | ts.ElementAccessExpression;
}
export type ImportRequests = Map<string, {
    nodeInfos: (DeprecatedApiAccessNode | GlobalPropertyAccessNodeInfo)[];
    identifier?: string;
}>;
export type ModuleDeclarationInfo = ExistingModuleDeclarationInfo | NewModuleDeclarationInfo;
export interface ExistingModuleDeclarationInfo {
    moduleDeclaration: ModuleDeclaration | RequireExpression;
    importRequests: ImportRequests;
}
export interface NewModuleDeclarationInfo {
    declareCall: ts.CallExpression;
    requireCalls: Map<string, ts.CallExpression[]>;
    importRequests: ImportRequests;
    endPos?: number;
}
export default function ({ rootDir: _unused1, namespace: _unused2, resources: autofixResources, context, }: AutofixOptions): Promise<AutofixResult>;
export {};
