// For Library Version: 1.120.14

declare module "sap/gantt/library" {
  import ChartScheme from "sap/gantt/config/ChartScheme";

  import ContainerLayout from "sap/gantt/config/ContainerLayout";

  import ToolbarScheme from "sap/gantt/config/ToolbarScheme";

  import Hierarchy from "sap/gantt/config/Hierarchy";

  import TimeHorizon from "sap/gantt/config/TimeHorizon";

  import Locale from "sap/gantt/config/Locale";

  import Mode from "sap/gantt/config/Mode";

  import ObjectType from "sap/gantt/config/ObjectType";

  import AxisTimeStrategyBase from "sap/gantt/axistime/AxisTimeStrategyBase";

  import SettingItem from "sap/gantt/config/SettingItem";

  /**
   * The layer of adhoc line in chart area
   */
  export enum AdhocLineLayer {
    /**
     * Adhoc lines are below all other shapes. If a calendar is shown in the chart area, adhoc lines are on
     * top of the calendar.
     */
    Bottom = "Bottom",
    /**
     * Adhoc lines are on top of all other shapes and patterns.
     */
    Top = "Top",
  }
  /**
   * The layer of delta line in chart area
   *
   * @since 1.84
   */
  export enum DeltaLineLayer {
    /**
     * Delta lines are below all other shapes and patterns.
     */
    Bottom = "Bottom",
    /**
     * Delta lines are above all other shapes and patterns.
     */
    Top = "Top",
  }
  /**
   * Defines how dragged ghost moves when dragging.
   */
  export enum DragOrientation {
    /**
     * When you click on a shape to start a drag-and-drop operation, the dragged shape's ghost can move in both
     * horizontal and verital directions, which means, both axis x and y may change at the same time.
     */
    Free = "Free",
    /**
     * When you click on a shape to start a drag-and-drop operation, the dragged shape's ghost can only move
     * in horizontal direction when dragging, which means, the axis y will not change.
     */
    Horizontal = "Horizontal",
    /**
     * When you click on a shape to start a drag-and-drop operation, the dragged shape's ghost can only move
     * in vertical direction when dragging, which means, the axis x will not change. When drag in vertical direction,
     * the ghost alignment will not work, and only one shape can be dragged.
     */
    Vertical = "Vertical",
  }
  /**
   * A hybrid data type that can represent an array of string, or array of object. The result value parsed
   * by this data type are "string[]" or "object[]"
   *
   * Examples of valid values in js:
   * 	 - ["order", "activity"]
   * 	 - [{name:"order", idName:"OrderNo"},{name:"activity"}]
   * 	 - [{name:"order", idName:"OrderNo"},"activity"]
   *
   * Examples of valid values in xml view:
   * 	 - "order,activity"
   * 	 - "[order,activity]"
   * 	 - [{"name":"order", "idName":"OrderNo"},{"name":"activity"}]
   */
  export type GenericArray = any;

  /**
   * Different zoom type for mouse wheel zooming
   */
  export enum MouseWheelZoomType {
    /**
     * The granularity is the unit time range of innerInterval under current zoom level
     */
    FineGranular = "FineGranular",
    /**
     * Do not support mouse wheel zooming
     */
    None = "None",
    /**
     * The granularity is a whole zoom level, just like the global zoom slider does
     */
    Stepwise = "Stepwise",
  }
  /**
   * Accepts only Gantt palette colors names.
   *
   * @since 1.69
   */
  export type PaletteColor = string;

  /**
   * Different selection mode for GanttChart
   */
  export enum SelectionMode {
    /**
     * Select multiple shapes at a time
     */
    Multiple = "Multiple",
    /**
     * Select multiple shapes alongwith lasso selection
     */
    MultipleWithLasso = "MultipleWithLasso",
    /**
     * Support multiple shape when pressing ctrl/meta key From version 1.40 to upper versions, support multiple
     * selection without Ctrl key for rows
     */
    MultiWithKeyboard = "MultiWithKeyboard",
    /**
     * Support multiple shape alongwith lasso selection when pressing ctrl/meta key
     */
    MultiWithKeyboardAndLasso = "MultiWithKeyboardAndLasso",
    /**
     * No shape can be selected
     */
    None = "None",
    /**
     * Select one shape at a time
     */
    Single = "Single",
  }
  /**
   * A length is a distance measurement, given as a number along with a unit. If unit is not provided, the
   * length value represents a distance in the current user coordinate system.
   */
  export type SVGLength = any;

  /**
   * A string type that represents SVG fill color values.
   *
   * Allowed values are {@link sap.ui.core.CSSColor} and {@link sap.m.ValueColor} and LESS parameter The empty
   * string and invalid less parameter fall back to default black color.
   */
  export type ValueSVGPaintServer = string;

  export namespace config {
    /**
     * Defines the default configuration chart scheme.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_CHART_SCHEME_KEY`
     * 	 - name - "Default"
     * 	 - rowSpan - 1
     * 	 - icon - null
     * 	 - modeKey - `sap.gantt.config.DEFAULT_MODE_KEY`
     * 	 - shapeKeys - []
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_CHART_SCHEME: ChartScheme;

    /**
     * Defines the default chart scheme key.
     *
     * The Default Chart Scheme Key is used in the default chart scheme configuration.
     */
    export const DEFAULT_CHART_SCHEME_KEY: string;

    /**
     * Defines the default list of chart schemes.
     *
     * Default values is `sap.gantt.config.DEFAULT_CHART_SCHEME`
     */
    export const DEFAULT_CHART_SCHEMES: ChartScheme[];

    /**
     * Defines the default configuration object for Dual Container layout.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_CONTAINER_DUAL_LAYOUT_KEY`
     * 	 - text - "Dual Gantt Chart Layout"
     * 	 - toolbarSchemeKey - `sap.gantt.config.DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY`
     * 	 - ganttChartLayouts - `[new sap.gantt.config.GanttChartLayout({ activeModeKey: sap.gantt.config.DEFAULT_MODE_KEY,
     *     hierarchyKey: sap.gantt.config.DEFAULT_HIERARCHY_KEY }), new sap.gantt.config.GanttChartLayout({ activeModeKey:
     *     sap.gantt.config.DEFAULT_MODE_KEY, hierarchyKey: sap.gantt.config.DEFAULT_HIERARCHY_KEY })]`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_CONTAINER_DUAL_LAYOUT: ContainerLayout;

    /**
     * Defines the default Gantt dual-view layout key.
     *
     * The default Gantt dual-view layout key is used in the default Gantt dual layout configuration.
     */
    export const DEFAULT_CONTAINER_DUAL_LAYOUT_KEY: string;

    /**
     * Defines the default list of Container layouts.
     *
     * Default values are a single-view layout and a dual-view layout.
     */
    export const DEFAULT_CONTAINER_LAYOUTS: ContainerLayout[];

    /**
     * Defines the default configuration object for the Single Container layout.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY`
     * 	 - text - "Single Gantt Chart Layout"
     * 	 - toolbarSchemeKey - `sap.gantt.config.DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY`
     * 	 - ganttChartLayouts - `[new sap.gantt.config.GanttChartLayout({ activeModeKey: sap.gantt.config.DEFAULT_MODE_KEY,
     *     hierarchyKey: sap.gantt.config.DEFAULT_HIERARCHY_KEY })]`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_CONTAINER_SINGLE_LAYOUT: ContainerLayout;

    /**
     * Defines the default Gantt single layout key.
     *
     * The default Gantt single layout key is used in the default Gantt single layout configuration.
     */
    export const DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY: string;

    /**
     * Defines the default configuration object for toolbar scheme on `sap.gantt.GanttChartContainer`.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY`
     * 	 - customToolbarItems - `sap.gantt.config.ToolbarGroup({ position: "L1", overflowPriority: sap.m.OverflowToolbarPriority.High
     *     })`
     * 	 - timeZoom - `sap.gantt.config.ToolbarGroup({ position: "R2", overflowPriority: sap.m.OverflowToolbarPriority.NeverOverflow
     *     })`
     * 	 - settings - `sap.gantt.config.ToolbarGroup({ position: "R1", overflowPriority: sap.m.OverflowToolbarPriority.low,
     *     items: sap.gantt.config.DEFAULT_TOOLBAR_SETTING_ITEMS })`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_CONTAINER_TOOLBAR_SCHEME: ToolbarScheme;

    /**
     * Defines the default toolbar scheme key for GanttContainer.
     *
     * The default GanttContainer toolbar scheme key is used in the default GanttContainer toolbar scheme configuration.
     */
    export const DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY: string;

    /**
     * Define default list of toolbar schemes for `sap.gantt.GanttChartContainer`.
     *
     * The default values include an empty toolbar and a default Gantt Chart Container toolbar.
     */
    export const DEFAULT_CONTAINER_TOOLBAR_SCHEMES: ToolbarScheme[];

    /**
     * Defines the default empty JSON object.
     */
    export const DEFAULT_EMPTY_OBJECT: object;

    /**
     * Defines the default configuration object for the toolbar scheme on `sap.gantt.GanttChartWithTable`.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEME_KEY`
     * 	 - customToolbarItems - `sap.gantt.config.ToolbarGroup({ position: "L2", overflowPriority: sap.m.OverflowToolbarPriority.High
     *     })`
     * 	 - expandTree - `sap.gantt.config.ToolbarGroup({ position: "L3", overflowPriority: sap.m.OverflowToolbarPriority.Low
     *     })`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_GANTTCHART_TOOLBAR_SCHEME: ToolbarScheme;

    /**
     * Defines the default toolbar scheme key for GanttWithTable.
     *
     * The default GanttWithTable toolbar scheme key is used in the default GanttWithTable toolbar scheme configuration.
     */
    export const DEFAULT_GANTTCHART_TOOLBAR_SCHEME_KEY: string;

    /**
     * Defines the default list of toolbar schemes for `sap.gantt.GanttChartBase`.
     *
     * The default values include an empty toolbar and a default Gantt Chart toolbar.
     */
    export const DEFAULT_GANTTCHART_TOOLBAR_SCHEMES: ToolbarScheme[];

    /**
     * Defines the default configuration object for Hierarchy.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_HIERARCHY_KEY`
     * 	 - text - "Default Hierarchy"
     * 	 - activeModeKey - `sap.gantt.config.DEFAULT_MODE_KEY`
     * 	 - toolbarSchemeKey - `sap.gantt.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEME_KEY`
     * 	 - columns - null
     * 	 - expandedLevels - null
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_HIERARCHY: Hierarchy;

    /**
     * Defines the default hierarchy key.
     *
     * The default hierarchy key is used in the default hierarchy configuration.
     */
    export const DEFAULT_HIERARCHY_KEY: string;

    /**
     * Defines the default list of hierarchies.
     *
     * The default value is `sap.gantt.config.DEFAULT_HIERARCHY`
     */
    export const DEFAULT_HIERARCHYS: Hierarchy[];

    /**
     * Defines the default configuration initHorizon.
     *
     * From one month ago, to one year from now.
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application. Create the
     * time horizons directly:
     * ```javascript
     *  new TimeHorizon({
     *         startTime: new Date((new Date()).getTime() - 2628000000),
     *         endTime: new Date((new Date()).getTime() + 2628000000)
     *     }); ```
     */
    export const DEFAULT_INIT_HORIZON: TimeHorizon;

    /**
     * Defines the default configuration object Locale. The configured time zone is considered as the default
     * time zone for the locale, see {@link sap.ui.core.Configuration#getTimezone}.. **Note:** Adjusting the
     * time zone in a running application can lead to unexpected data inconsistencies. For more information,
     * see {@link sap.ui.core.Configuration#setTimezone}. Default values
     * 	 - timeZoine - `null`
     */
    export const DEFAULT_LOCALE: Locale;

    /**
     * Defines the default configuration object locale.
     *
     * Default values
     * 	 - timeZoine - `"CET"`
     * 	 - utcdiff - `"000000"`
     * 	 - utcsign - `"+"`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_LOCALE_CET: Locale;

    /**
     * Defines the default configuration mode.
     *
     * Default values are:
     * 	 - key - `sap.gantt.config.DEFAULT_MODE_KEY`
     * 	 - text - "Default"
     * 	 - icon - `"sap-icon://status-positive"`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_MODE: Mode;

    /**
     * Defines the default mode key.
     *
     * The default mode key is used in Gantt and the default mode configuration is used when no mode configuration
     * is provided.
     */
    export const DEFAULT_MODE_KEY: string;

    /**
     * Defines the default list of configuration modes.
     *
     * Default value: `sap.gantt.config.DEFAULT_MODE`.
     */
    export const DEFAULT_MODES: Mode[];

    /**
     * Defines the default configuration object type.
     *
     * Default values:
     * 	 - key - `sap.gantt.config.DEFAULT_OBJECT_TYPE_KEY`
     * 	 - description - "Default"
     * 	 - mainChartSchemeKey - `sap.gantt.config.DEFAULT_CHART_SCHEME_KEY`
     * 	 - expandedChartSchemeKeys - []
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const DEFAULT_OBJECT_TYPE: ObjectType;

    /**
     * Defines the default object type key.
     *
     * Default object type key is used in the default object type configuration.
     */
    export const DEFAULT_OBJECT_TYPE_KEY: string;

    /**
     * Defines the default list of object types.
     *
     * The default value is `sap.gantt.config.DEFAULT_OBJECT_TYPE`.
     */
    export const DEFAULT_OBJECT_TYPES: ObjectType[];

    /**
     * Defines the default configuration planHorizon.
     *
     * From one year ago, to one year from now.
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application. Create the
     * time horizons directly:
     * ```javascript
     *  new TimeHorizon({
     *         startTime: new Date((new Date()).getTime() - 31536000000),
     *         endTime: new Date((new Date()).getTime() + 31536000000)
     *     }); ```
     */
    export const DEFAULT_PLAN_HORIZON: TimeHorizon;

    /**
     * Defines the default configuration for the time axis.
     *
     * Default values are:
     * 	 - planHorizon - `sap.gantt.config.DEFAULT_PLAN_HORIZON`
     * 	 - initHorizon - `sap.gantt.config.DEFAULT_INIT_HORIZON`
     * 	 - zoomStrategy - `sap.gantt.config.DEFAULT_TIME_ZOOM_STRATEGY`
     * 	 - finestGranularity - "15min"
     * 	 - coarsestGranularity - "6month"
     * 	 - rate> - 1
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application. Use ` new
     * AxisTimeStrategyBase() ` instead.
     */
    export const DEFAULT_TIME_AXIS: AxisTimeStrategyBase;

    /**
     * Defines the default configuration of the time zoom level. The default time zoom level includes a granularity
     * factor that determines the length of the interval between neighboring vertical lines.
     *
     * The time zoom level now is a JSON object with the granularity as the key and some internal information
     * such as formatting. Each level has 3 interval objects describing the time unit, the time span, and the
     * jump condition to the next level. The zoom level decides how the time axis behaves and how ticks are
     * displayed.
     *
     * Take `"12hour"` level for example
     * 	 - `"12hour":` - Granularity level ID.
     * 	 `"innerInterval"` - Time interval between neighboring vertical lines is 12 hours. The jump condition
     * to the next level is "1day" when the interval exceeds 90 pixels.
     * 	`"unit": sap.gantt.config.TimeUnit.hour` - Time unit is hour.
     * 	 - `"span": 12` - Span is 12.
     * 	 - `"range": 90` - Jumping condition is 90 pixels between neighboring vertical lines.
     * 	 -  `largeInterval` - Time interval of top row along the time axis is 1 day. Formatted in the locale
     *     language with the format string. This zoom level implements an interval larger than the interval in the
     *     default zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.day` -
     * 	 - `"span": 1` - Time span is 1.
     * 	 - `"pattern": "cccc dd.M.yyyy"` - Formats the string in CLDR date/time symbols.
     * 	 -  `smallInterval` - Time interval of the bottom row along the time axis is 12 hours. Formatted in
     *     the locale language with the format string. This zoom level implements an interval the same as the interval
     *     in the default zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.hour` - Time unit is hour.
     * 	 - `"span": 12` - Time span is 12.
     * 	 - `"pattern": "HH:mm"` - Formats the string in CLDR date/time symbols.
     *
     * The current granularity setting provides the following values in the default time zoom level:
     *  `5min`, `10min`, `15min`, `30min`,
     *  `1hour`, `2hour`, `4hour`, `6hour`, `12hour`,
     *  `1day`, `2day`, `4day`,
     *  `1week`, `2week`,
     *  `1month`, `2month`, `4month`, `6month`,
     *  `1year`, `2year`, `5year`.
     */
    export const DEFAULT_TIME_ZOOM_STRATEGY: undefined;

    /**
     * Defines the default configuration object for setting groups in the toolbar.
     *
     * Default values:
     * 	 - `sap.gantt.config.SETTING_ITEM_ENABLE_NOW_LINE`
     * 	 - `sap.gantt.config.SETTING_ITEM_ENABLE_CURSOR_LINE`
     * 	 - `sap.gantt.config.SETTING_ITEM_ENABLE_VERTICAL_LINE`
     * 	 - `sap.gantt.config.SETTING_ITEM_ENABLE_TIME_SCROLL_SYNC`
     */
    export const DEFAULT_TOOLBAR_SETTING_ITEMS: SettingItem[];

    /**
     * Defines the default empty toolbar scheme.
     *
     * This toolbar scheme has no built-in toolbar items. Only one toolbar group `customToolbarItems` is configured
     * to allow applications to place custom toolbar items. Default values:
     * 	 - key - `sap.gantt.config.EMPTY_TOOLBAR_SCHEME_KEY`
     * 	 - customToolbarItems - `sap.gantt.config.ToolbarGroup({ position: "L1", overflowPriority: sap.m.OverflowToolbarPriority.High
     *     })`
     *
     * @deprecated (since 1.63) - Using these constants may result in errors in your application.
     */
    export const EMPTY_TOOLBAR_SCHEME: ToolbarScheme;

    /**
     * Defines the default empty toolbar scheme key.
     *
     * The default empty toolbar scheme key is used in the default empty toolbar scheme.
     */
    export const EMPTY_TOOLBAR_SCHEME_KEY: string;

    /**
     * Defines the default configuration object for enabling the adhoc line setting item. Default values:
     *
     * 	 - key - `sap.gantt.config.SETTING_ITEM_ENABLE_ADHOC_LINE_KEY`
     * 	 - checked - true
     * 	 - displayText - "Show Adhoc Lines"
     * 	 - tooltip - "Show Adhoc Lines"
     */
    export const SETTING_ITEM_ENABLE_ADHOC_LINE: SettingItem;

    /**
     * Defines the default setting item key for the adhoc lines.
     *
     * The default setting item key for adhoc lines is used in the default settings group configuration.
     */
    export const SETTING_ITEM_ENABLE_ADHOC_LINE_KEY: string;

    /**
     * Defines the default configuration object for enabling the cursor line setting items. Default values:
     *
     * 	 - key - `sap.gantt.config.SETTING_ITEM_ENABLE_CURSOR_LINE_KEY`
     * 	 - checked - true
     * 	 - displayText - "Show Cursor Line"
     * 	 - tooltip - "Show a Vertical Line that Follows the Mouse Pointer"
     */
    export const SETTING_ITEM_ENABLE_CURSOR_LINE: SettingItem;

    /**
     * Defines the default setting item key for the cursor line.
     *
     * Default setting item key for the cursor line is used in the default settings group configuration.
     */
    export const SETTING_ITEM_ENABLE_CURSOR_LINE_KEY: string;

    /**
     * Defines the default configuration object for enabling the delta line setting item.
     */
    export const SETTING_ITEM_ENABLE_DELTA_LINE: SettingItem;

    /**
     * Defines the default setting of the item key for delta lines.
     *
     * The default setting of the item key for delta lines is used in the default settings of group configuration.
     */
    export const SETTING_ITEM_ENABLE_DELTA_LINE_KEY: string;

    /**
     * Defines the default configuration object for enabling the Calendar Defs setting item.
     */
    export const SETTING_ITEM_ENABLE_NON_WORKING_TIME: SettingItem;

    /**
     * Defines the default setting of the item key for calendar defs.
     *
     * The default setting of the item key for calendar defs is used in the default settings of group configuration.
     */
    export const SETTING_ITEM_ENABLE_NON_WORKING_TIME_KEY: string;

    /**
     * Defines the default configuration object for enabling the present time indicator setting item. Default
     * values:
     * 	 - key - `sap.gantt.config.SETTING_ITEM_ENABLE_NOW_LINE_KEY`
     * 	 - checked - true
     * 	 - displayText - "Indicate Current Time"
     * 	 - tooltip - "Draw a Vertical Line to Indicate the Current Time"
     */
    export const SETTING_ITEM_ENABLE_NOW_LINE: SettingItem;

    /**
     * Defines the default setting item key for the present time indicator.
     *
     * Default setting item key for the present time indicator is used in the default settings group configuration.
     */
    export const SETTING_ITEM_ENABLE_NOW_LINE_KEY: string;

    /**
     * Defines the default configuration object for enabling the satus bar.
     *
     * @since 1.88
     */
    export const SETTING_ITEM_ENABLE_STATUS_BAR: SettingItem;

    /**
     * Defines the default setting item key for status bar.
     *
     * The default setting item key for status bar is used in the default settings of group configuration.
     *
     * @since 1.88
     */
    export const SETTING_ITEM_ENABLE_STATUS_BAR_KEY: string;

    /**
     * Defines the default configuration object for enabling the synchronized time scroll setting item. Default
     * values are:
     * 	 - key - `sap.gantt.config.SETTING_ITEM_ENABLE_TIME_SCROLL_SYNC_KEY`
     * 	 - checked - true
     * 	 - displayText - "Synchronize Time Scroll"
     * 	 - tooltip - "Synchronize Horizontal Scroll Bars in Chart"
     */
    export const SETTING_ITEM_ENABLE_TIME_SCROLL_SYNC: SettingItem;

    /**
     * Defines the default setting item key for synchronized time scroll.
     *
     * Default setting item key for synchronized time scroll is used in the default settings group configuration.
     */
    export const SETTING_ITEM_ENABLE_TIME_SCROLL_SYNC_KEY: string;

    /**
     * Defines the default configuration object for enabling vertical line setting item. Default values:
     *
     * 	 - key - `sap.gantt.config.SETTING_ITEM_ENABLE_VERTICAL_LINE_KEY`
     * 	 - checked - true
     * 	 - displayText - "Show Divider Lines"
     * 	 - tooltip - "Show Vertical Divider Lines between Time Periods"
     */
    export const SETTING_ITEM_ENABLE_VERTICAL_LINE: SettingItem;

    /**
     * Defines the default setting item key for the vertical lines.
     *
     * Default setting item key for vertical lines is used in the default settings group configuration.
     */
    export const SETTING_ITEM_ENABLE_VERTICAL_LINE_KEY: string;

    /**
     * Define the range of data that bird eye would use to calculate visibleHorizon
     */
    enum BirdEyeRange {
      /**
       * Bird eye will calculate visibleHorizon based on all rows of current view, but this mode may cause low
       * performance. Using this bird eye range, the result is not influenced by vertical scroll bar position
       * as the total rows never changes.
       */
      AllRows = "AllRows",
      /**
       * Bird eye will calculate visibleHorizon based on row data only in visible rows. Using this bird eye range,
       * the result can be influenced by vertical scroll bar position as visible rows may change with the movement
       * of the vertical scroll bar position.
       */
      VisibleRows = "VisibleRows",
    }
    /**
     * Defines the control where find and select search box will appear
     */
    enum FindMode {
      /**
       * Find and select search box will appear on container toolbar as well as search side panel User can toggle
       * between toolbar and side panel using "find popup" button and "side panel" button respectively
       */
      Both = "Both",
      /**
       * Find and select search box will appear only on the search side panel
       */
      SidePanel = "SidePanel",
      /**
       * Find and select search box will appear only on the container toolbar
       */
      Toolbar = "Toolbar",
    }
    /**
     * Different time units used as part of the zoom level. They are names of d3 time unit classes.
     */
    enum TimeUnit {
      /**
       * Time unit of day.
       */
      day = "d3.time.day",
      /**
       * Time unit of hour.
       */
      hour = "d3.time.hour",
      /**
       * Time unit of minute.
       */
      minute = "d3.time.minute",
      /**
       * Time unit of month.
       */
      month = "d3.time.month",
      /**
       * Time unit of week.
       */
      week = "d3.time.week",
      /**
       * Time unit of year.
       */
      year = "d3.time.year",
    }
    /**
     * Define the type of zoom control in global tool bar
     */
    enum ZoomControlType {
      /**
       * Uses the ButtonsOnly control to modify the time zoom rate. The SliderOnly control only consists of zoom
       * in and zoom out buttons.
       */
      ButtonsOnly = "ButtonsOnly",
      /**
       * Display no zoom control
       */
      None = "None",
      /**
       * Uses the Select control to modify the time zoom rate. The Select control consists of a drop down list
       * to select a suitable zoom rate.
       */
      Select = "Select",
      /**
       * Uses the SliderOnly control to modify the time zoom rate. The SliderOnly control only consists of a slider.
       */
      SliderOnly = "SliderOnly",
      /**
       * Uses the SliderWithButtons control to modify the time zoom rate. The SliderWithButtons control consists
       * of zoom in and zoom out magnifier buttons and a slider.
       */
      SliderWithButtons = "SliderWithButtons",
    }
  }

  export namespace def {
    namespace filter {
      /**
       * Color Matrix Values.
       *
       * The matrix decides what target color from source color.
       */
      enum ColorMatrixValue {
        /**
         * Turns every color to black.
         */
        AllToBlack = "-1 0 0 0 0, 0 -1 0 0 0, 0 0 -1 0 0, 0 0 0 1 0",
        /**
         * Turns every color to white.
         */
        AllToWhite = "-1 0 0 0 1, 0 -1 0 0 1, 0 0 -1 0 1, 0 0 0 1 0",
      }
      /**
       * Morphology Operators.
       *
       * The operator decides the morphology to make the shape fatter or slimmer.
       */
      enum MorphologyOperator {
        /**
         * Fatter Morphology.
         */
        Dilate = "dilate",
        /**
         * Slimmer Morphology.
         */
        Erode = "erode",
      }
    }
  }

  export namespace dragdrop {
    /**
     * Defines how Gantt Chart aligns a draggable shape to the mouse pointer before dragging.
     */
    enum GhostAlignment {
      /**
       * When you click on a shape to start a drag-and-drop operation, the upper-right corner of the shape is
       * automatically moved to the mouse pointer before you start dragging. This option makes the end time of
       * the shape align with the cursor line through the whole drag-and-drop process, and thus you can precisely
       * determine the end time when you drop the shape.
       */
      End = "End",
      /**
       * Default drag-and-drop behavior. When you click on a shape to start a drag-and-drop operation, Gantt Chart
       * does not move the shape before you start dragging. This option keeps the relative position between the
       * shape and the mouse pointer intact through the whole drag-and-drop process.
       */
      None = "None",
      /**
       * When you click on a shape to start a drag-and-drop operation, the upper-left corner of the shape is automatically
       * moved to the mouse pointer before you start dragging. This option makes the start time of the shape align
       * with the cursor line through the whole drag-and-drop process, and thus you can precisely determine the
       * start time when you drop the shape.
       */
      Start = "Start",
    }
    /**
     * Defines the side of the shape that gets attached to the nearest visual element.
     *
     * @since 1.91
     */
    enum SnapMode {
      /**
       * While dragging, the side of the shape that is nearest to a visual element snaps and attaches to that
       * visual element.
       */
      Both = "Both",
      /**
       * While dragging, the left side of the shape snaps and attaches to the nearest visual element.
       */
      Left = "Left",
      /**
       * While dragging, the shape does not snap to any side. This is the default snap mode.
       */
      None = "None",
      /**
       * While dragging, the right side of the shape snaps and attaches to the nearest visual element.
       */
      Right = "Right",
    }
  }

  export namespace palette {
    /**
     * Accent colors: sapUiAccent1-sapUiAccent10
     *
     * @since 1.69
     */
    export const AccentColors: any[];

    /**
     * Legend colors: sapUiLegend1-sapUiLegend20
     *
     * @since 1.69
     */
    export const LegendColors: any[];

    /**
     * Semantic colors:
     * 	 - `sapUiNegativeText` - Negative (warning)
     * 	 - `sapUiCriticalText` - Critical (alert)
     * 	 - `sapUiPositiveText` - Positive (success)
     * 	 - `sapUiInformativeText` - Informative (information)
     * 	 - `sapUiNeutralText` - Neutral (no level)
     *
     * @since 1.69
     */
    export const SemanticColors: string[];
  }

  export namespace shape {
    namespace ext {
      namespace rls {
        /**
         * Type of relationships
         */
        enum RelationshipType {
          /**
           * Finish to finish type.
           */
          FinishToFinish = "FinishToFinish",
          /**
           * Finish to start type.
           */
          FinishToStart = "FinishToStart",
          /**
           * Start to finish type.
           */
          StartToFinish = "StartToFinish",
          /**
           * Start to start type.
           */
          StartToStart = "StartToStart",
        }
      }
    }

    /**
     * Shape Categories.
     *
     * Different categories use different Drawers. Therefore, different categories may have different designs
     * of parameters in their getter methods.
     */
    enum ShapeCategory {
      /**
       * Shapes attached to one row.
       */
      InRowShape = "InRowShape",
      /**
       * Relationship shapes connecting two in-row shape instances.
       */
      Relationship = "relationship",
    }
  }

  export namespace simple {
    namespace exportTableCustomDataType {
      /**
       * Property of type Boolean.
       */
      export const Boolean: undefined;

      /**
       * Property of type Currency.
       */
      export const Currency: undefined;

      /**
       * Property of type Date.
       */
      export const Date: undefined;

      /**
       * Property of type DateTime.
       */
      export const DateTime: undefined;

      /**
       * Property of type Numeric.
       */
      export const Numeric: undefined;

      /**
       * Property of type String.
       */
      export const String: undefined;

      /**
       * Property of type StringDate.
       */
      export const StringDate: undefined;

      /**
       * Property of type Time.
       */
      export const Time: undefined;
    }

    namespace shapes {
      /**
       * Configuration options for vertical alignment of shape representing a Task. This is only applicable for
       * Tasks.
       *
       * @since 1.81
       */
      enum ShapeAlignment {
        /**
         * Summary task is aligned at the bottom.
         */
        Bottom = "Bottom",
        /**
         * Summary task is aligned at the center.
         */
        Middle = "Middle",
        /**
         * Summary task is aligned at the top.
         */
        Top = "Top",
      }
      /**
       * Type of task shape.
       *
       * @since 1.69
       */
      enum TaskType {
        /**
         * An error task.
         */
        Error = "Error",
        /**
         * A normal task.
         */
        Normal = "Normal",
        /**
         * A collapsed summary task.
         */
        SummaryCollapsed = "SummaryCollapsed",
        /**
         * An expanded summary task.
         */
        SummaryExpanded = "SummaryExpanded",
      }
    }

    /**
     * Type connector shapes for relationship
     *
     * @since 1.86
     */
    enum connectorType {
      Arrow = "Arrow",

      Circle = "Circle",

      Diamond = "Diamond",
      /**
       * primarily used for overlapping of connector shapes.
       */
      HorizontalRectangle = "HorizontalRectangle",

      None = "None",

      Square = "Square",

      VerticalRectangle = "VerticalRectangle",
    }
    /**
     * Toolbar placeholders for a Gantt chart container.
     */
    enum ContainerToolbarPlaceholderType {
      /**
       * /** A bird eye toolbar button.
       */
      BirdEyeButton = "BirdEyeButton",
      /**
       * A display type toolbar button.
       */
      DisplayTypeButton = "DisplayTypeButton",
      /**
       * A legend toolbar button.
       */
      LegendButton = "LegendButton",
      /**
       * Settings toolbar button.
       */
      SettingButton = "SettingButton",
      /**
       * A toolbar spacer that can be used between buttons.
       */
      Spacer = "Spacer",
      /**
       * A time zoom control.
       */
      TimeZoomControl = "TimeZoomControl",
      /**
       * A Variant Management button.
       */
      VariantManagement = "VariantManagement",
    }
    /**
     * Defines the relationship between the operator and the property names using the findAll method
     *
     * @since 1.100
     */
    enum findByOperator {
      AND = "AND",

      OR = "OR",
    }
    /**
     * Gantt chart display types.
     */
    enum GanttChartWithTableDisplayType {
      /**
       * The {@link sap.gantt.simple.GanttChartWithTable} control displays both a table and a chart.
       */
      Both = "Both",
      /**
       * The {@link sap.gantt.simple.GanttChartWithTable} control displays only a chart.
       */
      Chart = "Chart",
      /**
       * The {@link sap.gantt.simple.GanttChartWithTable} control displays only a table.
       */
      Table = "Table",
    }
    /**
     * Configuration options for horizontal alignment of title of the shape representing a Task.
     *
     * @since 1.81
     */
    enum horizontalTextAlignment {
      /**
       * Shape title moves dynamically with horizontal scroll and zoom.
       *
       * @since 1.96
       */
      Dynamic = "Dynamic",
      /**
       * Shape title is aligned at the end of the x-axis.
       */
      End = "End",
      /**
       * Shape title is aligned at the center of the x-axis.
       */
      Middle = "Middle",
      /**
       * Shape title is aligned at the start of the x-axis.
       */
      Start = "Start",
    }
    /**
     * Size of shapes in the relationship
     *
     * @since 1.96
     */
    enum relationshipShapeSize {
      Large = "Large",

      Medium = "Medium",

      Small = "Small",
    }
    /**
     * Type of relationship shape. `sap.gantt.simple.RelationshipType` shall be used to define property type
     * on class `sap.gantt.simple.Relationship`
     *
     * @since 1.60.0
     */
    enum RelationshipType {
      /**
       * Finish to finish type.
       */
      FinishToFinish = "FinishToFinish",
      /**
       * Finish to start type.
       */
      FinishToStart = "FinishToStart",
      /**
       * Start to finish type.
       */
      StartToFinish = "StartToFinish",
      /**
       * Start to start type.
       */
      StartToStart = "StartToStart",
    }
    /**
     * Configuration options for vertical alignment of title of the shape representing a Task.
     *
     * @since 1.81
     */
    enum verticalTextAlignment {
      /**
       * Shape title is aligned at the bottom of the shape.
       */
      Bottom = "Bottom",
      /**
       * Shape title is aligned at the center of the shape.
       */
      Center = "Center",
      /**
       * Shape title is aligned at the top of the shape.
       */
      Top = "Top",
    }
    /**
     * This specifies the sub reason detailing why the visible horizon is changing
     *
     * @since 1.100
     */
    enum VisibleHorizonUpdateSubType {
      /**
       * Default value of VisibleHorizonUpdateSubType when VisibleHorizonUpdateType is other than ZoomLevelChanged.
       */
      NotApplicable = "NotApplicable",
      /**
       * The Visible horizon is updated when zoomed in.
       */
      ZoomIn = "ZoomIn",
      /**
       * The Visible horizon is updated when zoomed out.
       */
      ZoomOut = "ZoomOut",
    }
    /**
     * This type specifies the reason why visible horizon is changing.
     *
     * @since 1.68
     */
    enum VisibleHorizonUpdateType {
      /**
       * The visible horizon is updated when a user scrolls using the Gantt chart horizontal scroll bar.
       */
      HorizontalScroll = "HorizontalScroll",
      /**
       * The visible horizon is updated when Gantt chart gets rendered (which is triggered by an `onAfterRenderer`
       * event) and needs to set visible horizon based on the chart configuration.
       */
      InitialRender = "InitialRender",
      /**
       * The update is triggered by the user scrolling horizontally with a mouse wheel (Ctrl + Shift + mouse wheel).
       */
      MouseWheelZoom = "MouseWheelZoom",
      /**
       * The update is triggered by the {@link sap.gantt.simple.GanttChartContainer}. This update is used to keep
       * all Gantt charts in one container in sync. When the user performs an action that changes the visible
       * horizon, an event with the action type is fired on the original Gantt chart and `SyncVisibleHorizon`
       * gets fired on all other Gantt charts in the container.
       */
      SyncVisibleHorizon = "SyncVisibleHorizon",
      /**
       * An update happens when the user selects a time period using the Z key + mouse.
       */
      TimePeriodZooming = "TimePeriodZooming",
      /**
       * The visible horizon is updated when the total horizon of a Gantt chart changes or is set. Changes in
       * total horizon may affect the visible horizon as well.
       */
      TotalHorizonUpdated = "TotalHorizonUpdated",
      /**
       * The visible horizon is updated when the zoom level is changed, either by the user or the application.
       */
      ZoomLevelChanged = "ZoomLevelChanged",
    }
    /**
     * Configaration option for yAxis Column.
     *
     * @since 1.102
     */
    enum yAxisColumnContent {
      /**
       * yAis column has only threshold with width of 52px.
       */
      OnlyThreshold = "OnlyThreshold",
      /**
       * yAxis column has threshold and label with width of 124px.
       */
      ThresholdwithLabel = "ThresholdwithLabel",
      /**
       * yAxis column has threshold, label and UOM with Width of 192px.
       */
      ThresholdwithLabelandUOM = "ThresholdwithLabelandUOM",
      /**
       * yAxis column has threshould and UOM with width of 128px.
       */
      ThresholdwithUOM = "ThresholdwithUOM",
    }
  }
}

declare module "sap/gantt/AdhocLine" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The AdhocLine class contains properties to draw an additional vertical line at specific time points in
   * the chart area. You can use this line to mark milestones, such as the start of a project start, and special
   * events, such as holidays.
   *
   * @deprecated (since 1.84) - {@link sap.gantt.simple.AdhocLine} should be used instead.
   */
  export default class AdhocLine extends UI5Element {
    /**
     * Creates and initializes a new AdhocLine class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocLineSettings
    );
    /**
     * Creates and initializes a new AdhocLine class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocLineSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.AdhocLine with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AdhocLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.AdhocLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDescription description}.
     *
     * Description of the time stamp
     *
     *
     * @returns Value of property `description`
     */
    getDescription(): string;
    /**
     * Gets current value of property {@link #getStroke stroke}.
     *
     * Standard SVG 'stroke' attribute. You can provide the stroke attribute with HTML colors and the URL reference
     * to the paint server. Paint server definitions usually come from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `stroke`
     */
    getStroke(): ValueSVGPaintServer;
    /**
     * Gets current value of property {@link #getStrokeDasharray strokeDasharray}.
     *
     * Standard SVG 'stroke-dasharray' attribute.
     *
     *
     * @returns Value of property `strokeDasharray`
     */
    getStrokeDasharray(): string;
    /**
     * Gets current value of property {@link #getStrokeOpacity strokeOpacity}.
     *
     * Standard SVG 'stroke-opacity' attribute.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `strokeOpacity`
     */
    getStrokeOpacity(): float;
    /**
     * Gets current value of property {@link #getStrokeWidth strokeWidth}.
     *
     * Standard SVG 'stroke-width' attribute.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `strokeWidth`
     */
    getStrokeWidth(): float;
    /**
     * Gets current value of property {@link #getTimeStamp timeStamp}.
     *
     * Time stamp of the adhoc line
     *
     *
     * @returns Value of property `timeStamp`
     */
    getTimeStamp(): string;
    /**
     * Sets a new value for property {@link #getDescription description}.
     *
     * Description of the time stamp
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDescription(
      /**
       * New value for property `description`
       */
      sDescription: string
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * Standard SVG 'stroke' attribute. You can provide the stroke attribute with HTML colors and the URL reference
     * to the paint server. Paint server definitions usually come from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeDasharray strokeDasharray}.
     *
     * Standard SVG 'stroke-dasharray' attribute.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeDasharray(
      /**
       * New value for property `strokeDasharray`
       */
      sStrokeDasharray: string
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeOpacity strokeOpacity}.
     *
     * Standard SVG 'stroke-opacity' attribute.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeOpacity(
      /**
       * New value for property `strokeOpacity`
       */
      fStrokeOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * Standard SVG 'stroke-width' attribute.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      fStrokeWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTimeStamp timeStamp}.
     *
     * Time stamp of the adhoc line
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeStamp(
      /**
       * New value for property `timeStamp`
       */
      sTimeStamp: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AdhocLine constructor.
   *
   * @deprecated (since 1.84) - {@link sap.gantt.simple.AdhocLine} should be used instead.
   */
  export interface $AdhocLineSettings extends $ElementSettings {
    /**
     * Standard SVG 'stroke' attribute. You can provide the stroke attribute with HTML colors and the URL reference
     * to the paint server. Paint server definitions usually come from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     */
    stroke?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    /**
     * Standard SVG 'stroke-width' attribute.
     */
    strokeWidth?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Standard SVG 'stroke-dasharray' attribute.
     */
    strokeDasharray?: string | PropertyBindingInfo;

    /**
     * Standard SVG 'stroke-opacity' attribute.
     */
    strokeOpacity?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Time stamp of the adhoc line
     */
    timeStamp?: string | PropertyBindingInfo;

    /**
     * Description of the time stamp
     */
    description?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/axistime/AxisTimeStrategyBase" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Locale from "sap/gantt/config/Locale";

  import CalendarWeekNumbering from "sap/ui/core/date/CalendarWeekNumbering";

  import DateFormat from "sap/ui/core/format/DateFormat";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { MouseWheelZoomType } from "sap/gantt/library";

  import TimeHorizon from "sap/gantt/config/TimeHorizon";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for all zoom strategies. This base class defines basic properties and aggregations.
   *
   * This base class defines:
   * 	 - Basic properties and aggregations.  This class controls the zoom strategies and zoom rate in
   *     Gantt Chart. sap.gantt provides three basic implementations of `AxisTimeStrategy`:
   * 	 - `sap.gantt.axistime.ProportionZoomStrategy` - A zoom strategy that provides the proportional change
   *     ability. Proportional change ensures that Gantt Chart dynamically adjusts the zoom rate to be the best
   *     fit for rendering shapes in the chart area. This strategy cannot be used by the Select control.
   * 	 - `sap.gantt.axistime.FullScreenStrategy` - A zoom strategy that sets the value of `totalHorizon` to
   *     the value of `visibleHorizon`. When this strategy is implemented, `visibleHorizon` is fixed. Because
   *     of this, when you scroll the splitter to expand or shrink the chart area, the value of `visibleHorizon`
   *     remains intact, which makes shapes look larger or smaller accordingly. Moreover, the horizontal scroll
   *     bar never appears and the zoom control is deactivated.
   * 	 - `sap.gantt.axistime.StepwiseZoomStrategy` - A zoom strategy that provides the stepwise change ability
   *     to control the zoom level of Gantt Chart, which is often used by the Select zoom control.
   */
  export default abstract class AxisTimeStrategyBase extends UI5Element {
    /**
     * Creates and initializes a new AxisTimeStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $AxisTimeStrategyBaseSettings
    );
    /**
     * Creates and initializes a new AxisTimeStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new AxisTimeStrategy, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $AxisTimeStrategyBaseSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.axistime.AxisTimeStrategyBase with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AxisTimeStrategyBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.axistime.AxisTimeStrategyBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Calculates the middle date of the given two dates.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns the middle date
     */
    calMiddleDate(
      /**
       * the start date
       */
      dStart: Date,
      /**
       * the end date
       */
      dEnd: Date
    ): Date;
    /**
     * Calculate new visible horizon according to specified zoom center and zoom delta
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns a new visible horizon
     */
    calVisibleHorizonByDelta(
      /**
       * the delta of visible horizon time range in MS unit
       */
      nTimeSpanDelta: number,
      /**
       * optional the time where the zoom center located, if not provided, take the center of current visible
       * horizon as the zoom center
       */
      oAnchorTime?: Date
    ): object;
    /**
     * Calculate new visible horizon according to specified zoom center and zoom rate
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns a new visible horizon
     */
    calVisibleHorizonByRate(
      /**
       * the rate for new visible horizon
       */
      nZoomRate: number,
      /**
       * optional the time where the zoom center located, if not provided, take the center of current visible
       * horizon as the zoom center
       */
      oAnchorTime?: Date
    ): object;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns whether this._oZoom.base is generated
     */
    calZoomBase(): boolean;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    calZoomScale(): void;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    calZoomScaleByDate(): void;
    /**
     * Defaults the firstDayOfWeek property to a value from locale if user didn't specify it
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    checkFirstDayOfWeek(
      /**
       * Map/JSON-object with initial property values, aggregated objects etc. for the new object
       */
      mSettings: object
    ): void;
    /**
     * Creates an AxisTime instance to be used in Gantt Chart. If you build your own AxisTimeStrategy, you may
     * need to implement this method and return your own AxisTime.
     */
    createAxisTime(
      /**
       * Locale configuration passed from GanttChart
       */
      oLocale: Locale
    ): void;
    /**
     * Destroys the totalHorizon in the aggregation {@link #getTotalHorizon totalHorizon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTotalHorizon(): this;
    /**
     * Destroys the visibleHorizon in the aggregation {@link #getVisibleHorizon visibleHorizon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyVisibleHorizon(): this;
    /**
     * Gets current value of property {@link #getCalendarType calendarType}.
     *
     * Configures the calendar type for the Gantt Chart time label. We recommend that you set the type of this
     * argument to `sap.ui.core.CalendarType`. Otherwise some properties you set may not function properly.
     *
     * Default value is `sap.ui.core.CalendarType.Gregorian`.
     *
     *
     * @returns Value of property `calendarType`
     */
    getCalendarType(): string;
    /**
     * Gets current value of property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.110.0
     *
     * @returns Value of property `calendarWeekNumbering`
     */
    getCalendarWeekNumbering(): CalendarWeekNumbering;
    /**
     * Gets current value of property {@link #getCoarsestTimeLineOption coarsestTimeLineOption}.
     *
     * Coarsest time line option of AxisTimeStrategy
     *
     *
     * @returns Value of property `coarsestTimeLineOption`
     */
    getCoarsestTimeLineOption(): object;
    /**
     * Gets current value of property {@link #getFinestTimeLineOption finestTimeLineOption}.
     *
     * Finest time line option of AxisTimeStrategy
     *
     *
     * @returns Value of property `finestTimeLineOption`
     */
    getFinestTimeLineOption(): object;
    /**
     * Gets current value of property {@link #getFirstDayOfWeek firstDayOfWeek}.
     *
     * Configures the first day of the week relevant for displaying the Gantt Chart time intervals.
     *  This property has the same value type as {@link sap.ui.core.LocaleData#getFirstDayOfWeek} and by default
     * uses the value from the current locale.
     *
     * @since 1.73
     *
     * @returns Value of property `firstDayOfWeek`
     */
    getFirstDayOfWeek(): int;
    /**
     * Gets current value of property {@link #getLocale locale}.
     *
     * Configures the locale of the Gantt Chart time label. We recommend that you set the type of this argument
     * to `sap.ui.core.Locale`. Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `locale`
     */
    getLocale(): object;
    /**
     * Gets the time label formatter for Gantt Chart to draw the lower row in the timeline.
     *
     *
     * @returns Date formatter
     */
    getLowerRowFormatter(): DateFormat;
    /**
     * Gets current value of property {@link #getMouseWheelZoomType mouseWheelZoomType}.
     *
     * Specifies the mouse wheel zooming type, which determines the zoom granularity
     *
     * Default value is `FineGranular`.
     *
     *
     * @returns Value of property `mouseWheelZoomType`
     */
    getMouseWheelZoomType():
      | MouseWheelZoomType
      | keyof typeof MouseWheelZoomType;
    /**
     * Gets current value of property {@link #getTimeLineOption timeLineOption}.
     *
     * Current time line option of AxisTimeStrategy
     *
     *
     * @returns Value of property `timeLineOption`
     */
    getTimeLineOption(): object;
    /**
     * Gets current value of property {@link #getTimeLineOptions timeLineOptions}.
     *
     * Defines granularity levels, labelling formats, and range of the time line.
     * 	 - granularity level: time span between two neighboring vertical lines. Examples: 12 hours.
     * 	 - labelling format: time formats for the upper row and lower row in the time line. These two rows do
     *     not have to share the same format.
     * 	 - range: defines a certain length in pixel. Gantt Chart loops the granularity levels from the beginning
     *     and chooses the first granularity level with the time span that consumes more than the defined length.
     *     For example, if the current range is 90, Gantt Chart loops the granularity levels from the default initial
     *     granularity level 5min. If the 6hour granularity level consumes 50 pixels, 12hour consumes 100 pixels,
     *     and 1Day consumes 200 pixels, the 12hour granularity level is selected as the current granularity level
     *     as it's the first level with the time span that consumes more than 90 pixels.
     *
     * The granularity level is a JSON object with the granularity as the key and some internal information
     * such as formatting.
     *
     * Take the `"12hour"` granularity level for example.
     * 	 - `"12hour":` - Granularity level ID.
     * 	 `"innerInterval"` - Time interval between neighboring vertical lines is 12 hours.
     * 	`"unit": sap.gantt.config.TimeUnit.day` - Time unit is day.
     * 	 - `"span": 1` - Span is 1.
     * 	 - `"range": 90` - This granularity level is selected as the current level if 12 hours is the first
     *     time span that consumes more than 90 pixels to be displayed in the chart area.
     * 	 -  `largeInterval` - Time interval of the upper row in the timeline is 1 day. Formatted in the locale
     *     language with the format string. This zoom level implements an interval larger than the interval in the
     *     default zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.day` Time unit is day.
     * 	 - `"span": 1` - Time span is 1.
     * 	 - `"format": "cccc dd.M.yyyy"` - Formats the string in CLDR date/time symbols.
     * 	 - `"pattern": "yyyy"` -Aa data pattern in LDML format. This setting takes precedence over the setting
     *     of "format".
     * 	 - `"relativeTime": true` - Specifies whether or not to use relative time mode, which defaults to "false".
     *     When you set this property to "true", Gantt Chart ignores the values of "format" and "pattern". In this
     *     mode, if the largeInterval or the smallInterval of the timeline option uses the "sap.gantt.config.TimeUnit.day"
     *     or "sap.gantt.config.TimeUnit.week" unit, you must set the span to 1.
     * 	 - `"relativeTimePrefix": "Day"` - A string that specifies the prefix displayed before every relative
     *     time point. For example, if you set this property to "Day", the relative timeline will display "Day 1",
     *     "Day 2", "Day 3", and so on so forth.
     * 	 -  `smallInterval` - Time interval of the lower row in the timeline is 12 hours. Formatted in the locale
     *     language with the format string. This zoom level implements an interval the same as the that of the default
     *     zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.hour` - Time unit is hour.
     * 	 - `"span": 2` - Time span is 2.
     * 	 - `"format": "HH:mm"` - Formats the string in CLDR date/time symbols.
     * 	 - `"relativeTime": false`
     *
     * The current granularity setting provides the following values in the default time line option:
     *  `5min`, `10min`, `15min`, `30min`,
     *  `1hour`, `2hour`, `4hour`, `6hour`, `12hour`,
     *  `1day`, `2day`, `4day`,
     *  `1week`, `2week`,
     *  `1month`, `2month`, `4month`, `6month`,
     *  `1year`, `2year`, `5year`. We recommend that you use the default time line option object instead of
     * creating one by yourself. Because the default time line option object has been precisely calculated and
     * it fits most use cases. If the default time line option is not the best-fit, you can select a time line
     * option from the range (coarsestTimeLineOption, 5 years to finestTimeLineOption, 5 minutes) listed above.
     * Note that creating a new time line option object is a complex process. Moreover, the extra effort may
     * not serve significant purposes and is likely to cause text overlay in the Gantt Chart header.
     *
     *
     * @returns Value of property `timeLineOptions`
     */
    getTimeLineOptions(): object;
    /**
     * Gets content of aggregation {@link #getTotalHorizon totalHorizon}.
     *
     * Entire time span Gantt Chart can display in the chart area We recommend that you set the type of this
     * argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not function properly.
     *
     * Default totalHorizon value is: `sap.gantt.config.DEFAULT_TOTAL_HORIZON `
     */
    getTotalHorizon(): TimeHorizon;
    /**
     * Gets the time label formatter for Gantt Chart to draw the top row in the timeline.
     *
     *
     * @returns Date formatter
     */
    getUpperRowFormatter(): DateFormat;
    /**
     * Gets content of aggregation {@link #getVisibleHorizon visibleHorizon}.
     *
     * Time span Gantt Chart currently displays in the chart area Specifies the start and end points of the
     * time span that is visible in the chart area. `visibleHorizon` is less than or equal to `totalHorizon`.
     * You can configure the time horizon using one of the following patterns:
     * 	 - [startTime, null]: Jump to the position where the start time is on the left edge of the screen without
     *     changing the zoom rate. When you use this pattern, Gantt Chart calculates the endTime according to the
     *     current zoom rate.
     * 	 - [null, endTime]: Jump to the position where the end time is on the right edge of the screen without
     *     changing the zoom rate. When you use this pattern, Gantt Chart calculates the startTime accoridng to
     *     the current zoom rate.
     * 	 - [startTime, endTime]: Every strategy has their own implementation to control misc.AxisTime.
     *
     * **Note:** Before you set visibleHorizon, you have to set totalHorizon first. We recommend that you set
     * the type of this argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not
     * function properly.
     *
     * Default visible horizon value is `sap.gantt.config.DEFAULT_VISIBLE_HORIZON`
     */
    getVisibleHorizon(): TimeHorizon;
    /**
     * Gets current value of property {@link #getZoomLevel zoomLevel}.
     *
     * Current zoom level of your Gantt chart with 0 representing the initial zoom level. The value of this
     * property must be lower than that of totalZoomLevels.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `zoomLevel`
     */
    getZoomLevel(): int;
    /**
     * Gets current value of property {@link #getZoomLevels zoomLevels}.
     *
     * Total number of zoom levels on your zoom control. For example, the step count of Slider control and the
     * item count of Select control.
     *
     * Default value is `10`.
     *
     *
     * @returns Value of property `zoomLevels`
     */
    getZoomLevels(): int;
    /**
     * Sets a new value for property {@link #getCalendarType calendarType}.
     *
     * Configures the calendar type for the Gantt Chart time label. We recommend that you set the type of this
     * argument to `sap.ui.core.CalendarType`. Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.ui.core.CalendarType.Gregorian`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarType(
      /**
       * New value for property `calendarType`
       */
      sCalendarType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.110.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarWeekNumbering(
      /**
       * New value for property `calendarWeekNumbering`
       */
      sCalendarWeekNumbering?: CalendarWeekNumbering
    ): this;
    /**
     * Sets a new value for property {@link #getCoarsestTimeLineOption coarsestTimeLineOption}.
     *
     * Coarsest time line option of AxisTimeStrategy
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCoarsestTimeLineOption(
      /**
       * New value for property `coarsestTimeLineOption`
       */
      oCoarsestTimeLineOption: object
    ): this;
    /**
     * Sets a new value for property {@link #getFinestTimeLineOption finestTimeLineOption}.
     *
     * Finest time line option of AxisTimeStrategy
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFinestTimeLineOption(
      /**
       * New value for property `finestTimeLineOption`
       */
      oFinestTimeLineOption: object
    ): this;
    /**
     * Sets a new value for property {@link #getFirstDayOfWeek firstDayOfWeek}.
     *
     * Configures the first day of the week relevant for displaying the Gantt Chart time intervals.
     *  This property has the same value type as {@link sap.ui.core.LocaleData#getFirstDayOfWeek} and by default
     * uses the value from the current locale.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.73
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFirstDayOfWeek(
      /**
       * New value for property `firstDayOfWeek`
       */
      iFirstDayOfWeek: int
    ): this;
    /**
     * Sets a new value for property {@link #getLocale locale}.
     *
     * Configures the locale of the Gantt Chart time label. We recommend that you set the type of this argument
     * to `sap.ui.core.Locale`. Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLocale(
      /**
       * New value for property `locale`
       */
      oLocale: object
    ): this;
    /**
     * Sets a new value for property {@link #getMouseWheelZoomType mouseWheelZoomType}.
     *
     * Specifies the mouse wheel zooming type, which determines the zoom granularity
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `FineGranular`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMouseWheelZoomType(
      /**
       * New value for property `mouseWheelZoomType`
       */
      sMouseWheelZoomType?: MouseWheelZoomType | keyof typeof MouseWheelZoomType
    ): this;
    /**
     * Sets a new value for property {@link #getTimeLineOption timeLineOption}.
     *
     * Current time line option of AxisTimeStrategy
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeLineOption(
      /**
       * New value for property `timeLineOption`
       */
      oTimeLineOption: object
    ): this;
    /**
     * Sets a new value for property {@link #getTimeLineOptions timeLineOptions}.
     *
     * Defines granularity levels, labelling formats, and range of the time line.
     * 	 - granularity level: time span between two neighboring vertical lines. Examples: 12 hours.
     * 	 - labelling format: time formats for the upper row and lower row in the time line. These two rows do
     *     not have to share the same format.
     * 	 - range: defines a certain length in pixel. Gantt Chart loops the granularity levels from the beginning
     *     and chooses the first granularity level with the time span that consumes more than the defined length.
     *     For example, if the current range is 90, Gantt Chart loops the granularity levels from the default initial
     *     granularity level 5min. If the 6hour granularity level consumes 50 pixels, 12hour consumes 100 pixels,
     *     and 1Day consumes 200 pixels, the 12hour granularity level is selected as the current granularity level
     *     as it's the first level with the time span that consumes more than 90 pixels.
     *
     * The granularity level is a JSON object with the granularity as the key and some internal information
     * such as formatting.
     *
     * Take the `"12hour"` granularity level for example.
     * 	 - `"12hour":` - Granularity level ID.
     * 	 `"innerInterval"` - Time interval between neighboring vertical lines is 12 hours.
     * 	`"unit": sap.gantt.config.TimeUnit.day` - Time unit is day.
     * 	 - `"span": 1` - Span is 1.
     * 	 - `"range": 90` - This granularity level is selected as the current level if 12 hours is the first
     *     time span that consumes more than 90 pixels to be displayed in the chart area.
     * 	 -  `largeInterval` - Time interval of the upper row in the timeline is 1 day. Formatted in the locale
     *     language with the format string. This zoom level implements an interval larger than the interval in the
     *     default zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.day` Time unit is day.
     * 	 - `"span": 1` - Time span is 1.
     * 	 - `"format": "cccc dd.M.yyyy"` - Formats the string in CLDR date/time symbols.
     * 	 - `"pattern": "yyyy"` -Aa data pattern in LDML format. This setting takes precedence over the setting
     *     of "format".
     * 	 - `"relativeTime": true` - Specifies whether or not to use relative time mode, which defaults to "false".
     *     When you set this property to "true", Gantt Chart ignores the values of "format" and "pattern". In this
     *     mode, if the largeInterval or the smallInterval of the timeline option uses the "sap.gantt.config.TimeUnit.day"
     *     or "sap.gantt.config.TimeUnit.week" unit, you must set the span to 1.
     * 	 - `"relativeTimePrefix": "Day"` - A string that specifies the prefix displayed before every relative
     *     time point. For example, if you set this property to "Day", the relative timeline will display "Day 1",
     *     "Day 2", "Day 3", and so on so forth.
     * 	 -  `smallInterval` - Time interval of the lower row in the timeline is 12 hours. Formatted in the locale
     *     language with the format string. This zoom level implements an interval the same as the that of the default
     *     zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.hour` - Time unit is hour.
     * 	 - `"span": 2` - Time span is 2.
     * 	 - `"format": "HH:mm"` - Formats the string in CLDR date/time symbols.
     * 	 - `"relativeTime": false`
     *
     * The current granularity setting provides the following values in the default time line option:
     *  `5min`, `10min`, `15min`, `30min`,
     *  `1hour`, `2hour`, `4hour`, `6hour`, `12hour`,
     *  `1day`, `2day`, `4day`,
     *  `1week`, `2week`,
     *  `1month`, `2month`, `4month`, `6month`,
     *  `1year`, `2year`, `5year`. We recommend that you use the default time line option object instead of
     * creating one by yourself. Because the default time line option object has been precisely calculated and
     * it fits most use cases. If the default time line option is not the best-fit, you can select a time line
     * option from the range (coarsestTimeLineOption, 5 years to finestTimeLineOption, 5 minutes) listed above.
     * Note that creating a new time line option object is a complex process. Moreover, the extra effort may
     * not serve significant purposes and is likely to cause text overlay in the Gantt Chart header.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeLineOptions(
      /**
       * New value for property `timeLineOptions`
       */
      oTimeLineOptions: object
    ): this;
    /**
     * Sets the aggregated {@link #getTotalHorizon totalHorizon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTotalHorizon(
      /**
       * The totalHorizon to set
       */
      oTotalHorizon: TimeHorizon
    ): this;
    /**
     * Sets the aggregated {@link #getVisibleHorizon visibleHorizon}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisibleHorizon(
      /**
       * The visibleHorizon to set
       */
      oVisibleHorizon: TimeHorizon
    ): this;
    /**
     * Sets a new value for property {@link #getZoomLevel zoomLevel}.
     *
     * Current zoom level of your Gantt chart with 0 representing the initial zoom level. The value of this
     * property must be lower than that of totalZoomLevels.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomLevel(
      /**
       * New value for property `zoomLevel`
       */
      iZoomLevel?: int
    ): this;
    /**
     * Sets a new value for property {@link #getZoomLevels zoomLevels}.
     *
     * Total number of zoom levels on your zoom control. For example, the step count of Slider control and the
     * item count of Select control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomLevels(
      /**
       * New value for property `zoomLevels`
       */
      iZoomLevels?: int
    ): this;
    /**
     * In the shape drawing process, Gantt Chart calls this function to get the latest information about Stop
     * and AxisTime. Moreover, when you run this function, AxisTimeStrategy updates the GanttChart status such
     * as the zoom rate of AxisTime.
     *
     *
     * @returns The status plain object about AxisTimeStrategy. The return contains two properties `zoomLevel`
     * and `axisTimeChanged`.
     */
    syncContext(
      /**
       * Width of the visible area in Gantt Chart
       */
      nClientWidth: int
    ): object;
    /**
     * This is the delegate function of the zoom control event, such as the zoom in or zoom out event. You must
     * implement your zoom level change logic.
     */
    updateStopInfo(
      /**
       * Zoom stop information, which contains the parameters `key` and `text`.
       */
      oStopInfo: object
    ): void;
    /**
     * Calculate and set new visible horizon for fine granular mouse wheel zoom
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    updateVisibleHorizonOnFineGranularMouseWheelZoom(
      /**
       * the time where mouse pointer located during the zooming
       */
      oTimeAtZoomCenter: Date,
      /**
       * true if zoom in, false if zoom out
       */
      bZoomIn: boolean,
      /**
       * the scroll range of each mouse wheel scrolling / 100, serves as a coefficient when calculating zoom delta
       */
      iZoomFactor: number
    ): void;
    /**
     * update visible horizon for mouse wheel zoom according to configured zoom type
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    updateVisibleHorizonOnMouseWheelZoom(
      /**
       * the time where mouse pointer located during the zooming
       */
      oTimeAtZoomCenter: Date,
      /**
       * the range of each mouse wheel scrolling
       */
      iScrollDelta: number
    ): void;
    /**
     * Calculate and set new visible horizon for step-wise mouse wheel zoom
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    updateVisibleHorizonOnStepWiseMouseWheelZoom(
      /**
       * the time where mouse pointer located during the zooming
       */
      oTimeAtZoomCenter: Date,
      /**
       * true if zoom in, false if zoom out
       */
      bZoomIn: boolean,
      /**
       * the scroll range of each mouse wheel scrolling / 100, serves as a coefficient when calculating zoom delta
       */
      iZoomFactor: number
    ): void;
  }
  /**
   * Describes the settings that can be provided to the AxisTimeStrategyBase constructor.
   */
  export interface $AxisTimeStrategyBaseSettings extends $ElementSettings {
    /**
     * Defines granularity levels, labelling formats, and range of the time line.
     * 	 - granularity level: time span between two neighboring vertical lines. Examples: 12 hours.
     * 	 - labelling format: time formats for the upper row and lower row in the time line. These two rows do
     *     not have to share the same format.
     * 	 - range: defines a certain length in pixel. Gantt Chart loops the granularity levels from the beginning
     *     and chooses the first granularity level with the time span that consumes more than the defined length.
     *     For example, if the current range is 90, Gantt Chart loops the granularity levels from the default initial
     *     granularity level 5min. If the 6hour granularity level consumes 50 pixels, 12hour consumes 100 pixels,
     *     and 1Day consumes 200 pixels, the 12hour granularity level is selected as the current granularity level
     *     as it's the first level with the time span that consumes more than 90 pixels.
     *
     * The granularity level is a JSON object with the granularity as the key and some internal information
     * such as formatting.
     *
     * Take the `"12hour"` granularity level for example.
     * 	 - `"12hour":` - Granularity level ID.
     * 	 `"innerInterval"` - Time interval between neighboring vertical lines is 12 hours.
     * 	`"unit": sap.gantt.config.TimeUnit.day` - Time unit is day.
     * 	 - `"span": 1` - Span is 1.
     * 	 - `"range": 90` - This granularity level is selected as the current level if 12 hours is the first
     *     time span that consumes more than 90 pixels to be displayed in the chart area.
     * 	 -  `largeInterval` - Time interval of the upper row in the timeline is 1 day. Formatted in the locale
     *     language with the format string. This zoom level implements an interval larger than the interval in the
     *     default zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.day` Time unit is day.
     * 	 - `"span": 1` - Time span is 1.
     * 	 - `"format": "cccc dd.M.yyyy"` - Formats the string in CLDR date/time symbols.
     * 	 - `"pattern": "yyyy"` -Aa data pattern in LDML format. This setting takes precedence over the setting
     *     of "format".
     * 	 - `"relativeTime": true` - Specifies whether or not to use relative time mode, which defaults to "false".
     *     When you set this property to "true", Gantt Chart ignores the values of "format" and "pattern". In this
     *     mode, if the largeInterval or the smallInterval of the timeline option uses the "sap.gantt.config.TimeUnit.day"
     *     or "sap.gantt.config.TimeUnit.week" unit, you must set the span to 1.
     * 	 - `"relativeTimePrefix": "Day"` - A string that specifies the prefix displayed before every relative
     *     time point. For example, if you set this property to "Day", the relative timeline will display "Day 1",
     *     "Day 2", "Day 3", and so on so forth.
     * 	 -  `smallInterval` - Time interval of the lower row in the timeline is 12 hours. Formatted in the locale
     *     language with the format string. This zoom level implements an interval the same as the that of the default
     *     zoom level.
     * 	`"unit": sap.gantt.config.TimeUnit.hour` - Time unit is hour.
     * 	 - `"span": 2` - Time span is 2.
     * 	 - `"format": "HH:mm"` - Formats the string in CLDR date/time symbols.
     * 	 - `"relativeTime": false`
     *
     * The current granularity setting provides the following values in the default time line option:
     *  `5min`, `10min`, `15min`, `30min`,
     *  `1hour`, `2hour`, `4hour`, `6hour`, `12hour`,
     *  `1day`, `2day`, `4day`,
     *  `1week`, `2week`,
     *  `1month`, `2month`, `4month`, `6month`,
     *  `1year`, `2year`, `5year`. We recommend that you use the default time line option object instead of
     * creating one by yourself. Because the default time line option object has been precisely calculated and
     * it fits most use cases. If the default time line option is not the best-fit, you can select a time line
     * option from the range (coarsestTimeLineOption, 5 years to finestTimeLineOption, 5 minutes) listed above.
     * Note that creating a new time line option object is a complex process. Moreover, the extra effort may
     * not serve significant purposes and is likely to cause text overlay in the Gantt Chart header.
     */
    timeLineOptions?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Current time line option of AxisTimeStrategy
     */
    timeLineOption?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Coarsest time line option of AxisTimeStrategy
     */
    coarsestTimeLineOption?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Finest time line option of AxisTimeStrategy
     */
    finestTimeLineOption?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Total number of zoom levels on your zoom control. For example, the step count of Slider control and the
     * item count of Select control.
     */
    zoomLevels?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Current zoom level of your Gantt chart with 0 representing the initial zoom level. The value of this
     * property must be lower than that of totalZoomLevels.
     */
    zoomLevel?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Configures the calendar type for the Gantt Chart time label. We recommend that you set the type of this
     * argument to `sap.ui.core.CalendarType`. Otherwise some properties you set may not function properly.
     */
    calendarType?: string | PropertyBindingInfo;

    /**
     * Configures the locale of the Gantt Chart time label. We recommend that you set the type of this argument
     * to `sap.ui.core.Locale`. Otherwise some properties you set may not function properly.
     */
    locale?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Configures the first day of the week relevant for displaying the Gantt Chart time intervals.
     *  This property has the same value type as {@link sap.ui.core.LocaleData#getFirstDayOfWeek} and by default
     * uses the value from the current locale.
     *
     * @since 1.73
     */
    firstDayOfWeek?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the mouse wheel zooming type, which determines the zoom granularity
     */
    mouseWheelZoomType?:
      | (MouseWheelZoomType | keyof typeof MouseWheelZoomType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.110.0
     */
    calendarWeekNumbering?:
      | CalendarWeekNumbering
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Entire time span Gantt Chart can display in the chart area We recommend that you set the type of this
     * argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not function properly.
     *
     * Default totalHorizon value is: `sap.gantt.config.DEFAULT_TOTAL_HORIZON `
     */
    totalHorizon?: TimeHorizon;

    /**
     * Time span Gantt Chart currently displays in the chart area Specifies the start and end points of the
     * time span that is visible in the chart area. `visibleHorizon` is less than or equal to `totalHorizon`.
     * You can configure the time horizon using one of the following patterns:
     * 	 - [startTime, null]: Jump to the position where the start time is on the left edge of the screen without
     *     changing the zoom rate. When you use this pattern, Gantt Chart calculates the endTime according to the
     *     current zoom rate.
     * 	 - [null, endTime]: Jump to the position where the end time is on the right edge of the screen without
     *     changing the zoom rate. When you use this pattern, Gantt Chart calculates the startTime accoridng to
     *     the current zoom rate.
     * 	 - [startTime, endTime]: Every strategy has their own implementation to control misc.AxisTime.
     *
     * **Note:** Before you set visibleHorizon, you have to set totalHorizon first. We recommend that you set
     * the type of this argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not
     * function properly.
     *
     * Default visible horizon value is `sap.gantt.config.DEFAULT_VISIBLE_HORIZON`
     */
    visibleHorizon?: TimeHorizon;
  }
}

declare module "sap/gantt/axistime/FullScreenStrategy" {
  import {
    default as AxisTimeStrategyBase,
    $AxisTimeStrategyBaseSettings,
  } from "sap/gantt/axistime/AxisTimeStrategyBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * FullScreenStrategy
   *
   *  A zoom strategy that sets the value of `totalHorizon` to the value of `visibleHorizon`. When this
   * strategy is implemented, `visibleHorizon` is fixed. Because of this, when you scroll the splitter to
   * expand or shrink the chart area, the value of `visibleHorizon` remains intact, which makes shapes look
   * larger or smaller accordingly. Moreover, the horizontal scroll bar never appears and the zoom control
   * is deactivated.
   */
  export default class FullScreenStrategy extends AxisTimeStrategyBase {
    /**
     * Creates and initializes a FullScreenStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $FullScreenStrategySettings
    );
    /**
     * Creates and initializes a FullScreenStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new AxisTimeStrategy, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $FullScreenStrategySettings
    );

    /**
     * Creates a new subclass of class sap.gantt.axistime.FullScreenStrategy with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.axistime.AxisTimeStrategyBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FullScreenStrategy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.axistime.FullScreenStrategy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the FullScreenStrategy constructor.
   */
  export interface $FullScreenStrategySettings
    extends $AxisTimeStrategyBaseSettings {}
}

declare module "sap/gantt/axistime/ProportionZoomStrategy" {
  import {
    default as AxisTimeStrategyBase,
    $AxisTimeStrategyBaseSettings,
  } from "sap/gantt/axistime/AxisTimeStrategyBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * ProportionZoomStrategy
   *
   *  A zoom strategy that provides the proportional change ability. Proportional change ensures that Gantt
   * Chart dynamically adjusts the zoom rate to be the best fit for rendering shapes in the chart area. This
   * strategy cannot be used by the Select control.
   */
  export default class ProportionZoomStrategy extends AxisTimeStrategyBase {
    /**
     * Creates and initializes a ProportionZoomStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $ProportionZoomStrategySettings
    );
    /**
     * Creates and initializes a ProportionZoomStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new AxisTimeStrategy, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new AxisTimeStrategy
       */
      mSettings?: $ProportionZoomStrategySettings
    );

    /**
     * Creates a new subclass of class sap.gantt.axistime.ProportionZoomStrategy with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.axistime.AxisTimeStrategyBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ProportionZoomStrategy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.axistime.ProportionZoomStrategy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the ProportionZoomStrategy constructor.
   */
  export interface $ProportionZoomStrategySettings
    extends $AxisTimeStrategyBaseSettings {}
}

declare module "sap/gantt/axistime/StepwiseZoomStrategy" {
  import {
    default as AxisTimeStrategyBase,
    $AxisTimeStrategyBaseSettings,
  } from "sap/gantt/axistime/AxisTimeStrategyBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import TimeHorizon from "sap/gantt/config/TimeHorizon";

  /**
   * The class allows you to define a zoom strategy whose time line options are stepwise, i.e. the width of
   * each time line option is pre-defined and won't be changed during zooming.
   */
  export default class StepwiseZoomStrategy extends AxisTimeStrategyBase {
    /**
     * Constructor for a new StepwiseZoomStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $StepwiseZoomStrategySettings
    );
    /**
     * Constructor for a new StepwiseZoomStrategy.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     *
     * This class does not have its own settings, but all settings applicable to the base type {@link sap.gantt.axistime.AxisTimeStrategyBase#constructor sap.gantt.axistime.AxisTimeStrategyBase }
     * can be used.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $StepwiseZoomStrategySettings
    );

    /**
     * Creates a new subclass of class sap.gantt.axistime.StepwiseZoomStrategy with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.axistime.AxisTimeStrategyBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, StepwiseZoomStrategy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.axistime.StepwiseZoomStrategy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Return total horizon time. The value will be changed according to zoom level, and is not same as the
     * value user set.
     */
    getTotalHorizon(): TimeHorizon;
    /**
     * Don't use this method to set coarsestTimeLineOption because its value is determined by timeLineOptions.
     * The last entry of timeLineOptions is coarsestTimeLineOption.
     *
     *
     * @returns for chaining
     */
    setCoarsestTimeLineOption(
      /**
       * coarsest time line option of StepwiseZoomStrategy
       */
      oTimeLineOption: object
    ): this;
    /**
     * Don't use this method to set finestTimeLineOption because its value is determined by timeLineOptions.
     * The first entry of timeLineOptions is finestTimeLineOption.
     *
     *
     * @returns for chaining
     */
    setFinestTimeLineOption(
      /**
       * finest time line option of StepwiseZoomStrategy
       */
      oTimeLineOption: object
    ): this;
    /**
     * Sets the time line options of StepwiseZoomStrategy.
     *
     *
     * @returns for chaining
     */
    setTimeLineOptions(
      /**
       * time line options of StepwiseZoomStrategy
       */
      oTimeLineOptions: object
    ): this;
    /**
     * Sets the total horizon of StepwiseZoomStrategy. The time range and view range of this.getAxisTime() will
     * also be updated, the rate will remain unchanged.
     *
     *
     * @returns for chaining
     */
    setTotalHorizon(
      /**
       * total horizon of StepwiseZoomStrategy
       */
      oTotalHorizon: object
    ): this;
    /**
     * Sets the visible horizon of StepwiseZoomStrategy. Don't use this method to set visible horizon because
     * its value is determined by zoomLevel or timeLineoption.
     *
     *
     * @returns for chaining
     */
    setVisibleHorizon(
      /**
       * visible horizon of StepwiseZoomStrategy
       */
      oVisibleHorizon: object
    ): this;
    /**
     * Don't use this method to set zoomLevels because its value is determined by timeLineOptions. The account
     * of entities in timeLineOptions is zoomLevels.
     *
     *
     * @returns for chaining
     */
    setZoomLevels(
      /**
       * zoom levels of StepwiseZoomStrategy
       */
      iZoomLevels: int
    ): this;
    /**
     * This method does below things: 1. Sets time line option according to the stop info object. 2. Sets zoom
     * level according to the stop info object. The setter of zoom level does some additional things.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns for chaining
     */
    updateStopInfo(
      /**
       * Zoom stop information, which contains the parameters `key` and `text`.
       */
      oStopInfo: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the StepwiseZoomStrategy constructor.
   */
  export interface $StepwiseZoomStrategySettings
    extends $AxisTimeStrategyBaseSettings {}
}

declare module "sap/gantt/config/BirdEyeGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * You can define bird eye toolbar items in the Gantt chart toolbar.
   *
   * @deprecated (since 1.64)
   */
  export default class BirdEyeGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new toolbar group for bird eye button
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BirdEyeGroupSettings
    );
    /**
     * Creates and initializes a new toolbar group for bird eye button
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BirdEyeGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.BirdEyeGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BirdEyeGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.BirdEyeGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBirdEyeRange birdEyeRange}.
     *
     * Specify the data range that bird eye use to calculte the suitable visible horizon By default the bird
     * eye is a menu button: one menu item for ` sap.gantt.config.BirdEyeRange.VisibleRows` and the other for
     * `sap.gantt.config.BirdEyeRange.AllRows`
     *
     *
     * @returns Value of property `birdEyeRange`
     */
    getBirdEyeRange(): string;
    /**
     * Sets a new value for property {@link #getBirdEyeRange birdEyeRange}.
     *
     * Specify the data range that bird eye use to calculte the suitable visible horizon By default the bird
     * eye is a menu button: one menu item for ` sap.gantt.config.BirdEyeRange.VisibleRows` and the other for
     * `sap.gantt.config.BirdEyeRange.AllRows`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBirdEyeRange(
      /**
       * New value for property `birdEyeRange`
       */
      sBirdEyeRange?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BirdEyeGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $BirdEyeGroupSettings extends $ToolbarGroupSettings {
    /**
     * Specify the data range that bird eye use to calculte the suitable visible horizon By default the bird
     * eye is a menu button: one menu item for ` sap.gantt.config.BirdEyeRange.VisibleRows` and the other for
     * `sap.gantt.config.BirdEyeRange.AllRows`
     */
    birdEyeRange?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/ChartScheme" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The ChartScheme control is one of the settings of {@link sap.gantt.GanttChart}. A Gantt chart uses
   * this setting to decide the mode of Gantt chart and the shapes to display in the Gantt chart. A Gantt
   * chart contains one or more Chart schemes. By switching between these schemes, the Gantt chart can display
   * different shapes.
   *
   * @deprecated (since 1.64)
   */
  export default class ChartScheme extends UI5Element {
    /**
     * Creates and initializes a new ChartScheme class
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ChartSchemeSettings
    );
    /**
     * Creates and initializes a new ChartScheme class
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ChartSchemeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ChartScheme with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ChartScheme>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ChartScheme.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBackgroundClass backgroundClass}.
     *
     * Decides the background color of the row in the chart scheme
     *
     *
     * @returns Value of property `backgroundClass`
     */
    getBackgroundClass(): string;
    /**
     * Gets current value of property {@link #getHaveBackground haveBackground}.
     *
     * Decides whether the shape has a background
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `haveBackground`
     */
    getHaveBackground(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * URL of the icon of the Chart scheme
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the Chart scheme
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getModeKey modeKey}.
     *
     * Key of {@link sap.gantt.config.Mode}
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Value of property `modeKey`
     */
    getModeKey(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Description of the Chart scheme
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getRowIndexName rowIndexName}.
     *
     * Decides which attribute serves as the purpose of "rowIndex" if it has multiple rows
     *
     * Default value is `"rowIndex"`.
     *
     *
     * @returns Value of property `rowIndexName`
     */
    getRowIndexName(): string;
    /**
     * Gets current value of property {@link #getRowSpan rowSpan}.
     *
     * Decides the row height of {@link sap.gantt.GanttChartBase} For example, if rowSpan is 2, the row height
     * of the Gantt chart equals twice of the row height of the tree table
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `rowSpan`
     */
    getRowSpan(): int;
    /**
     * Gets current value of property {@link #getShapeKeys shapeKeys}.
     *
     * Array of the key of {@link sap.gantt.config.Shape}
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `shapeKeys`
     */
    getShapeKeys(): string[];
    /**
     * Sets a new value for property {@link #getBackgroundClass backgroundClass}.
     *
     * Decides the background color of the row in the chart scheme
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundClass(
      /**
       * New value for property `backgroundClass`
       */
      sBackgroundClass: string
    ): this;
    /**
     * Sets a new value for property {@link #getHaveBackground haveBackground}.
     *
     * Decides whether the shape has a background
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHaveBackground(
      /**
       * New value for property `haveBackground`
       */
      bHaveBackground?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * URL of the icon of the Chart scheme
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the Chart scheme
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getModeKey modeKey}.
     *
     * Key of {@link sap.gantt.config.Mode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModeKey(
      /**
       * New value for property `modeKey`
       */
      sModeKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Description of the Chart scheme
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRowIndexName rowIndexName}.
     *
     * Decides which attribute serves as the purpose of "rowIndex" if it has multiple rows
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rowIndex"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRowIndexName(
      /**
       * New value for property `rowIndexName`
       */
      sRowIndexName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRowSpan rowSpan}.
     *
     * Decides the row height of {@link sap.gantt.GanttChartBase} For example, if rowSpan is 2, the row height
     * of the Gantt chart equals twice of the row height of the tree table
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRowSpan(
      /**
       * New value for property `rowSpan`
       */
      iRowSpan?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShapeKeys shapeKeys}.
     *
     * Array of the key of {@link sap.gantt.config.Shape}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeKeys(
      /**
       * New value for property `shapeKeys`
       */
      sShapeKeys?: string[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ChartScheme constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ChartSchemeSettings extends $ElementSettings {
    /**
     * Unique key of the Chart scheme
     */
    key?: string | PropertyBindingInfo;

    /**
     * Description of the Chart scheme
     */
    name?: string | PropertyBindingInfo;

    /**
     * Decides the row height of {@link sap.gantt.GanttChartBase} For example, if rowSpan is 2, the row height
     * of the Gantt chart equals twice of the row height of the tree table
     */
    rowSpan?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * URL of the icon of the Chart scheme
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Key of {@link sap.gantt.config.Mode}
     */
    modeKey?: string | PropertyBindingInfo;

    /**
     * Decides whether the shape has a background
     */
    haveBackground?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Decides the background color of the row in the chart scheme
     */
    backgroundClass?: string | PropertyBindingInfo;

    /**
     * Array of the key of {@link sap.gantt.config.Shape}
     */
    shapeKeys?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Decides which attribute serves as the purpose of "rowIndex" if it has multiple rows
     */
    rowIndexName?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/ColumnAttribute" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the column attribute which is used in the hierarchy column
   *
   * @deprecated (since 1.64)
   */
  export default class ColumnAttribute extends UI5Element {
    /**
     * Constructor for a new ColumnAttribute
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnAttributeSettings
    );
    /**
     * Constructor for a new ColumnAttribute
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnAttributeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ColumnAttribute with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnAttribute>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ColumnAttribute.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAttribute attribute}.
     *
     * Attribute name of the column
     *
     *
     * @returns Value of property `attribute`
     */
    getAttribute(): string;
    /**
     * Gets current value of property {@link #getObjectTypeKey objectTypeKey}.
     *
     * Key of {@link sap.gantt.config.ObjectType}
     *
     *
     * @returns Value of property `objectTypeKey`
     */
    getObjectTypeKey(): string;
    /**
     * Sets a new value for property {@link #getAttribute attribute}.
     *
     * Attribute name of the column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttribute(
      /**
       * New value for property `attribute`
       */
      sAttribute?: string
    ): this;
    /**
     * Sets a new value for property {@link #getObjectTypeKey objectTypeKey}.
     *
     * Key of {@link sap.gantt.config.ObjectType}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectTypeKey(
      /**
       * New value for property `objectTypeKey`
       */
      sObjectTypeKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnAttribute constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ColumnAttributeSettings extends $ElementSettings {
    /**
     * Key of {@link sap.gantt.config.ObjectType}
     */
    objectTypeKey?: string | PropertyBindingInfo;

    /**
     * Attribute name of the column
     */
    attribute?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/ContainerLayout" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Orientation, CSSSize } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the container layout. The container layout determines the layout of a Gantt chart container such
   * as the CSS size, orientation, toolbar, and tree table size.
   *
   * @deprecated (since 1.64)
   */
  export default class ContainerLayout extends UI5Element {
    /**
     * Creates and initializes a new container layout
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ContainerLayoutSettings
    );
    /**
     * Creates and initializes a new container layout
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ContainerLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ContainerLayout with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContainerLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ContainerLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getActiveModeKey activeModeKey}.
     *
     * Active mode key. See {@link sap.gantt.config.Mode}
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Value of property `activeModeKey`
     */
    getActiveModeKey(): string;
    /**
     * Gets current value of property {@link #getGanttChartLayouts ganttChartLayouts}.
     *
     * Array of the Gantt chart layout. See {@link sap.gantt.config.GanttChartLayout} We recommend that you
     * set the type of this argument to `sap.gantt.config.GanttChartLayout[]`. Otherwise some properties you
     * set may not function properly.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `ganttChartLayouts`
     */
    getGanttChartLayouts(): object[];
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the container layout
     *
     * Default value is `sap.gantt.config.DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY`.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getOrientation orientation}.
     *
     * Orientation of the Gantt chart container. See {@link sap.ui.core.Oritentation}
     *
     * Default value is `Vertical`.
     *
     *
     * @returns Value of property `orientation`
     */
    getOrientation(): Orientation | keyof typeof Orientation;
    /**
     * Gets current value of property {@link #getSelectionPanelSize selectionPanelSize}.
     *
     * CSS size of the selection panel. See {@link sap.ui.core.CSSSize}
     *
     * Default value is `"30%"`.
     *
     *
     * @returns Value of property `selectionPanelSize`
     */
    getSelectionPanelSize(): CSSSize;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getToolbarSchemeKey toolbarSchemeKey}.
     *
     * Toolbar scheme key. See {@link sap.gantt.config.ToolbarScheme}
     *
     * Default value is `sap.gantt.config.DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY`.
     *
     *
     * @returns Value of property `toolbarSchemeKey`
     */
    getToolbarSchemeKey(): string;
    /**
     * Sets a new value for property {@link #getActiveModeKey activeModeKey}.
     *
     * Active mode key. See {@link sap.gantt.config.Mode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveModeKey(
      /**
       * New value for property `activeModeKey`
       */
      sActiveModeKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGanttChartLayouts ganttChartLayouts}.
     *
     * Array of the Gantt chart layout. See {@link sap.gantt.config.GanttChartLayout} We recommend that you
     * set the type of this argument to `sap.gantt.config.GanttChartLayout[]`. Otherwise some properties you
     * set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGanttChartLayouts(
      /**
       * New value for property `ganttChartLayouts`
       */
      sGanttChartLayouts?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the container layout
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOrientation orientation}.
     *
     * Orientation of the Gantt chart container. See {@link sap.ui.core.Oritentation}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Vertical`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOrientation(
      /**
       * New value for property `orientation`
       */
      sOrientation?: Orientation | keyof typeof Orientation
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionPanelSize selectionPanelSize}.
     *
     * CSS size of the selection panel. See {@link sap.ui.core.CSSSize}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"30%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionPanelSize(
      /**
       * New value for property `selectionPanelSize`
       */
      sSelectionPanelSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `...see text or source`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getToolbarSchemeKey toolbarSchemeKey}.
     *
     * Toolbar scheme key. See {@link sap.gantt.config.ToolbarScheme}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_CONTAINER_TOOLBAR_SCHEME_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolbarSchemeKey(
      /**
       * New value for property `toolbarSchemeKey`
       */
      sToolbarSchemeKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContainerLayout constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ContainerLayoutSettings extends $ElementSettings {
    /**
     * Unique key of the container layout
     */
    key?: string | PropertyBindingInfo;

    text?: string | PropertyBindingInfo;

    /**
     * Orientation of the Gantt chart container. See {@link sap.ui.core.Oritentation}
     */
    orientation?:
      | (Orientation | keyof typeof Orientation)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Active mode key. See {@link sap.gantt.config.Mode}
     */
    activeModeKey?: string | PropertyBindingInfo;

    /**
     * Toolbar scheme key. See {@link sap.gantt.config.ToolbarScheme}
     */
    toolbarSchemeKey?: string | PropertyBindingInfo;

    /**
     * CSS size of the selection panel. See {@link sap.ui.core.CSSSize}
     */
    selectionPanelSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of the Gantt chart layout. See {@link sap.gantt.config.GanttChartLayout} We recommend that you
     * set the type of this argument to `sap.gantt.config.GanttChartLayout[]`. Otherwise some properties you
     * set may not function properly.
     */
    ganttChartLayouts?: object[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/ExpandChart" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the expand chart which is used by {@link sap.gantt.config.ExpandChartGroup}.
   *
   * @deprecated (since 1.64)
   */
  export default class ExpandChart extends UI5Element {
    /**
     * Creates and initializes a new expand chart
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandChartSettings
    );
    /**
     * Creates and initializes a new expand chart
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandChartSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ExpandChart with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExpandChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ExpandChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getChartSchemeKeys chartSchemeKeys}.
     *
     * Array of key of {@link sap.gantt.config.ChartScheme}
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `chartSchemeKeys`
     */
    getChartSchemeKeys(): string[];
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * URL of the icon of the expand chart
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getIsExpand isExpand}.
     *
     * Specifies whether the action is to expand or to collapse a row in the chart.
     *
     *
     * @returns Value of property `isExpand`
     */
    getIsExpand(): boolean;
    /**
     * Sets a new value for property {@link #getChartSchemeKeys chartSchemeKeys}.
     *
     * Array of key of {@link sap.gantt.config.ChartScheme}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartSchemeKeys(
      /**
       * New value for property `chartSchemeKeys`
       */
      sChartSchemeKeys?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * URL of the icon of the expand chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getIsExpand isExpand}.
     *
     * Specifies whether the action is to expand or to collapse a row in the chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsExpand(
      /**
       * New value for property `isExpand`
       */
      bIsExpand?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ExpandChart constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ExpandChartSettings extends $ElementSettings {
    /**
     * URL of the icon of the expand chart
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether the action is to expand or to collapse a row in the chart.
     */
    isExpand?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of key of {@link sap.gantt.config.ChartScheme}
     */
    chartSchemeKeys?: string[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/ExpandChartGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines a toolbar group for the expand chart-related toolbar items. These expand chart-related toolbar
   * items are displayed in the Gantt chart toolbar.
   *
   * @deprecated (since 1.64)
   */
  export default class ExpandChartGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new expand chart group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandChartGroupSettings
    );
    /**
     * Creates and initializes a new expand chart group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandChartGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ExpandChartGroup with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExpandChartGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ExpandChartGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableRichType enableRichType}.
     *
     * When this property is enabled, expand button is in emphasized button type, and collapse button is in
     * default button type.
     *
     *
     * @returns Value of property `enableRichType`
     */
    getEnableRichType(): boolean;
    /**
     * Gets current value of property {@link #getExpandCharts expandCharts}.
     *
     * Array of {@link sap.gantt.config.ExpandChart}
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `expandCharts`
     */
    getExpandCharts(): object[];
    /**
     * Gets current value of property {@link #getShowArrowText showArrowText}.
     *
     * When this property is enabled, text arrow is shown beside icon indicating expand/collapse function
     *
     *
     * @returns Value of property `showArrowText`
     */
    getShowArrowText(): boolean;
    /**
     * Sets a new value for property {@link #getEnableRichType enableRichType}.
     *
     * When this property is enabled, expand button is in emphasized button type, and collapse button is in
     * default button type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableRichType(
      /**
       * New value for property `enableRichType`
       */
      bEnableRichType: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getExpandCharts expandCharts}.
     *
     * Array of {@link sap.gantt.config.ExpandChart}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandCharts(
      /**
       * New value for property `expandCharts`
       */
      sExpandCharts?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getShowArrowText showArrowText}.
     *
     * When this property is enabled, text arrow is shown beside icon indicating expand/collapse function
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowArrowText(
      /**
       * New value for property `showArrowText`
       */
      bShowArrowText: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ExpandChartGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ExpandChartGroupSettings extends $ToolbarGroupSettings {
    /**
     * Array of {@link sap.gantt.config.ExpandChart}
     */
    expandCharts?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * When this property is enabled, expand button is in emphasized button type, and collapse button is in
     * default button type.
     */
    enableRichType?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * When this property is enabled, text arrow is shown beside icon indicating expand/collapse function
     */
    showArrowText?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/GanttChartLayout" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the Gantt chart layout. This includes but is not limited to the CSS size, mode, and hierarchy
   * of the Gantt chart.
   *
   * @deprecated (since 1.64)
   */
  export default class GanttChartLayout extends UI5Element {
    /**
     * Creates and initializes a new Gantt chart layout
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartLayoutSettings
    );
    /**
     * Creates and initializes a new Gantt chart layout
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.GanttChartLayout with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttChartLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.GanttChartLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getActiveModeKey activeModeKey}.
     *
     * Key of the mode. See {@link sap.gantt.config.Mode}
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Value of property `activeModeKey`
     */
    getActiveModeKey(): string;
    /**
     * Gets current value of property {@link #getGanttChartSize ganttChartSize}.
     *
     * CSS Size of the Gantt chart. See {@link sap.ui.core.CSSSize}
     *
     *
     * @returns Value of property `ganttChartSize`
     */
    getGanttChartSize(): CSSSize;
    /**
     * Gets current value of property {@link #getHierarchyKey hierarchyKey}.
     *
     * Key of the hierarchy. See {@link sap.gantt.config.Hierarchy}
     *
     * Default value is `sap.gantt.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Value of property `hierarchyKey`
     */
    getHierarchyKey(): string;
    /**
     * Sets a new value for property {@link #getActiveModeKey activeModeKey}.
     *
     * Key of the mode. See {@link sap.gantt.config.Mode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveModeKey(
      /**
       * New value for property `activeModeKey`
       */
      sActiveModeKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGanttChartSize ganttChartSize}.
     *
     * CSS Size of the Gantt chart. See {@link sap.ui.core.CSSSize}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGanttChartSize(
      /**
       * New value for property `ganttChartSize`
       */
      sGanttChartSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchyKey hierarchyKey}.
     *
     * Key of the hierarchy. See {@link sap.gantt.config.Hierarchy}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchyKey(
      /**
       * New value for property `hierarchyKey`
       */
      sHierarchyKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the GanttChartLayout constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $GanttChartLayoutSettings extends $ElementSettings {
    /**
     * CSS Size of the Gantt chart. See {@link sap.ui.core.CSSSize}
     */
    ganttChartSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Key of the mode. See {@link sap.gantt.config.Mode}
     */
    activeModeKey?: string | PropertyBindingInfo;

    /**
     * Key of the hierarchy. See {@link sap.gantt.config.Hierarchy}
     */
    hierarchyKey?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/Hierarchy" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the hierarchy in the Gantt chart. The hierarchy is used for building the tree table in {@link sap.gantt.GanttChartWithTable}.
   *
   * @deprecated (since 1.64)
   */
  export default class Hierarchy extends UI5Element {
    /**
     * Creates and initializes a new hierarchy
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $HierarchySettings
    );
    /**
     * Creates and initializes a new hierarchy
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $HierarchySettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.Hierarchy with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Hierarchy>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.Hierarchy.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getActiveModeKey activeModeKey}.
     *
     * Key of {@link sap.gantt.config.Mode}
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Value of property `activeModeKey`
     */
    getActiveModeKey(): string;
    /**
     * Gets current value of property {@link #getColumns columns}.
     *
     * Columns of the hierarchy. Array of {@link sap.gantt.config.HierarchyColumn}
     *
     *
     * @returns Value of property `columns`
     */
    getColumns(): object[];
    /**
     * Gets current value of property {@link #getExpandedLevels expandedLevels}.
     *
     * expandedLevels determines how the tree table is initially expanded. This property is a two-dimensional
     * array containing object types of row data. Only rows with data of the specified object types are expanded.
     * Each child array represents a specific level in the hierarchy with the first child array representing
     * the first level and so forth. For example, if this property is set to [["02", "03"], ["05"]], rows containing
     * data of object types 02 or 03 in the first level and rows containing data of object type 05 in the second
     * level are expanded.
     *
     * @deprecated (since 1.46.8) - This feature may cause severe performance issue! Since TreeTable doesn't
     * have API to expand specific multiple rows in one call, GanttChart expand the tree tale to level calculated
     * from the configuration, then loop all data in the model, collapse the node which does not full-fill the
     * configuration one by one. This feature is application specific and should be handled by application.
     *
     * @returns Value of property `expandedLevels`
     */
    getExpandedLevels(): string[][];
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the hierarchy
     *
     * Default value is `sap.gantt.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Description of the hierarchy
     *
     * Default value is `"Default Hierarchy"`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getToolbarSchemeKey toolbarSchemeKey}.
     *
     * Key of {@link sap.gantt.config.ToolbarScheme}
     *
     * Default value is `sap.gantt.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEME_KEY`.
     *
     *
     * @returns Value of property `toolbarSchemeKey`
     */
    getToolbarSchemeKey(): string;
    /**
     * Sets a new value for property {@link #getActiveModeKey activeModeKey}.
     *
     * Key of {@link sap.gantt.config.Mode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveModeKey(
      /**
       * New value for property `activeModeKey`
       */
      sActiveModeKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getColumns columns}.
     *
     * Columns of the hierarchy. Array of {@link sap.gantt.config.HierarchyColumn}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumns(
      /**
       * New value for property `columns`
       */
      sColumns: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getExpandedLevels expandedLevels}.
     *
     * expandedLevels determines how the tree table is initially expanded. This property is a two-dimensional
     * array containing object types of row data. Only rows with data of the specified object types are expanded.
     * Each child array represents a specific level in the hierarchy with the first child array representing
     * the first level and so forth. For example, if this property is set to [["02", "03"], ["05"]], rows containing
     * data of object types 02 or 03 in the first level and rows containing data of object type 05 in the second
     * level are expanded.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.46.8) - This feature may cause severe performance issue! Since TreeTable doesn't
     * have API to expand specific multiple rows in one call, GanttChart expand the tree tale to level calculated
     * from the configuration, then loop all data in the model, collapse the node which does not full-fill the
     * configuration one by one. This feature is application specific and should be handled by application.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandedLevels(
      /**
       * New value for property `expandedLevels`
       */
      sExpandedLevels: string[][]
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the hierarchy
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Description of the hierarchy
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Default Hierarchy"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getToolbarSchemeKey toolbarSchemeKey}.
     *
     * Key of {@link sap.gantt.config.ToolbarScheme}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEME_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolbarSchemeKey(
      /**
       * New value for property `toolbarSchemeKey`
       */
      sToolbarSchemeKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Hierarchy constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $HierarchySettings extends $ElementSettings {
    /**
     * Unique key of the hierarchy
     */
    key?: string | PropertyBindingInfo;

    /**
     * Description of the hierarchy
     */
    text?: string | PropertyBindingInfo;

    /**
     * Key of {@link sap.gantt.config.Mode}
     */
    activeModeKey?: string | PropertyBindingInfo;

    /**
     * Key of {@link sap.gantt.config.ToolbarScheme}
     */
    toolbarSchemeKey?: string | PropertyBindingInfo;

    /**
     * Columns of the hierarchy. Array of {@link sap.gantt.config.HierarchyColumn}
     */
    columns?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * expandedLevels determines how the tree table is initially expanded. This property is a two-dimensional
     * array containing object types of row data. Only rows with data of the specified object types are expanded.
     * Each child array represents a specific level in the hierarchy with the first child array representing
     * the first level and so forth. For example, if this property is set to [["02", "03"], ["05"]], rows containing
     * data of object types 02 or 03 in the first level and rows containing data of object type 05 in the second
     * level are expanded.
     *
     * @deprecated (since 1.46.8) - This feature may cause severe performance issue! Since TreeTable doesn't
     * have API to expand specific multiple rows in one call, GanttChart expand the tree tale to level calculated
     * from the configuration, then loop all data in the model, collapse the node which does not full-fill the
     * configuration one by one. This feature is application specific and should be handled by application.
     */
    expandedLevels?: string[][] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/HierarchyColumn" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { CSSSize } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the column attribute which is used in the hierarchy column
   *
   * @deprecated (since 1.64)
   */
  export default class HierarchyColumn extends UI5Element {
    /**
     * Creates and initializes a new hierarchy column
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $HierarchyColumnSettings
    );
    /**
     * Creates and initializes a new hierarchy column
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $HierarchyColumnSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.HierarchyColumn with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, HierarchyColumn>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.HierarchyColumn.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAttribute attribute}.
     *
     * Attribute
     *
     *
     * @returns Value of property `attribute`
     */
    getAttribute(): string;
    /**
     * Gets current value of property {@link #getAttributes attributes}.
     *
     * Attributes. Array of {@link sap.gantt.config.ColumnAttribute} optional. array of objects. new file columnAttribute
     * to describe object: object type, attribute
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `attributes`
     */
    getAttributes(): object[];
    /**
     * Gets current value of property {@link #getContentType contentType}.
     *
     * Content type of the column
     *
     *
     * @returns Value of property `contentType`
     */
    getContentType(): string;
    /**
     * Gets current value of property {@link #getFilterAttribute filterAttribute}.
     *
     * Specifies the attribute by which the tree table filter items in the column
     *
     *
     * @returns Value of property `filterAttribute`
     */
    getFilterAttribute(): string;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the hierarchy column
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getSortAttribute sortAttribute}.
     *
     * Specifies the attribute by which the tree table sorts items in the column
     *
     *
     * @returns Value of property `sortAttribute`
     */
    getSortAttribute(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title is used as the title of the column header in the tree table
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Column Width
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Sets a new value for property {@link #getAttribute attribute}.
     *
     * Attribute
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttribute(
      /**
       * New value for property `attribute`
       */
      sAttribute?: string
    ): this;
    /**
     * Sets a new value for property {@link #getAttributes attributes}.
     *
     * Attributes. Array of {@link sap.gantt.config.ColumnAttribute} optional. array of objects. new file columnAttribute
     * to describe object: object type, attribute
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAttributes(
      /**
       * New value for property `attributes`
       */
      sAttributes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getContentType contentType}.
     *
     * Content type of the column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentType(
      /**
       * New value for property `contentType`
       */
      sContentType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFilterAttribute filterAttribute}.
     *
     * Specifies the attribute by which the tree table filter items in the column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterAttribute(
      /**
       * New value for property `filterAttribute`
       */
      sFilterAttribute?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the hierarchy column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSortAttribute sortAttribute}.
     *
     * Specifies the attribute by which the tree table sorts items in the column
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSortAttribute(
      /**
       * New value for property `sortAttribute`
       */
      sSortAttribute?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title is used as the title of the column header in the tree table
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Column Width
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the HierarchyColumn constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $HierarchyColumnSettings extends $ElementSettings {
    /**
     * Unique key of the hierarchy column
     */
    key?: string | PropertyBindingInfo;

    /**
     * Title is used as the title of the column header in the tree table
     */
    title?: string | PropertyBindingInfo;

    /**
     * Content type of the column
     */
    contentType?: string | PropertyBindingInfo;

    /**
     * Specifies the attribute by which the tree table sorts items in the column
     */
    sortAttribute?: string | PropertyBindingInfo;

    /**
     * Specifies the attribute by which the tree table filter items in the column
     */
    filterAttribute?: string | PropertyBindingInfo;

    /**
     * Attribute
     */
    attribute?: string | PropertyBindingInfo;

    /**
     * Attributes. Array of {@link sap.gantt.config.ColumnAttribute} optional. array of objects. new file columnAttribute
     * to describe object: object type, attribute
     */
    attributes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Column Width
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/LayoutGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * You can specify the Gantt chart layout-related toolbar items in the Gantt chart toolbar
   *
   * @deprecated (since 1.64)
   */
  export default class LayoutGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new layout group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LayoutGroupSettings
    );
    /**
     * Creates and initializes a new layout group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LayoutGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.LayoutGroup with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LayoutGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.LayoutGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEnableRichStyle enableRichStyle}.
     *
     * Determines the button type. See {@link sap.m.ButtonType} true stands for {@link sap.m.ButtonType.Emphasized }
     * false stands for {@link sap.m.ButtonType.Default}
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.50)
     *
     * @returns Value of property `enableRichStyle`
     */
    getEnableRichStyle(): boolean;
    /**
     * Sets a new value for property {@link #getEnableRichStyle enableRichStyle}.
     *
     * Determines the button type. See {@link sap.m.ButtonType} true stands for {@link sap.m.ButtonType.Emphasized }
     * false stands for {@link sap.m.ButtonType.Default}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.50)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableRichStyle(
      /**
       * New value for property `enableRichStyle`
       */
      bEnableRichStyle?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LayoutGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $LayoutGroupSettings extends $ToolbarGroupSettings {
    /**
     * Determines the button type. See {@link sap.m.ButtonType} true stands for {@link sap.m.ButtonType.Emphasized }
     * false stands for {@link sap.m.ButtonType.Default}
     *
     * @deprecated (since 1.50)
     */
    enableRichStyle?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/Locale" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The locale control is used for converting the UTC date time to your local date time
   */
  export default class Locale extends UI5Element {
    /**
     * Creates and initializes a new Locale
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LocaleSettings
    );
    /**
     * Creates and initializes a new Locale
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LocaleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.Locale with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Locale>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.Locale.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDstHorizons dstHorizons}.
     *
     * Day-light saving time periods. Array of {@link sap.gantt.config.TimeHorizon} other locale info like langu,
     * dateFormat, timeFormat and numberFormat, please use UI5 standard configuration object.
     *
     * Default value is `[]`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Value of property `dstHorizons`
     */
    getDstHorizons(): object[];
    /**
     * Gets current value of property {@link #getUtcdiff utcdiff}.
     *
     * Gap value to the UTC time in the format hhmmss
     *
     * Default value is `"000000"`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Value of property `utcdiff`
     */
    getUtcdiff(): string;
    /**
     * Gets current value of property {@link #getUtcsign utcsign}.
     *
     * Sign of the gap to the UTC time. Two valid values: "+" or "-".
     *
     * Default value is `"+"`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Value of property `utcsign`
     */
    getUtcsign(): string;
    /**
     * Sets a new value for property {@link #getDstHorizons dstHorizons}.
     *
     * Day-light saving time periods. Array of {@link sap.gantt.config.TimeHorizon} other locale info like langu,
     * dateFormat, timeFormat and numberFormat, please use UI5 standard configuration object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDstHorizons(
      /**
       * New value for property `dstHorizons`
       */
      sDstHorizons?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getTimeZone timeZone}.
     *
     * Custom timezone for Gantt. The configured time zone is considered as the default time zone for the locale,
     * see {@link sap.ui.core.Configuration#getTimezone}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeZone(
      /**
       * New value for property `timeZone`
       */
      sTimeZone: string
    ): this;
    /**
     * Sets a new value for property {@link #getUtcdiff utcdiff}.
     *
     * Gap value to the UTC time in the format hhmmss
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"000000"`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUtcdiff(
      /**
       * New value for property `utcdiff`
       */
      sUtcdiff?: string
    ): this;
    /**
     * Sets a new value for property {@link #getUtcsign utcsign}.
     *
     * Sign of the gap to the UTC time. Two valid values: "+" or "-".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"+"`.
     *
     * @deprecated (since 1.119)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUtcsign(
      /**
       * New value for property `utcsign`
       */
      sUtcsign?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Locale constructor.
   */
  export interface $LocaleSettings extends $ElementSettings {
    /**
     * Custom timezone for Gantt. The configured time zone is considered as the default time zone for the locale,
     * see {@link sap.ui.core.Configuration#getTimezone}
     */
    timeZone?: string | PropertyBindingInfo;

    /**
     * Gap value to the UTC time in the format hhmmss
     *
     * @deprecated (since 1.119)
     */
    utcdiff?: string | PropertyBindingInfo;

    /**
     * Sign of the gap to the UTC time. Two valid values: "+" or "-".
     *
     * @deprecated (since 1.119)
     */
    utcsign?: string | PropertyBindingInfo;

    /**
     * Day-light saving time periods. Array of {@link sap.gantt.config.TimeHorizon} other locale info like langu,
     * dateFormat, timeFormat and numberFormat, please use UI5 standard configuration object.
     *
     * @deprecated (since 1.119)
     */
    dstHorizons?: object[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/Mode" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The Mode control specifies the mode which is used in GanttChart and Shape. Mode enables GanttChart to
   * show the same objects in different views.
   *
   * @deprecated (since 1.64)
   */
  export default class Mode extends UI5Element {
    /**
     * Creates and initializes a new mode
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ModeSettings
    );
    /**
     * Creates and initializes a new mode
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ModeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.Mode with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Mode>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.Mode.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getActiveIcon activeIcon}.
     *
     * URL of the active icon of the mode
     *
     *
     * @returns Value of property `activeIcon`
     */
    getActiveIcon(): URI;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * URL of the icon of the mode
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the mode
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Description of the mode
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getActiveIcon activeIcon}.
     *
     * URL of the active icon of the mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveIcon(
      /**
       * New value for property `activeIcon`
       */
      sActiveIcon: URI
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * URL of the icon of the mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Description of the mode
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Mode constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ModeSettings extends $ElementSettings {
    /**
     * Unique key of the mode
     */
    key?: string | PropertyBindingInfo;

    /**
     * Description of the mode
     */
    text?: string | PropertyBindingInfo;

    /**
     * URL of the icon of the mode
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * URL of the active icon of the mode
     */
    activeIcon?: URI | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/ModeGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The ModeGroup control specifies the mode-related buttons in the Gantt chart toolbar
   *
   * @deprecated (since 1.64)
   */
  export default class ModeGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new mode group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ModeGroupSettings
    );
    /**
     * Creates and initializes a new mode group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ModeGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ModeGroup with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ModeGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ModeGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getModeKeys modeKeys}.
     *
     * Array of key of {@link sap.gantt.config.Mode}
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `modeKeys`
     */
    getModeKeys(): string[];
    /**
     * Sets a new value for property {@link #getModeKeys modeKeys}.
     *
     * Array of key of {@link sap.gantt.config.Mode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModeKeys(
      /**
       * New value for property `modeKeys`
       */
      sModeKeys?: string[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ModeGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ModeGroupSettings extends $ToolbarGroupSettings {
    /**
     * Array of key of {@link sap.gantt.config.Mode}
     */
    modeKeys?: string[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/ObjectType" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Define the ObjectType which is used in GanttChart
   *
   * @deprecated (since 1.64)
   */
  export default class ObjectType extends UI5Element {
    /**
     * Creates and initializes a new object type
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ObjectTypeSettings
    );
    /**
     * Creates and initializes a new object type
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ObjectTypeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ObjectType with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ObjectType>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ObjectType.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getDescription description}.
     *
     * Description of the object type
     *
     *
     * @returns Value of property `description`
     */
    getDescription(): string;
    /**
     * Gets current value of property {@link #getExpandedChartSchemeKeys expandedChartSchemeKeys}.
     *
     * Specifies the expanded chart scheme in which the the object type can be shown Array of keys of {@link sap.gantt.config.ChartScheme}
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `expandedChartSchemeKeys`
     */
    getExpandedChartSchemeKeys(): string[];
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique Key of the object type
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getMainChartSchemeKey mainChartSchemeKey}.
     *
     * Specifies the chart scheme in which the the object type can be shown Key of {@link sap.gantt.config.ChartScheme}
     *
     * Default value is `sap.gantt.config.DEFAULT_MAIN_CHART_SCHEME_KEY`.
     *
     *
     * @returns Value of property `mainChartSchemeKey`
     */
    getMainChartSchemeKey(): string;
    /**
     * Sets a new value for property {@link #getDescription description}.
     *
     * Description of the object type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDescription(
      /**
       * New value for property `description`
       */
      sDescription?: string
    ): this;
    /**
     * Sets a new value for property {@link #getExpandedChartSchemeKeys expandedChartSchemeKeys}.
     *
     * Specifies the expanded chart scheme in which the the object type can be shown Array of keys of {@link sap.gantt.config.ChartScheme}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandedChartSchemeKeys(
      /**
       * New value for property `expandedChartSchemeKeys`
       */
      sExpandedChartSchemeKeys?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique Key of the object type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMainChartSchemeKey mainChartSchemeKey}.
     *
     * Specifies the chart scheme in which the the object type can be shown Key of {@link sap.gantt.config.ChartScheme}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_MAIN_CHART_SCHEME_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMainChartSchemeKey(
      /**
       * New value for property `mainChartSchemeKey`
       */
      sMainChartSchemeKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ObjectType constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ObjectTypeSettings extends $ElementSettings {
    /**
     * Unique Key of the object type
     */
    key?: string | PropertyBindingInfo;

    /**
     * Description of the object type
     */
    description?: string | PropertyBindingInfo;

    /**
     * Specifies the chart scheme in which the the object type can be shown Key of {@link sap.gantt.config.ChartScheme}
     */
    mainChartSchemeKey?: string | PropertyBindingInfo;

    /**
     * Specifies the expanded chart scheme in which the the object type can be shown Array of keys of {@link sap.gantt.config.ChartScheme}
     */
    expandedChartSchemeKeys?: string[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/SettingGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SettingGroup control allows you to specify the number of setting items to display in the Setting
   * window.
   *
   * @deprecated (since 1.64)
   */
  export default class SettingGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new setting group.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SettingGroupSettings
    );
    /**
     * Creates and initializes a new setting group.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SettingGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.SettingGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SettingGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.SettingGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getItems items}.
     *
     * Association to the setting item. See {@link sap.gantt.config.SettingItem} We recommend that you set the
     * type of this argument to `sap.gantt.config.SettingItem[]`. Otherwise some properties you set may not
     * function properly.
     *
     * Default value is `sap.gantt.config.DEFAULT_TOOLBAR_SETTING_ITEMS`.
     *
     *
     * @returns Value of property `items`
     */
    getItems(): object[];
    /**
     * Sets a new value for property {@link #getItems items}.
     *
     * Association to the setting item. See {@link sap.gantt.config.SettingItem} We recommend that you set the
     * type of this argument to `sap.gantt.config.SettingItem[]`. Otherwise some properties you set may not
     * function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_TOOLBAR_SETTING_ITEMS`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setItems(
      /**
       * New value for property `items`
       */
      sItems?: object[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SettingGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $SettingGroupSettings extends $ToolbarGroupSettings {
    /**
     * Association to the setting item. See {@link sap.gantt.config.SettingItem} We recommend that you set the
     * type of this argument to `sap.gantt.config.SettingItem[]`. Otherwise some properties you set may not
     * function properly.
     */
    items?: object[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/SettingItem" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The SettingItem control allows you to create a setting item in the toolbar, which is presented as a checkbox
   * with a label.
   */
  export default class SettingItem extends UI5Element {
    /**
     * Creates and initializes a new setting item.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SettingItemSettings
    );
    /**
     * Creates and initializes a new setting item.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SettingItemSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.SettingItem with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SettingItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.SettingItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getChecked checked}.
     *
     * Indicates whether the checkbox is selected or not
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `checked`
     */
    getChecked(): boolean;
    /**
     * Gets current value of property {@link #getDisplayText displayText}.
     *
     * Aria label of the checkbox
     *
     *
     * @returns Value of property `displayText`
     */
    getDisplayText(): string;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Identifier of an event when the checkbox is toggled
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Sets a new value for property {@link #getChecked checked}.
     *
     * Indicates whether the checkbox is selected or not
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChecked(
      /**
       * New value for property `checked`
       */
      bChecked?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayText displayText}.
     *
     * Aria label of the checkbox
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayText(
      /**
       * New value for property `displayText`
       */
      sDisplayText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Identifier of an event when the checkbox is toggled
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SettingItem constructor.
   */
  export interface $SettingItemSettings extends $ElementSettings {
    /**
     * Indicates whether the checkbox is selected or not
     */
    checked?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Identifier of an event when the checkbox is toggled
     */
    key?: string | PropertyBindingInfo;

    /**
     * Aria label of the checkbox
     */
    displayText?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/Shape" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Configuration object for Shape.
   *
   *  This configuration specifies the Shape class used to represent specific data and how the Shape class
   * is constructed. Some properties of Shape can be directly configured by setting property `shapeProperties`.
   *
   * A Shape class may come from the shape library provided in namespace `sap.gantt.shape` or from any extended
   * shape you've created. Shape classes are instantiated according to the structure described in this configuration
   * class inside `sap.gantt.Gantt`. The aggregation structure is described by properties `groupAggregation`,
   * `clippathAggregation`, and `selectedClassName`.
   *
   * The root shape is called 'top shape'. Some properties are only top shape relevant such as `key`, `level`,
   * and `selectedClassName`.
   *
   * @deprecated (since 1.64)
   */
  export default class Shape extends UI5Element {
    /**
     * Creates and initializes a shape configuration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ShapeSettings
    );
    /**
     * Creates and initializes a shape configuration.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ShapeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.Shape with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Shape>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.Shape.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getClippathAggregation clippathAggregation}.
     *
     * Aggregation path classes for sap.gantt.shape.Clippath class. This aggregation is only valid for shape
     * classes with tag='clippath'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `clippathAggregation`
     */
    getClippathAggregation(): object[];
    /**
     * Gets current value of property {@link #getCountInBirdEye countInBirdEye}.
     *
     * Specifies whether or not should the shape be considered into bird eye range. we suggest to set this property
     * to true only for shapes that really need to be considered into bird eye range.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `countInBirdEye`
     */
    getCountInBirdEye(): boolean;
    /**
     * Gets current value of property {@link #getGroupAggregation groupAggregation}.
     *
     * Aggregation shapes for sap.gantt.shape.Group class. This aggregation is only valid for shape classes
     * with tag='g'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`. Otherwise
     * some properties you set may not function properly.
     *
     *
     * @returns Value of property `groupAggregation`
     */
    getGroupAggregation(): object[];
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Primary key of the shape configuration. This property can be referenced from other configuration object,
     * such as `sap.gantt.config.ChartScheme`. This property is only relevant to top Shape configuration.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getLevel level}.
     *
     * Level of shapes. Shapes closer to the top shape have a smaller value in level. This property is only
     * relevant to top shape configuration (non aggregated shape configuration).
     *
     *
     * @returns Value of property `level`
     */
    getLevel(): string;
    /**
     * Gets current value of property {@link #getModeKeys modeKeys}.
     *
     * Specifies the key of modes in which the shape is drawn. If you leave this property empty, the shape is
     * drawn in all modes.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `modeKeys`
     */
    getModeKeys(): string[];
    /**
     * Gets current value of property {@link #getResizeShadowClassName resizeShadowClassName}.
     *
     * Aggregation class for drawing shadow when resizing this shape. If nothing is assigned to this property,
     * `sap.gantt.Gantt` instantiates the default shadow shape class.
     *
     *
     * @returns Value of property `resizeShadowClassName`
     */
    getResizeShadowClassName(): string;
    /**
     * Gets current value of property {@link #getSelectedClassName selectedClassName}.
     *
     * Aggregation class for drawing selection of this shape. If nothing is assigned to this property, `sap.gantt.Gantt`
     * instantiates the default selected shape class.
     *
     *
     * @returns Value of property `selectedClassName`
     */
    getSelectedClassName(): string;
    /**
     * Gets current value of property {@link #getShapeClassName shapeClassName}.
     *
     * Specifies the shape class to be used for data representation. Both shapes from `sap.gantt.shape` and
     * extended shapes can be used here.
     *
     *
     * @returns Value of property `shapeClassName`
     */
    getShapeClassName(): string;
    /**
     * Gets current value of property {@link #getShapeDataName shapeDataName}.
     *
     * Specifies the name of the data name to be represented. This is for the top shape only.
     *
     *
     * @returns Value of property `shapeDataName`
     */
    getShapeDataName(): string;
    /**
     * Gets current value of property {@link #getShapeProperties shapeProperties}.
     *
     * Pre-configured values for Shape. The values specified in this object have a higher priority than values
     * coded in the Shape class.
     *
     * Default value is `library.config.DEFAULT_EMPTY_OBJECT`.
     *
     *
     * @returns Value of property `shapeProperties`
     */
    getShapeProperties(): object;
    /**
     * Get a pre-configured property from `shapeProperties`.
     *
     * This method together with method `hasShapeProperty` is frequently used in `sap.gantt.shape` classes
     * to make sure the principle of 'configuration first' is applied. .
     *
     *
     * @returns - Pre-configured value.
     */
    getShapeProperty(
      /**
       * Name of the shape property.
       */
      sPropertyName: string
    ): string;
    /**
     * Gets current value of property {@link #getSwitchOfCheckBox switchOfCheckBox}.
     *
     * Switch of shape's checkbox value in list legend, its value can be "noShow", "checked" and "unchecked".
     *
     * Default value is `"noShow"`.
     *
     *
     * @returns Value of property `switchOfCheckBox`
     */
    getSwitchOfCheckBox(): string;
    /**
     * Checks if a property is pre-configured in `shapeProperties`.
     *
     * This method together with method `getShapeProperty()` is frequently used in `sap.gantt.shape` classes
     * to make sure the principle of 'configuration first' is applied. .
     *
     *
     * @returns - Whether the property is pre-configured.
     */
    hasShapeProperty(
      /**
       * Name of the shape property.
       */
      sPropertyName: string
    ): boolean;
    /**
     * Sets a new value for property {@link #getClippathAggregation clippathAggregation}.
     *
     * Aggregation path classes for sap.gantt.shape.Clippath class. This aggregation is only valid for shape
     * classes with tag='clippath'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClippathAggregation(
      /**
       * New value for property `clippathAggregation`
       */
      sClippathAggregation: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getCountInBirdEye countInBirdEye}.
     *
     * Specifies whether or not should the shape be considered into bird eye range. we suggest to set this property
     * to true only for shapes that really need to be considered into bird eye range.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCountInBirdEye(
      /**
       * New value for property `countInBirdEye`
       */
      bCountInBirdEye?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGroupAggregation groupAggregation}.
     *
     * Aggregation shapes for sap.gantt.shape.Group class. This aggregation is only valid for shape classes
     * with tag='g'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`. Otherwise
     * some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGroupAggregation(
      /**
       * New value for property `groupAggregation`
       */
      sGroupAggregation: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Primary key of the shape configuration. This property can be referenced from other configuration object,
     * such as `sap.gantt.config.ChartScheme`. This property is only relevant to top Shape configuration.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLevel level}.
     *
     * Level of shapes. Shapes closer to the top shape have a smaller value in level. This property is only
     * relevant to top shape configuration (non aggregated shape configuration).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLevel(
      /**
       * New value for property `level`
       */
      sLevel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getModeKeys modeKeys}.
     *
     * Specifies the key of modes in which the shape is drawn. If you leave this property empty, the shape is
     * drawn in all modes.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModeKeys(
      /**
       * New value for property `modeKeys`
       */
      sModeKeys?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getResizeShadowClassName resizeShadowClassName}.
     *
     * Aggregation class for drawing shadow when resizing this shape. If nothing is assigned to this property,
     * `sap.gantt.Gantt` instantiates the default shadow shape class.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResizeShadowClassName(
      /**
       * New value for property `resizeShadowClassName`
       */
      sResizeShadowClassName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedClassName selectedClassName}.
     *
     * Aggregation class for drawing selection of this shape. If nothing is assigned to this property, `sap.gantt.Gantt`
     * instantiates the default selected shape class.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedClassName(
      /**
       * New value for property `selectedClassName`
       */
      sSelectedClassName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShapeClassName shapeClassName}.
     *
     * Specifies the shape class to be used for data representation. Both shapes from `sap.gantt.shape` and
     * extended shapes can be used here.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeClassName(
      /**
       * New value for property `shapeClassName`
       */
      sShapeClassName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShapeDataName shapeDataName}.
     *
     * Specifies the name of the data name to be represented. This is for the top shape only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeDataName(
      /**
       * New value for property `shapeDataName`
       */
      sShapeDataName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShapeProperties shapeProperties}.
     *
     * Pre-configured values for Shape. The values specified in this object have a higher priority than values
     * coded in the Shape class.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_EMPTY_OBJECT`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeProperties(
      /**
       * New value for property `shapeProperties`
       */
      oShapeProperties?: object
    ): this;
    /**
     * Sets a new value for property {@link #getSwitchOfCheckBox switchOfCheckBox}.
     *
     * Switch of shape's checkbox value in list legend, its value can be "noShow", "checked" and "unchecked".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"noShow"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSwitchOfCheckBox(
      /**
       * New value for property `switchOfCheckBox`
       */
      sSwitchOfCheckBox?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Shape constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ShapeSettings extends $ElementSettings {
    /**
     * Primary key of the shape configuration. This property can be referenced from other configuration object,
     * such as `sap.gantt.config.ChartScheme`. This property is only relevant to top Shape configuration.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Specifies the shape class to be used for data representation. Both shapes from `sap.gantt.shape` and
     * extended shapes can be used here.
     */
    shapeClassName?: string | PropertyBindingInfo;

    /**
     * Specifies the name of the data name to be represented. This is for the top shape only.
     */
    shapeDataName?: string | PropertyBindingInfo;

    /**
     * Specifies the key of modes in which the shape is drawn. If you leave this property empty, the shape is
     * drawn in all modes.
     */
    modeKeys?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Level of shapes. Shapes closer to the top shape have a smaller value in level. This property is only
     * relevant to top shape configuration (non aggregated shape configuration).
     */
    level?: string | PropertyBindingInfo;

    /**
     * Pre-configured values for Shape. The values specified in this object have a higher priority than values
     * coded in the Shape class.
     */
    shapeProperties?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation shapes for sap.gantt.shape.Group class. This aggregation is only valid for shape classes
     * with tag='g'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`. Otherwise
     * some properties you set may not function properly.
     */
    groupAggregation?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation path classes for sap.gantt.shape.Clippath class. This aggregation is only valid for shape
     * classes with tag='clippath'. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     */
    clippathAggregation?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Aggregation class for drawing selection of this shape. If nothing is assigned to this property, `sap.gantt.Gantt`
     * instantiates the default selected shape class.
     */
    selectedClassName?: string | PropertyBindingInfo;

    /**
     * Switch of shape's checkbox value in list legend, its value can be "noShow", "checked" and "unchecked".
     */
    switchOfCheckBox?: string | PropertyBindingInfo;

    /**
     * Aggregation class for drawing shadow when resizing this shape. If nothing is assigned to this property,
     * `sap.gantt.Gantt` instantiates the default shadow shape class.
     */
    resizeShadowClassName?: string | PropertyBindingInfo;

    /**
     * Specifies whether or not should the shape be considered into bird eye range. we suggest to set this property
     * to true only for shapes that really need to be considered into bird eye range.
     */
    countInBirdEye?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/TimeAxis" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the time axis of a Gantt chart
   *
   * @deprecated (since 1.44) - replaced by sap.gantt.axistime.AxisTimeStrategy
   */
  export default class TimeAxis extends UI5Element {
    /**
     * Creates and initializes a new time axis
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $TimeAxisSettings
    );
    /**
     * Creates and initializes a new time axis
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $TimeAxisSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.TimeAxis with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TimeAxis>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.TimeAxis.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCoarsestGranularity coarsestGranularity}.
     *
     * Granularity when the GanttChart is zoomed out to the minimum
     *
     * Default value is `"1month"`.
     *
     *
     * @returns Value of property `coarsestGranularity`
     */
    getCoarsestGranularity(): string;
    /**
     * Gets current value of property {@link #getFinestGranularity finestGranularity}.
     *
     * Granularity when the Gantt chart is zoomed in to the maximum
     *
     * Default value is `"5min"`.
     *
     *
     * @returns Value of property `finestGranularity`
     */
    getFinestGranularity(): string;
    /**
     * Gets current value of property {@link #getGranularity granularity}.
     *
     * Initial granularity of the time axis
     *
     * Default value is `"4day"`.
     *
     *
     * @returns Value of property `granularity`
     */
    getGranularity(): string;
    /**
     * Gets current value of property {@link #getInitHorizon initHorizon}.
     *
     * Time horizon which is displayed after the Gantt chart is initialized We recommend that you set the type
     * of this argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not function
     * properly.
     *
     * Default value is `sap.gantt.config.DEFAULT_INIT_HORIZON`.
     *
     *
     * @returns Value of property `initHorizon`
     */
    getInitHorizon(): object;
    /**
     * Gets current value of property {@link #getPlanHorizon planHorizon}.
     *
     * Whole time horizon of the Gantt chart We recommend that you set the type of this argument to `sap.gantt.config.TimeHorizon`.
     * Otherwise some properties you set may not function properly.
     *
     * Default value is `sap.gantt.config.DEFAULT_PLAN_HORIZON`.
     *
     *
     * @returns Value of property `planHorizon`
     */
    getPlanHorizon(): object;
    /**
     * Gets current value of property {@link #getRate rate}.
     *
     * Zoom rate of the Gantt chart
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `rate`
     */
    getRate(): float;
    /**
     * Gets current value of property {@link #getZoomStrategy zoomStrategy}.
     *
     * Zoom strategy of the Gantt chart
     *
     * {@see sap.gantt.axistime.AxisTimeStrategy}
     *
     * Default value is `sap.gantt.config.DEFAULT_TIME_ZOOM_STRATEGY`.
     *
     *
     * @returns Value of property `zoomStrategy`
     */
    getZoomStrategy(): object;
    /**
     * Sets a new value for property {@link #getCoarsestGranularity coarsestGranularity}.
     *
     * Granularity when the GanttChart is zoomed out to the minimum
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"1month"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCoarsestGranularity(
      /**
       * New value for property `coarsestGranularity`
       */
      sCoarsestGranularity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFinestGranularity finestGranularity}.
     *
     * Granularity when the Gantt chart is zoomed in to the maximum
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"5min"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFinestGranularity(
      /**
       * New value for property `finestGranularity`
       */
      sFinestGranularity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getGranularity granularity}.
     *
     * Initial granularity of the time axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"4day"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGranularity(
      /**
       * New value for property `granularity`
       */
      sGranularity?: string
    ): this;
    /**
     * Sets a new value for property {@link #getInitHorizon initHorizon}.
     *
     * Time horizon which is displayed after the Gantt chart is initialized We recommend that you set the type
     * of this argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not function
     * properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_INIT_HORIZON`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitHorizon(
      /**
       * New value for property `initHorizon`
       */
      oInitHorizon?: object
    ): this;
    /**
     * Sets a new value for property {@link #getPlanHorizon planHorizon}.
     *
     * Whole time horizon of the Gantt chart We recommend that you set the type of this argument to `sap.gantt.config.TimeHorizon`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_PLAN_HORIZON`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlanHorizon(
      /**
       * New value for property `planHorizon`
       */
      oPlanHorizon?: object
    ): this;
    /**
     * Sets a new value for property {@link #getRate rate}.
     *
     * Zoom rate of the Gantt chart
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRate(
      /**
       * New value for property `rate`
       */
      fRate?: float
    ): this;
    /**
     * Sets a new value for property {@link #getZoomStrategy zoomStrategy}.
     *
     * Zoom strategy of the Gantt chart
     *
     * {@see sap.gantt.axistime.AxisTimeStrategy}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.config.DEFAULT_TIME_ZOOM_STRATEGY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomStrategy(
      /**
       * New value for property `zoomStrategy`
       */
      oZoomStrategy?: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TimeAxis constructor.
   *
   * @deprecated (since 1.44) - replaced by sap.gantt.axistime.AxisTimeStrategy
   */
  export interface $TimeAxisSettings extends $ElementSettings {
    /**
     * Whole time horizon of the Gantt chart We recommend that you set the type of this argument to `sap.gantt.config.TimeHorizon`.
     * Otherwise some properties you set may not function properly.
     */
    planHorizon?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Time horizon which is displayed after the Gantt chart is initialized We recommend that you set the type
     * of this argument to `sap.gantt.config.TimeHorizon`. Otherwise some properties you set may not function
     * properly.
     */
    initHorizon?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Zoom strategy of the Gantt chart
     *
     * {@see sap.gantt.axistime.AxisTimeStrategy}
     */
    zoomStrategy?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Initial granularity of the time axis
     */
    granularity?: string | PropertyBindingInfo;

    /**
     * Granularity when the Gantt chart is zoomed in to the maximum
     */
    finestGranularity?: string | PropertyBindingInfo;

    /**
     * Granularity when the GanttChart is zoomed out to the minimum
     */
    coarsestGranularity?: string | PropertyBindingInfo;

    /**
     * Zoom rate of the Gantt chart
     */
    rate?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/TimeHorizon" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the Time horizon
   */
  export default class TimeHorizon extends UI5Element {
    /**
     * Creates and initializes a new Time horizon
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * =Initial settings for the new control
       */
      mSettings?: $TimeHorizonSettings
    );
    /**
     * Creates and initializes a new Time horizon
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * =Initial settings for the new control
       */
      mSettings?: $TimeHorizonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.TimeHorizon with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TimeHorizon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.TimeHorizon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Compares two time horizons.
     *
     *
     * @returns True if both horizons are equal.
     */
    equals(
      /**
       * Time horizon to compare.
       */
      oTimeHorizon: undefined
    ): boolean;
    /**
     * Gets current value of property {@link #getEndTime endTime}.
     *
     * End time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `endTime` is `Object`, the
     * value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `endTime`
     */
    getEndTime(): string;
    /**
     * Gets current value of property {@link #getStartTime startTime}.
     *
     * Start time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `startTime` is `Object`,
     * the value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Value of property `startTime`
     */
    getStartTime(): string;
    /**
     * Sets a new value for property {@link #getEndTime endTime}.
     *
     * End time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `endTime` is `Object`, the
     * value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndTime(
      /**
       * New value for property `endTime`
       */
      sEndTime?: string
    ): this;
    /**
     * Sets a new value for property {@link #getStartTime startTime}.
     *
     * Start time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `startTime` is `Object`,
     * the value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStartTime(
      /**
       * New value for property `startTime`
       */
      sStartTime?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TimeHorizon constructor.
   */
  export interface $TimeHorizonSettings extends $ElementSettings {
    /**
     * Start time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `startTime` is `Object`,
     * the value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     */
    startTime?: string | PropertyBindingInfo;

    /**
     * End time of the time horizon in this format: YYYYMMDDHHMMSS. If the type of `endTime` is `Object`, the
     * value is converted to a string. **Note:** Modifying this property does not invalidate the control.
     */
    endTime?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/config/TimeZoomGroup" {
  import {
    default as ToolbarGroup,
    $ToolbarGroupSettings,
  } from "sap/gantt/config/ToolbarGroup";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { config } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * You can define time zooming related toolbar items in the Gantt chart toolbar.
   *
   * @deprecated (since 1.64)
   */
  export default class TimeZoomGroup extends ToolbarGroup {
    /**
     * Creates and initializes a new time zoom group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $TimeZoomGroupSettings
    );
    /**
     * Creates and initializes a new time zoom group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $TimeZoomGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.TimeZoomGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.config.ToolbarGroup.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TimeZoomGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.TimeZoomGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getInfoOfSelectItems infoOfSelectItems}.
     *
     * Array of plain objects which has "key" and "text" properties, or array of sap.ui.core.Item used to configure
     * the items in the Select control when the zoom control type is sap.gantt.config.ZoomControlType.Select.
     *
     *
     * @returns Value of property `infoOfSelectItems`
     */
    getInfoOfSelectItems(): object[];
    /**
     * Gets current value of property {@link #getShowZoomButtons showZoomButtons}.
     *
     * Enables zoom in and zoom out buttons for the time zooming function.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     *
     * @returns Value of property `showZoomButtons`
     */
    getShowZoomButtons(): boolean;
    /**
     * Gets current value of property {@link #getShowZoomSlider showZoomSlider}.
     *
     * Enables the Slider control for the time zooming function.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     *
     * @returns Value of property `showZoomSlider`
     */
    getShowZoomSlider(): boolean;
    /**
     * Gets current value of property {@link #getStepCountOfSlider stepCountOfSlider}.
     *
     * Sets the step when the zoom control type is sap.gantt.config.ZoomControlType.SliderWithButtons or sap.gantt.config.ZoomControlType.SliderOnly.
     *
     * Default value is `10`.
     *
     *
     * @returns Value of property `stepCountOfSlider`
     */
    getStepCountOfSlider(): int;
    /**
     * Gets current value of property {@link #getZoomControlType zoomControlType}.
     *
     * Defines the control type to set the zoom rate.
     *
     * Default value is `SliderWithButtons`.
     *
     *
     * @returns Value of property `zoomControlType`
     */
    getZoomControlType():
      | config.ZoomControlType
      | keyof typeof config.ZoomControlType;
    /**
     * Sets a new value for property {@link #getInfoOfSelectItems infoOfSelectItems}.
     *
     * Array of plain objects which has "key" and "text" properties, or array of sap.ui.core.Item used to configure
     * the items in the Select control when the zoom control type is sap.gantt.config.ZoomControlType.Select.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInfoOfSelectItems(
      /**
       * New value for property `infoOfSelectItems`
       */
      sInfoOfSelectItems: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getShowZoomButtons showZoomButtons}.
     *
     * Enables zoom in and zoom out buttons for the time zooming function.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowZoomButtons(
      /**
       * New value for property `showZoomButtons`
       */
      bShowZoomButtons?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowZoomSlider showZoomSlider}.
     *
     * Enables the Slider control for the time zooming function.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowZoomSlider(
      /**
       * New value for property `showZoomSlider`
       */
      bShowZoomSlider?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStepCountOfSlider stepCountOfSlider}.
     *
     * Sets the step when the zoom control type is sap.gantt.config.ZoomControlType.SliderWithButtons or sap.gantt.config.ZoomControlType.SliderOnly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStepCountOfSlider(
      /**
       * New value for property `stepCountOfSlider`
       */
      iStepCountOfSlider?: int
    ): this;
    /**
     * Sets a new value for property {@link #getZoomControlType zoomControlType}.
     *
     * Defines the control type to set the zoom rate.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `SliderWithButtons`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setZoomControlType(
      /**
       * New value for property `zoomControlType`
       */
      sZoomControlType?:
        | config.ZoomControlType
        | keyof typeof config.ZoomControlType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TimeZoomGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $TimeZoomGroupSettings extends $ToolbarGroupSettings {
    /**
     * Enables the Slider control for the time zooming function.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     */
    showZoomSlider?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Enables zoom in and zoom out buttons for the time zooming function.
     *
     * @deprecated (since 1.44) - replaced by zoomControlType
     */
    showZoomButtons?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the control type to set the zoom rate.
     */
    zoomControlType?:
      | (config.ZoomControlType | keyof typeof config.ZoomControlType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Sets the step when the zoom control type is sap.gantt.config.ZoomControlType.SliderWithButtons or sap.gantt.config.ZoomControlType.SliderOnly.
     */
    stepCountOfSlider?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of plain objects which has "key" and "text" properties, or array of sap.ui.core.Item used to configure
     * the items in the Select control when the zoom control type is sap.gantt.config.ZoomControlType.Select.
     */
    infoOfSelectItems?: object[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/config/ToolbarGroup" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { ButtonType, OverflowToolbarPriority } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the toolbar group. Toolbar groups enables you to categorize related toolbar items. For example,
   * you can put all settings-related toolbar items in the Setting group.
   *
   * @deprecated (since 1.64)
   */
  export default class ToolbarGroup extends UI5Element {
    /**
     * Creates and initializes a new toolbar group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarGroupSettings
    );
    /**
     * Creates and initializes a new toolbar group
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarGroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ToolbarGroup with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ToolbarGroup>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ToolbarGroup.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getButtonType buttonType}.
     *
     * Type of a button in the toolbar group if it's a button
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `buttonType`
     */
    getButtonType(): ButtonType | keyof typeof ButtonType;
    /**
     * Gets current value of property {@link #getOverflowPriority overflowPriority}.
     *
     * Overflow priority. See {@link sap.m.OverflowToolbarPriority}
     *
     * Default value is `Low`.
     *
     *
     * @returns Value of property `overflowPriority`
     */
    getOverflowPriority():
      | OverflowToolbarPriority
      | keyof typeof OverflowToolbarPriority;
    /**
     * Gets current value of property {@link #getPosition position}.
     *
     * Specifies the position of the toolbar group. Note that all toolbar groups must be put into the Gantt
     * chart toolbar.
     *
     *
     * @returns Value of property `position`
     */
    getPosition(): string;
    /**
     * Sets a new value for property {@link #getButtonType buttonType}.
     *
     * Type of a button in the toolbar group if it's a button
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setButtonType(
      /**
       * New value for property `buttonType`
       */
      sButtonType?: ButtonType | keyof typeof ButtonType
    ): this;
    /**
     * Sets a new value for property {@link #getOverflowPriority overflowPriority}.
     *
     * Overflow priority. See {@link sap.m.OverflowToolbarPriority}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Low`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverflowPriority(
      /**
       * New value for property `overflowPriority`
       */
      sOverflowPriority?:
        | OverflowToolbarPriority
        | keyof typeof OverflowToolbarPriority
    ): this;
    /**
     * Sets a new value for property {@link #getPosition position}.
     *
     * Specifies the position of the toolbar group. Note that all toolbar groups must be put into the Gantt
     * chart toolbar.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPosition(
      /**
       * New value for property `position`
       */
      sPosition?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ToolbarGroup constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ToolbarGroupSettings extends $ElementSettings {
    /**
     * Specifies the position of the toolbar group. Note that all toolbar groups must be put into the Gantt
     * chart toolbar.
     */
    position?: string | PropertyBindingInfo;

    /**
     * Overflow priority. See {@link sap.m.OverflowToolbarPriority}
     */
    overflowPriority?:
      | (OverflowToolbarPriority | keyof typeof OverflowToolbarPriority)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Type of a button in the toolbar group if it's a button
     */
    buttonType?:
      | (ButtonType | keyof typeof ButtonType)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/gantt/config/ToolbarScheme" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Defines the Toolbar scheme
   *
   * @deprecated (since 1.64)
   */
  export default class ToolbarScheme extends UI5Element {
    /**
     * Creates and initializes a new toolbar scheme
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarSchemeSettings
    );
    /**
     * Creates and initializes a new toolbar scheme
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ToolbarSchemeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.config.ToolbarScheme with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ToolbarScheme>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.config.ToolbarScheme.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBirdEye birdEye}.
     *
     * Toolbar group for bird eye We recommend that you set the type of this argument to `sap.gantt.config.BirdEyeGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `birdEye`
     */
    getBirdEye(): object;
    /**
     * Gets current value of property {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Toolbar group for custom toolbar items We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `customToolbarItems`
     */
    getCustomToolbarItems(): object;
    /**
     * Gets current value of property {@link #getExpandChart expandChart}.
     *
     * Toolbar group for expanding a chart We recommend that you set the type of this argument to `sap.gantt.config.ExpandChartGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `expandChart`
     */
    getExpandChart(): object;
    /**
     * Gets current value of property {@link #getExpandTree expandTree}.
     *
     * Toolbar group for expanding nodes of a tree table We recommend that you set the type of this argument
     * to `sap.gantt.config.ToolbarGroup`. Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `expandTree`
     */
    getExpandTree(): object;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique key of the toolbar scheme
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getLayout layout}.
     *
     * Toolbar group for the Gantt chart layout We recommend that you set the type of this argument to `sap.gantt.config.LayoutGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `layout`
     */
    getLayout(): object;
    /**
     * Gets current value of property {@link #getLegend legend}.
     *
     * Toolbar group for legend We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `legend`
     */
    getLegend(): object;
    /**
     * Gets current value of property {@link #getMode mode}.
     *
     * See {@link sap.gantt.config.ModeGroup} We recommend that you set the type of this argument to `sap.gantt.config.ModeGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `mode`
     */
    getMode(): object;
    /**
     * Gets current value of property {@link #getSettings settings}.
     *
     * See {@link sap.gantt.config.SettingGroup} We recommend that you set the type of this argument to `sap.gantt.config.SettingGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `settings`
     */
    getSettings(): object;
    /**
     * Gets current value of property {@link #getSourceSelect sourceSelect}.
     *
     * Toolbar group for selecting a source We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `sourceSelect`
     */
    getSourceSelect(): object;
    /**
     * Gets current value of property {@link #getTimeZoom timeZoom}.
     *
     * Toolbar group for the time zoom We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `timeZoom`
     */
    getTimeZoom(): object;
    /**
     * Gets current value of property {@link #getToolbarDesign toolbarDesign}.
     *
     * Toolbar design. See {@link sap.m.ToolbarDesign}
     *
     * Default value is `sap.m.ToolbarDesign.Auto`.
     *
     *
     * @returns Value of property `toolbarDesign`
     */
    getToolbarDesign(): string;
    /**
     * Sets a new value for property {@link #getBirdEye birdEye}.
     *
     * Toolbar group for bird eye We recommend that you set the type of this argument to `sap.gantt.config.BirdEyeGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBirdEye(
      /**
       * New value for property `birdEye`
       */
      oBirdEye?: object
    ): this;
    /**
     * Sets a new value for property {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Toolbar group for custom toolbar items We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomToolbarItems(
      /**
       * New value for property `customToolbarItems`
       */
      oCustomToolbarItems?: object
    ): this;
    /**
     * Sets a new value for property {@link #getExpandChart expandChart}.
     *
     * Toolbar group for expanding a chart We recommend that you set the type of this argument to `sap.gantt.config.ExpandChartGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandChart(
      /**
       * New value for property `expandChart`
       */
      oExpandChart?: object
    ): this;
    /**
     * Sets a new value for property {@link #getExpandTree expandTree}.
     *
     * Toolbar group for expanding nodes of a tree table We recommend that you set the type of this argument
     * to `sap.gantt.config.ToolbarGroup`. Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExpandTree(
      /**
       * New value for property `expandTree`
       */
      oExpandTree?: object
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique key of the toolbar scheme
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLayout layout}.
     *
     * Toolbar group for the Gantt chart layout We recommend that you set the type of this argument to `sap.gantt.config.LayoutGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLayout(
      /**
       * New value for property `layout`
       */
      oLayout?: object
    ): this;
    /**
     * Sets a new value for property {@link #getLegend legend}.
     *
     * Toolbar group for legend We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * New value for property `legend`
       */
      oLegend?: object
    ): this;
    /**
     * Sets a new value for property {@link #getMode mode}.
     *
     * See {@link sap.gantt.config.ModeGroup} We recommend that you set the type of this argument to `sap.gantt.config.ModeGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMode(
      /**
       * New value for property `mode`
       */
      oMode?: object
    ): this;
    /**
     * Sets a new value for property {@link #getSettings settings}.
     *
     * See {@link sap.gantt.config.SettingGroup} We recommend that you set the type of this argument to `sap.gantt.config.SettingGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSettings(
      /**
       * New value for property `settings`
       */
      oSettings?: object
    ): this;
    /**
     * Sets a new value for property {@link #getSourceSelect sourceSelect}.
     *
     * Toolbar group for selecting a source We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSourceSelect(
      /**
       * New value for property `sourceSelect`
       */
      oSourceSelect?: object
    ): this;
    /**
     * Sets a new value for property {@link #getTimeZoom timeZoom}.
     *
     * Toolbar group for the time zoom We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeZoom(
      /**
       * New value for property `timeZoom`
       */
      oTimeZoom?: object
    ): this;
    /**
     * Sets a new value for property {@link #getToolbarDesign toolbarDesign}.
     *
     * Toolbar design. See {@link sap.m.ToolbarDesign}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.m.ToolbarDesign.Auto`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolbarDesign(
      /**
       * New value for property `toolbarDesign`
       */
      sToolbarDesign?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ToolbarScheme constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ToolbarSchemeSettings extends $ElementSettings {
    /**
     * Unique key of the toolbar scheme
     */
    key?: string | PropertyBindingInfo;

    /**
     * Toolbar group for selecting a source We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     */
    sourceSelect?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for bird eye We recommend that you set the type of this argument to `sap.gantt.config.BirdEyeGroup`.
     * Otherwise some properties you set may not function properly.
     */
    birdEye?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for the Gantt chart layout We recommend that you set the type of this argument to `sap.gantt.config.LayoutGroup`.
     * Otherwise some properties you set may not function properly.
     */
    layout?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for custom toolbar items We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     */
    customToolbarItems?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for expanding a chart We recommend that you set the type of this argument to `sap.gantt.config.ExpandChartGroup`.
     * Otherwise some properties you set may not function properly.
     */
    expandChart?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for expanding nodes of a tree table We recommend that you set the type of this argument
     * to `sap.gantt.config.ToolbarGroup`. Otherwise some properties you set may not function properly.
     */
    expandTree?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for the time zoom We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     */
    timeZoom?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar group for legend We recommend that you set the type of this argument to `sap.gantt.config.ToolbarGroup`.
     * Otherwise some properties you set may not function properly.
     */
    legend?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * See {@link sap.gantt.config.SettingGroup} We recommend that you set the type of this argument to `sap.gantt.config.SettingGroup`.
     * Otherwise some properties you set may not function properly.
     */
    settings?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * See {@link sap.gantt.config.ModeGroup} We recommend that you set the type of this argument to `sap.gantt.config.ModeGroup`.
     * Otherwise some properties you set may not function properly.
     */
    mode?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Toolbar design. See {@link sap.m.ToolbarDesign}
     */
    toolbarDesign?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/control/Cell" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cell acts as an abstract class. You can use this class to define a placeholder for your application to
   * provide the specific implementation. Applications can fill the cell content by using cellCallback which
   * returns instances such as Icon, Text, or Text input.
   *
   * You can also use this class to define column specific properties that are applied when rendering a list.
   *
   * @deprecated (since 1.64)
   */
  export default class Cell extends Control {
    /**
     * Creates and initializes a new Cell class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CellSettings
    );
    /**
     * Creates and initializes a new Cell class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CellSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.control.Cell with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Cell>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.control.Cell.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Provide accessibility support for control Cell
     * See:
     * 	{sap.ui.core.Control#getAccessibilityInfo}
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control.
     */
    getAccessibilityInfo(): object;
    /**
     * Gets current value of property {@link #getCellCallback cellCallback}.
     *
     * Cell callback function that returns the specific control instance which is rendered in a table.
     *
     *
     * @returns Value of property `cellCallback`
     */
    getCellCallback(): object;
    /**
     * Gets current value of property {@link #getColumnConfig columnConfig}.
     *
     * Column configuration object. We recommend that you set the type of this argument to `sap.gantt.config.HierarchyColumn`.
     * Otherwise some properties you set may not function properly.
     *
     *
     * @returns Value of property `columnConfig`
     */
    getColumnConfig(): object;
    /**
     * Sets a new value for property {@link #getCellCallback cellCallback}.
     *
     * Cell callback function that returns the specific control instance which is rendered in a table.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCellCallback(
      /**
       * New value for property `cellCallback`
       */
      oCellCallback: object
    ): this;
    /**
     * Sets a new value for property {@link #getColumnConfig columnConfig}.
     *
     * Column configuration object. We recommend that you set the type of this argument to `sap.gantt.config.HierarchyColumn`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColumnConfig(
      /**
       * New value for property `columnConfig`
       */
      oColumnConfig: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Cell constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $CellSettings extends $ControlSettings {
    /**
     * Cell callback function that returns the specific control instance which is rendered in a table.
     */
    cellCallback?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Column configuration object. We recommend that you set the type of this argument to `sap.gantt.config.HierarchyColumn`.
     * Otherwise some properties you set may not function properly.
     */
    columnConfig?: object | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/cal/Calendar" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import TimeInterval from "sap/gantt/def/cal/TimeInterval";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * A calendar that contains a list of time interval definitions.
   *
   *  A pattern definition is generated per calendar key.
   */
  export default class Calendar extends DefBase {
    /**
     * Creates and initializes a calendar defined and embedded in a 'defs' tag for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );
    /**
     * Creates and initializes a calendar defined and embedded in a 'defs' tag for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.cal.Calendar with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Calendar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.cal.Calendar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some timeInterval to the aggregation {@link #getTimeIntervals timeIntervals}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addTimeInterval(
      /**
       * The timeInterval to add; if empty, nothing is inserted
       */
      oTimeInterval: TimeInterval
    ): this;
    /**
     * Binds aggregation {@link #getTimeIntervals timeIntervals} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindTimeIntervals(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the timeIntervals in the aggregation {@link #getTimeIntervals timeIntervals}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyTimeIntervals(): this;
    /**
     * Gets current value of property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of time intervals.
     *
     * Default value is `"#e5e5e5"`.
     *
     *
     * @returns Value of property `backgroundColor`
     */
    getBackgroundColor(): ValueSVGPaintServer;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Key of the calendar. Note that this value is used to generate the referencing string of the calendar
     * pattern.
     *
     * Default value is `"calendar"`.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets content of aggregation {@link #getTimeIntervals timeIntervals}.
     *
     * Time intervals that should be painted with the value of `backgroundColor`.
     */
    getTimeIntervals(): TimeInterval[];
    /**
     * Checks for the provided `sap.gantt.def.cal.TimeInterval` in the aggregation {@link #getTimeIntervals timeIntervals}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfTimeInterval(
      /**
       * The timeInterval whose index is looked for
       */
      oTimeInterval: TimeInterval
    ): int;
    /**
     * Inserts a timeInterval into the aggregation {@link #getTimeIntervals timeIntervals}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertTimeInterval(
      /**
       * The timeInterval to insert; if empty, nothing is inserted
       */
      oTimeInterval: TimeInterval,
      /**
       * The `0`-based index the timeInterval should be inserted at; for a negative value of `iIndex`, the timeInterval
       * is inserted at position 0; for a value greater than the current size of the aggregation, the timeInterval
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getTimeIntervals timeIntervals}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllTimeIntervals(): TimeInterval[];
    /**
     * Removes a timeInterval from the aggregation {@link #getTimeIntervals timeIntervals}.
     *
     *
     * @returns The removed timeInterval or `null`
     */
    removeTimeInterval(
      /**
       * The timeInterval to remove or its index or id
       */
      vTimeInterval: int | string | TimeInterval
    ): TimeInterval | null;
    /**
     * Sets a new value for property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of time intervals.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#e5e5e5"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundColor(
      /**
       * New value for property `backgroundColor`
       */
      sBackgroundColor?: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Key of the calendar. Note that this value is used to generate the referencing string of the calendar
     * pattern.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"calendar"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Unbinds aggregation {@link #getTimeIntervals timeIntervals} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindTimeIntervals(): this;
  }
  /**
   * Describes the settings that can be provided to the Calendar constructor.
   */
  export interface $CalendarSettings extends $DefBaseSettings {
    /**
     * Key of the calendar. Note that this value is used to generate the referencing string of the calendar
     * pattern.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Background color of time intervals.
     */
    backgroundColor?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    /**
     * Time intervals that should be painted with the value of `backgroundColor`.
     */
    timeIntervals?:
      | TimeInterval[]
      | TimeInterval
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/gantt/def/cal/CalendarDefs" {
  import { default as SvgDefs, $SvgDefsSettings } from "sap/gantt/def/SvgDefs";

  import DefBase from "sap/gantt/def/DefBase";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * Calendar pattern definition. This class generates the 'defs' tag from the 'defs' aggregation.
   *
   *  Calendar (for non-working hours) is a widely used graphic element in a Gantt chart. Calendar is considered
   * to be highly reusable between different rows of resources. A default implementation of patterns is provided.
   * After calendars are rendered from def tags, shape `sap.gantt.shape.cal.Calendar` can be used to consume
   * the calendar pattern definition.
   *
   * This class is extended to provide a specific logic for generating referencing strings for calendar patterns.
   */
  export default class CalendarDefs extends SvgDefs {
    /**
     * Specific 'def' elements for the calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarDefsSettings
    );
    /**
     * Specific 'def' elements for the calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarDefsSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.cal.CalendarDefs with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.SvgDefs.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CalendarDefs>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.cal.CalendarDefs.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Adds some def1 to the aggregation {@link #getDefs1 defs1}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef1(
      /**
       * The def1 to add; if empty, nothing is inserted
       */
      oDef1: DefBase
    ): this;
    /**
     * Adds some def2 to the aggregation {@link #getDefs2 defs2}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef2(
      /**
       * The def2 to add; if empty, nothing is inserted
       */
      oDef2: DefBase
    ): this;
    /**
     * Adds some def3 to the aggregation {@link #getDefs3 defs3}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef3(
      /**
       * The def3 to add; if empty, nothing is inserted
       */
      oDef3: DefBase
    ): this;
    /**
     * Adds some def4 to the aggregation {@link #getDefs4 defs4}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef4(
      /**
       * The def4 to add; if empty, nothing is inserted
       */
      oDef4: DefBase
    ): this;
    /**
     * Adds some def5 to the aggregation {@link #getDefs5 defs5}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef5(
      /**
       * The def5 to add; if empty, nothing is inserted
       */
      oDef5: DefBase
    ): this;
    /**
     * Binds aggregation {@link #getDefs1 defs1} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs1(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getDefs2 defs2} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs2(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getDefs3 defs3} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs3(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getDefs4 defs4} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs4(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getDefs5 defs5} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs5(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the defs1 in the aggregation {@link #getDefs1 defs1}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs1(): this;
    /**
     * Destroys all the defs2 in the aggregation {@link #getDefs2 defs2}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs2(): this;
    /**
     * Destroys all the defs3 in the aggregation {@link #getDefs3 defs3}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs3(): this;
    /**
     * Destroys all the defs4 in the aggregation {@link #getDefs4 defs4}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs4(): this;
    /**
     * Destroys all the defs5 in the aggregation {@link #getDefs5 defs5}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs5(): this;
    /**
     * Gets content of aggregation {@link #getDefs1 defs1}.
     *
     * @since 1.91
     */
    getDefs1(): DefBase[];
    /**
     * Gets content of aggregation {@link #getDefs2 defs2}.
     *
     * @since 1.91
     */
    getDefs2(): DefBase[];
    /**
     * Gets content of aggregation {@link #getDefs3 defs3}.
     *
     * @since 1.91
     */
    getDefs3(): DefBase[];
    /**
     * Gets content of aggregation {@link #getDefs4 defs4}.
     *
     * @since 1.91
     */
    getDefs4(): DefBase[];
    /**
     * Gets content of aggregation {@link #getDefs5 defs5}.
     *
     * @since 1.91
     */
    getDefs5(): DefBase[];
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs1 defs1}. and returns
     * its index if found or -1 otherwise.
     *
     * @since 1.91
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef1(
      /**
       * The def1 whose index is looked for
       */
      oDef1: DefBase
    ): int;
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs2 defs2}. and returns
     * its index if found or -1 otherwise.
     *
     * @since 1.91
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef2(
      /**
       * The def2 whose index is looked for
       */
      oDef2: DefBase
    ): int;
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs3 defs3}. and returns
     * its index if found or -1 otherwise.
     *
     * @since 1.91
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef3(
      /**
       * The def3 whose index is looked for
       */
      oDef3: DefBase
    ): int;
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs4 defs4}. and returns
     * its index if found or -1 otherwise.
     *
     * @since 1.91
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef4(
      /**
       * The def4 whose index is looked for
       */
      oDef4: DefBase
    ): int;
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs5 defs5}. and returns
     * its index if found or -1 otherwise.
     *
     * @since 1.91
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef5(
      /**
       * The def5 whose index is looked for
       */
      oDef5: DefBase
    ): int;
    /**
     * Inserts a def1 into the aggregation {@link #getDefs1 defs1}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef1(
      /**
       * The def1 to insert; if empty, nothing is inserted
       */
      oDef1: DefBase,
      /**
       * The `0`-based index the def1 should be inserted at; for a negative value of `iIndex`, the def1 is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def1 is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a def2 into the aggregation {@link #getDefs2 defs2}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef2(
      /**
       * The def2 to insert; if empty, nothing is inserted
       */
      oDef2: DefBase,
      /**
       * The `0`-based index the def2 should be inserted at; for a negative value of `iIndex`, the def2 is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def2 is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a def3 into the aggregation {@link #getDefs3 defs3}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef3(
      /**
       * The def3 to insert; if empty, nothing is inserted
       */
      oDef3: DefBase,
      /**
       * The `0`-based index the def3 should be inserted at; for a negative value of `iIndex`, the def3 is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def3 is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a def4 into the aggregation {@link #getDefs4 defs4}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef4(
      /**
       * The def4 to insert; if empty, nothing is inserted
       */
      oDef4: DefBase,
      /**
       * The `0`-based index the def4 should be inserted at; for a negative value of `iIndex`, the def4 is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def4 is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a def5 into the aggregation {@link #getDefs5 defs5}.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef5(
      /**
       * The def5 to insert; if empty, nothing is inserted
       */
      oDef5: DefBase,
      /**
       * The `0`-based index the def5 should be inserted at; for a negative value of `iIndex`, the def5 is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def5 is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDefs1 defs1}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.91
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs1(): DefBase[];
    /**
     * Removes all the controls from the aggregation {@link #getDefs2 defs2}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.91
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs2(): DefBase[];
    /**
     * Removes all the controls from the aggregation {@link #getDefs3 defs3}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.91
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs3(): DefBase[];
    /**
     * Removes all the controls from the aggregation {@link #getDefs4 defs4}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.91
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs4(): DefBase[];
    /**
     * Removes all the controls from the aggregation {@link #getDefs5 defs5}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.91
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs5(): DefBase[];
    /**
     * Removes a def1 from the aggregation {@link #getDefs1 defs1}.
     *
     * @since 1.91
     *
     * @returns The removed def1 or `null`
     */
    removeDef1(
      /**
       * The def1 to remove or its index or id
       */
      vDef1: int | string | DefBase
    ): DefBase | null;
    /**
     * Removes a def2 from the aggregation {@link #getDefs2 defs2}.
     *
     * @since 1.91
     *
     * @returns The removed def2 or `null`
     */
    removeDef2(
      /**
       * The def2 to remove or its index or id
       */
      vDef2: int | string | DefBase
    ): DefBase | null;
    /**
     * Removes a def3 from the aggregation {@link #getDefs3 defs3}.
     *
     * @since 1.91
     *
     * @returns The removed def3 or `null`
     */
    removeDef3(
      /**
       * The def3 to remove or its index or id
       */
      vDef3: int | string | DefBase
    ): DefBase | null;
    /**
     * Removes a def4 from the aggregation {@link #getDefs4 defs4}.
     *
     * @since 1.91
     *
     * @returns The removed def4 or `null`
     */
    removeDef4(
      /**
       * The def4 to remove or its index or id
       */
      vDef4: int | string | DefBase
    ): DefBase | null;
    /**
     * Removes a def5 from the aggregation {@link #getDefs5 defs5}.
     *
     * @since 1.91
     *
     * @returns The removed def5 or `null`
     */
    removeDef5(
      /**
       * The def5 to remove or its index or id
       */
      vDef5: int | string | DefBase
    ): DefBase | null;
    /**
     * Unbinds aggregation {@link #getDefs1 defs1} from model data.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs1(): this;
    /**
     * Unbinds aggregation {@link #getDefs2 defs2} from model data.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs2(): this;
    /**
     * Unbinds aggregation {@link #getDefs3 defs3} from model data.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs3(): this;
    /**
     * Unbinds aggregation {@link #getDefs4 defs4} from model data.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs4(): this;
    /**
     * Unbinds aggregation {@link #getDefs5 defs5} from model data.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs5(): this;
  }
  /**
   * Describes the settings that can be provided to the CalendarDefs constructor.
   */
  export interface $CalendarDefsSettings extends $SvgDefsSettings {
    /**
     * @since 1.91
     */
    defs1?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;

    /**
     * @since 1.91
     */
    defs2?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;

    /**
     * @since 1.91
     */
    defs3?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;

    /**
     * @since 1.91
     */
    defs4?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;

    /**
     * @since 1.91
     */
    defs5?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/cal/TimeInterval" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A time interval pattern.
   */
  export default class TimeInterval extends DefBase {
    /**
     * Creates and initializes a time interval inside the calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new element
       */
      mSettings?: $TimeIntervalSettings
    );
    /**
     * Creates and initializes a time interval inside the calendar.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new element, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new element
       */
      mSettings?: $TimeIntervalSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.cal.TimeInterval with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TimeInterval>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.cal.TimeInterval.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getEndTime endTime}.
     *
     * End time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     *
     *
     * @returns Value of property `endTime`
     */
    getEndTime(): string;
    /**
     * Gets current value of property {@link #getStartTime startTime}.
     *
     * Start Time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     *
     *
     * @returns Value of property `startTime`
     */
    getStartTime(): string;
    /**
     * Sets a new value for property {@link #getEndTime endTime}.
     *
     * End time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndTime(
      /**
       * New value for property `endTime`
       */
      sEndTime?: string
    ): this;
    /**
     * Sets a new value for property {@link #getStartTime startTime}.
     *
     * Start Time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStartTime(
      /**
       * New value for property `startTime`
       */
      sStartTime?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TimeInterval constructor.
   */
  export interface $TimeIntervalSettings extends $DefBaseSettings {
    /**
     * Start Time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     */
    startTime?: string | PropertyBindingInfo;

    /**
     * End time of timeHorizon. Format: YYYYMMDDHHMMSS. If the type of startTime is object, the value is converted
     * to string.
     */
    endTime?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/def/DefBase" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for all SVG definitions.
   *
   *  SVG uses the 'defs' tag to represent graphic objects that can be reused at a later time. Currently
   * `sap.gantt` provides defs including the following definition tags: 'pattern', 'gradient', and 'filter'.
   * Applications can also extend this base class to support more functionality.
   */
  export default abstract class DefBase extends UI5Element {
    /**
     * Creates and initializes a new SVG graphic object for reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DefBaseSettings
    );
    /**
     * Creates and initializes a new SVG graphic object for reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DefBaseSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.DefBase with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DefBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.DefBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Provides a referencing ID. The default implementation is to use control ID as the referencing ID.
     * See:
     * 	sap.ui.table.Table.getSelectedIndex
     *
     *
     * @returns Referencing ID.
     */
    generateRefId(): string;
    /**
     * Gets current value of property {@link #getDefString defString}.
     *
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     *
     *
     * @returns Value of property `defString`
     */
    getDefString(): string;
    /**
     * Gets current value of property {@link #getRefString refString}.
     *
     * Referencing string. The default implementation is the referencing ID wrapped by 'url(#)'.
     *
     *
     * @returns Value of property `refString`
     */
    getRefString(): string;
    /**
     * Sets a new value for property {@link #getDefString defString}.
     *
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefString(
      /**
       * New value for property `defString`
       */
      sDefString?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRefString refString}.
     *
     * Referencing string. The default implementation is the referencing ID wrapped by 'url(#)'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRefString(
      /**
       * New value for property `refString`
       */
      sRefString?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DefBase constructor.
   */
  export interface $DefBaseSettings extends $ElementSettings {
    /**
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     */
    defString?: string | PropertyBindingInfo;

    /**
     * Referencing string. The default implementation is the referencing ID wrapped by 'url(#)'.
     */
    refString?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/def/filter/MorphologyFilter" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * This filter is a combination of several filters. The main one is morphology.
   *
   *  The purpose of this filter is to generate a white outline of a target shape when the target is overlapping
   * with other shapes. In general this filter is recommended to be used only on 'text' and 'image' whose
   * outline is very hard to determine. For regular SVG tags like 'rect', 'circle' etc, use the 'stroke' attribute
   * instead if possible. This is because filters in general have worse performance.
   *  Tags used in this filter are:
   * 	 - 'femorphology': Use operator 'dilate' to make a fatter shape of the source shape.
   * 	 - 'feColorMatrix': Fills fatter shape. The default matrix turns every color into white.
   * 	 - 'feMerge': Merges the source shape into the fatter shape to produce an outline effect on the target
   *     shape.  Effect of this filter is:
   *
   *
   *    Can
   * you see me? How about now?
   */
  export default class MorphologyFilter extends DefBase {
    /**
     * Creates and initializes a morphology filter defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $MorphologyFilterSettings
    );
    /**
     * Creates and initializes a morphology filter defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $MorphologyFilterSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.filter.MorphologyFilter with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, MorphologyFilter>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.filter.MorphologyFilter.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getColorMatrix colorMatrix}.
     *
     * Attribute of SVG tag 'feColorMatrix'. Predefined values are in {@link sap.gantt.def.filter.ColorMatrixValue}.
     * Advanced users can provide a customized matrix in string.
     *
     * Default value is `library.def.filter.ColorMatrixValue.AllToWhite`.
     *
     *
     * @returns Value of property `colorMatrix`
     */
    getColorMatrix(): string;
    /**
     * Gets current value of property {@link #getOperator operator}.
     *
     * Atrribute of SVG tag 'feMorphology'. Possible values are in {@link sap.gantt.def.filter.MorphologyOperator}.
     *
     * Default value is `library.def.filter.MorphologyOperator.Dilate`.
     *
     *
     * @returns Value of property `operator`
     */
    getOperator(): string;
    /**
     * Gets current value of property {@link #getRadius radius}.
     *
     * Attribute of SVG tag 'feMorphology'.
     *
     * Default value is `"2,1"`.
     *
     *
     * @returns Value of property `radius`
     */
    getRadius(): string;
    /**
     * Sets a new value for property {@link #getColorMatrix colorMatrix}.
     *
     * Attribute of SVG tag 'feColorMatrix'. Predefined values are in {@link sap.gantt.def.filter.ColorMatrixValue}.
     * Advanced users can provide a customized matrix in string.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.def.filter.ColorMatrixValue.AllToWhite`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColorMatrix(
      /**
       * New value for property `colorMatrix`
       */
      sColorMatrix?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOperator operator}.
     *
     * Atrribute of SVG tag 'feMorphology'. Possible values are in {@link sap.gantt.def.filter.MorphologyOperator}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.def.filter.MorphologyOperator.Dilate`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOperator(
      /**
       * New value for property `operator`
       */
      sOperator?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRadius radius}.
     *
     * Attribute of SVG tag 'feMorphology'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"2,1"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius(
      /**
       * New value for property `radius`
       */
      sRadius?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the MorphologyFilter constructor.
   */
  export interface $MorphologyFilterSettings extends $DefBaseSettings {
    /**
     * Atrribute of SVG tag 'feMorphology'. Possible values are in {@link sap.gantt.def.filter.MorphologyOperator}.
     */
    operator?: string | PropertyBindingInfo;

    /**
     * Attribute of SVG tag 'feMorphology'.
     */
    radius?: string | PropertyBindingInfo;

    /**
     * Attribute of SVG tag 'feColorMatrix'. Predefined values are in {@link sap.gantt.def.filter.ColorMatrixValue}.
     * Advanced users can provide a customized matrix in string.
     */
    colorMatrix?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/def/gradient/LinearGradient" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import Stop from "sap/gantt/def/gradient/Stop";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Linear gradient defined by SVG tag 'linearGradient'.
   */
  export default class LinearGradient extends DefBase {
    /**
     * Creates and initializes a linear gradient defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinearGradientSettings
    );
    /**
     * Creates and initializes a linear gradient defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LinearGradientSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.gradient.LinearGradient with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LinearGradient>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.gradient.LinearGradient.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some stop to the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addStop(
      /**
       * The stop to add; if empty, nothing is inserted
       */
      oStop: Stop
    ): this;
    /**
     * Destroys all the stops in the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyStops(): this;
    /**
     * Gets content of aggregation {@link #getStops stops}.
     *
     * 'stop' elements in the 'linearGradient' element.
     */
    getStops(): Stop[];
    /**
     * Gets current value of property {@link #getX1 x1}.
     *
     * Attribute 'x1' of SVG tag 'linearGradient'.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `x1`
     */
    getX1(): string;
    /**
     * Gets current value of property {@link #getX2 x2}.
     *
     * Attribute 'x2' of SVG tag 'linearGradient'.
     *
     * Default value is `"100"`.
     *
     *
     * @returns Value of property `x2`
     */
    getX2(): string;
    /**
     * Gets current value of property {@link #getY1 y1}.
     *
     * Attribute 'y1' of SVG tag 'linearGradient'.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Value of property `y1`
     */
    getY1(): string;
    /**
     * Gets current value of property {@link #getY2 y2}.
     *
     * Attribute 'y2' of SVG tag 'linearGradient'.
     *
     * Default value is `"15"`.
     *
     *
     * @returns Value of property `y2`
     */
    getY2(): string;
    /**
     * Checks for the provided `sap.gantt.def.gradient.Stop` in the aggregation {@link #getStops stops}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfStop(
      /**
       * The stop whose index is looked for
       */
      oStop: Stop
    ): int;
    /**
     * Inserts a stop into the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertStop(
      /**
       * The stop to insert; if empty, nothing is inserted
       */
      oStop: Stop,
      /**
       * The `0`-based index the stop should be inserted at; for a negative value of `iIndex`, the stop is inserted
       * at position 0; for a value greater than the current size of the aggregation, the stop is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getStops stops}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllStops(): Stop[];
    /**
     * Removes a stop from the aggregation {@link #getStops stops}.
     *
     *
     * @returns The removed stop or `null`
     */
    removeStop(
      /**
       * The stop to remove or its index or id
       */
      vStop: int | string | Stop
    ): Stop | null;
    /**
     * Sets a new value for property {@link #getX1 x1}.
     *
     * Attribute 'x1' of SVG tag 'linearGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX1(
      /**
       * New value for property `x1`
       */
      sX1?: string
    ): this;
    /**
     * Sets a new value for property {@link #getX2 x2}.
     *
     * Attribute 'x2' of SVG tag 'linearGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX2(
      /**
       * New value for property `x2`
       */
      sX2?: string
    ): this;
    /**
     * Sets a new value for property {@link #getY1 y1}.
     *
     * Attribute 'y1' of SVG tag 'linearGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY1(
      /**
       * New value for property `y1`
       */
      sY1?: string
    ): this;
    /**
     * Sets a new value for property {@link #getY2 y2}.
     *
     * Attribute 'y2' of SVG tag 'linearGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"15"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY2(
      /**
       * New value for property `y2`
       */
      sY2?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LinearGradient constructor.
   */
  export interface $LinearGradientSettings extends $DefBaseSettings {
    /**
     * Attribute 'x1' of SVG tag 'linearGradient'.
     */
    x1?: string | PropertyBindingInfo;

    /**
     * Attribute 'y1' of SVG tag 'linearGradient'.
     */
    y1?: string | PropertyBindingInfo;

    /**
     * Attribute 'x2' of SVG tag 'linearGradient'.
     */
    x2?: string | PropertyBindingInfo;

    /**
     * Attribute 'y2' of SVG tag 'linearGradient'.
     */
    y2?: string | PropertyBindingInfo;

    /**
     * 'stop' elements in the 'linearGradient' element.
     */
    stops?: Stop[] | Stop | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/gradient/RadialGradient" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import Stop from "sap/gantt/def/gradient/Stop";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Radial gradient defined by SVG tag 'radialGradient'.
   */
  export default class RadialGradient extends DefBase {
    /**
     * Creates and initializes a radial gradient defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RadialGradientSettings
    );
    /**
     * Creates and initializes a radial gradient defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RadialGradientSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.gradient.RadialGradient with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, RadialGradient>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.gradient.RadialGradient.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some stop to the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addStop(
      /**
       * The stop to add; if empty, nothing is inserted
       */
      oStop: Stop
    ): this;
    /**
     * Destroys all the stops in the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyStops(): this;
    /**
     * Gets current value of property {@link #getCx cx}.
     *
     * Attribute 'cx' of SVG tag 'radialGradient'.
     *
     * Default value is `400`.
     *
     *
     * @returns Value of property `cx`
     */
    getCx(): float;
    /**
     * Gets current value of property {@link #getCy cy}.
     *
     * Attribute 'cy' of SVG tag 'radialGradient'.
     *
     * Default value is `200`.
     *
     *
     * @returns Value of property `cy`
     */
    getCy(): float;
    /**
     * Gets current value of property {@link #getFx fx}.
     *
     * Attribute 'fx' of SVG tag 'radialGradient'.
     *
     * Default value is `400`.
     *
     *
     * @returns Value of property `fx`
     */
    getFx(): float;
    /**
     * Gets current value of property {@link #getFy fy}.
     *
     * Attribute 'fy' of SVG tag 'radialGradient'.
     *
     * Default value is `200`.
     *
     *
     * @returns Value of property `fy`
     */
    getFy(): float;
    /**
     * Gets current value of property {@link #getR r}.
     *
     * Attribute 'r' of SVG tag 'radialGradient'.
     *
     * Default value is `300`.
     *
     *
     * @returns Value of property `r`
     */
    getR(): float;
    /**
     * Gets content of aggregation {@link #getStops stops}.
     *
     * 'stop' elements in the 'radialGradient' element.
     */
    getStops(): Stop[];
    /**
     * Checks for the provided `sap.gantt.def.gradient.Stop` in the aggregation {@link #getStops stops}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfStop(
      /**
       * The stop whose index is looked for
       */
      oStop: Stop
    ): int;
    /**
     * Inserts a stop into the aggregation {@link #getStops stops}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertStop(
      /**
       * The stop to insert; if empty, nothing is inserted
       */
      oStop: Stop,
      /**
       * The `0`-based index the stop should be inserted at; for a negative value of `iIndex`, the stop is inserted
       * at position 0; for a value greater than the current size of the aggregation, the stop is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getStops stops}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllStops(): Stop[];
    /**
     * Removes a stop from the aggregation {@link #getStops stops}.
     *
     *
     * @returns The removed stop or `null`
     */
    removeStop(
      /**
       * The stop to remove or its index or id
       */
      vStop: int | string | Stop
    ): Stop | null;
    /**
     * Sets a new value for property {@link #getCx cx}.
     *
     * Attribute 'cx' of SVG tag 'radialGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `400`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCx(
      /**
       * New value for property `cx`
       */
      fCx?: float
    ): this;
    /**
     * Sets a new value for property {@link #getCy cy}.
     *
     * Attribute 'cy' of SVG tag 'radialGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `200`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCy(
      /**
       * New value for property `cy`
       */
      fCy?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFx fx}.
     *
     * Attribute 'fx' of SVG tag 'radialGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `400`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFx(
      /**
       * New value for property `fx`
       */
      fFx?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFy fy}.
     *
     * Attribute 'fy' of SVG tag 'radialGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `200`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFy(
      /**
       * New value for property `fy`
       */
      fFy?: float
    ): this;
    /**
     * Sets a new value for property {@link #getR r}.
     *
     * Attribute 'r' of SVG tag 'radialGradient'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `300`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setR(
      /**
       * New value for property `r`
       */
      fR?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the RadialGradient constructor.
   */
  export interface $RadialGradientSettings extends $DefBaseSettings {
    /**
     * Attribute 'cx' of SVG tag 'radialGradient'.
     */
    cx?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Attribute 'cy' of SVG tag 'radialGradient'.
     */
    cy?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Attribute 'r' of SVG tag 'radialGradient'.
     */
    r?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Attribute 'fx' of SVG tag 'radialGradient'.
     */
    fx?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Attribute 'fy' of SVG tag 'radialGradient'.
     */
    fy?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * 'stop' elements in the 'radialGradient' element.
     */
    stops?: Stop[] | Stop | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/gradient/Stop" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Gradient stop defined by SVG tag 'stop'.
   */
  export default class Stop extends DefBase {
    /**
     * Creates and initializes a gradient stop defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $StopSettings
    );
    /**
     * Creates and initializes a gradient stop defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $StopSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.gradient.Stop with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Stop>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.gradient.Stop.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getOffSet offSet}.
     *
     * Attribute 'offset' of SVG tag 'stop'.
     *
     * Default value is `"5%"`.
     *
     *
     * @returns Value of property `offSet`
     */
    getOffSet(): string;
    /**
     * Gets current value of property {@link #getStopColor stopColor}.
     *
     * Property 'stop-color' of SVG tag 'stop'.
     *
     * Default value is `"#FFFFFF"`.
     *
     *
     * @returns Value of property `stopColor`
     */
    getStopColor(): ValueSVGPaintServer;
    /**
     * Sets a new value for property {@link #getOffSet offSet}.
     *
     * Attribute 'offset' of SVG tag 'stop'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"5%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOffSet(
      /**
       * New value for property `offSet`
       */
      sOffSet?: string
    ): this;
    /**
     * Sets a new value for property {@link #getStopColor stopColor}.
     *
     * Property 'stop-color' of SVG tag 'stop'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#FFFFFF"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStopColor(
      /**
       * New value for property `stopColor`
       */
      sStopColor?: ValueSVGPaintServer
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Stop constructor.
   */
  export interface $StopSettings extends $DefBaseSettings {
    /**
     * Attribute 'offset' of SVG tag 'stop'.
     */
    offSet?: string | PropertyBindingInfo;

    /**
     * Property 'stop-color' of SVG tag 'stop'.
     */
    stopColor?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/pattern/BackSlashPattern" {
  import {
    default as PatternBase,
    $PatternBaseSettings,
  } from "sap/gantt/def/pattern/PatternBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Backslash pattern defined by a path. The stroke color and stroke width of the path can be modified with
   * properties.
   *
   *
   *           Tile Detail:       tileHeight tileWidth background Color
   * strokeColor strokeWidth
   */
  export default class BackSlashPattern extends PatternBase {
    /**
     * Creates and initializes a backslash pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BackSlashPatternSettings
    );
    /**
     * Creates and initializes a backslash pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BackSlashPatternSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.pattern.BackSlashPattern with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.pattern.PatternBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BackSlashPattern>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.pattern.BackSlashPattern.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getPath path}.
     *
     * Value of the d attribute in Path element. The value is affected by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the effect is not guaranteed.
     *
     *
     * @returns Value of property `path`
     */
    getPath(): string;
    /**
     * Gets current value of property {@link #getStroke stroke}.
     *
     * Stroke color of the path element.
     *
     *
     * @returns Value of property `stroke`
     */
    getStroke(): ValueSVGPaintServer;
    /**
     * Gets current value of property {@link #getStrokeWidth strokeWidth}.
     *
     * Stroke width of the path element.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `strokeWidth`
     */
    getStrokeWidth(): int;
    /**
     * Sets a new value for property {@link #getPath path}.
     *
     * Value of the d attribute in Path element. The value is affected by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the effect is not guaranteed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPath(
      /**
       * New value for property `path`
       */
      sPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * Stroke color of the path element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * Stroke width of the path element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      iStrokeWidth?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BackSlashPattern constructor.
   */
  export interface $BackSlashPatternSettings extends $PatternBaseSettings {
    /**
     * Value of the d attribute in Path element. The value is affected by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the effect is not guaranteed.
     */
    path?: string | PropertyBindingInfo;

    /**
     * Stroke color of the path element.
     */
    stroke?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    /**
     * Stroke width of the path element.
     */
    strokeWidth?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/pattern/PatternBase" {
  import { default as DefBase, $DefBaseSettings } from "sap/gantt/def/DefBase";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for SVG pattern definitions.
   *
   *  Pattern is a built-in paint server in SVG. It provides tile-based patterns to the SVG 'fill' or 'stroke'
   * attributes.
   */
  export default class PatternBase extends DefBase {
    /**
     * Creates and initializes a new SVG pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PatternBaseSettings
    );
    /**
     * Creates and initializes a new SVG pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PatternBaseSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.pattern.PatternBase with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.DefBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, PatternBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.pattern.PatternBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of the pattern. Technically a rectangle with the color is added in the beginning of
     * the pattern definition.
     *
     * Default value is `"#fff"`.
     *
     *
     * @returns Value of property `backgroundColor`
     */
    getBackgroundColor(): ValueSVGPaintServer;
    /**
     * Gets current value of property {@link #getBackgroundFillOpacity backgroundFillOpacity}.
     *
     * Fill opacity of background color.
     *
     * Default value is `"1"`.
     *
     *
     * @returns Value of property `backgroundFillOpacity`
     */
    getBackgroundFillOpacity(): float;
    /**
     * Gets current value of property {@link #getTileHeight tileHeight}.
     *
     * Height of the pattern tile.
     *
     * Default value is `8`.
     *
     *
     * @returns Value of property `tileHeight`
     */
    getTileHeight(): int;
    /**
     * Gets current value of property {@link #getTileWidth tileWidth}.
     *
     * Width of the pattern tile.
     *
     * Default value is `8`.
     *
     *
     * @returns Value of property `tileWidth`
     */
    getTileWidth(): int;
    /**
     * Sets a new value for property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of the pattern. Technically a rectangle with the color is added in the beginning of
     * the pattern definition.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#fff"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundColor(
      /**
       * New value for property `backgroundColor`
       */
      sBackgroundColor?: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundFillOpacity backgroundFillOpacity}.
     *
     * Fill opacity of background color.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"1"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundFillOpacity(
      /**
       * New value for property `backgroundFillOpacity`
       */
      fBackgroundFillOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTileHeight tileHeight}.
     *
     * Height of the pattern tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `8`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileHeight(
      /**
       * New value for property `tileHeight`
       */
      iTileHeight?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTileWidth tileWidth}.
     *
     * Width of the pattern tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `8`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTileWidth(
      /**
       * New value for property `tileWidth`
       */
      iTileWidth?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the PatternBase constructor.
   */
  export interface $PatternBaseSettings extends $DefBaseSettings {
    /**
     * Width of the pattern tile.
     */
    tileWidth?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the pattern tile.
     */
    tileHeight?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Background color of the pattern. Technically a rectangle with the color is added in the beginning of
     * the pattern definition.
     */
    backgroundColor?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    /**
     * Fill opacity of background color.
     */
    backgroundFillOpacity?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/pattern/SlashPattern" {
  import {
    default as PatternBase,
    $PatternBaseSettings,
  } from "sap/gantt/def/pattern/PatternBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Slash pattern defined by a path. Stroke color and stroke width of the path can be changed by corresponding
   * properties.
   *
   *
   *           Tile Detail:       tileHeight tileWidth background Color strokeColor strokeWidth
   */
  export default abstract class SlashPattern extends PatternBase {
    /**
     * Creates and initializes a slash pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SlashPatternSettings
    );
    /**
     * Creates and initializes a slash pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SlashPatternSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.pattern.SlashPattern with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.def.pattern.PatternBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SlashPattern>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.pattern.SlashPattern.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getPath path}.
     *
     * Value of d attribute in Path element. The value is influenced by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the logic cannot be guaranteed.
     *
     *
     * @returns Value of property `path`
     */
    getPath(): string;
    /**
     * Gets current value of property {@link #getStroke stroke}.
     *
     * Stroke color of the path element.
     *
     *
     * @returns Value of property `stroke`
     */
    getStroke(): ValueSVGPaintServer;
    /**
     * Gets current value of property {@link #getStrokeWidth strokeWidth}.
     *
     * Stroke width of the path element.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `strokeWidth`
     */
    getStrokeWidth(): int;
    /**
     * Sets a new value for property {@link #getPath path}.
     *
     * Value of d attribute in Path element. The value is influenced by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the logic cannot be guaranteed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPath(
      /**
       * New value for property `path`
       */
      sPath?: string
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * Stroke color of the path element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * Stroke width of the path element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      iStrokeWidth?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SlashPattern constructor.
   */
  export interface $SlashPatternSettings extends $PatternBaseSettings {
    /**
     * Value of d attribute in Path element. The value is influenced by property `tileWidth` and `tileHeight`.
     * If this value is changed by coding, the logic cannot be guaranteed.
     */
    path?: string | PropertyBindingInfo;

    /**
     * Stroke color of the path element.
     */
    stroke?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    /**
     * Stroke width of the path element.
     */
    strokeWidth?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/def/SvgDefs" {
  import {
    default as ManagedObject,
    AggregationBindingInfo,
    $ManagedObjectSettings,
  } from "sap/ui/base/ManagedObject";

  import DefBase from "sap/gantt/def/DefBase";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  /**
   * The class handles the container tag "defs" for all reusable SVG graphic definitions. It provides interfaces
   * for SVG definition strings and referencing strings. The parent class is responsible for rendering the
   * definition strings.
   *
   *  SVG uses the 'defs' tag to represent graphic objects that are defined for reuse at a later time.
   * Currently `sap.gantt` provides defs including the following definition tags: 'pattern', 'gradient', and
   * 'filter'. Applications can also extend this base class to support more functionality.
   */
  export default class SvgDefs extends ManagedObject {
    /**
     * SVG definition tag class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SvgDefsSettings
    );
    /**
     * SVG definition tag class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SvgDefsSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.def.SvgDefs with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SvgDefs>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.def.SvgDefs.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Adds some def to the aggregation {@link #getDefs defs}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addDef(
      /**
       * The def to add; if empty, nothing is inserted
       */
      oDef: DefBase
    ): this;
    /**
     * Binds aggregation {@link #getDefs defs} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDefs(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the defs in the aggregation {@link #getDefs defs}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyDefs(): this;
    /**
     * Gets content of aggregation {@link #getDefs defs}.
     *
     * SVG definition instances.
     */
    getDefs(): DefBase[];
    /**
     * Definition string of the SVG 'defs' tag.
     *
     *
     * @returns - Definition string to be rendered by caller.
     */
    getDefString(): string;
    /**
     * Checks for the provided `sap.gantt.def.DefBase` in the aggregation {@link #getDefs defs}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfDef(
      /**
       * The def whose index is looked for
       */
      oDef: DefBase
    ): int;
    /**
     * Inserts a def into the aggregation {@link #getDefs defs}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertDef(
      /**
       * The def to insert; if empty, nothing is inserted
       */
      oDef: DefBase,
      /**
       * The `0`-based index the def should be inserted at; for a negative value of `iIndex`, the def is inserted
       * at position 0; for a value greater than the current size of the aggregation, the def is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getDefs defs}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllDefs(): DefBase[];
    /**
     * Removes a def from the aggregation {@link #getDefs defs}.
     *
     *
     * @returns The removed def or `null`
     */
    removeDef(
      /**
       * The def to remove or its index or id
       */
      vDef: int | string | DefBase
    ): DefBase | null;
    /**
     * Unbinds aggregation {@link #getDefs defs} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDefs(): this;
  }
  /**
   * Describes the settings that can be provided to the SvgDefs constructor.
   */
  export interface $SvgDefsSettings extends $ManagedObjectSettings {
    /**
     * SVG definition instances.
     */
    defs?: DefBase[] | DefBase | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/GanttChart" {
  import {
    default as GanttChartBase,
    $GanttChartBaseSettings,
  } from "sap/gantt/GanttChartBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Gantt Chart control.
   *
   * The Gantt chart has a horizontal axis at the top that represents time and a vertical axis that represents
   * rows.
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartWithTable} should be used instead.
   */
  export default class GanttChart extends GanttChartBase {
    /**
     * Creates and initializes a new Gantt Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartSettings
    );
    /**
     * Creates and initializes a new Gantt Chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.GanttChart with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.GanttChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.GanttChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * GanttChart will do birdEye on the specified row. The row index starts from 0 and indicates the position
     * in all rows, instead of visible rows
     */
    doBirdEyeOnRow(): void;
    /**
     * Set AxixTimeStrategy aggregation.
     *
     *
     * @returns GanttChart instance for chaining
     */
    setAxisTimeStrategy(
      /**
       * an instance of AxisTime Zoom Strategy
       */
      oAxisTimeStrategy: object
    ): this;
    /**
     * Sets the first visible row in the Gantt Chart Control.
     * See:
     * 	sap.ui.table.Table.setFirstVisibleRow
     *
     * @deprecated (since 1.50.7) - We recommend use setTableProperties function instead
     *
     * @returns A reference to the GanttChart control, which can be used for chaining
     */
    setFirstVisibleRow(
      /**
       * The row index to be set as the first visible row
       */
      iRowIndex: int
    ): GanttChart;
  }
  /**
   * Describes the settings that can be provided to the GanttChart constructor.
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartWithTable} should be used instead.
   */
  export interface $GanttChartSettings extends $GanttChartBaseSettings {}
}

declare module "sap/gantt/GanttChartBase" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import AdhocLine from "sap/gantt/AdhocLine";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import AxisOrdinal from "sap/gantt/misc/AxisOrdinal";

  import AxisTime from "sap/gantt/misc/AxisTime";

  import AxisTimeStrategyBase from "sap/gantt/axistime/AxisTimeStrategyBase";

  import CalendarDefs from "sap/gantt/def/cal/CalendarDefs";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { SelectionMode, GenericArray } from "sap/gantt/library";

  import GanttChart from "sap/gantt/GanttChart";

  import GanttChartWithTable from "sap/gantt/GanttChartWithTable";

  import Event from "sap/ui/base/Event";

  /**
   * Base class for all Gantt charts.
   *
   * This base class defines:
   * 	 - Basic properties and aggregations.
   * 	 - Metadata required integrate with GanttChartContainer.  sap.gantt provides two basic implementations
   *     of `GanttChartBase`:
   * 	 - `sap.gantt.GanttChart` - A chart area that contains rows along the vertical axis and a time scale
   *     along the horizontal axis.
   * 	 - `sap.gantt.GanttChartWithTable` - A tree table and a chart area separated by a splitter with rows
   *     synchronized.
   *
   * A number of `get` and `select` functions in this class use the row ID, row UI ID (UID), shape ID,
   * or shape UID as the input to identify the objects to select or retrieve.
   *
   * A row UID comprises the following parts:
   * 	 - Row ID: Identifier of a specific row. In most cases, this ID is specified in your data model, for
   *     example: 0001. The system generates a random ID for a row if you do not specify the row ID.
   * 	 - Row path: Represents the ID hierarchy in a tree structure. For example, if a tree has a three-level
   *     hierarchy, the row path follows this pattern: Level_1_row_id|level_2_row_id|level_3_row_id
   * 	 - Scheme: Chart scheme which is configured in shape configuration. The scheme controls what kind of
   *     shapes are shown in a row.  Row UID pattern: PATH:row_id|SCHEME:chart_scheme_key[index]
   *
   * A shape UID comprises the following parts:
   * 	 - Row UID: UID of the row where the shape is located.
   * 	 - Shape data name: Key of the shape in the data model. For example: DATA:activity_greedy
   * 	 - Shape ID: Identifier of a specific shape. In most cases, this ID is specified in your data model.
   *     The system generates a random ID for a shape if you do not specify the shape ID.  Row UID pattern:
   *     PATH:row_id|SCHEME:chart_scheme_key[index]|DATA:shape_data_name[shape_id]
   *
   * Note that you do not need to specify the UID for a shape or row. Gantt Chart automatically forms the
   * UIDs for shapes or rows.
   *
   * @deprecated (since 1.64)
   */
  export default abstract class GanttChartBase extends Control {
    /**
     * Creates and initializes a new Gantt chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartBaseSettings
    );
    /**
     * Creates and initializes a new Gantt chart.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartBaseSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.GanttChartBase with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttChartBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.GanttChartBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some adhocLine to the aggregation {@link #getAdhocLines adhocLines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAdhocLine(
      /**
       * The adhocLine to add; if empty, nothing is inserted
       */
      oAdhocLine: AdhocLine
    ): this;
    /**
     * Adds some relationship to the aggregation {@link #getRelationships relationships}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addRelationship(
      /**
       * The relationship to add; if empty, nothing is inserted
       */
      oRelationship: Control
    ): this;
    /**
     * Adds some row to the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addRow(
      /**
       * The row to add; if empty, nothing is inserted
       */
      oRow: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartClick chartClick} event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartClick chartClick} event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDoubleClick chartDoubleClick} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is double-clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDoubleClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDoubleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDoubleClick chartDoubleClick} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is double-clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDoubleClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDoubleClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDragEnter chartDragEnter} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDragEnter(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDragEnter chartDragEnter} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDragEnter(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDragLeave chartDragLeave} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDragLeave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartDragLeave chartDragLeave} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartDragLeave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartMouseOver chartMouseOver} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event is fired when a mouse-hover occurs in the graphic part.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartMouseOver(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartMouseOverEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartMouseOver chartMouseOver} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event is fired when a mouse-hover occurs in the graphic part.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartMouseOver(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartMouseOverEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartRightClick chartRightClick} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is right-clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartRightClick(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartRightClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:chartRightClick chartRightClick} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the chart is right-clicked
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChartRightClick(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartRightClickEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ganttChartSwitchRequested ganttChartSwitchRequested }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the hierarchy key has changed in the Gantt chart toolbar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachGanttChartSwitchRequested(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$GanttChartSwitchRequestedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ganttChartSwitchRequested ganttChartSwitchRequested }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the hierarchy key has changed in the Gantt chart toolbar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachGanttChartSwitchRequested(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$GanttChartSwitchRequestedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:horizontalScroll horizontalScroll} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Horizontal (time axis) scroll.
     *
     * If the horizontal scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHorizontalScroll(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$HorizontalScrollEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:horizontalScroll horizontalScroll} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Horizontal (time axis) scroll.
     *
     * If the horizontal scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachHorizontalScroll(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$HorizontalScrollEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:relationshipSelectionChange relationshipSelectionChange }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of relationships changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRelationshipSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RelationshipSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:relationshipSelectionChange relationshipSelectionChange }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of relationships changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRelationshipSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RelationshipSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rowSelectionChange rowSelectionChange} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of rows changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRowSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RowSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:rowSelectionChange rowSelectionChange} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of rows changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachRowSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RowSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeDragEnd shapeDragEnd} event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when a drag-and-drop occurs on one or more selected shapes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeDragEnd(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeDragEndEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeDragEnd shapeDragEnd} event of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when a drag-and-drop occurs on one or more selected shapes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeDragEnd(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeDragEndEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeMouseEnter shapeMouseEnter} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You hover the mouse on a shape and keep the mouse stationary for 500 millisecond or longer.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeMouseEnter(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeMouseEnter shapeMouseEnter} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You hover the mouse on a shape and keep the mouse stationary for 500 millisecond or longer.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeMouseEnter(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseEnterEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeMouseLeave shapeMouseLeave} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You move the mouse out of a shape and keep the mouse stationary for 500 millisecond or longer.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeMouseLeave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeMouseLeave shapeMouseLeave} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You move the mouse out of a shape and keep the mouse stationary for 500 millisecond or longer.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeMouseLeave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseLeaveEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeResizeEnd shapeResizeEnd} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when a resizing occurs on a resized shape.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeResizeEnd(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeResizeEndEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeResizeEnd shapeResizeEnd} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when a resizing occurs on a resized shape.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeResizeEnd(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeResizeEndEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeSelectionChange shapeSelectionChange} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of shapes changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:shapeSelectionChange shapeSelectionChange} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when the selection status of shapes changes.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachShapeSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeSelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:splitterResize splitterResize} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Splitter (if exists) resized.
     *
     * If a splitter exists and synchronization is needed with other Gantt charts in the container, use this
     * event. You can listen for this event and obtain `zoomInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSplitterResize(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$SplitterResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:splitterResize splitterResize} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Splitter (if exists) resized.
     *
     * If a splitter exists and synchronization is needed with other Gantt charts in the container, use this
     * event. You can listen for this event and obtain `zoomInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSplitterResize(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$SplitterResizeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:treeTableToggleEvent treeTableToggleEvent} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when toggle node of the tree table.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTreeTableToggleEvent(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$TreeTableToggleEventEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:treeTableToggleEvent treeTableToggleEvent} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Event fired when toggle node of the tree table.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTreeTableToggleEvent(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$TreeTableToggleEventEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:verticalScroll verticalScroll} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Vertical (row axis) scroll.
     *
     * If the vertical scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVerticalScroll(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$VerticalScrollEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:verticalScroll verticalScroll} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartBase` itself.
     *
     * Vertical (row axis) scroll.
     *
     * If the vertical scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachVerticalScroll(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartBase$VerticalScrollEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getAdhocLines adhocLines} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindAdhocLines(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getAxisTimeStrategy axisTimeStrategy} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindAxisTimeStrategy(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getCalendarDef calendarDef} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindCalendarDef(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getRelationships relationships} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRelationships(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getRows rows} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindRows(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Deselects a group of relationships specified by the aId array.
     *
     *
     * @returns Gantt Chart instance
     */
    deselectRelationships(
      /**
       * List of IDs of the relationships to deselect
       */
      aId?: any[]
    ): this;
    /**
     * Deselects a group of rows specified by the aId array.
     *
     *
     * @returns Gantt Chart instance
     */
    deselectRows(
      /**
       * List of the rows that you want to deselect
       */
      aId?: any[]
    ): this;
    /**
     * Deselects a group of shapes specified by the aId array.
     *
     *
     * @returns Gantt Chart instance
     */
    deselectShapes(
      /**
       * List of IDs of the shapes to deselect
       */
      aId?: any[]
    ): this;
    /**
     * Destroys all the adhocLines in the aggregation {@link #getAdhocLines adhocLines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAdhocLines(): this;
    /**
     * Destroys the axisTimeStrategy in the aggregation {@link #getAxisTimeStrategy axisTimeStrategy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAxisTimeStrategy(): this;
    /**
     * Destroys the calendarDef in the aggregation {@link #getCalendarDef calendarDef}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCalendarDef(): this;
    /**
     * Destroys all the relationships in the aggregation {@link #getRelationships relationships}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRelationships(): this;
    /**
     * Destroys all the rows in the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyRows(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartClick chartClick} event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartDoubleClick chartDoubleClick} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartDoubleClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDoubleClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartDragEnter chartDragEnter} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartDragEnter(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragEnterEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartDragLeave chartDragLeave} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartDragLeave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartDragLeaveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartMouseOver chartMouseOver} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartMouseOver(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartMouseOverEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:chartRightClick chartRightClick} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChartRightClick(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ChartRightClickEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:ganttChartSwitchRequested ganttChartSwitchRequested }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachGanttChartSwitchRequested(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$GanttChartSwitchRequestedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:horizontalScroll horizontalScroll} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachHorizontalScroll(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$HorizontalScrollEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:relationshipSelectionChange relationshipSelectionChange }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRelationshipSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RelationshipSelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:rowSelectionChange rowSelectionChange} event
     * of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachRowSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$RowSelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:shapeDragEnd shapeDragEnd} event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShapeDragEnd(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeDragEndEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:shapeMouseEnter shapeMouseEnter} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShapeMouseEnter(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseEnterEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:shapeMouseLeave shapeMouseLeave} event of
     * this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShapeMouseLeave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeMouseLeaveEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:shapeResizeEnd shapeResizeEnd} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShapeResizeEnd(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeResizeEndEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:shapeSelectionChange shapeSelectionChange }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachShapeSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$ShapeSelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:splitterResize splitterResize} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSplitterResize(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$SplitterResizeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:treeTableToggleEvent treeTableToggleEvent }
     * event of this `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTreeTableToggleEvent(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$TreeTableToggleEventEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:verticalScroll verticalScroll} event of this
     * `sap.gantt.GanttChartBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated (since 1.44)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachVerticalScroll(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartBase$VerticalScrollEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Expands the Gantt chart to the given level.
     * See:
     * 	sap.ui.table.TreeTable.expandToLevel
     *
     *
     * @returns Reference to the GanttChart control, which can be used for chaining
     */
    expandToLevel(
      /**
       * Level to be expanded to
       */
      iLevel: int
    ): this;
    /**
     * Fires event {@link #event:chartClick chartClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartDoubleClick chartDoubleClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartDoubleClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartDoubleClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartDragEnter chartDragEnter} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartDragEnter(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartDragEnterEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartDragLeave chartDragLeave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartDragLeave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartDragLeaveEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartMouseOver chartMouseOver} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartMouseOver(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartMouseOverEventParameters
    ): this;
    /**
     * Fires event {@link #event:chartRightClick chartRightClick} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChartRightClick(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ChartRightClickEventParameters
    ): this;
    /**
     * Fires event {@link #event:ganttChartSwitchRequested ganttChartSwitchRequested} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireGanttChartSwitchRequested(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$GanttChartSwitchRequestedEventParameters
    ): this;
    /**
     * Fires event {@link #event:horizontalScroll horizontalScroll} to attached listeners.
     *
     * @deprecated (since 1.44)
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireHorizontalScroll(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$HorizontalScrollEventParameters
    ): this;
    /**
     * Fires event {@link #event:relationshipSelectionChange relationshipSelectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRelationshipSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$RelationshipSelectionChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:rowSelectionChange rowSelectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireRowSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$RowSelectionChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:shapeDragEnd shapeDragEnd} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShapeDragEnd(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ShapeDragEndEventParameters
    ): this;
    /**
     * Fires event {@link #event:shapeMouseEnter shapeMouseEnter} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShapeMouseEnter(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ShapeMouseEnterEventParameters
    ): this;
    /**
     * Fires event {@link #event:shapeMouseLeave shapeMouseLeave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShapeMouseLeave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ShapeMouseLeaveEventParameters
    ): this;
    /**
     * Fires event {@link #event:shapeResizeEnd shapeResizeEnd} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShapeResizeEnd(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ShapeResizeEndEventParameters
    ): this;
    /**
     * Fires event {@link #event:shapeSelectionChange shapeSelectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireShapeSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$ShapeSelectionChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:splitterResize splitterResize} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSplitterResize(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$SplitterResizeEventParameters
    ): this;
    /**
     * Fires event {@link #event:treeTableToggleEvent treeTableToggleEvent} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTreeTableToggleEvent(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$TreeTableToggleEventEventParameters
    ): this;
    /**
     * Fires event {@link #event:verticalScroll verticalScroll} to attached listeners.
     *
     * @deprecated (since 1.44)
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireVerticalScroll(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartBase$VerticalScrollEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAdhocLineLayer adhocLineLayer}.
     *
     * Specifies on which layer adhoc lines reside. By default, adhoc lines are on top of all other shapes and
     * patterns.
     *
     * Default value is `library.AdhocLineLayer.Top`.
     *
     *
     * @returns Value of property `adhocLineLayer`
     */
    getAdhocLineLayer(): string;
    /**
     * Gets content of aggregation {@link #getAdhocLines adhocLines}.
     *
     * The aggregation is used to store configuration of adhoc lines, adhoc lines represent milestones and events
     * in axis time.
     */
    getAdhocLines(): AdhocLine[];
    /**
     * Gets the selected rows, shapes, and relationships.
     *
     *
     * @returns The returned object contains row data for all selected rows, shape data for all selected shapes,
     * and relationship data for all selected relationships.
     */
    getAllSelections(): object;
    /**
     * Provides the Ordinal Axis that is used to draw the SVG graphic.
     *
     * This method is intended to allow access to the ordinal axis. Do not change the ordinal axis. All subclasses
     * must provide implementations.
     *
     *
     * @returns Returns the axis ordinal instance.
     */
    getAxisOrdinal(): AxisOrdinal;
    /**
     * Provides the Time Axis that is used to draw the SVG graphic.
     *
     * This method is intended to allow access to the time axis. Do not change the time axis. All subclasses
     * must provide implementations.
     *
     *
     * @returns Returns the axis time instance.
     */
    getAxisTime(): AxisTime;
    /**
     * Gets content of aggregation {@link #getAxisTimeStrategy axisTimeStrategy}.
     *
     * This aggregation controls the zoom strategies and zoom rate in Gantt Chart.
     */
    getAxisTimeStrategy(): AxisTimeStrategyBase;
    /**
     * Gets current value of property {@link #getBaseRowHeight baseRowHeight}.
     *
     * row height of Gantt Chart. If this property is set, then it will change the Table row height on the left
     *
     *
     * @returns Value of property `baseRowHeight`
     */
    getBaseRowHeight(): int;
    /**
     * Gets content of aggregation {@link #getCalendarDef calendarDef}.
     *
     * Paint servers consumed by special shape `sap.gantt.shape.cal.Calendar`.
     *
     * This aggregation is designed to improve performance of calendar shapes. Rows usually share a similar
     * definition with calendar shapes. It is possible to define a Calendar paint server to draw only one rectangle
     * for each row. Notes for classes extended from `sap.gantt.def.cal.CalendarDef`: Different from property
     * `paintServerDefs`, paint servers defined here must implement method `getDefNode()` instead of method
     * `getDefString()`.
     */
    getCalendarDef(): CalendarDefs;
    /**
     * Gets current value of property {@link #getChartSchemes chartSchemes}.
     *
     * Configuration of chart schemes.
     *
     * List of available chart schemes. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ChartScheme[]`. Otherwise some properties you
     * set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_CHART_SCHEMES`.
     *
     *
     * @returns Value of property `chartSchemes`
     */
    getChartSchemes(): object[];
    /**
     * Gets current value of property {@link #getEnableAdhocLine enableAdhocLine}.
     *
     * Switch to show and hide adhoc lines representing milestones and events along the time axis
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableAdhocLine`
     */
    getEnableAdhocLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableCursorLine enableCursorLine}.
     *
     * Switch to show and hide the cursor line that follows the cursor.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableCursorLine`
     */
    getEnableCursorLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableNowLine enableNowLine}.
     *
     * Switch to show and hide the present time indicator
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableNowLine`
     */
    getEnableNowLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableShapeTimeDisplay enableShapeTimeDisplay}.
     *
     * Switch to show or hide the start time and end time of a shape when you drag it along the time line
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableShapeTimeDisplay`
     */
    getEnableShapeTimeDisplay(): boolean;
    /**
     * Gets current value of property {@link #getEnableVerticalLine enableVerticalLine}.
     *
     * Switch to show and hide vertical lines representing intervals along the time axis
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableVerticalLine`
     */
    getEnableVerticalLine(): boolean;
    /**
     * Gets current value of property {@link #getGhostAlignment ghostAlignment}.
     *
     * Defines how to adjust the relative position between a draggable shape and the mouse pointer.
     *
     * Default value is `library.dragdrop.GhostAlignment.None`.
     *
     *
     * @returns Value of property `ghostAlignment`
     */
    getGhostAlignment(): string;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the control.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHierarchies hierarchies}.
     *
     * Configuration of hierarchies.
     *
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_HIERARCHYS`.
     *
     *
     * @returns Value of property `hierarchies`
     */
    getHierarchies(): object[];
    /**
     * Gets current value of property {@link #getHierarchyKey hierarchyKey}.
     *
     * Current hierarchy key referencing from configuration property `hierarchies`.
     *
     * If `source select group` is enabled in the Gantt chart toolbar, the current hierarchy name referenced
     * from `hierarchies` by this property is shown. For applications that do not require this function, this
     * property can be ignored and a default value is used.
     *
     * Default value is `library.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Value of property `hierarchyKey`
     */
    getHierarchyKey(): string;
    /**
     * Gets current value of property {@link #getLocale locale}.
     *
     * Configuration of locale settings.
     *
     * Most locale settings can be configured in sap.ui.configuration objects. Only the time zone and day-light-saving
     * time option are provided by locale settings. We recommend that you set the type of this argument to `sap.gantt.config.Locale`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_LOCALE`.
     *
     *
     * @returns Value of property `locale`
     */
    getLocale(): object;
    /**
     * Gets current value of property {@link #getMode mode}.
     *
     * Current mode of the Gantt chart.
     *
     * If no value is provided, GanttChart uses a default mode key.
     *
     * Default value is `library.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Value of property `mode`
     */
    getMode(): string;
    /**
     * Gets current value of property {@link #getModes modes}.
     *
     * Configuration of available modes.
     *
     * List of available modes. To apply modes to toolbar and shapes, further configuration is needed. If not
     * provided, a default configuration is provided. We recommend that you set the type of this argument to
     * `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_MODES`.
     *
     *
     * @returns Value of property `modes`
     */
    getModes(): object[];
    /**
     * Gets current value of property {@link #getNowLineInUTC nowLineInUTC}.
     *
     * Flag whether to show the `nowLine` in UTC or in local time.
     *
     * Default value is `true`.
     *
     * @since 1.68
     *
     * @returns Value of property `nowLineInUTC`
     */
    getNowLineInUTC(): boolean;
    /**
     * Gets current value of property {@link #getObjectTypes objectTypes}.
     *
     * Configuration of object types.
     *
     * List of available object types. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ObjectType[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_OBJECT_TYPES`.
     *
     *
     * @returns Value of property `objectTypes`
     */
    getObjectTypes(): object[];
    /**
     * Gets content of aggregation {@link #getRelationships relationships}.
     *
     * Relationships of shapes carried by rows.
     *
     * Similar to rows, this aggregation does not request templates either. Relationships are a special shape
     * with a category of `"crossRowShape"`. How relationships are drawn is also specified in configuration
     * property `shapes`.
     */
    getRelationships(): Control[];
    /**
     * Gets a row object by the corresponding shape UID.
     *
     *
     * @returns Row object
     */
    getRowByShapeUid(
      /**
       * Shape UID
       */
      sShapeUid?: string
    ): object;
    /**
     * Gets content of aggregation {@link #getRows rows}.
     *
     * Rows of `sap.gantt.GanttChartBase`
     *
     * This aggregation is delegated to `sap.gantt.table.TreeTable`. Rows are provide a base for shapes with
     * a category of `"InRowShape"`. The configuration in property `shapes` determines how the shapes are drawn.
     */
    getRows(): Control[];
    /**
     * Gets all the selected relationships.
     *
     *
     * @returns selected relationships
     */
    getSelectedRelationships(): any[];
    /**
     * Gets the selected rows.
     *
     *
     * @returns Row data of the selected rows
     */
    getSelectedRows(): any[];
    /**
     * Gets the shape data of the selected shapes.
     *
     *
     * @returns Selected shapes. The returned structure is shown as below. { "shapeDataName1": [oShapeData1,
     * oShapeData2, ...] "shapeDataName2": [oShapeData3, oShapeData3, ...] ... }
     */
    getSelectedShapes(): any[];
    /**
     * Gets current value of property {@link #getSelectionMode selectionMode}.
     *
     * Selection mode for GanttChart
     *
     * This property controls whether multiToggle or multi-selection mode is enabled for the tree table and
     * for shapes. It may also affect the visual appearance, such as whether check boxes are available for selection.
     * From version 1.40 to upper versions, multi is replaced by multiToggle selection mode in tree table
     *
     * Default value is `MultiWithKeyboard`.
     *
     * @deprecated (since 1.50.7) - Please use `tableProperties`(e.g. `setTableproperties({selectionMode: "None"})`)
     * to control table selection mode, and `shapeSelectionMode`(e.g. `setShapeSelectionMode("None")`) to control
     * shape selection mode.
     *
     * @returns Value of property `selectionMode`
     */
    getSelectionMode(): SelectionMode | keyof typeof SelectionMode;
    /**
     * Gets current value of property {@link #getSelectionPanelSize selectionPanelSize}.
     *
     * This property control the size of the selection panel. The value will be overwritten by property `selectionPanelSize`
     * in `sap.gantt.config.ContainerLayout` if you are using GanttChartContainer
     *
     * In the current library, `sap.gantt.GanttChart` does not have a selection panel. `sap.gantt.GanttChartWithTable`
     * has a selection panel implemented by `sap.ui.table.TreeTable`.
     *
     * Default value is `"30%"`.
     *
     *
     * @returns Value of property `selectionPanelSize`
     */
    getSelectionPanelSize(): CSSSize;
    /**
     * Gets current value of property {@link #getShapeDataNames shapeDataNames}.
     *
     * Configuration of shape data names and the attribute in raw data that serves as 'id'.
     *
     * This property value should be an array, either an array of string, each string represents one available
     * shape data name, or an array of object, each object specifies the shape data name and data attribute
     * that will serves as 'id'. This configuration must be provided if SVG graphics are needed.
     *
     * Example: ` new sap.gantt.GanttChartWithTable({ shapeDataNames: ["task", "order"], shapes: [ new sap.gantt.shape.Shape({
     * key: "calendar", shapeDataName: "task" shapeClassName: "sap.gantt.shape.Rectangle", // ... }) ] // ...
     * }); `
     *
     * or in XMLView ` <GanttChartWithTable shapeDataNames="task,order"> </GanttChartWithTable>
     * `
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `shapeDataNames`
     */
    getShapeDataNames(): GenericArray;
    /**
     * Gets current value of property {@link #getShapes shapes}.
     *
     * Configuration of shape data against shape classes.
     *
     * List of available shapes. The shapes configured in this list are initialized inside `sap.gantt.GanttChartBase`.
     * Note that for JSON data binding, this configuration supports deep structured data structures. For ODATA
     * binding, only one level is supported. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `shapes`
     */
    getShapes(): object[];
    /**
     * Gets current value of property {@link #getShapeSelectionMode shapeSelectionMode}.
     *
     * Selection mode for shape
     *
     * This property controls 4 shape selection modes(MultiWithKeyboard, Multiple, Single, None). You can use
     * `setShapeSelectionMode("None")` to set shape selection mode.
     *
     * Default value is `MultiWithKeyboard`.
     *
     *
     * @returns Value of property `shapeSelectionMode`
     */
    getShapeSelectionMode(): SelectionMode | keyof typeof SelectionMode;
    /**
     * Gets current value of property {@link #getSvgDefs svgDefs}.
     *
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. We recommend that
     * you set the type of this argument to `sap.gantt.def.SvgDefs`. Otherwise some properties you set may not
     * function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     *
     * @returns Value of property `svgDefs`
     */
    getSvgDefs(): object;
    /**
     * Get exposed TreeTable properties
     *
     *
     * @returns The all exposed TreeTable properties
     */
    getTableProperties(): Object;
    /**
     * Gets current value of property {@link #getTimeAxis timeAxis}.
     *
     * Configuration of the time axis.
     *
     * Default value is `library.config.DEFAULT_TIME_AXIS`.
     *
     * @deprecated (since 1.44) - replaced by aggregation 'axisTimeStrategy'. Planning horizon, initial horizon,
     * and zoom level can be configured with this property. If not provided, a default configuration is provided.
     * We recommend that you set the type of this argument to `sap.gantt.config.TimeAxis`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * @returns Value of property `timeAxis`
     */
    getTimeAxis(): object;
    /**
     * Gets current value of property {@link #getTimeZoomRate timeZoomRate}.
     *
     * Zoom level in float.
     *
     * This property allows application developers to control the zoom level. When GanttChart is embedded in
     * `sap.gantt.GanttChartContainer`, you do not have to manage this property.
     *
     * Default value is `1`.
     *
     * @deprecated (since 1.44) - please use sap.gantt.axistime.AxisTimeStrategy to change the zoom rate
     *
     * @returns Value of property `timeZoomRate`
     */
    getTimeZoomRate(): float;
    /**
     * Gets current value of property {@link #getToolbarSchemes toolbarSchemes}.
     *
     * Configuration of toolbar schemes.
     *
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEMES`.
     *
     *
     * @returns Value of property `toolbarSchemes`
     */
    getToolbarSchemes(): object[];
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the control.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Default event handler for the internal event expandChartChange from global TOOLBAR.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    handleExpandChartChange(
      /**
       * expand or collapse the selected row
       */
      bExpanded: boolean,
      /**
       * bound chart scheme
       */
      aChartSchemes: any[],
      /**
       * user selected row indices
       */
      aSelectedIndices: any[]
    ): void;
    /**
     * Checks for the provided `sap.gantt.AdhocLine` in the aggregation {@link #getAdhocLines adhocLines}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAdhocLine(
      /**
       * The adhocLine whose index is looked for
       */
      oAdhocLine: AdhocLine
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getRelationships relationships}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRelationship(
      /**
       * The relationship whose index is looked for
       */
      oRelationship: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getRows rows}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfRow(
      /**
       * The row whose index is looked for
       */
      oRow: Control
    ): int;
    /**
     * Initializes the GanttChart instance after creation.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(): void;
    /**
     * Inserts a adhocLine into the aggregation {@link #getAdhocLines adhocLines}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAdhocLine(
      /**
       * The adhocLine to insert; if empty, nothing is inserted
       */
      oAdhocLine: AdhocLine,
      /**
       * The `0`-based index the adhocLine should be inserted at; for a negative value of `iIndex`, the adhocLine
       * is inserted at position 0; for a value greater than the current size of the aggregation, the adhocLine
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a relationship into the aggregation {@link #getRelationships relationships}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertRelationship(
      /**
       * The relationship to insert; if empty, nothing is inserted
       */
      oRelationship: Control,
      /**
       * The `0`-based index the relationship should be inserted at; for a negative value of `iIndex`, the relationship
       * is inserted at position 0; for a value greater than the current size of the aggregation, the relationship
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a row into the aggregation {@link #getRows rows}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertRow(
      /**
       * The row to insert; if empty, nothing is inserted
       */
      oRow: Control,
      /**
       * The `0`-based index the row should be inserted at; for a negative value of `iIndex`, the row is inserted
       * at position 0; for a value greater than the current size of the aggregation, the row is inserted at the
       * last position
       */
      iIndex: int
    ): this;
    /**
     * Jumps to a given time.
     *
     * This method sets the position of the visible area to a certain timestamp. It can be used to implement
     * the function of Jump To First, Jump To Last, and Jump To Current.
     *
     * A Redraw of SVG is triggered.
     */
    jumpToPosition(
      /**
       * A date object or a 14-digit timestamp string in this format: YYYYMMDDHHMMSS. An array can also be passed
       * where the two values determine the start time and end time of the visible horizon.
       */
      vDate: Date | string | any[]
    ): void;
    /**
     * Notifies that the data source has changed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    notifySourceChange(): void;
    /**
     * Removes a adhocLine from the aggregation {@link #getAdhocLines adhocLines}.
     *
     *
     * @returns The removed adhocLine or `null`
     */
    removeAdhocLine(
      /**
       * The adhocLine to remove or its index or id
       */
      vAdhocLine: int | string | AdhocLine
    ): AdhocLine | null;
    /**
     * Removes all the controls from the aggregation {@link #getAdhocLines adhocLines}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAdhocLines(): AdhocLine[];
    /**
     * Removes all the controls from the aggregation {@link #getRelationships relationships}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllRelationships(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getRows rows}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllRows(): Control[];
    /**
     * Removes a relationship from the aggregation {@link #getRelationships relationships}.
     *
     *
     * @returns The removed relationship or `null`
     */
    removeRelationship(
      /**
       * The relationship to remove or its index or id
       */
      vRelationship: int | string | Control
    ): Control | null;
    /**
     * Removes a row from the aggregation {@link #getRows rows}.
     *
     *
     * @returns The removed row or `null`
     */
    removeRow(
      /**
       * The row to remove or its index or id
       */
      vRow: int | string | Control
    ): Control | null;
    /**
     * Selects shape data or row data by UI ID (UID).
     *
     * UID is generated by Gantt Chart to identify the appearance of shape data and row data. You can retrieve
     * UIDs by certain events. The current implementation only supports shape selection by UID.
     */
    selectByUid(
      /**
       * Array of the UIDs of the UI elements to be selected
       */
      aUid: any[]
    ): void;
    /**
     * Selects a group of relationships specified by the aId array. Alternatively, this function deselects all
     * selected relationships if aId is a null list and bExclusive is true.
     *
     *
     * @returns Gantt Chart instance
     */
    selectRelationships(
      /**
       * List of IDs of the relationships to select
       */
      aId?: any[],
      /**
       * Whether or not to deselect all selected shapes when aId is null
       */
      bExclusive?: boolean
    ): this;
    /**
     * Selects a group of rows specified by the aId array.
     *
     *
     * @returns Gantt Chart instance
     */
    selectRows(
      /**
       * List of IDs of the rows to select
       */
      aId?: any[],
      /**
       * Whether or not to deselect all selected rows when aId is null
       */
      bExclusive?: boolean
    ): this;
    /**
     * Selects rows and all shapes contained in those rows specified by an array of row IDs. Alternatively,
     * this function deselects all selected rows and shapes in those rows if the row ID array is null and bExclusive
     * is true.
     *
     *
     * @returns Gantt Chart instance
     */
    selectRowsAndShapes(
      /**
       * List of IDs of the rows to select
       */
      aRowId?: any[],
      /**
       * Whether or not to deselect all selected rows and shapes when aRowId is null
       */
      bExclusive?: boolean
    ): this;
    /**
     * Selects a group of shapes specified by the aId array. Alternatively, this function deselects all selected
     * shapes when aId is a null list and bExclusive is true.
     *
     *
     * @returns Gantt Chart instance
     */
    selectShapes(
      /**
       * List of the IDs of the shapes to select
       */
      aId?: any[],
      /**
       * Whether or not to deselect all selected shapes when aId is null
       */
      bExclusive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAdhocLineLayer adhocLineLayer}.
     *
     * Specifies on which layer adhoc lines reside. By default, adhoc lines are on top of all other shapes and
     * patterns.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.AdhocLineLayer.Top`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdhocLineLayer(
      /**
       * New value for property `adhocLineLayer`
       */
      sAdhocLineLayer?: string
    ): this;
    /**
     * Sets the aggregated {@link #getAxisTimeStrategy axisTimeStrategy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAxisTimeStrategy(
      /**
       * The axisTimeStrategy to set
       */
      oAxisTimeStrategy: AxisTimeStrategyBase
    ): this;
    /**
     * Sets a new value for property {@link #getBaseRowHeight baseRowHeight}.
     *
     * row height of Gantt Chart. If this property is set, then it will change the Table row height on the left
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBaseRowHeight(
      /**
       * New value for property `baseRowHeight`
       */
      iBaseRowHeight?: int
    ): this;
    /**
     * Sets the aggregated {@link #getCalendarDef calendarDef}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarDef(
      /**
       * The calendarDef to set
       */
      oCalendarDef: CalendarDefs
    ): this;
    /**
     * Sets a new value for property {@link #getChartSchemes chartSchemes}.
     *
     * Configuration of chart schemes.
     *
     * List of available chart schemes. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ChartScheme[]`. Otherwise some properties you
     * set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_CHART_SCHEMES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChartSchemes(
      /**
       * New value for property `chartSchemes`
       */
      sChartSchemes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAdhocLine enableAdhocLine}.
     *
     * Switch to show and hide adhoc lines representing milestones and events along the time axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAdhocLine(
      /**
       * New value for property `enableAdhocLine`
       */
      bEnableAdhocLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableCursorLine enableCursorLine}.
     *
     * Switch to show and hide the cursor line that follows the cursor.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableCursorLine(
      /**
       * New value for property `enableCursorLine`
       */
      bEnableCursorLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableNowLine enableNowLine}.
     *
     * Switch to show and hide the present time indicator
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableNowLine(
      /**
       * New value for property `enableNowLine`
       */
      bEnableNowLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableShapeTimeDisplay enableShapeTimeDisplay}.
     *
     * Switch to show or hide the start time and end time of a shape when you drag it along the time line
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableShapeTimeDisplay(
      /**
       * New value for property `enableShapeTimeDisplay`
       */
      bEnableShapeTimeDisplay?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableVerticalLine enableVerticalLine}.
     *
     * Switch to show and hide vertical lines representing intervals along the time axis
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableVerticalLine(
      /**
       * New value for property `enableVerticalLine`
       */
      bEnableVerticalLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGhostAlignment ghostAlignment}.
     *
     * Defines how to adjust the relative position between a draggable shape and the mouse pointer.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.dragdrop.GhostAlignment.None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGhostAlignment(
      /**
       * New value for property `ghostAlignment`
       */
      sGhostAlignment?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchies hierarchies}.
     *
     * Configuration of hierarchies.
     *
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_HIERARCHYS`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchies(
      /**
       * New value for property `hierarchies`
       */
      sHierarchies?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchyKey hierarchyKey}.
     *
     * Current hierarchy key referencing from configuration property `hierarchies`.
     *
     * If `source select group` is enabled in the Gantt chart toolbar, the current hierarchy name referenced
     * from `hierarchies` by this property is shown. For applications that do not require this function, this
     * property can be ignored and a default value is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_HIERARCHY_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchyKey(
      /**
       * New value for property `hierarchyKey`
       */
      sHierarchyKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getLocale locale}.
     *
     * Configuration of locale settings.
     *
     * Most locale settings can be configured in sap.ui.configuration objects. Only the time zone and day-light-saving
     * time option are provided by locale settings. We recommend that you set the type of this argument to `sap.gantt.config.Locale`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_LOCALE`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLocale(
      /**
       * New value for property `locale`
       */
      oLocale?: object
    ): this;
    /**
     * Sets a new value for property {@link #getMode mode}.
     *
     * Current mode of the Gantt chart.
     *
     * If no value is provided, GanttChart uses a default mode key.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_MODE_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMode(
      /**
       * New value for property `mode`
       */
      sMode?: string
    ): this;
    /**
     * Sets a new value for property {@link #getModes modes}.
     *
     * Configuration of available modes.
     *
     * List of available modes. To apply modes to toolbar and shapes, further configuration is needed. If not
     * provided, a default configuration is provided. We recommend that you set the type of this argument to
     * `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_MODES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModes(
      /**
       * New value for property `modes`
       */
      sModes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getNowLineInUTC nowLineInUTC}.
     *
     * Flag whether to show the `nowLine` in UTC or in local time.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.68
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setNowLineInUTC(
      /**
       * New value for property `nowLineInUTC`
       */
      bNowLineInUTC?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getObjectTypes objectTypes}.
     *
     * Configuration of object types.
     *
     * List of available object types. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ObjectType[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_OBJECT_TYPES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setObjectTypes(
      /**
       * New value for property `objectTypes`
       */
      sObjectTypes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionMode selectionMode}.
     *
     * Selection mode for GanttChart
     *
     * This property controls whether multiToggle or multi-selection mode is enabled for the tree table and
     * for shapes. It may also affect the visual appearance, such as whether check boxes are available for selection.
     * From version 1.40 to upper versions, multi is replaced by multiToggle selection mode in tree table
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MultiWithKeyboard`.
     *
     * @deprecated (since 1.50.7) - Please use `tableProperties`(e.g. `setTableproperties({selectionMode: "None"})`)
     * to control table selection mode, and `shapeSelectionMode`(e.g. `setShapeSelectionMode("None")`) to control
     * shape selection mode.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionMode(
      /**
       * New value for property `selectionMode`
       */
      sSelectionMode?: SelectionMode | keyof typeof SelectionMode
    ): this;
    /**
     * Sets a new value for property {@link #getSelectionPanelSize selectionPanelSize}.
     *
     * This property control the size of the selection panel. The value will be overwritten by property `selectionPanelSize`
     * in `sap.gantt.config.ContainerLayout` if you are using GanttChartContainer
     *
     * In the current library, `sap.gantt.GanttChart` does not have a selection panel. `sap.gantt.GanttChartWithTable`
     * has a selection panel implemented by `sap.ui.table.TreeTable`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"30%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectionPanelSize(
      /**
       * New value for property `selectionPanelSize`
       */
      sSelectionPanelSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getShapeDataNames shapeDataNames}.
     *
     * Configuration of shape data names and the attribute in raw data that serves as 'id'.
     *
     * This property value should be an array, either an array of string, each string represents one available
     * shape data name, or an array of object, each object specifies the shape data name and data attribute
     * that will serves as 'id'. This configuration must be provided if SVG graphics are needed.
     *
     * Example: ` new sap.gantt.GanttChartWithTable({ shapeDataNames: ["task", "order"], shapes: [ new sap.gantt.shape.Shape({
     * key: "calendar", shapeDataName: "task" shapeClassName: "sap.gantt.shape.Rectangle", // ... }) ] // ...
     * }); `
     *
     * or in XMLView ` <GanttChartWithTable shapeDataNames="task,order"> </GanttChartWithTable>
     * `
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeDataNames(
      /**
       * New value for property `shapeDataNames`
       */
      sShapeDataNames?: GenericArray
    ): this;
    /**
     * Sets a new value for property {@link #getShapes shapes}.
     *
     * Configuration of shape data against shape classes.
     *
     * List of available shapes. The shapes configured in this list are initialized inside `sap.gantt.GanttChartBase`.
     * Note that for JSON data binding, this configuration supports deep structured data structures. For ODATA
     * binding, only one level is supported. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapes(
      /**
       * New value for property `shapes`
       */
      sShapes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getShapeSelectionMode shapeSelectionMode}.
     *
     * Selection mode for shape
     *
     * This property controls 4 shape selection modes(MultiWithKeyboard, Multiple, Single, None). You can use
     * `setShapeSelectionMode("None")` to set shape selection mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `MultiWithKeyboard`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapeSelectionMode(
      /**
       * New value for property `shapeSelectionMode`
       */
      sShapeSelectionMode?: SelectionMode | keyof typeof SelectionMode
    ): this;
    /**
     * Sets a new value for property {@link #getSvgDefs svgDefs}.
     *
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. We recommend that
     * you set the type of this argument to `sap.gantt.def.SvgDefs`. Otherwise some properties you set may not
     * function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSvgDefs(
      /**
       * New value for property `svgDefs`
       */
      oSvgDefs?: object
    ): this;
    /**
     * Set exposed TreeTable properties
     *
     *
     * @returns Reference to this in order to allow method chaining
     */
    setTableProperties(
      /**
       * The object include some properties from TreeTable
       */
      oProperties: Object
    ): GanttChart | GanttChartWithTable;
    /**
     * Sets a new value for property {@link #getTimeAxis timeAxis}.
     *
     * Configuration of the time axis.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_TIME_AXIS`.
     *
     * @deprecated (since 1.44) - replaced by aggregation 'axisTimeStrategy'. Planning horizon, initial horizon,
     * and zoom level can be configured with this property. If not provided, a default configuration is provided.
     * We recommend that you set the type of this argument to `sap.gantt.config.TimeAxis`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeAxis(
      /**
       * New value for property `timeAxis`
       */
      oTimeAxis?: object
    ): this;
    /**
     * Sets a new value for property {@link #getTimeZoomRate timeZoomRate}.
     *
     * Zoom level in float.
     *
     * This property allows application developers to control the zoom level. When GanttChart is embedded in
     * `sap.gantt.GanttChartContainer`, you do not have to manage this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @deprecated (since 1.44) - please use sap.gantt.axistime.AxisTimeStrategy to change the zoom rate
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeZoomRate(
      /**
       * New value for property `timeZoomRate`
       */
      fTimeZoomRate?: float
    ): this;
    /**
     * Sets a new value for property {@link #getToolbarSchemes toolbarSchemes}.
     *
     * Configuration of toolbar schemes.
     *
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_GANTTCHART_TOOLBAR_SCHEMES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolbarSchemes(
      /**
       * New value for property `toolbarSchemes`
       */
      sToolbarSchemes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Unbinds aggregation {@link #getAdhocLines adhocLines} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindAdhocLines(): this;
    /**
     * Unbinds aggregation {@link #getAxisTimeStrategy axisTimeStrategy} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindAxisTimeStrategy(): this;
    /**
     * Unbinds aggregation {@link #getCalendarDef calendarDef} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindCalendarDef(): this;
    /**
     * Unbinds aggregation {@link #getRelationships relationships} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRelationships(): this;
    /**
     * Unbinds aggregation {@link #getRows rows} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindRows(): this;
  }
  /**
   * Describes the settings that can be provided to the GanttChartBase constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $GanttChartBaseSettings extends $ControlSettings {
    /**
     * Width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the control.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to show and hide the cursor line that follows the cursor.
     */
    enableCursorLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to show and hide the present time indicator
     */
    enableNowLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to show and hide vertical lines representing intervals along the time axis
     */
    enableVerticalLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to show and hide adhoc lines representing milestones and events along the time axis
     */
    enableAdhocLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to show or hide the start time and end time of a shape when you drag it along the time line
     */
    enableShapeTimeDisplay?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Zoom level in float.
     *
     * This property allows application developers to control the zoom level. When GanttChart is embedded in
     * `sap.gantt.GanttChartContainer`, you do not have to manage this property.
     *
     * @deprecated (since 1.44) - please use sap.gantt.axistime.AxisTimeStrategy to change the zoom rate
     */
    timeZoomRate?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Current mode of the Gantt chart.
     *
     * If no value is provided, GanttChart uses a default mode key.
     */
    mode?: string | PropertyBindingInfo;

    /**
     * Selection mode for GanttChart
     *
     * This property controls whether multiToggle or multi-selection mode is enabled for the tree table and
     * for shapes. It may also affect the visual appearance, such as whether check boxes are available for selection.
     * From version 1.40 to upper versions, multi is replaced by multiToggle selection mode in tree table
     *
     * @deprecated (since 1.50.7) - Please use `tableProperties`(e.g. `setTableproperties({selectionMode: "None"})`)
     * to control table selection mode, and `shapeSelectionMode`(e.g. `setShapeSelectionMode("None")`) to control
     * shape selection mode.
     */
    selectionMode?:
      | (SelectionMode | keyof typeof SelectionMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Selection mode for shape
     *
     * This property controls 4 shape selection modes(MultiWithKeyboard, Multiple, Single, None). You can use
     * `setShapeSelectionMode("None")` to set shape selection mode.
     */
    shapeSelectionMode?:
      | (SelectionMode | keyof typeof SelectionMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * This property control the size of the selection panel. The value will be overwritten by property `selectionPanelSize`
     * in `sap.gantt.config.ContainerLayout` if you are using GanttChartContainer
     *
     * In the current library, `sap.gantt.GanttChart` does not have a selection panel. `sap.gantt.GanttChartWithTable`
     * has a selection panel implemented by `sap.ui.table.TreeTable`.
     */
    selectionPanelSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Current hierarchy key referencing from configuration property `hierarchies`.
     *
     * If `source select group` is enabled in the Gantt chart toolbar, the current hierarchy name referenced
     * from `hierarchies` by this property is shown. For applications that do not require this function, this
     * property can be ignored and a default value is used.
     */
    hierarchyKey?: string | PropertyBindingInfo;

    /**
     * row height of Gantt Chart. If this property is set, then it will change the Table row height on the left
     */
    baseRowHeight?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. We recommend that
     * you set the type of this argument to `sap.gantt.def.SvgDefs`. Otherwise some properties you set may not
     * function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    svgDefs?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of the time axis.
     *
     * @deprecated (since 1.44) - replaced by aggregation 'axisTimeStrategy'. Planning horizon, initial horizon,
     * and zoom level can be configured with this property. If not provided, a default configuration is provided.
     * We recommend that you set the type of this argument to `sap.gantt.config.TimeAxis`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    timeAxis?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of available modes.
     *
     * List of available modes. To apply modes to toolbar and shapes, further configuration is needed. If not
     * provided, a default configuration is provided. We recommend that you set the type of this argument to
     * `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    modes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of toolbar schemes.
     *
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    toolbarSchemes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of hierarchies.
     *
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    hierarchies?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of object types.
     *
     * List of available object types. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ObjectType[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    objectTypes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of chart schemes.
     *
     * List of available chart schemes. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.ChartScheme[]`. Otherwise some properties you
     * set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    chartSchemes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of locale settings.
     *
     * Most locale settings can be configured in sap.ui.configuration objects. Only the time zone and day-light-saving
     * time option are provided by locale settings. We recommend that you set the type of this argument to `sap.gantt.config.Locale`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    locale?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of shape data names and the attribute in raw data that serves as 'id'.
     *
     * This property value should be an array, either an array of string, each string represents one available
     * shape data name, or an array of object, each object specifies the shape data name and data attribute
     * that will serves as 'id'. This configuration must be provided if SVG graphics are needed.
     *
     * Example: ` new sap.gantt.GanttChartWithTable({ shapeDataNames: ["task", "order"], shapes: [ new sap.gantt.shape.Shape({
     * key: "calendar", shapeDataName: "task" shapeClassName: "sap.gantt.shape.Rectangle", // ... }) ] // ...
     * }); `
     *
     * or in XMLView ` <GanttChartWithTable shapeDataNames="task,order"> </GanttChartWithTable>
     * `
     */
    shapeDataNames?: GenericArray | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of shape data against shape classes.
     *
     * List of available shapes. The shapes configured in this list are initialized inside `sap.gantt.GanttChartBase`.
     * Note that for JSON data binding, this configuration supports deep structured data structures. For ODATA
     * binding, only one level is supported. We recommend that you set the type of this argument to `sap.gantt.config.Shape[]`.
     * Otherwise some properties you set may not function properly.
     */
    shapes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies on which layer adhoc lines reside. By default, adhoc lines are on top of all other shapes and
     * patterns.
     */
    adhocLineLayer?: string | PropertyBindingInfo;

    /**
     * Exposed properties from TreeTable
     */
    tableProperties?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how to adjust the relative position between a draggable shape and the mouse pointer.
     */
    ghostAlignment?: string | PropertyBindingInfo;

    /**
     * Flag whether to show the `nowLine` in UTC or in local time.
     *
     * @since 1.68
     */
    nowLineInUTC?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Rows of `sap.gantt.GanttChartBase`
     *
     * This aggregation is delegated to `sap.gantt.table.TreeTable`. Rows are provide a base for shapes with
     * a category of `"InRowShape"`. The configuration in property `shapes` determines how the shapes are drawn.
     */
    rows?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Relationships of shapes carried by rows.
     *
     * Similar to rows, this aggregation does not request templates either. Relationships are a special shape
     * with a category of `"crossRowShape"`. How relationships are drawn is also specified in configuration
     * property `shapes`.
     */
    relationships?:
      | Control[]
      | Control
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Paint servers consumed by special shape `sap.gantt.shape.cal.Calendar`.
     *
     * This aggregation is designed to improve performance of calendar shapes. Rows usually share a similar
     * definition with calendar shapes. It is possible to define a Calendar paint server to draw only one rectangle
     * for each row. Notes for classes extended from `sap.gantt.def.cal.CalendarDef`: Different from property
     * `paintServerDefs`, paint servers defined here must implement method `getDefNode()` instead of method
     * `getDefString()`.
     */
    calendarDef?: CalendarDefs;

    /**
     * This aggregation controls the zoom strategies and zoom rate in Gantt Chart.
     */
    axisTimeStrategy?: AxisTimeStrategyBase;

    /**
     * The aggregation is used to store configuration of adhoc lines, adhoc lines represent milestones and events
     * in axis time.
     */
    adhocLines?:
      | AdhocLine[]
      | AdhocLine
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Event fired when the hierarchy key has changed in the Gantt chart toolbar.
     */
    ganttChartSwitchRequested?: (
      oEvent: GanttChartBase$GanttChartSwitchRequestedEvent
    ) => void;

    /**
     * Splitter (if exists) resized.
     *
     * If a splitter exists and synchronization is needed with other Gantt charts in the container, use this
     * event. You can listen for this event and obtain `zoomInfo`.
     */
    splitterResize?: (oEvent: GanttChartBase$SplitterResizeEvent) => void;

    /**
     * Horizontal (time axis) scroll.
     *
     * If the horizontal scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     */
    horizontalScroll?: (oEvent: GanttChartBase$HorizontalScrollEvent) => void;

    /**
     * Vertical (row axis) scroll.
     *
     * If the vertical scroll bar exists and synchronization is needed with other Gantt charts in the container,
     * use this event.
     *
     * @deprecated (since 1.44)
     */
    verticalScroll?: (oEvent: GanttChartBase$VerticalScrollEvent) => void;

    /**
     * Event is fired when a mouse-hover occurs in the graphic part.
     */
    chartMouseOver?: (oEvent: GanttChartBase$ChartMouseOverEvent) => void;

    /**
     * Event fired when the chart is clicked
     */
    chartClick?: (oEvent: GanttChartBase$ChartClickEvent) => void;

    /**
     * Event fired when the chart is double-clicked
     */
    chartDoubleClick?: (oEvent: GanttChartBase$ChartDoubleClickEvent) => void;

    /**
     * Event fired when the chart is right-clicked
     */
    chartRightClick?: (oEvent: GanttChartBase$ChartRightClickEvent) => void;

    chartDragEnter?: (oEvent: GanttChartBase$ChartDragEnterEvent) => void;

    chartDragLeave?: (oEvent: GanttChartBase$ChartDragLeaveEvent) => void;

    /**
     * Event fired when the selection status of rows changes.
     */
    rowSelectionChange?: (
      oEvent: GanttChartBase$RowSelectionChangeEvent
    ) => void;

    /**
     * Event fired when the selection status of relationships changes.
     */
    relationshipSelectionChange?: (
      oEvent: GanttChartBase$RelationshipSelectionChangeEvent
    ) => void;

    /**
     * Event fired when the selection status of shapes changes.
     */
    shapeSelectionChange?: (
      oEvent: GanttChartBase$ShapeSelectionChangeEvent
    ) => void;

    /**
     * Event fired when a drag-and-drop occurs on one or more selected shapes.
     */
    shapeDragEnd?: (oEvent: GanttChartBase$ShapeDragEndEvent) => void;

    /**
     * Event fired when toggle node of the tree table.
     */
    treeTableToggleEvent?: (
      oEvent: GanttChartBase$TreeTableToggleEventEvent
    ) => void;

    /**
     * Event fired when a resizing occurs on a resized shape.
     */
    shapeResizeEnd?: (oEvent: GanttChartBase$ShapeResizeEndEvent) => void;

    /**
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You hover the mouse on a shape and keep the mouse stationary for 500 millisecond or longer.
     */
    shapeMouseEnter?: (oEvent: GanttChartBase$ShapeMouseEnterEvent) => void;

    /**
     * Event fired when the following conditions are met: The 'enableHover' property of Shape is set to true.
     * You move the mouse out of a shape and keep the mouse stationary for 500 millisecond or longer.
     */
    shapeMouseLeave?: (oEvent: GanttChartBase$ShapeMouseLeaveEvent) => void;
  }

  /**
   * Parameters of the GanttChartBase#chartClick event.
   */
  export interface GanttChartBase$ChartClickEventParameters {
    /**
     * Row object information of the current mouse point.
     */
    objectInfo?: object;

    /**
     * Leading row object information. null when it is the main row at current mouse point; main row information
     * if it is one of multiple expanded rows.
     */
    leadingRowInfo?: object;

    /**
     * Timestamp of the current mouse point.
     */
    timestamp?: string;

    /**
     * ID of SVG.
     */
    svgId?: string;

    /**
     * [x, y] Coordinate of the current mouse point in the SVG coordinate system.
     */
    svgCoordinate?: int[];

    /**
     * Effective mode. It can be the current Gantt Chart mode or the mode derived from the chart scheme mode.
     */
    effectingMode?: string;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#chartClick event.
   */
  export type GanttChartBase$ChartClickEvent = Event<
    GanttChartBase$ChartClickEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#chartDoubleClick event.
   */
  export interface GanttChartBase$ChartDoubleClickEventParameters {
    /**
     * Row object information of the current mouse point.
     */
    objectInfo?: object;

    /**
     * Leading row object information. null when it is the main row at current mouse point; main row information
     * if it is one of multiple expanded rows.
     */
    leadingRowInfo?: object;

    /**
     * Timestamp of the current mouse point.
     */
    timestamp?: string;

    /**
     * ID of SVG.
     */
    svgId?: string;

    /**
     * [x, y] Coordinate of the current mouse point in the SVG coordinate system.
     */
    svgCoordinate?: int[];

    /**
     * Effective mode. It can be the current Gantt Chart mode or the mode derived from the chart scheme mode.
     */
    effectingMode?: string;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#chartDoubleClick event.
   */
  export type GanttChartBase$ChartDoubleClickEvent = Event<
    GanttChartBase$ChartDoubleClickEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#chartDragEnter event.
   */
  export interface GanttChartBase$ChartDragEnterEventParameters {
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#chartDragEnter event.
   */
  export type GanttChartBase$ChartDragEnterEvent = Event<
    GanttChartBase$ChartDragEnterEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#chartDragLeave event.
   */
  export interface GanttChartBase$ChartDragLeaveEventParameters {
    originEvent?: object;

    draggingSource?: object;
  }

  /**
   * Event object of the GanttChartBase#chartDragLeave event.
   */
  export type GanttChartBase$ChartDragLeaveEvent = Event<
    GanttChartBase$ChartDragLeaveEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#chartMouseOver event.
   */
  export interface GanttChartBase$ChartMouseOverEventParameters {
    /**
     * Row object information of the current mouse point.
     */
    objectInfo?: object;

    /**
     * Leading row object information. null when it is the main row at current mouse point; main row information
     * if it is one of multiple expanded rows.
     */
    leadingRowInfo?: object;

    /**
     * Timestamp of the current mouse point.
     */
    timestamp?: string;

    /**
     * ID of SVG.
     */
    svgId?: string;

    /**
     * [x, y] Coordinate of the current mouse point in the SVG coordinate system.
     */
    svgCoordinate?: int[];

    /**
     * Effective mode. It can be the current Gantt Chart mode or the mode derived from the chart scheme mode.
     */
    effectingMode?: string;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#chartMouseOver event.
   */
  export type GanttChartBase$ChartMouseOverEvent = Event<
    GanttChartBase$ChartMouseOverEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#chartRightClick event.
   */
  export interface GanttChartBase$ChartRightClickEventParameters {
    /**
     * Row object information of the current mouse point.
     */
    objectInfo?: object;

    /**
     * Leading row object information. null when it is the main row at current mouse point; main row information
     * if it is one of multiple expanded rows.
     */
    leadingRowInfo?: object;

    /**
     * Timestamp of the current mouse point.
     */
    timestamp?: string;

    /**
     * ID of SVG.
     */
    svgId?: string;

    /**
     * [x, y] Coordinate of the current mouse point in the SVG coordinate system.
     */
    svgCoordinate?: int[];

    /**
     * Effective mode. It can be the current Gantt Chart mode or a mode derived from the chart scheme mode.
     */
    effectingMode?: string;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#chartRightClick event.
   */
  export type GanttChartBase$ChartRightClickEvent = Event<
    GanttChartBase$ChartRightClickEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#ganttChartSwitchRequested event.
   */
  export interface GanttChartBase$GanttChartSwitchRequestedEventParameters {
    /**
     * Target hierarchy key.
     */
    hierarchyKey?: string;
  }

  /**
   * Event object of the GanttChartBase#ganttChartSwitchRequested event.
   */
  export type GanttChartBase$GanttChartSwitchRequestedEvent = Event<
    GanttChartBase$GanttChartSwitchRequestedEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#horizontalScroll event.
   *
   * @deprecated (since 1.44)
   */
  export interface GanttChartBase$HorizontalScrollEventParameters {
    /**
     * Scroll steps.
     */
    scrollSteps?: int;

    /**
     * The start time of Gantt Chart visible area when the event fired
     */
    startTime?: string;

    /**
     * The end time of Gantt Chart visible area when the event fired
     */
    endTime?: string;
  }

  /**
   * Event object of the GanttChartBase#horizontalScroll event.
   *
   * @deprecated (since 1.44)
   */
  export type GanttChartBase$HorizontalScrollEvent = Event<
    GanttChartBase$HorizontalScrollEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#relationshipSelectionChange event.
   */
  export interface GanttChartBase$RelationshipSelectionChangeEventParameters {
    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#relationshipSelectionChange event.
   */
  export type GanttChartBase$RelationshipSelectionChangeEvent = Event<
    GanttChartBase$RelationshipSelectionChangeEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#rowSelectionChange event.
   */
  export interface GanttChartBase$RowSelectionChangeEventParameters {
    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#rowSelectionChange event.
   */
  export type GanttChartBase$RowSelectionChangeEvent = Event<
    GanttChartBase$RowSelectionChangeEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#shapeDragEnd event.
   */
  export interface GanttChartBase$ShapeDragEndEventParameters {
    /**
     * Original JQuery event object.
     */
    originEvent?: object;

    /**
     * List of source shape data.
     */
    sourceShapeData?: object[];

    /**
     * Source SVG ID.
     */
    sourceSvgId?: string;

    /**
     * Information about the drop position and target row. It contains the following properties:
     * 	 - shapeTimestamp startTime and endTime of a dropped shape. This property is added to support the newly
     *     introduced drag-and-drop behaviors. For more information, see `sap.gantt.dragdrop.GhostAlignment`.
     * 	 - cursorTimestamp Cursor timestamp when a shape is dropped. This property is added to support the newly
     *     introduced drag-and-drop behaviors. For more information, see `sap.gantt.dragdrop.GhostAlignment`.
     * 	 - mode Mode of the current view.
     * 	 - objectInfo Data of the row where you dropped the shape.   Note: The original property 'mouseTimestamp',
     *     which contains the startTime/endTime of a dropped shape has been deprecated.
     */
    targetData?: object;

    /**
     * Target SVG ID.
     */
    targetSvgId?: string;
  }

  /**
   * Event object of the GanttChartBase#shapeDragEnd event.
   */
  export type GanttChartBase$ShapeDragEndEvent = Event<
    GanttChartBase$ShapeDragEndEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#shapeMouseEnter event.
   */
  export interface GanttChartBase$ShapeMouseEnterEventParameters {
    /**
     * The data of the shape which fires this event.
     */
    shapeData?: object;

    /**
     * The mouse position relative to the left edge of the document.
     */
    pageX?: int;

    /**
     * The mouse position relative to the top edge of the document.
     */
    pageY?: int;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#shapeMouseEnter event.
   */
  export type GanttChartBase$ShapeMouseEnterEvent = Event<
    GanttChartBase$ShapeMouseEnterEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#shapeMouseLeave event.
   */
  export interface GanttChartBase$ShapeMouseLeaveEventParameters {
    /**
     * The data of the shape which fires this event.
     */
    shapeData?: object;

    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#shapeMouseLeave event.
   */
  export type GanttChartBase$ShapeMouseLeaveEvent = Event<
    GanttChartBase$ShapeMouseLeaveEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#shapeResizeEnd event.
   */
  export interface GanttChartBase$ShapeResizeEndEventParameters {
    /**
     * UID of the resized shape.
     */
    shapeUid?: string;

    /**
     * Row object of the resizing shape.
     */
    rowObject?: object;

    /**
     * Original shape time array, including the start time and end time.
     */
    oldTime?: string[];

    /**
     * New shape time array, including the start time and end time.
     */
    newTime?: string[];
  }

  /**
   * Event object of the GanttChartBase#shapeResizeEnd event.
   */
  export type GanttChartBase$ShapeResizeEndEvent = Event<
    GanttChartBase$ShapeResizeEndEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#shapeSelectionChange event.
   */
  export interface GanttChartBase$ShapeSelectionChangeEventParameters {
    /**
     * Original JQuery event object.
     */
    originEvent?: object;
  }

  /**
   * Event object of the GanttChartBase#shapeSelectionChange event.
   */
  export type GanttChartBase$ShapeSelectionChangeEvent = Event<
    GanttChartBase$ShapeSelectionChangeEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#splitterResize event.
   */
  export interface GanttChartBase$SplitterResizeEventParameters {
    /**
     * ID of the source control.
     */
    id?: string;

    /**
     * Old size in the form of [height, width].
     */
    oldSizes?: int[];

    /**
     * New size in the form of [height, width].
     */
    newSizes?: int[];

    /**
     * Zoom information.
     *
     * This object contains all related information for the listener to get the current zoom level of the time
     * axis. Usually `zoomInfo` contains the following information:
     * 	 - `"base"` - Base for zooming calculation.
     * 	`"sGranularity"`: "4day", - Zoom level that is used to calculate the zoom base; it is taken from timeAxis.granularity.
     *
     * 	 - `"fScale"`: 3840000 - Base scale determined by zoomStrategy level and now().
     * 	 - `"determinedByConfig"` - Zoom level calculated by configuration `timeAxis`.
     * 	`"fRate"`: 1, - Zoom rate determined by configuration timeAxis.granularity.
     * 	 - `"fMaxRate"`: 384, - Maximum zoom rate determined by configuration timeAxis.finestGranularity.
     * 	 - `"fMinRate"`: 0.02197802197802198 - Minimum zoom rate determined by configuration timeAxis.coarsestGranularity.
     *
     * 	 - `"determinedByChartWidth"` - Zoom level calculated by the SVG width.
     * 	`"fMinRate"`: 0.0279009617614573, - Minimum zoom rate determined by the chart width and configuration
     * timeAxis.planHorizon.
     * 	 - `"fSuitableRate"`: 0.5078804440909039 - Suitable zoom rate determined by the chart width and configuration
     *     timeAxis.initHorizon.
     * 	 - `iChartWidth`: 417 - Chart width in pixel.
     */
    zoomInfo?: object;
  }

  /**
   * Event object of the GanttChartBase#splitterResize event.
   */
  export type GanttChartBase$SplitterResizeEvent = Event<
    GanttChartBase$SplitterResizeEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#treeTableToggleEvent event.
   */
  export interface GanttChartBase$TreeTableToggleEventEventParameters {
    /**
     * The index of the expanded/collapsed row.
     */
    rowIndex?: int;

    /**
     * The binding context of the selected row.
     */
    rowContext?: object;

    /**
     * flag whether the node has been expanded or collapsed.
     */
    expanded?: boolean;
  }

  /**
   * Event object of the GanttChartBase#treeTableToggleEvent event.
   */
  export type GanttChartBase$TreeTableToggleEventEvent = Event<
    GanttChartBase$TreeTableToggleEventEventParameters,
    GanttChartBase
  >;

  /**
   * Parameters of the GanttChartBase#verticalScroll event.
   *
   * @deprecated (since 1.44)
   */
  export interface GanttChartBase$VerticalScrollEventParameters {
    /**
     * Scroll steps.
     */
    scrollSteps?: int;
  }

  /**
   * Event object of the GanttChartBase#verticalScroll event.
   *
   * @deprecated (since 1.44)
   */
  export type GanttChartBase$VerticalScrollEvent = Event<
    GanttChartBase$VerticalScrollEventParameters,
    GanttChartBase
  >;
}

declare module "sap/gantt/GanttChartContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import GanttChartBase from "sap/gantt/GanttChartBase";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import { CSSSize } from "sap/ui/core/library";

  import LegendContainer from "sap/gantt/legend/LegendContainer";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Event from "sap/ui/base/Event";

  /**
   * A container that holds one or more `GanttChartBase` instances.
   *
   *  This class has several built-in several controls to support `GanttChartBase` instances:
   * 	 - A toolbar above all Gantt Charts. Many built-in controls can be enabled or disabled using configuration
   *     property `toolbarScheme`. Built-in functions include:
   * 	ComboBox for container selection
   * 	 - Buttons for Add View, Delete View, and Switch Splitter Orientation
   * 	 - Expand/Collapse groups for expandable charts
   * 	 - A zooming slider
   * 	 - A legend button
   * 	 - A Settings button  If nothing is added to the toolbar, the toolbar is hidden automatically.
   *     For more information about the functions and configuration, see the API documentation of `sap.gantt.config.ToolbarScheme.`
   *
   * 	 - A Splitter containing aggregation `ganttCharts`
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartContainer} should be used instead.
   */
  export default class GanttChartContainer extends Control {
    /**
     * Creates and initializes a new Gantt chart container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartContainerSettings
    );
    /**
     * Creates and initializes a new Gantt chart container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GanttChartContainerSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.GanttChartContainer with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttChartContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.GanttChartContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some customToolbarItem to the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCustomToolbarItem(
      /**
       * The customToolbarItem to add; if empty, nothing is inserted
       */
      oCustomToolbarItem: Control
    ): this;
    /**
     * Adds some ganttChart to the aggregation {@link #getGanttCharts ganttCharts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addGanttChart(
      /**
       * The ganttChart to add; if empty, nothing is inserted
       */
      oGanttChart: GanttChartBase
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customSettingChange customSettingChange} event
     * of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when the custom settings are changed.
     *
     * The Custom settings are application-injected settings that can be configured in the Settings dialog box.
     * This event allows the application to handle these settings. Only check boxes are supported.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomSettingChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$CustomSettingChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:customSettingChange customSettingChange} event
     * of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when the custom settings are changed.
     *
     * The Custom settings are application-injected settings that can be configured in the Settings dialog box.
     * This event allows the application to handle these settings. Only check boxes are supported.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCustomSettingChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$CustomSettingChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ganttChartChangeRequested ganttChartChangeRequested }
     * event of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when any change occurs in the toolbar that requests the application to change aggregation
     * `ganttCharts`.
     *
     * Possible triggers are:
     * 	 - The source selection group changes in the container toolbar.
     * 	 - The layout group button is clicked in the container toolbar.
     * 	 - The source selection group changes in the Gantt chart toolbar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachGanttChartChangeRequested(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: GanttChartContainer$GanttChartChangeRequestedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:ganttChartChangeRequested ganttChartChangeRequested }
     * event of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when any change occurs in the toolbar that requests the application to change aggregation
     * `ganttCharts`.
     *
     * Possible triggers are:
     * 	 - The source selection group changes in the container toolbar.
     * 	 - The layout group button is clicked in the container toolbar.
     * 	 - The source selection group changes in the Gantt chart toolbar.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachGanttChartChangeRequested(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (
        p1: GanttChartContainer$GanttChartChangeRequestedEvent
      ) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:treeTableToggleEvent treeTableToggleEvent} event
     * of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when toggle node of the tree table.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTreeTableToggleEvent(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$TreeTableToggleEventEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:treeTableToggleEvent treeTableToggleEvent} event
     * of this `sap.gantt.GanttChartContainer`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.GanttChartContainer` itself.
     *
     * Event fired when toggle node of the tree table.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTreeTableToggleEvent(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$TreeTableToggleEventEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.GanttChartContainer` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getCustomToolbarItems customToolbarItems} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindCustomToolbarItems(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Binds aggregation {@link #getGanttCharts ganttCharts} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindGanttCharts(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Deselects relationships and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    deselectRelationships(
      /**
       * Index of the Gantt chart containing the relationships that you want to deselect
       */
      iGanttChartIndex?: int,
      /**
       * List of the relationships that you want to deselect
       */
      aIds?: any[]
    ): boolean;
    /**
     * Deselects rows and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    deselectRows(
      /**
       * Index of the Gantt chart containing the rows that you want to deselect
       */
      iGanttChartIndex?: int,
      /**
       * List of the rows that you want to deselect
       */
      aIds?: any[]
    ): boolean;
    /**
     * Deselects in-row shapes and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    deselectShapes(
      /**
       * Index of the Gantt chart containing the shapes that you want to deselect
       */
      iGanttChartIndex?: int,
      /**
       * List of the shapes that you want to deselect
       */
      aIds?: any[]
    ): boolean;
    /**
     * Destroys all the customToolbarItems in the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomToolbarItems(): this;
    /**
     * Destroys all the ganttCharts in the aggregation {@link #getGanttCharts ganttCharts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyGanttCharts(): this;
    /**
     * Destroys the legendContainer in the aggregation {@link #getLegendContainer legendContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendContainer(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:customSettingChange customSettingChange} event
     * of this `sap.gantt.GanttChartContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCustomSettingChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$CustomSettingChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:ganttChartChangeRequested ganttChartChangeRequested }
     * event of this `sap.gantt.GanttChartContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachGanttChartChangeRequested(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (
        p1: GanttChartContainer$GanttChartChangeRequestedEvent
      ) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:treeTableToggleEvent treeTableToggleEvent }
     * event of this `sap.gantt.GanttChartContainer`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTreeTableToggleEvent(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: GanttChartContainer$TreeTableToggleEventEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:customSettingChange customSettingChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCustomSettingChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartContainer$CustomSettingChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:ganttChartChangeRequested ganttChartChangeRequested} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireGanttChartChangeRequested(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartContainer$GanttChartChangeRequestedEventParameters
    ): this;
    /**
     * Fires event {@link #event:treeTableToggleEvent treeTableToggleEvent} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTreeTableToggleEvent(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: GanttChartContainer$TreeTableToggleEventEventParameters
    ): this;
    /**
     * Gets all selected rows and shapes, including relationships.
     *
     *
     * @returns The returned object contains "rows" for all selected rows, "shapes" for all selected shapes,
     * and "relationships" for all selected relationships
     */
    getAllSelections(
      /**
       * Index of the Gantt chart containing that you want to get
       */
      iGanttChartIndex?: int
    ): object;
    /**
     * Gets current value of property {@link #getContainerLayoutKey containerLayoutKey}.
     *
     * Current container layout key.
     *
     * This is a key configured in configuration property `containerLayouts`.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY`.
     *
     *
     * @returns Value of property `containerLayoutKey`
     */
    getContainerLayoutKey(): string;
    /**
     * Gets current value of property {@link #getContainerLayouts containerLayouts}.
     *
     * Configuration of container layouts.
     *
     * This configuration affects the data source selection ComboBox in the Container Toolbar. When the selection
     * changes, the `ganttChartChangeRequested` event that is triggered includes the corresponding layout key.
     * We recommend that you set the type of this argument to `sap.gantt.config.ContainerLayout[]`. Otherwise
     * some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_LAYOUTS`.
     *
     *
     * @returns Value of property `containerLayouts`
     */
    getContainerLayouts(): object[];
    /**
     * Gets content of aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Controls to be placed in the container toolbar.
     *
     * This aggregation is used only when the custom toolbar item group is configured to be shown in the
     * container toolbar. Different from the built-in buttons that are configured to be shown or hidden, these
     * controls are free controls created by the application, but are only placed in the container toolbar by
     * `sap.gantt.GanttChartContainer`.
     *
     * If the source selection group is enabled and you want your application to use a container layout pre-configured
     * for a specific source, you can implement your custom toolbar items in the event handler of event `ganttChartChangeRequested`.
     */
    getCustomToolbarItems(): Control[];
    /**
     * Gets current value of property {@link #getEnableAdhocLine enableAdhocLine}.
     *
     * Switch to enable and disable adhoc lines representing milestones and events along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableAdhocLine`
     */
    getEnableAdhocLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableCursorLine enableCursorLine}.
     *
     * Switch to enable and disable the cursor line that follows the cursor.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableCursorLine`
     */
    getEnableCursorLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableNowLine enableNowLine}.
     *
     * Switch to enable and disable the present time indicator.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableNowLine`
     */
    getEnableNowLine(): boolean;
    /**
     * Gets current value of property {@link #getEnableTimeScrollSync enableTimeScrollSync}.
     *
     * Switch to enable and disable scroll synchronization by time on instances of aggregation `ganttCharts`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableTimeScrollSync`
     */
    getEnableTimeScrollSync(): boolean;
    /**
     * Gets current value of property {@link #getEnableVerticalLine enableVerticalLine}.
     *
     * Switch to enable and disable vertical lines representing intervals along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enableVerticalLine`
     */
    getEnableVerticalLine(): boolean;
    /**
     * Gets content of aggregation {@link #getGanttCharts ganttCharts}.
     *
     * Gantt chart instances.
     *
     * If the source selection group is enabled and you want your application to use a container layout pre-configured
     * for a specific source, you can implement your custom toolbar items in the event handler of event `ganttChartChangeRequested`.
     * Provide a Gantt chart in compliance with the container layout setting. GanttChartContainer is designed
     * to support Gantt chart layouts that include multiple views.
     */
    getGanttCharts(): GanttChartBase[];
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the control
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getHierarchies hierarchies}.
     *
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_HIERARCHYS`.
     *
     *
     * @returns Value of property `hierarchies`
     */
    getHierarchies(): object[];
    /**
     * Gets content of aggregation {@link #getLegendContainer legendContainer}.
     *
     * Legend shown when the legend button is clicked.
     *
     * This aggregation is used only when the Legend button is configured to be shown in the container toolbar.
     */
    getLegendContainer(): LegendContainer;
    /**
     * Gets current value of property {@link #getMaxNumOfGanttCharts maxNumOfGanttCharts}.
     *
     * Define the maximum number of Gantt charts to be displayed on the same screen. When this number is reached,
     * the "Add Gantt Chart" button is grayed out.
     *
     * Default value is `3`.
     *
     *
     * @returns Value of property `maxNumOfGanttCharts`
     */
    getMaxNumOfGanttCharts(): int;
    /**
     * Gets current value of property {@link #getModes modes}.
     *
     * List of available modes. To apply modes to the toolbar and shapes, further configuration is needed. (specifically,
     * in property `toolbarSchemes`, and properties `toolbarSchemes` and `shapes` in the `GanttChartBase` class)If
     * not provided, a default configuration is provided. We recommend that you set the type of this argument
     * to `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_MODES`.
     *
     *
     * @returns Value of property `modes`
     */
    getModes(): object[];
    /**
     * Gets the selected relationships.
     *
     *
     * @returns Returns all selected relationships in the chart
     */
    getSelectedRelationships(
      /**
       * Index of the Gantt chart containing the selected relationships that you want to get
       */
      iGanttChartIndex?: int
    ): any[];
    /**
     * Gets the selected rows.
     *
     *
     * @returns Returns all selected rows
     */
    getSelectedRows(
      /**
       * Index of the Gantt chart containing the selected rows that you want to get
       */
      iGanttChartIndex?: int
    ): any[];
    /**
     * Gets the selected in-row shapes.
     *
     *
     * @returns Returns all selected shapes in the chart
     */
    getSelectedShapes(
      /**
       * Index of the Gantt chart containing the selected shapes that you want to get
       */
      iGanttChartIndex?: int
    ): any[];
    /**
     * Gets current value of property {@link #getSliderStep sliderStep}.
     *
     * Define the amount of units to change the time zoom slider.
     *
     * See {@link sap.m.Slider#setStep}
     *
     * @deprecated (since 1.44) - please set the property 'stepCountOfSlider' in sap.gantt.config.TimeZoomGroup.
     *
     * @returns Value of property `sliderStep`
     */
    getSliderStep(): int;
    /**
     * Gets current value of property {@link #getSvgDefs svgDefs}.
     *
     * Definitions of paint servers used for advanced shape features around SVG fill, stroke, and filter attributes.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. It is easier to
     * assign a common paint server definition in this class instead of in separate instances of `sap.gantt.GanttChartBase`.
     * Then the definition is rendered only once. We recommend that you set the type of this argument to `sap.gantt.def.SvgDefs`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     *
     * @returns Value of property `svgDefs`
     */
    getSvgDefs(): object;
    /**
     * Returns the current effective toolbar scheme key.
     *
     *
     * @returns - Toolbar scheme key.
     */
    getToolbarSchemeKey(): string;
    /**
     * Gets current value of property {@link #getToolbarSchemes toolbarSchemes}.
     *
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_TOOLBAR_SCHEMES`.
     *
     *
     * @returns Value of property `toolbarSchemes`
     */
    getToolbarSchemes(): object[];
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the control
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCustomToolbarItem(
      /**
       * The customToolbarItem whose index is looked for
       */
      oCustomToolbarItem: Control
    ): int;
    /**
     * Checks for the provided `sap.gantt.GanttChartBase` in the aggregation {@link #getGanttCharts ganttCharts}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfGanttChart(
      /**
       * The ganttChart whose index is looked for
       */
      oGanttChart: GanttChartBase
    ): int;
    /**
     * Inserts a customToolbarItem into the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCustomToolbarItem(
      /**
       * The customToolbarItem to insert; if empty, nothing is inserted
       */
      oCustomToolbarItem: Control,
      /**
       * The `0`-based index the customToolbarItem should be inserted at; for a negative value of `iIndex`, the
       * customToolbarItem is inserted at position 0; for a value greater than the current size of the aggregation,
       * the customToolbarItem is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a ganttChart into the aggregation {@link #getGanttCharts ganttCharts}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertGanttChart(
      /**
       * The ganttChart to insert; if empty, nothing is inserted
       */
      oGanttChart: GanttChartBase,
      /**
       * The `0`-based index the ganttChart should be inserted at; for a negative value of `iIndex`, the ganttChart
       * is inserted at position 0; for a value greater than the current size of the aggregation, the ganttChart
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCustomToolbarItems(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getGanttCharts ganttCharts}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllGanttCharts(): GanttChartBase[];
    /**
     * Removes a customToolbarItem from the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns The removed customToolbarItem or `null`
     */
    removeCustomToolbarItem(
      /**
       * The customToolbarItem to remove or its index or id
       */
      vCustomToolbarItem: int | string | Control
    ): Control | null;
    /**
     * Removes a ganttChart from the aggregation {@link #getGanttCharts ganttCharts}.
     *
     *
     * @returns The removed ganttChart or `null`
     */
    removeGanttChart(
      /**
       * The ganttChart to remove or its index or id
       */
      vGanttChart: int | string | GanttChartBase
    ): GanttChartBase | null;
    /**
     * Selects relationships and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    selectRelationships(
      /**
       * Index of the Gantt chart containing the relationships that you want to select
       */
      iGanttChartIndex?: int,
      /**
       * List of the relationships that you want to select
       */
      aIds?: any[],
      /**
       * Whether all other selected relationships are to be deselected
       */
      isExclusive?: boolean
    ): boolean;
    /**
     * Selects rows and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    selectRows(
      /**
       * Index of the Gantt chart containing the rows that you want to select
       */
      iGanttChartIndex?: int,
      /**
       * List of the rows that you want to select
       */
      aIds?: any[],
      /**
       * Whether all other selected rows are to be deselected
       */
      isExclusive?: boolean
    ): boolean;
    /**
     * Selects rows and all shapes contained in these rows.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    selectRowsAndShapes(
      /**
       * Index of the Gantt chart containing the rows and shapes that you want to select
       */
      iGanttChartIndex?: int,
      /**
       * Row UIDs
       */
      aIds?: any[],
      /**
       * Whether reset all other selected rows and shapes are to be reset
       */
      bIsExclusive?: boolean
    ): boolean;
    /**
     * Selects in-row shapes and returns a success code.
     *
     *
     * @returns - If any selection change is applied, returns true.
     */
    selectShapes(
      /**
       * Index of the Gantt chart containing the shapes that you want to select
       */
      iGanttChart?: int,
      /**
       * List of the shape IDs that you want to select
       */
      aIds?: any[],
      /**
       * Whether all other selected shapes are to be deselected
       */
      isExclusive?: boolean
    ): boolean;
    /**
     * Sets a new value for property {@link #getContainerLayoutKey containerLayoutKey}.
     *
     * Current container layout key.
     *
     * This is a key configured in configuration property `containerLayouts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_SINGLE_LAYOUT_KEY`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContainerLayoutKey(
      /**
       * New value for property `containerLayoutKey`
       */
      sContainerLayoutKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getContainerLayouts containerLayouts}.
     *
     * Configuration of container layouts.
     *
     * This configuration affects the data source selection ComboBox in the Container Toolbar. When the selection
     * changes, the `ganttChartChangeRequested` event that is triggered includes the corresponding layout key.
     * We recommend that you set the type of this argument to `sap.gantt.config.ContainerLayout[]`. Otherwise
     * some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_LAYOUTS`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContainerLayouts(
      /**
       * New value for property `containerLayouts`
       */
      sContainerLayouts?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getEnableAdhocLine enableAdhocLine}.
     *
     * Switch to enable and disable adhoc lines representing milestones and events along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableAdhocLine(
      /**
       * New value for property `enableAdhocLine`
       */
      bEnableAdhocLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableCursorLine enableCursorLine}.
     *
     * Switch to enable and disable the cursor line that follows the cursor.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableCursorLine(
      /**
       * New value for property `enableCursorLine`
       */
      bEnableCursorLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableNowLine enableNowLine}.
     *
     * Switch to enable and disable the present time indicator.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableNowLine(
      /**
       * New value for property `enableNowLine`
       */
      bEnableNowLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableTimeScrollSync enableTimeScrollSync}.
     *
     * Switch to enable and disable scroll synchronization by time on instances of aggregation `ganttCharts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableTimeScrollSync(
      /**
       * New value for property `enableTimeScrollSync`
       */
      bEnableTimeScrollSync?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableVerticalLine enableVerticalLine}.
     *
     * Switch to enable and disable vertical lines representing intervals along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableVerticalLine(
      /**
       * New value for property `enableVerticalLine`
       */
      bEnableVerticalLine?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getHierarchies hierarchies}.
     *
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_HIERARCHYS`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHierarchies(
      /**
       * New value for property `hierarchies`
       */
      sHierarchies?: object[]
    ): this;
    /**
     * Sets the aggregated {@link #getLegendContainer legendContainer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendContainer(
      /**
       * The legendContainer to set
       */
      oLegendContainer: LegendContainer
    ): this;
    /**
     * Sets a new value for property {@link #getMaxNumOfGanttCharts maxNumOfGanttCharts}.
     *
     * Define the maximum number of Gantt charts to be displayed on the same screen. When this number is reached,
     * the "Add Gantt Chart" button is grayed out.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `3`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxNumOfGanttCharts(
      /**
       * New value for property `maxNumOfGanttCharts`
       */
      iMaxNumOfGanttCharts?: int
    ): this;
    /**
     * Sets a new value for property {@link #getModes modes}.
     *
     * List of available modes. To apply modes to the toolbar and shapes, further configuration is needed. (specifically,
     * in property `toolbarSchemes`, and properties `toolbarSchemes` and `shapes` in the `GanttChartBase` class)If
     * not provided, a default configuration is provided. We recommend that you set the type of this argument
     * to `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_MODES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setModes(
      /**
       * New value for property `modes`
       */
      sModes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getSliderStep sliderStep}.
     *
     * Define the amount of units to change the time zoom slider.
     *
     * See {@link sap.m.Slider#setStep}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated (since 1.44) - please set the property 'stepCountOfSlider' in sap.gantt.config.TimeZoomGroup.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSliderStep(
      /**
       * New value for property `sliderStep`
       */
      iSliderStep: int
    ): this;
    /**
     * Sets a new value for property {@link #getSvgDefs svgDefs}.
     *
     * Definitions of paint servers used for advanced shape features around SVG fill, stroke, and filter attributes.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. It is easier to
     * assign a common paint server definition in this class instead of in separate instances of `sap.gantt.GanttChartBase`.
     * Then the definition is rendered only once. We recommend that you set the type of this argument to `sap.gantt.def.SvgDefs`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSvgDefs(
      /**
       * New value for property `svgDefs`
       */
      oSvgDefs?: object
    ): this;
    /**
     * Sets a new value for property {@link #getToolbarSchemes toolbarSchemes}.
     *
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.config.DEFAULT_CONTAINER_TOOLBAR_SCHEMES`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToolbarSchemes(
      /**
       * New value for property `toolbarSchemes`
       */
      sToolbarSchemes?: object[]
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the control
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Switches the splitter orientation.
     *
     *
     * @returns - `this`
     */
    switchOrientation(
      /**
       * Target orientation. If not provided, this method inverts the orientation.
       */
      vOrientation?: string,
      /**
       * If this value is provided, it overrides the target orientation from the current configuration indicated
       * by property `containerLayoutKey`.
       */
      bReadConfig?: boolean
    ): object;
    /**
     * Unbinds aggregation {@link #getCustomToolbarItems customToolbarItems} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindCustomToolbarItems(): this;
    /**
     * Unbinds aggregation {@link #getGanttCharts ganttCharts} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindGanttCharts(): this;
  }
  /**
   * Describes the settings that can be provided to the GanttChartContainer constructor.
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartContainer} should be used instead.
   */
  export interface $GanttChartContainerSettings extends $ControlSettings {
    /**
     * Width of the control
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the control
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to enable and disable scroll synchronization by time on instances of aggregation `ganttCharts`.
     */
    enableTimeScrollSync?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to enable and disable the cursor line that follows the cursor.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     */
    enableCursorLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to enable and disable the present time indicator.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     */
    enableNowLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to enable and disable vertical lines representing intervals along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     */
    enableVerticalLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Switch to enable and disable adhoc lines representing milestones and events along the time axis.
     *
     * When this value is set, it overrides the corresponding value on instances of aggregation `ganttCharts`.
     */
    enableAdhocLine?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Definitions of paint servers used for advanced shape features around SVG fill, stroke, and filter attributes.
     *
     * If this property is provided, the paint server definition of the SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed in in this property. It is easier to
     * assign a common paint server definition in this class instead of in separate instances of `sap.gantt.GanttChartBase`.
     * Then the definition is rendered only once. We recommend that you set the type of this argument to `sap.gantt.def.SvgDefs`.
     * Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    svgDefs?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * List of available modes. To apply modes to the toolbar and shapes, further configuration is needed. (specifically,
     * in property `toolbarSchemes`, and properties `toolbarSchemes` and `shapes` in the `GanttChartBase` class)If
     * not provided, a default configuration is provided. We recommend that you set the type of this argument
     * to `sap.gantt.config.Mode[]`. Otherwise some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    modes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * List of available toolbar schemes. If not provided, a default configuration is provided. We recommend
     * that you set the type of this argument to `sap.gantt.config.ToolbarScheme[]`. Otherwise some properties
     * you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    toolbarSchemes?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * List of available hierarchies. If not provided, a default configuration is provided. We recommend that
     * you set the type of this argument to `sap.gantt.config.Hierarchy[]`. Otherwise some properties you set
     * may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    hierarchies?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Configuration of container layouts.
     *
     * This configuration affects the data source selection ComboBox in the Container Toolbar. When the selection
     * changes, the `ganttChartChangeRequested` event that is triggered includes the corresponding layout key.
     * We recommend that you set the type of this argument to `sap.gantt.config.ContainerLayout[]`. Otherwise
     * some properties you set may not function properly.
     *
     * Restriction: It is defined as a property, and hence cannot be used in an XML view.
     */
    containerLayouts?: object[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Current container layout key.
     *
     * This is a key configured in configuration property `containerLayouts`.
     */
    containerLayoutKey?: string | PropertyBindingInfo;

    /**
     * Define the amount of units to change the time zoom slider.
     *
     * See {@link sap.m.Slider#setStep}
     *
     * @deprecated (since 1.44) - please set the property 'stepCountOfSlider' in sap.gantt.config.TimeZoomGroup.
     */
    sliderStep?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Define the maximum number of Gantt charts to be displayed on the same screen. When this number is reached,
     * the "Add Gantt Chart" button is grayed out.
     */
    maxNumOfGanttCharts?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Legend shown when the legend button is clicked.
     *
     * This aggregation is used only when the Legend button is configured to be shown in the container toolbar.
     */
    legendContainer?: LegendContainer;

    /**
     * Controls to be placed in the container toolbar.
     *
     * This aggregation is used only when the custom toolbar item group is configured to be shown in the
     * container toolbar. Different from the built-in buttons that are configured to be shown or hidden, these
     * controls are free controls created by the application, but are only placed in the container toolbar by
     * `sap.gantt.GanttChartContainer`.
     *
     * If the source selection group is enabled and you want your application to use a container layout pre-configured
     * for a specific source, you can implement your custom toolbar items in the event handler of event `ganttChartChangeRequested`.
     */
    customToolbarItems?:
      | Control[]
      | Control
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Gantt chart instances.
     *
     * If the source selection group is enabled and you want your application to use a container layout pre-configured
     * for a specific source, you can implement your custom toolbar items in the event handler of event `ganttChartChangeRequested`.
     * Provide a Gantt chart in compliance with the container layout setting. GanttChartContainer is designed
     * to support Gantt chart layouts that include multiple views.
     */
    ganttCharts?:
      | GanttChartBase[]
      | GanttChartBase
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Event fired when any change occurs in the toolbar that requests the application to change aggregation
     * `ganttCharts`.
     *
     * Possible triggers are:
     * 	 - The source selection group changes in the container toolbar.
     * 	 - The layout group button is clicked in the container toolbar.
     * 	 - The source selection group changes in the Gantt chart toolbar.
     */
    ganttChartChangeRequested?: (
      oEvent: GanttChartContainer$GanttChartChangeRequestedEvent
    ) => void;

    /**
     * Event fired when the custom settings are changed.
     *
     * The Custom settings are application-injected settings that can be configured in the Settings dialog box.
     * This event allows the application to handle these settings. Only check boxes are supported.
     */
    customSettingChange?: (
      oEvent: GanttChartContainer$CustomSettingChangeEvent
    ) => void;

    /**
     * Event fired when toggle node of the tree table.
     */
    treeTableToggleEvent?: (
      oEvent: GanttChartContainer$TreeTableToggleEventEvent
    ) => void;
  }

  /**
   * Parameters of the GanttChartContainer#customSettingChange event.
   */
  export interface GanttChartContainer$CustomSettingChangeEventParameters {
    /**
     * ID of the custom setting
     */
    id?: string;

    /**
     * The value of the custom setting
     */
    value?: boolean;
  }

  /**
   * Event object of the GanttChartContainer#customSettingChange event.
   */
  export type GanttChartContainer$CustomSettingChangeEvent = Event<
    GanttChartContainer$CustomSettingChangeEventParameters,
    GanttChartContainer
  >;

  /**
   * Parameters of the GanttChartContainer#ganttChartChangeRequested event.
   */
  export interface GanttChartContainer$GanttChartChangeRequestedEventParameters {
    /**
     * Action that caused the change.
     *
     * Possible action values are:
     * 	 - `'switchGanttChart'`: The source selection group of one Gantt chart toolbar is changed.
     * 	 - `'addGanttChart'`: The Add Gantt chart dropdown menu is selected.
     * 	 - `'lessGanttChart'`: The Less Gantt chart dropdown menu is selected.
     * 	 - `'switchContainerLayout'`: The source selection group of the Container toolbar is changed.
     */
    action?: string;

    /**
     * Provided for actions `'switchGanttChart'` and `'lessGanttChart'`.
     */
    ganttChartIndex?: int;

    /**
     * Provided for actions `'switchGanttChart'`, `'addGanttChart'` and `'lessGanttChart'`.
     */
    hierarchyKey?: string;

    /**
     * Provided for action `'switchGanttChart'`.
     */
    oldHierarchyKey?: string;

    /**
     * Provided for action `'switchContainerLayout'`.
     */
    containerLayoutKey?: string;
  }

  /**
   * Event object of the GanttChartContainer#ganttChartChangeRequested event.
   */
  export type GanttChartContainer$GanttChartChangeRequestedEvent = Event<
    GanttChartContainer$GanttChartChangeRequestedEventParameters,
    GanttChartContainer
  >;

  /**
   * Parameters of the GanttChartContainer#treeTableToggleEvent event.
   */
  export interface GanttChartContainer$TreeTableToggleEventEventParameters {
    /**
     * The index of the expanded/collapsed row.
     */
    rowIndex?: int;

    /**
     * The binding context of the selected row.
     */
    rowContext?: object;

    /**
     * flag whether the node has been expanded or collapsed.
     */
    expanded?: boolean;
  }

  /**
   * Event object of the GanttChartContainer#treeTableToggleEvent event.
   */
  export type GanttChartContainer$TreeTableToggleEventEvent = Event<
    GanttChartContainer$TreeTableToggleEventEventParameters,
    GanttChartContainer
  >;
}

declare module "sap/gantt/GanttChartWithTable" {
  import {
    default as GanttChartBase,
    $GanttChartBaseSettings,
  } from "sap/gantt/GanttChartBase";

  import Column from "sap/ui/table/Column";

  import Control from "sap/ui/core/Control";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SelectionPlugin from "sap/ui/table/plugins/SelectionPlugin";

  /**
   * Embed a `sap.ui.table.TreeTable` and a `sap.gantt.GanttChart` side-by-side.
   *
   * This class defines: The TreeTable part provide a column view of data with sorting/filtering functions
   * available. The svg chart part provide graphic Gantt chart view of data. Both width can be adjusted by
   * a splitter bar, and row scrolling are always synchronized.3
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartWithTable} should be used instead.
   */
  export default class GanttChartWithTable extends GanttChartBase {
    /**
     * Creates and initializes a new Gantt Chart with a TreeTable control on the left and a svg chart area on
     * the right.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $GanttChartWithTableSettings
    );
    /**
     * Creates and initializes a new Gantt Chart with a TreeTable control on the left and a svg chart area on
     * the right.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $GanttChartWithTableSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.GanttChartWithTable with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.GanttChartBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttChartWithTable>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.GanttChartWithTable.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some column to the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addColumn(
      /**
       * The column to add; if empty, nothing is inserted
       */
      oColumn: Column
    ): this;
    /**
     * Adds some customToolbarItem to the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCustomToolbarItem(
      /**
       * The customToolbarItem to add; if empty, nothing is inserted
       */
      oCustomToolbarItem: Control
    ): this;
    /**
     * Triggers automatic resizing of a column to the widest content.(experimental!)
     * See:
     * 	sap.ui.table.Table.autoResizeColumn
     */
    autoResizeColumn(
      /**
       * column id
       */
      iColId: int
    ): void;
    /**
     * Binds aggregation {@link #getCustomToolbarItems customToolbarItems} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindCustomToolbarItems(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the columns in the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyColumns(): this;
    /**
     * Destroys all the customToolbarItems in the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomToolbarItems(): this;
    /**
     * Gets current value of property {@link #getCellCallback cellCallback}.
     *
     * A customized cell callback function.
     *
     *  This property is used in combination with configuration property `hierarchies`. If aggregation `columns`
     * is provided, property `hierarchies` and `cellCallback` is ignored. Otherwise property `hierarchies` must
     * provide column configurations that cellCallback can consume. And if cellCallback is not provided, a default
     * cellCallback adds `sap.m.Label` to fill cells.
     *
     *
     * @returns Value of property `cellCallback`
     */
    getCellCallback(): object;
    /**
     * Gets content of aggregation {@link #getColumns columns}.
     *
     * Aggregation delegated to `sap.ui.table.Table`.
     *
     * If this aggregation is provided, call back property `cellCallBack` and column configuration in property
     * `hierarchies` will be ignored.
     */
    getColumns(): Column[];
    /**
     * Gets content of aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Controls to be place in Gantt chart toolbar.
     *
     * This aggregation is only used when custom toolbar item group is configured to be shown in Gantt chart
     * toolbar. Different from the build-in buttons which are configured to be shown or hidden, these are free
     * controls created by application, only they are placed in container toolbar by `sap.gantt.GanttChartWithTable`.
     *
     * A common recommendation is, if the source select group is enabled and application wants to pre-configure
     * container layouts, the chance to change custom toolbar items is in event handler to event `ganttChartSwitchRequested`.
     */
    getCustomToolbarItems(): Control[];
    /**
     * Gets the first visible row of the selection panel.
     * See:
     * 	sap.ui.table.Table.getFirstVisibleRow
     *
     * @deprecated (since 1.50.7) - We recommend use getTableProperties function instead
     *
     * @returns the first visible row index
     */
    getFirstVisibleRow(): int;
    /**
     * To get fixedColumnCount value
     * See:
     * 	sap.ui.table.Table.getFixedColumnCount
     *
     * @deprecated (since 1.50.7) - We recommend use getTableProperties function instead
     *
     * @returns The value of fixedColumnCount
     */
    getFixedColumnCount(): int;
    /**
     * Retrieves the lead selection index. The lead selection index is, among other things, used to determine
     * the start and end of a selection range, when using Shift-Click to select multiple entries.
     * See:
     * 	sap.ui.table.Table.getSelectedIndex
     *
     *
     * @returns An array containing all selected indexes (ascending ordered integers)
     */
    getSelectedIndex(): int[];
    /**
     * Returns the effective toolbar scheme key.
     *
     *
     * @returns - Toolbar scheme key.
     */
    getToolbarSchemeKey(): string;
    /**
     * Checks for the provided `sap.ui.table.Column` in the aggregation {@link #getColumns columns}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfColumn(
      /**
       * The column whose index is looked for
       */
      oColumn: Column
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCustomToolbarItem(
      /**
       * The customToolbarItem whose index is looked for
       */
      oCustomToolbarItem: Control
    ): int;
    /**
     * Inserts a column into the aggregation {@link #getColumns columns}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertColumn(
      /**
       * The column to insert; if empty, nothing is inserted
       */
      oColumn: Column,
      /**
       * The `0`-based index the column should be inserted at; for a negative value of `iIndex`, the column is
       * inserted at position 0; for a value greater than the current size of the aggregation, the column is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a customToolbarItem into the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCustomToolbarItem(
      /**
       * The customToolbarItem to insert; if empty, nothing is inserted
       */
      oCustomToolbarItem: Control,
      /**
       * The `0`-based index the customToolbarItem should be inserted at; for a negative value of `iIndex`, the
       * customToolbarItem is inserted at position 0; for a value greater than the current size of the aggregation,
       * the customToolbarItem is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Scrolls the visible chart area to a certain time.
     *
     * It can be used to implement the function of 'Jump To First', 'Jump To Last' and 'Jump To Current'.
     */
    jumpToPosition(
      /**
       * The date object to which the user wants the visible area to scroll.
       */
      oDate: Date
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getColumns columns}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllColumns(): Column[];
    /**
     * Removes all the controls from the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCustomToolbarItems(): Control[];
    /**
     * Removes a column from the aggregation {@link #getColumns columns}.
     *
     *
     * @returns The removed column or `null`
     */
    removeColumn(
      /**
       * The column to remove or its index or id
       */
      vColumn: int | string | Column
    ): Column | null;
    /**
     * Removes a customToolbarItem from the aggregation {@link #getCustomToolbarItems customToolbarItems}.
     *
     *
     * @returns The removed customToolbarItem or `null`
     */
    removeCustomToolbarItem(
      /**
       * The customToolbarItem to remove or its index or id
       */
      vCustomToolbarItem: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getCellCallback cellCallback}.
     *
     * A customized cell callback function.
     *
     *  This property is used in combination with configuration property `hierarchies`. If aggregation `columns`
     * is provided, property `hierarchies` and `cellCallback` is ignored. Otherwise property `hierarchies` must
     * provide column configurations that cellCallback can consume. And if cellCallback is not provided, a default
     * cellCallback adds `sap.m.Label` to fill cells.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCellCallback(
      /**
       * New value for property `cellCallback`
       */
      oCellCallback: object
    ): this;
    /**
     * Sets the first visible row in the selection panel.
     * See:
     * 	sap.ui.table.Table.setFirstVisibleRow
     *
     * @deprecated (since 1.50.7) - We recommend use setTableProperties function instead
     *
     * @returns A reference to the GanttChartWithTable control, which can be used for chaining
     */
    setFirstVisibleRow(
      /**
       * The row index to be set as the first visible row
       */
      iRowIndex: int
    ): this;
    /**
     * To set fixedColumnCount value
     * See:
     * 	sap.ui.table.Table.setFixedColumnCount
     *
     * @deprecated (since 1.50.7) - We recommend use setTableProperties function instead
     *
     * @returns A reference to the GanttChartWithTable control, which can be used for chaining
     */
    setFixedColumnCount(iFixedColumnCount: int): this;
    /**
     * Selects a row in the selection panel.
     * See:
     * 	sap.ui.table.Table.setSelectedIndex
     *
     *
     * @returns A reference to the GanttChartWithTable control, which can be used for chaining
     */
    setSelectedIndex(
      /**
       * The row index to be selected (if any exists)
       */
      iRowIndex: int
    ): this;
    /**
     * Allows to hide the hierarchy structure (tree icons, indentation) in left table. This might be useful
     * in some scenarios when the data is not hierarchical, no need for any expand/collapse. **Note:** In flat
     * mode the hierarchy is not visible to the user.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setUseFlatMode(
      /**
       * If set to `true`, the flat mode is enabled
       */
      bFlat: boolean
    ): void;
    /**
     * Unbinds aggregation {@link #getCustomToolbarItems customToolbarItems} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindCustomToolbarItems(): this;
    /**
     * Configures Gantt chart to use the provided selection plugin in its tables.
     *
     * @since 1.76
     */
    useSelectionPlugin(
      /**
       * Selection plugin to use. Passing an empty value disables any selection plugin that was used previously.
       */
      oSelectionPlugin: SelectionPlugin
    ): void;
  }
  /**
   * Describes the settings that can be provided to the GanttChartWithTable constructor.
   *
   * @deprecated (since 1.64) - {@link sap.gantt.simple.GanttChartWithTable} should be used instead.
   */
  export interface $GanttChartWithTableSettings
    extends $GanttChartBaseSettings {
    /**
     * A customized cell callback function.
     *
     *  This property is used in combination with configuration property `hierarchies`. If aggregation `columns`
     * is provided, property `hierarchies` and `cellCallback` is ignored. Otherwise property `hierarchies` must
     * provide column configurations that cellCallback can consume. And if cellCallback is not provided, a default
     * cellCallback adds `sap.m.Label` to fill cells.
     */
    cellCallback?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Property propagated from `sap.ui.table.Table`.
     *
     * @deprecated - We don't recommend use this property
     */
    fixedColumnCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Controls to be place in Gantt chart toolbar.
     *
     * This aggregation is only used when custom toolbar item group is configured to be shown in Gantt chart
     * toolbar. Different from the build-in buttons which are configured to be shown or hidden, these are free
     * controls created by application, only they are placed in container toolbar by `sap.gantt.GanttChartWithTable`.
     *
     * A common recommendation is, if the source select group is enabled and application wants to pre-configure
     * container layouts, the chance to change custom toolbar items is in event handler to event `ganttChartSwitchRequested`.
     */
    customToolbarItems?:
      | Control[]
      | Control
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Aggregation delegated to `sap.ui.table.Table`.
     *
     * If this aggregation is provided, call back property `cellCallBack` and column configuration in property
     * `hierarchies` will be ignored.
     */
    columns?: Column[] | Column | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/legend/DimensionLegend" {
  import {
    default as LegendBase,
    $LegendBaseSettings,
  } from "sap/gantt/legend/LegendBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Shape from "sap/gantt/config/Shape";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Dimension Legend provides a template for two-dimension legends. This template defines the representation
   * (shape, pattern, and color) of individual legend items and their corresponding meanings in both dimensions.
   *
   * Consider that you need to create a legend where legend items represent both the type and status of an
   * object. In this case, you can configure xDimention to indicate object types and yDimension to indicate
   * object statuses. Assume that valid object types are "Freight Order", "Freight Unit", and "Trailer Unit";
   * valid object statuses are "Executed", "In Execution", "Fixed", "Planned", and “Unplanned”. You will have
   * a three by four two-dimension legend containing twelve legend items. Each them represents an object in
   * a specific type and a specific status. For example, a red square stands for executed freight orders.
   *
   * @deprecated (since 1.64)
   */
  export default class DimensionLegend extends LegendBase {
    /**
     * Creates and initializes a new Dimension Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DimensionLegendSettings
    );
    /**
     * Creates and initializes a new Dimension Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DimensionLegendSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.legend.DimensionLegend with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.legend.LegendBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DimensionLegend>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.legend.DimensionLegend.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getExclude exclude}.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `exclude`
     */
    getExclude(): any[][];
    /**
     * Gets current value of property {@link #getLegendSpace legendSpace}.
     *
     * Space between two legend items.
     *
     * Default value is `8`.
     *
     *
     * @returns Value of property `legendSpace`
     */
    getLegendSpace(): float;
    /**
     * Gets current value of property {@link #getShape shape}.
     *
     * A Shape instance that contains two sets of data, one for the 'x' dimension and the other for the 'y'
     * dimension. The system determines the representation of a legend element according to its 'x' dimension
     * and 'y' dimension values.
     *
     *
     * @returns Value of property `shape`
     */
    getShape(): Shape;
    /**
     * Gets current value of property {@link #getXDimension xDimension}.
     *
     * Name of xDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     *
     *
     * @returns Value of property `xDimension`
     */
    getXDimension(): string;
    /**
     * Gets current value of property {@link #getXDomain xDomain}.
     *
     * Valid values of xDimension. Each of these values has a corresponding entry in the data set that matches
     * xDimension in the Shape instance.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `xDomain`
     */
    getXDomain(): any[];
    /**
     * Gets current value of property {@link #getYDimension yDimension}.
     *
     * Name of yDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     *
     *
     * @returns Value of property `yDimension`
     */
    getYDimension(): string;
    /**
     * Gets current value of property {@link #getYDomain yDomain}.
     *
     * Valid values of yDimension. Each of these values has a corresponding entry in the data set that matches
     * yDimension in the Shape instance.
     *
     * Default value is `[]`.
     *
     *
     * @returns Value of property `yDomain`
     */
    getYDomain(): any[];
    /**
     * Sets a new value for property {@link #getExclude exclude}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setExclude(
      /**
       * New value for property `exclude`
       */
      sExclude?: any[][]
    ): this;
    /**
     * Sets a new value for property {@link #getLegendSpace legendSpace}.
     *
     * Space between two legend items.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `8`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendSpace(
      /**
       * New value for property `legendSpace`
       */
      fLegendSpace?: float
    ): this;
    /**
     * Sets a new value for property {@link #getShape shape}.
     *
     * A Shape instance that contains two sets of data, one for the 'x' dimension and the other for the 'y'
     * dimension. The system determines the representation of a legend element according to its 'x' dimension
     * and 'y' dimension values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShape(
      /**
       * New value for property `shape`
       */
      sShape: Shape
    ): this;
    /**
     * Sets a new value for property {@link #getXDimension xDimension}.
     *
     * Name of xDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXDimension(
      /**
       * New value for property `xDimension`
       */
      sXDimension: string
    ): this;
    /**
     * Sets a new value for property {@link #getXDomain xDomain}.
     *
     * Valid values of xDimension. Each of these values has a corresponding entry in the data set that matches
     * xDimension in the Shape instance.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXDomain(
      /**
       * New value for property `xDomain`
       */
      sXDomain?: any[]
    ): this;
    /**
     * Sets a new value for property {@link #getYDimension yDimension}.
     *
     * Name of yDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYDimension(
      /**
       * New value for property `yDimension`
       */
      sYDimension: string
    ): this;
    /**
     * Sets a new value for property {@link #getYDomain yDomain}.
     *
     * Valid values of yDimension. Each of these values has a corresponding entry in the data set that matches
     * yDimension in the Shape instance.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `[]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYDomain(
      /**
       * New value for property `yDomain`
       */
      sYDomain?: any[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DimensionLegend constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $DimensionLegendSettings extends $LegendBaseSettings {
    /**
     * A Shape instance that contains two sets of data, one for the 'x' dimension and the other for the 'y'
     * dimension. The system determines the representation of a legend element according to its 'x' dimension
     * and 'y' dimension values.
     */
    shape?: Shape | PropertyBindingInfo | `{${string}}`;

    /**
     * Name of xDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     */
    xDimension?: string | PropertyBindingInfo;

    /**
     * Name of yDimension. Note that the Shape instance used in DimensionLegend must have a set of data matches
     * this property's value. The data set contains entries specifying the representation of individual legend
     * items.
     */
    yDimension?: string | PropertyBindingInfo;

    /**
     * Valid values of xDimension. Each of these values has a corresponding entry in the data set that matches
     * xDimension in the Shape instance.
     */
    xDomain?: any[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Valid values of yDimension. Each of these values has a corresponding entry in the data set that matches
     * yDimension in the Shape instance.
     */
    yDomain?: any[] | PropertyBindingInfo | `{${string}}`;

    exclude?: any[][] | PropertyBindingInfo | `{${string}}`;

    /**
     * Space between two legend items.
     */
    legendSpace?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/legend/LegendBase" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SvgDefs from "sap/gantt/def/SvgDefs";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for all legend template.
   *
   * This base class defines basic properties for legend templates. sap.gantt provides two basic implementations
   * of `LegendBase`:
   * 	 - `sap.gantt.legend.ListLegend` - A list legend template defines the representation of a list of legend
   *     items and their corresponding meanings
   * 	 - `sap.gantt.legend.DimensionLegend` - A dimension legend template defines the representation (shape,
   *     pattern, and color) of individual legend items and their corresponding meanings in both dimensions
   *
   *
   * @deprecated (since 1.64)
   */
  export default abstract class LegendBase extends Control {
    /**
     * Creates and initializes a new Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LegendBaseSettings
    );
    /**
     * Creates and initializes a new Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LegendBaseSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.legend.LegendBase with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LegendBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.legend.LegendBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getFontSize fontSize}.
     *
     * Font size of legend item texts.
     *
     * Default value is `16`.
     *
     *
     * @returns Value of property `fontSize`
     */
    getFontSize(): int;
    /**
     * Gets current value of property {@link #getLegendHeight legendHeight}.
     *
     * Height of a legend item.
     *
     * Default value is `32`.
     *
     *
     * @returns Value of property `legendHeight`
     */
    getLegendHeight(): float;
    /**
     * Gets current value of property {@link #getLegendWidth legendWidth}.
     *
     * Width of a legend item.
     *
     * Default value is `32`.
     *
     *
     * @returns Value of property `legendWidth`
     */
    getLegendWidth(): float;
    /**
     * Gets the value of the SAP UI size class.
     *
     *
     * @returns Value of the SAP UI size class.
     */
    getSapUiSizeClass(): string;
    /**
     * Gets the legend item height according to the SAP UI size class.
     *
     *
     * @returns Value of the legend item height.
     */
    getScaledLegendHeight(): string;
    /**
     * Gets the legend item width according to the SAP UI size class.
     *
     *
     * @returns Value of the legend item width.
     */
    getScaledLegendWidth(): string;
    /**
     * Gets current value of property {@link #getSvgDefs svgDefs}.
     *
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed to this property.
     *
     *
     * @returns Value of property `svgDefs`
     */
    getSvgDefs(): SvgDefs;
    /**
     * Sets a new value for property {@link #getFontSize fontSize}.
     *
     * Font size of legend item texts.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `16`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontSize(
      /**
       * New value for property `fontSize`
       */
      iFontSize?: int
    ): this;
    /**
     * Sets a new value for property {@link #getLegendHeight legendHeight}.
     *
     * Height of a legend item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `32`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendHeight(
      /**
       * New value for property `legendHeight`
       */
      fLegendHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getLegendWidth legendWidth}.
     *
     * Width of a legend item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `32`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegendWidth(
      /**
       * New value for property `legendWidth`
       */
      fLegendWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getSvgDefs svgDefs}.
     *
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed to this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSvgDefs(
      /**
       * New value for property `svgDefs`
       */
      sSvgDefs?: SvgDefs
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LegendBase constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $LegendBaseSettings extends $ControlSettings {
    /**
     * SVG reusable element definitions.
     *
     * If this property is provided, the paint server definition of SVG is rendered. Method `getDefString()`
     * should be implemented by all paint server classes that are passed to this property.
     */
    svgDefs?: SvgDefs | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of a legend item.
     */
    legendWidth?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of a legend item.
     */
    legendHeight?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Font size of legend item texts.
     */
    fontSize?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/legend/LegendContainer" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Page from "sap/m/Page";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import StandardListItem from "sap/m/StandardListItem";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The LegendContainer control uses the NavContainer control to handle hierarchical navigation between legend
   * sections. The LegendContainer control contains an initial navigation page. Both the initial navigation
   * page legend sections are Page controls.
   *
   * @deprecated (since 1.64)
   */
  export default class LegendContainer extends Control {
    /**
     * Creates and initializes a new legend container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LegendContainerSettings
    );
    /**
     * Creates and initializes a new legend container.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LegendContainerSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.legend.LegendContainer with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, LegendContainer>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.legend.LegendContainer.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some legendSection to the aggregation {@link #getLegendSections legendSections}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addLegendSection(
      /**
       * The legendSection to add; if empty, nothing is inserted
       */
      oLegendSection: Page
    ): this;
    /**
     * Destroys all the legendSections in the aggregation {@link #getLegendSections legendSections}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLegendSections(): this;
    /**
     * Returns the currently displayed legend section. If no legend section is added, this function returns
     * the initial navigation page.
     *
     *
     * @returns Control instance of the legend section
     */
    getCurrentLegendSection(): Page;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Height of the legend navigation. When the height specified is smaller than a section content, a vertical
     * scroll bar appears.
     *
     * Default value is `"200px"`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets content of aggregation {@link #getLegendSections legendSections}.
     *
     * This aggregation specifies the title of a legend section. When you add the legend section to a legend
     * navigation container, you must specify a title for the legend section so that the section can be identified
     * in the initial navigation list. Otherwise, your legend section is not reachable via GUI.
     */
    getLegendSections(): Page[];
    /**
     * Returns the navigation items in the initial navigation list
     *
     *
     * @returns Control instance of the initial page
     */
    getNavigationItems(): StandardListItem;
    /**
     * Returns the control instance of List Control for the initial navigation page
     *
     *
     * @returns Control instance of the initial navigation page
     */
    getNavigationPage(): Page;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Width of the legend navigation. When the width specified is smaller than a section content, a horizontal
     * scroll bar appears.width of the legend navigation. When the width specified is smaller than a section
     * content, a horizontal scroll bar appears.
     *
     * Default value is `"200px"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.m.Page` in the aggregation {@link #getLegendSections legendSections}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfLegendSection(
      /**
       * The legendSection whose index is looked for
       */
      oLegendSection: Page
    ): int;
    /**
     * Inserts a legendSection into the aggregation {@link #getLegendSections legendSections}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertLegendSection(
      /**
       * The legendSection to insert; if empty, nothing is inserted
       */
      oLegendSection: Page,
      /**
       * The `0`-based index the legendSection should be inserted at; for a negative value of `iIndex`, the legendSection
       * is inserted at position 0; for a value greater than the current size of the aggregation, the legendSection
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getLegendSections legendSections}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllLegendSections(): Page[];
    /**
     * Removes a legendSection from the aggregation {@link #getLegendSections legendSections}.
     *
     *
     * @returns The removed legendSection or `null`
     */
    removeLegendSection(
      /**
       * The legendSection to remove or its index or id
       */
      vLegendSection: int | string | Page
    ): Page | null;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * Height of the legend navigation. When the height specified is smaller than a section content, a vertical
     * scroll bar appears.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"200px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Width of the legend navigation. When the width specified is smaller than a section content, a horizontal
     * scroll bar appears.width of the legend navigation. When the width specified is smaller than a section
     * content, a horizontal scroll bar appears.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"200px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the LegendContainer constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $LegendContainerSettings extends $ControlSettings {
    /**
     * Width of the legend navigation. When the width specified is smaller than a section content, a horizontal
     * scroll bar appears.width of the legend navigation. When the width specified is smaller than a section
     * content, a horizontal scroll bar appears.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the legend navigation. When the height specified is smaller than a section content, a vertical
     * scroll bar appears.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * This aggregation specifies the title of a legend section. When you add the legend section to a legend
     * navigation container, you must specify a title for the legend section so that the section can be identified
     * in the initial navigation list. Otherwise, your legend section is not reachable via GUI.
     */
    legendSections?: Page[] | Page | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/legend/ListLegend" {
  import {
    default as LegendBase,
    $LegendBaseSettings,
  } from "sap/gantt/legend/LegendBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Shape from "sap/gantt/config/Shape";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * List Legend is a legend template that contains a list of shapes. You can use this class to define a list
   * legend.
   *
   * @deprecated (since 1.64)
   */
  export default class ListLegend extends LegendBase {
    /**
     * Creates and initializes a new List Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ListLegendSettings
    );
    /**
     * Creates and initializes a new List Legend class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ListLegendSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.legend.ListLegend with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.legend.LegendBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ListLegend>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.legend.ListLegend.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:checkBoxChange checkBoxChange} event of this
     * `sap.gantt.legend.ListLegend`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.legend.ListLegend` itself.
     *
     * Event fired when the check box of a certain legend item is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCheckBoxChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListLegend$CheckBoxChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.legend.ListLegend` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:checkBoxChange checkBoxChange} event of this
     * `sap.gantt.legend.ListLegend`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.legend.ListLegend` itself.
     *
     * Event fired when the check box of a certain legend item is selected.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCheckBoxChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ListLegend$CheckBoxChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.legend.ListLegend` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:checkBoxChange checkBoxChange} event of this
     * `sap.gantt.legend.ListLegend`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCheckBoxChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ListLegend$CheckBoxChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:checkBoxChange checkBoxChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCheckBoxChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ListLegend$CheckBoxChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getShapes shapes}.
     *
     * Shapes for legend items. These shapes are used in the Gantt chart.
     *
     *
     * @returns Value of property `shapes`
     */
    getShapes(): Shape[];
    /**
     * Sets a new value for property {@link #getShapes shapes}.
     *
     * Shapes for legend items. These shapes are used in the Gantt chart.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShapes(
      /**
       * New value for property `shapes`
       */
      sShapes: Shape[]
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ListLegend constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ListLegendSettings extends $LegendBaseSettings {
    /**
     * Shapes for legend items. These shapes are used in the Gantt chart.
     */
    shapes?: Shape[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Event fired when the check box of a certain legend item is selected.
     */
    checkBoxChange?: (oEvent: ListLegend$CheckBoxChangeEvent) => void;
  }

  /**
   * Parameters of the ListLegend#checkBoxChange event.
   */
  export interface ListLegend$CheckBoxChangeEventParameters {
    /**
     * The shape that is checked or unchecked.
     */
    legendType?: string;

    /**
     * The value of the check box.
     */
    value?: boolean;
  }

  /**
   * Event object of the ListLegend#checkBoxChange event.
   */
  export type ListLegend$CheckBoxChangeEvent = Event<
    ListLegend$CheckBoxChangeEventParameters,
    ListLegend
  >;
}

declare module "sap/gantt/misc/AxisOrdinal" {
  /**
   * The reusable functional class represents an instance of ordinal pattern coordinate mapping.
   */
  export default class AxisOrdinal {
    /**
     * Creates and initializes an AxisOrdinal class.
     */
    constructor(
      /**
       * Element array corresponding to an ordinal axis.
       */
      aElementArray: any[],
      /**
       * Scale array where each item represents one or more smallest width units in one-to-one relationship with
       * aAlementArray.
       */
      aScaleArray: any[],
      /**
       * Smallest width unit for elements.
       */
      nViewBandWidth: number,
      /**
       * Start position of an axis in the viewport area.
       */
      nViewRangeStart: number,
      /**
       * End position of an axis in the viewport area. The parameter is ignored if viewBandWidth is set.
       */
      nViewRangeEnd: number,
      /**
       * Zoom rate of the viewport area.
       */
      nZoomRate: number,
      /**
       * Zoom origin of the viewport area.
       */
      nZoomOrigin: number,
      /**
       * Padding for each band.
       */
      nPadding: number
    );

    /**
     * Clones a new AxisOrdinal from the current one.
     *
     *
     * @returns Reference to the newly created clone.
     */
    clone(): this;
    /**
     * Transforms an element to a position in the coordinate system
     *
     *
     * @returns Position in the coordinate system
     */
    elementToView(
      /**
       * Element that exists in parameter elementArray of the constructor
       */
      element: Object
    ): undefined;
    /**
     * Retrieves the value of elementArray.
     *
     *
     * @returns Value of elementArray.
     */
    getElementArray(): any[];
    /**
     * Retrieves the value of scaleArray.
     *
     *
     * @returns Value of scaleArray.
     */
    getScaleArray(): any[];
    /**
     * Retrieves the value of viewBandWidth.
     *
     *
     * @returns Value of viewBandWidth that indicates the smallest width unit for elements.
     */
    getViewBandWidth(): number;
    /**
     * Retrieves the view range of the current viewport area.
     *
     *
     * @returns Value of the view range containing the start and end positions.
     */
    getViewRange(): any[];
    /**
     * Retrieves the zoom origin.
     *
     *
     * @returns Zoom origin.
     */
    getZoomOrigin(): number;
    /**
     * Retrieves the value of zoom rate.
     *
     *
     * @returns Value of zoom rate.
     */
    getZoomRate(): number;
    /**
     * Sets a new value of elementArray with the corresponding scaleArray.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setElements(
      /**
       * New element array corresponding to an ordinal axis.
       */
      elementArray: any[],
      /**
       * Corresponding scale array where each item represents one or more smallest width units in one-to-one relationship
       * with elementArray.
       */
      scaleArray: any[]
    ): this;
    /**
     * Sets a new value of viewBandWidth.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setViewBandWidth(
      /**
       * Smallest width unit for elements.
       */
      viewBandWidth: number
    ): this;
    /**
     * Sets a new value of the end position of a view range.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setViewRangeEnd(
      /**
       * End position of axis in the viewport area. The parameter is ignored if viewBandWidth is set.
       */
      viewRangeEnd: number
    ): this;
    /**
     * Sets a new value of the start position of a view range.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setViewRangeStart(
      /**
       * Start position of an axis in the viewport area.
       */
      viewRangeStart: number
    ): this;
    /**
     * Sets the zoom origin.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setZoomOrigin(
      /**
       * Zoom origin of the viewport area.
       */
      zoomOrigin: number
    ): this;
    /**
     * Sets a new value of zoom rate.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setZoomRate(
      /**
       * New zoom rate of the viewport area.
       */
      zoomRate: number
    ): this;
    /**
     * Transforms a position in the coordinate system to a band index
     *
     *
     * @returns Index that describes which band the position is located in
     */
    viewToBandIndex(
      /**
       * A position in the coordinate system
       */
      value: number
    ): undefined;
    /**
     * Transforms a position in the coordinate system to an element
     *
     *
     * @returns Element that exists in parameter elementArray of the constructor
     */
    viewToElement(
      /**
       * Position in the coordinate system
       */
      value: number
    ): undefined;
    /**
     * Transforms a position in the coordinate system to an element index
     *
     *
     * @returns Index of the corresponding element that exists in parameter elementArray of the constructor
     */
    viewToElementIndex(
      /**
       * Position in the coordinate system
       */
      value: number
    ): undefined;
    /**
     * Transforms a position in the coordinate system to a row index
     *
     *
     * @returns Index of the corresponding row
     */
    viewToRowIndex(
      /**
       * Position in the coordinate system
       */
      value: number,
      /**
       * Max row index in the coordinate system
       */
      iMaxIndex: int
    ): undefined;
  }
}

declare module "sap/gantt/misc/AxisTime" {
  /**
   * The reusable functional class represents an instance of time-value linear coordinate mapping.
   */
  export default class AxisTime {
    /**
     * Creates and initializes an AxisTime class.
     */
    constructor(
      /**
       * The array must contain two or more dates that represent some ranges of data.
       */
      timeRange: any[],
      /**
       * The array must contain two or more values, to match the cardinality of timeRange, representing some ranges
       * of values.
       */
      viewRange: any[],
      /**
       * Zoom rate of the viewport area.
       */
      zoomRate: number,
      /**
       * Zoom origin of the viewport area.
       */
      zoomOrigin: number,
      /**
       * Offset of the viewport area.
       */
      viewOffset: number,
      /**
       * Settings for language, time zone, and daylight saving.
       */
      locale: object,
      /**
       * Specifies the strategy to zoom in/out.
       */
      oZoomStrategy: any[]
    );

    /**
     * Clones a new AxisTimes from the current one.
     *
     *
     * @returns Reference to the newly created clone.
     */
    clone(): this;
    /**
     * Retrieves a key of the time interval level in array oZoomStrategy.
     *
     * @deprecated (since 1.44) - replaced by sap.gantt.axistime.AxisTimeStrategyBase.getZoomLevel
     *
     * @returns Key of the time interval level in array oZoomStrategy.
     */
    getCurrentTickTimeIntervalKey(): string;
    /**
     * Retrieves an index of the time interval level in array oZoomStrategy.
     *
     * @deprecated (since 1.44) - replaced by sap.gantt.axistime.AxisTimeStrategyBase.getZoomLevel
     *
     * @returns Index of the time interval level in array oZoomStrategy.
     */
    getCurrentTickTimeIntervalLevel(): number;
    /**
     * Returns the index of first visible small interval label.
     *
     *
     * @returns Index of first visible small interval label.
     */
    getFirstSmallIntervalIndex(
      /**
       * Array of small interval labels on gantt header.
       */
      aSmallIntervalTicks: object,
      /**
       * Start time of gantt chart's visible horizon.
       */
      startTime: number
    ): int;
    /**
     * Retrieves an object containing the information of current time, its position, and label.
     *
     *
     * @returns Reference to an object containing the information of current time, its position, and label.
     */
    getNowLabel(
      /**
       * Convert date to UTC.
       */
      bTimeInUTC: boolean
    ): object;
    /**
     * Retrieves an array of time ticks, each item containing date position and label, for the specified level
     * within the given timeBoundary or viewBoundary.
     *
     *
     * @returns Reference to an array of time ticks, each item containing date, position, and label.
     */
    getTickTimeIntervalLabel(
      /**
       * Corresponding index in array oZoomStrategy.
       */
      level: number,
      /**
       * Time range within which time ticks are generated.
       */
      timeBoundary: number,
      /**
       * View range within which time ticks are generated. Available only when timeBoundary isn't specified.
       */
      viewBoundary: number
    ): object;
    /**
     * Retrieves the value of timeRange.
     *
     *
     * @returns Value of timeRange.
     */
    getTimeRange(): any[];
    /**
     * Calculate a slice of time range out of the total range
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getTimeRangeSlice(
      iStartX: int,

      iEndX: int
    ): void;
    /**
     * Retrieves the value of viewOffset.
     *
     *
     * @returns Value of viewOffset.
     */
    getViewOffset(): number;
    /**
     * Retrieves the value of viewRange.
     *
     *
     * @returns Value of viewRange.
     */
    getViewRange(): any[];
    /**
     * Retrieves the value of zoomOrigin.
     *
     *
     * @returns Value of zoomOrigin.
     */
    getZoomOrigin(): number;
    /**
     * Retrieves the value of zoomRate.
     *
     *
     * @returns Value of zoomRate.
     */
    getZoomRate(): number;
    /**
     * Retrieves the value of oZoomStrategy.
     *
     *
     * @returns Value of oZoomStrategy.
     */
    getZoomStrategy(): object;
    /**
     * Sets a new value of timeRange.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setTimeRange(
      /**
       * New value of timeRange.
       */
      timeRange: any[]
    ): this;
    /**
     * Sets a new value of viewOffset.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setViewOffset(
      /**
       * New value of viewOffset.
       */
      viewOffset: number
    ): this;
    /**
     * Sets a new value of viewRange.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setViewRange(
      /**
       * New value of viewRange.
       */
      viewRange: any[]
    ): this;
    /**
     * Sets a new value of zoomOrigin.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setZoomOrigin(
      /**
       * New value of zoomOrigin.
       */
      zoomOrigin: number
    ): this;
    /**
     * Sets a new value of zoomRate.
     *
     *
     * @returns Reference to this in order to allow method chaining.
     */
    setZoomRate(
      /**
       * New value of zoomRate.
       */
      zoomRate: number
    ): this;
    /**
     * Given a date within the timeRange, this function returns the corresponding value within the viewRange.
     *
     *
     * @returns Value corresponding to the given date within the viewRange.
     */
    timeToView(
      /**
       * Given date within the timeRange.
       */
      time: Date
    ): number;
    /**
     * Returns the date within the timeRange for the corresponding value within the viewRange.
     *
     *
     * @returns Date corresponding to the given value within the timeRange
     */
    viewToTime(
      /**
       * Given value within the viewRange.
       */
      value: number
    ): Date;
  }
}

declare module "sap/gantt/misc/Format" {
  import Locale from "sap/gantt/config/Locale";

  /**
   * The Format class provides static methods for formatting dates, times, and timestamps to be used in sap.gantt
   */
  export default class Format {
    /**
     * A dummy constructor for Format. Do not construct a Format object; instead, call static methods abapTimestampToDate,
     * dateToAbapTimestamp, and abapTimestampToTimeLabel directly.
     */
    constructor();

    /**
     * Converts an ABAP timestamp(eg:"20150909000000" ) into a Date instance.
     *
     *
     * @returns The output date instance
     */
    static abapTimestampToDate(
      /**
       * The ABAP timestamp to convert
       */
      sTimestamp: string
    ): Date;
    /**
     * Converts an ABAP timestamp into a time label to be used in Gantt.
     *
     *
     * @returns The output time label
     */
    static abapTimestampToTimeLabel(
      /**
       * The ABAP timestamp to convert
       */
      sTimestamp: string,
      /**
       * The locale object has the time zone and DST info; this determines how the function converts the timestamp
       * into a locale-specific time label
       */
      oLocale: Locale
    ): string;
    /**
     * Converts an absolute time object into a relative time object, which contains the following properties:
     * { intervalDays: * difference in the day segment between the target time and base time*, intervalHours:
     * * difference in the hour segment between the target time and base time*, intervalMinutes: * difference
     * in the minute segment between the target time and base time*, intervalSecond: * difference in the segment
     * segment between the target time and base time* } Use this method only in relative time axis mode.
     *
     *
     * @returns relative time information object
     */
    static absolutTimeToRelativeTime(
      /**
       * the absolute time object will be converted
       */
      oTime: Date
    ): object;
    /**
     * Converts a Date instance into an ABAP timestamp.
     *
     *
     * @returns The output ABAP timestamp
     */
    static dateToAbapTimestamp(
      /**
       * The date instance to convert
       */
      oDate: Date
    ): string;
    /**
     * Converts an ISO timestamp (example: "2021-04-19T17:13:10.000Z") into an ABAP timestamp.
     *
     *
     * @returns The output ABAP timestamp
     */
    static isoTimestampToAbapTimestamp(
      /**
       * The ISO timestamp to convert
       */
      sTimestamp: string
    ): string;
    /**
     * Converts a relative time object into an absolute time object. Use this method only in relative time axis
     * mode.
     *
     *
     * @returns converted absolute time object
     */
    static relativeTimeToAbsolutTime(
      /**
       * difference in the day segment between the target time and base time
       */
      iIntervalDays: int,
      /**
       * difference in the hour segment between the target time and base time
       */
      iIntervalHours: int,
      /**
       * difference in the minute segment between the target time and base time
       */
      iIntervalMinutes: int,
      /**
       * difference in the second segment between the target time and base time
       */
      iIntervalSeconds: int
    ): Date;
  }
}

declare module "sap/gantt/overlays/GanttRowOverlay" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Overlay from "sap/gantt/overlays/Overlay";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The GanttRowOverlay class contains staticOverlay and expanded aggregations that are of type Overlay.
   *
   * @since 1.120
   * @experimental (since 1.120)
   */
  export default class GanttRowOverlay extends UI5Element {
    /**
     * Creates and initializes a new GanttRowOverlay class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if an ID is not provided.
       */
      sId?: string
    );

    /**
     * Creates a new subclass of class sap.gantt.overlays.GanttRowOverlay with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, GanttRowOverlay>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.overlays.GanttRowOverlay.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some expandedOverlay to the aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addExpandedOverlay(
      /**
       * The expandedOverlay to add; if empty, nothing is inserted
       */
      oExpandedOverlay: Overlay
    ): this;
    /**
     * Adds some staticOverlay to the aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addStaticOverlay(
      /**
       * The staticOverlay to add; if empty, nothing is inserted
       */
      oStaticOverlay: Overlay
    ): this;
    /**
     * Destroys all the expandedOverlay in the aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyExpandedOverlay(): this;
    /**
     * Destroys all the staticOverlay in the aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyStaticOverlay(): this;
    /**
     * Gets content of aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     */
    getExpandedOverlay(): Overlay[];
    /**
     * Gets content of aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     */
    getStaticOverlay(): Overlay[];
    /**
     * Checks for the provided `sap.gantt.overlays.Overlay` in the aggregation {@link #getExpandedOverlay expandedOverlay}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfExpandedOverlay(
      /**
       * The expandedOverlay whose index is looked for
       */
      oExpandedOverlay: Overlay
    ): int;
    /**
     * Checks for the provided `sap.gantt.overlays.Overlay` in the aggregation {@link #getStaticOverlay staticOverlay}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfStaticOverlay(
      /**
       * The staticOverlay whose index is looked for
       */
      oStaticOverlay: Overlay
    ): int;
    /**
     * Inserts a expandedOverlay into the aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertExpandedOverlay(
      /**
       * The expandedOverlay to insert; if empty, nothing is inserted
       */
      oExpandedOverlay: Overlay,
      /**
       * The `0`-based index the expandedOverlay should be inserted at; for a negative value of `iIndex`, the
       * expandedOverlay is inserted at position 0; for a value greater than the current size of the aggregation,
       * the expandedOverlay is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a staticOverlay into the aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertStaticOverlay(
      /**
       * The staticOverlay to insert; if empty, nothing is inserted
       */
      oStaticOverlay: Overlay,
      /**
       * The `0`-based index the staticOverlay should be inserted at; for a negative value of `iIndex`, the staticOverlay
       * is inserted at position 0; for a value greater than the current size of the aggregation, the staticOverlay
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllExpandedOverlay(): Overlay[];
    /**
     * Removes all the controls from the aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllStaticOverlay(): Overlay[];
    /**
     * Removes a expandedOverlay from the aggregation {@link #getExpandedOverlay expandedOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns The removed expandedOverlay or `null`
     */
    removeExpandedOverlay(
      /**
       * The expandedOverlay to remove or its index or id
       */
      vExpandedOverlay: int | string | Overlay
    ): Overlay | null;
    /**
     * Removes a staticOverlay from the aggregation {@link #getStaticOverlay staticOverlay}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns The removed staticOverlay or `null`
     */
    removeStaticOverlay(
      /**
       * The staticOverlay to remove or its index or id
       */
      vStaticOverlay: int | string | Overlay
    ): Overlay | null;
  }
  /**
   * Describes the settings that can be provided to the GanttRowOverlay constructor.
   *
   * @experimental (since 1.120)
   */
  export interface $GanttRowOverlaySettings extends $ElementSettings {
    /**
     * @since 1.120
     * @experimental (since 1.120)
     */
    staticOverlay?:
      | Overlay[]
      | Overlay
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * @since 1.120
     * @experimental (since 1.120)
     */
    expandedOverlay?:
      | Overlay[]
      | Overlay
      | AggregationBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/gantt/overlays/Overlay" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import BaseShape from "sap/gantt/simple/BaseShape";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The Overlay class contains a shape aggregation to draw any Gantt 2.0 supported shapes as an overlay at
   * specific time points in the chart area.
   *
   * @since 1.120
   * @experimental (since 1.120)
   */
  export default class Overlay extends UI5Element {
    /**
     * Creates and initializes a new Overlay class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if an ID is not provided.
       */
      sId?: string
    );

    /**
     * Creates a new subclass of class sap.gantt.overlays.Overlay with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Overlay>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.overlays.Overlay.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the shape in the aggregation {@link #getShape shape}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyShape(): this;
    /**
     * Gets current value of property {@link #getOverlayLevel overlayLevel}.
     *
     * Default value is `1`.
     *
     * @since 1.120
     * @experimental (since 1.120) - level defined for an overlay shape that is to be added on the expansion
     * of a row.
     *
     * @returns Value of property `overlayLevel`
     */
    getOverlayLevel(): int;
    /**
     * Gets current value of property {@link #getOverlayShapeId overlayShapeId}.
     *
     * @since 1.120
     * @experimental (since 1.120) - shape id for an overlay shape that is to be added on the expansion of a
     * row, this is valid for the shape bound overlay. this id should match with the shape id that must be associated.
     * this property has precedence over "overlayLevel" property incase of shape bound overlay.
     *
     * @returns Value of property `overlayShapeId`
     */
    getOverlayShapeId(): string;
    /**
     * Gets content of aggregation {@link #getShape shape}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     */
    getShape(): BaseShape;
    /**
     * Sets a new value for property {@link #getOverlayLevel overlayLevel}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @since 1.120
     * @experimental (since 1.120) - level defined for an overlay shape that is to be added on the expansion
     * of a row.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverlayLevel(
      /**
       * New value for property `overlayLevel`
       */
      iOverlayLevel?: int
    ): this;
    /**
     * Sets a new value for property {@link #getOverlayShapeId overlayShapeId}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.120
     * @experimental (since 1.120) - shape id for an overlay shape that is to be added on the expansion of a
     * row, this is valid for the shape bound overlay. this id should match with the shape id that must be associated.
     * this property has precedence over "overlayLevel" property incase of shape bound overlay.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverlayShapeId(
      /**
       * New value for property `overlayShapeId`
       */
      sOverlayShapeId: string
    ): this;
    /**
     * Sets the aggregated {@link #getShape shape}.
     *
     * @since 1.120
     * @experimental (since 1.120)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShape(
      /**
       * The shape to set
       */
      oShape: BaseShape
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Overlay constructor.
   *
   * @experimental (since 1.120)
   */
  export interface $OverlaySettings extends $ElementSettings {
    /**
     * @since 1.120
     * @experimental (since 1.120) - level defined for an overlay shape that is to be added on the expansion
     * of a row.
     */
    overlayLevel?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * @since 1.120
     * @experimental (since 1.120) - shape id for an overlay shape that is to be added on the expansion of a
     * row, this is valid for the shape bound overlay. this id should match with the shape id that must be associated.
     * this property has precedence over "overlayLevel" property incase of shape bound overlay.
     */
    overlayShapeId?: string | PropertyBindingInfo;

    /**
     * @since 1.120
     * @experimental (since 1.120)
     */
    shape?: BaseShape;
  }
}

declare module "sap/gantt/shape/cal/Calendar" {
  import {
    default as Rectangle,
    $RectangleSettings,
  } from "sap/gantt/shape/Rectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Calendar shape.
   *
   *  The Calendar shape must be used in combination with Calendar def class {@link sap.gantt.def.cal.Calendar }
   * which draws SVG 'defs' tag.
   *
   * @deprecated (since 1.64)
   */
  export default class Calendar extends Rectangle {
    /**
     * Creates a Calendar shape which consumes pattern from Calendar in 'def' package.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );
    /**
     * Creates a Calendar shape which consumes pattern from Calendar in 'def' package.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CalendarSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.cal.Calendar with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Rectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Calendar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.cal.Calendar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `calendarName`.
     *
     *  Calendar key.
     *
     * This property is used to generate referencing string to compose the `fill` property. This property is
     * must provided.
     *
     *
     * @returns Value of property `calendarName`.
     */
    getCalendarName(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `enableSelection`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `fill`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `height`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `isBulk`.
     *
     * General recommendation is don't configure or code against this property.
     *
     *
     * @returns Value of property `isBulk`.
     */
    getIsBulk(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `width`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `x`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `y`.
     *
     * General recommendation is don't configure or code against this property. Calendar is treated as a bulk
     * shape filled with pattern occupying visible chart area. Application should implement their own shape
     * if a select able calendar is expected.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getCalendarName calendarName}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"nwt"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarName(
      /**
       * New value for property `calendarName`
       */
      sCalendarName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSelection enableSelection}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSelection(
      /**
       * New value for property `enableSelection`
       */
      bEnableSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsBulk isBulk}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsBulk(
      /**
       * New value for property `isBulk`
       */
      bIsBulk?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Calendar constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $CalendarSettings extends $RectangleSettings {
    isBulk?: boolean | PropertyBindingInfo | `{${string}}`;

    enableSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    calendarName?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/Circle" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Circle shape class using SVG tag 'circle'. This shape is usually used to represent points in time.
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Circle extends Shape {
    /**
     * Creates and initializes a new Circle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CircleSettings
    );
    /**
     * Creates and initializes a new Circle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CircleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Circle with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Circle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Circle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `cx`.
     *
     *  x coordinate of the center of the circle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using the `time`
     * property as a base and makes some adjustments.
     *
     *
     * @returns Value of property `cx`.
     */
    getCx(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the current value of property `cy`.
     *
     *  y coordinate of the center of the circle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`
     * as a base and makes some adjustments to align the center of the row rectangle along the y axis. If you
     * override the default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     * @returns Value of property `cy`.
     */
    getCy(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `r`.
     *
     *  Radius of the circle.
     *
     *
     * @returns Value of property `r`.
     */
    getR(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getCx cx}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCx(
      /**
       * New value for property `cx`
       */
      fCx: float
    ): this;
    /**
     * Sets a new value for property {@link #getCy cy}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCy(
      /**
       * New value for property `cy`
       */
      fCy: float
    ): this;
    /**
     * Sets a new value for property {@link #getR r}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setR(
      /**
       * New value for property `r`
       */
      fR?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"circle"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Circle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $CircleSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    cx?: float | PropertyBindingInfo | `{${string}}`;

    cy?: float | PropertyBindingInfo | `{${string}}`;

    r?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ClipPath" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import Path from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Clippath shape class using SVG container tag 'clippath'. It is usually used together with {@link sap.gantt.shape.Path }
   * as aggregations, and referenced by other shapes by URL.
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class ClipPath extends Shape {
    /**
     * Creates and initializes a new Clippath class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ClipPathSettings
    );
    /**
     * Creates and initializes a new Clippath class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ClipPathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ClipPath with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ClipPath>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ClipPath.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some path to the aggregation {@link #getPaths paths}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPath(
      /**
       * The path to add; if empty, nothing is inserted
       */
      oPath: Path
    ): this;
    /**
     * Destroys all the paths in the aggregation {@link #getPaths paths}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPaths(): this;
    /**
     * Gets content of aggregation {@link #getPaths paths}.
     *
     * Paths defining the clipPath.
     */
    getPaths(): Path[];
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Checks for the provided `sap.gantt.shape.Path` in the aggregation {@link #getPaths paths}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPath(
      /**
       * The path whose index is looked for
       */
      oPath: Path
    ): int;
    /**
     * Inserts a path into the aggregation {@link #getPaths paths}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPath(
      /**
       * The path to insert; if empty, nothing is inserted
       */
      oPath: Path,
      /**
       * The `0`-based index the path should be inserted at; for a negative value of `iIndex`, the path is inserted
       * at position 0; for a value greater than the current size of the aggregation, the path is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getPaths paths}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPaths(): Path[];
    /**
     * Removes a path from the aggregation {@link #getPaths paths}.
     *
     *
     * @returns The removed path or `null`
     */
    removePath(
      /**
       * The path to remove or its index or id
       */
      vPath: int | string | Path
    ): Path | null;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"clippath"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ClipPath constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ClipPathSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    /**
     * Paths defining the clipPath.
     */
    paths?: Path[] | Path | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/Definitions" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for all SVG definitions. It is different from the svgDefs in `GanttChartBase`. It is a container
   * shape and related to shape data.
   *
   *  SVG uses the 'defs' tag to represent graphic objects that can be reused at a later time. Currently
   * `sap.gantt` provides defs like TextRepeat. Applications can also extend this base class to support more
   * functionality.
   *
   * @deprecated (since 1.64)
   */
  export default class Definitions extends Shape {
    /**
     * Creates and initializes a new SVG graphic object according to shape data.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DefinitionsSettings
    );
    /**
     * Creates and initializes a new SVG graphic object according to shape data.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DefinitionsSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Definitions with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Definitions>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Definitions.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of the `childTagName` property.
     *
     * The 'defs' element is a container element for referenced elements. The content model for 'defs' is the
     * same as that for the 'g' element; thus, any element that can be a child of a 'g' can also be a child
     * of a 'defs'. The 'childTagName' is the name of any child element of 'defs'.
     *
     *
     *
     * @returns Value of the `childTagName` property.
     */
    getChildTagName(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property {@link #getContent content}.
     *
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `content`
     */
    getContent(): string;
    /**
     * Gets current value of property {@link #getReferenceId referenceId}.
     *
     * Unique id for definition.
     *
     *
     * @returns Value of property `referenceId`
     */
    getReferenceId(): string;
    /**
     * Gets the value of the `tag` property.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of the `tag` property.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getChildTagName childTagName}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChildTagName(
      /**
       * New value for property `childTagName`
       */
      sChildTagName: string
    ): this;
    /**
     * Sets a new value for property {@link #getContent content}.
     *
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * New value for property `content`
       */
      sContent?: string
    ): this;
    /**
     * Sets a new value for property {@link #getReferenceId referenceId}.
     *
     * Unique id for definition.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setReferenceId(
      /**
       * New value for property `referenceId`
       */
      sReferenceId: string
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"defs"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Definitions constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $DefinitionsSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    childTagName?: string | PropertyBindingInfo;

    /**
     * Definition string. Subclasses can implement their own getters of this property to override the one in
     * this class.
     */
    content?: string | PropertyBindingInfo;

    /**
     * Unique id for definition.
     */
    referenceId?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/ext/Chevron" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Chevron shape class using SVG tag 'path'. It's usually used to represent a duration of time.
   *
   *  The following SVG image shows how the properties are designed:
   *
   *             time endTime rotation Center
   * height tailLength headLength
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Chevron extends Path {
    /**
     * Creates and initializes a new Chevron class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $ChevronSettings
    );
    /**
     * Creates and initializes a new Chevron class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $ChevronSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Chevron with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Chevron>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Chevron.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of the path element.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of d by using
     * property `time`, `endTime`, `tailLength`, `headLength`, and `height`.
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `headLength`.
     *
     *  Head length of a chevron shape.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `headLength`.
     */
    getHeadLength(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  Height of a chevron shape.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `isClosed`.
     *
     *
     * @returns Value of property `isClosed`.
     */
    getIsClosed(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `isDuration`.
     *
     *
     * @returns Value of property `isDuration`.
     */
    getIsDuration(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `tailLength`.
     *
     *  Tail length of a chevron shape.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `tailLength`.
     */
    getTailLength(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getHeadLength headLength}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeadLength(
      /**
       * New value for property `headLength`
       */
      fHeadLength?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `15`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsDuration isDuration}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDuration(
      /**
       * New value for property `isDuration`
       */
      bIsDuration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTailLength tailLength}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTailLength(
      /**
       * New value for property `tailLength`
       */
      fTailLength?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Chevron constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ChevronSettings extends $PathSettings {
    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    isDuration?: boolean | PropertyBindingInfo | `{${string}}`;

    headLength?: float | PropertyBindingInfo | `{${string}}`;

    tailLength?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/Cursor" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Cursor shape class using SVG tag 'path'. It's usually treated as a transient shape.
   *
   *  The following SVG image shows how the properties are designed:
   *
   *
   *        time
   * rotation Center
   * length width
   * point Height
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Cursor extends Path {
    /**
     * Creates and initializes a new Cursor class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $CursorSettings
    );
    /**
     * Creates and initializes a new Cursor class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $CursorSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Cursor with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Cursor>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Cursor.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of the path element.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of d by using
     * properties `length`, `width`, and `pointHeight`. The value of these properties can be retrieved using
     * the corresponding getters (getLength, getWidth, and getPointHeight).
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `isClosed`.
     *
     *
     * @returns Value of property `isClosed`.
     */
    getIsClosed(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `length`.
     *
     *  Length of a cursor.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `length`.
     */
    getLength(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `pointHeight`.
     *
     *  Point height of a cursor.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `pointHeight`.
     */
    getPointHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `width`.
     *
     *  Width of a cursor.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLength length}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLength(
      /**
       * New value for property `length`
       */
      fLength?: float
    ): this;
    /**
     * Sets a new value for property {@link #getPointHeight pointHeight}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPointHeight(
      /**
       * New value for property `pointHeight`
       */
      fPointHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Cursor constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $CursorSettings extends $PathSettings {
    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    length?: float | PropertyBindingInfo | `{${string}}`;

    width?: float | PropertyBindingInfo | `{${string}}`;

    pointHeight?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/Diamond" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Diamond shape class using SVG tag 'path'. It's usually treated as transient shape.
   *
   *  The following SVG image shows how the properties are designed:
   *
   *
   *       time rotation Center horizontalDiagonal vertitalDiagonal
   *
   * @deprecated (since 1.64)
   */
  export default class Diamond extends Path {
    /**
     * Creates and initializes a new Diamond class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $DiamondSettings
    );
    /**
     * Creates and initializes a new Diamond class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $DiamondSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Diamond with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Diamond>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Diamond.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of the path element.
     *
     * You application should not configure this value. Instead, the getter calculates value of d by using properties
     * `horizontalDiagonal` and `verticalDiagonal`. The value of these properties can be retrieved using the
     * corresponding getters (getHorizontalDiagonal and getVerticalDiagonal).
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `horizontalDiagonal`.
     *
     *  Horizontal diagonal of a diamond shape.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `horizontalDiagonal`.
     */
    getHorizontalDiagonal(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `isClosed`.
     *
     *
     * @returns Value of property `isClosed`.
     */
    getIsClosed(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `verticalDiagonal`.
     *
     *  Vertical diagonal of a diamond shape.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `verticalDiagonal`.
     */
    getVerticalDiagonal(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getHorizontalDiagonal horizontalDiagonal}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `12`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalDiagonal(
      /**
       * New value for property `horizontalDiagonal`
       */
      fHorizontalDiagonal?: float
    ): this;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getVerticalDiagonal verticalDiagonal}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `12`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalDiagonal(
      /**
       * New value for property `verticalDiagonal`
       */
      fVerticalDiagonal?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Diamond constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $DiamondSettings extends $PathSettings {
    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    verticalDiagonal?: float | PropertyBindingInfo | `{${string}}`;

    horizontalDiagonal?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/Iconfont" {
  import { default as Text, $TextSettings } from "sap/gantt/shape/Text";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Iconfont shape class using SVG tag 'text'. This shape is usually used to display icons in Gantt chart.
   *
   * @deprecated (since 1.64)
   */
  export default class Iconfont extends Text {
    /**
     * Creates and initializes a new Iconfont class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $IconfontSettings
    );
    /**
     * Creates and initializes a new Iconfont class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $IconfontSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Iconfont with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Text.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Iconfont>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Iconfont.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `collectionName`.
     *
     *  The collectionName of iconfont as mentioned in property `text`
     *
     *
     * @returns Value of property `collectionName`.
     */
    getCollectionName(
      /**
       * Shape data.
       */
      oData: object
    ): string;
    /**
     * Gets the value of property `fontFamily`.
     *
     *  Font family of Iconfont.
     *
     *
     * @returns Value of property `fontFamily`.
     */
    getFontFamily(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `name`.
     *
     *  The name of iconfont as mentioned in property `text`
     *
     *
     * @returns Value of property `name`.
     */
    getName(
      /**
       * Shape data.
       */
      oData: object
    ): string;
    /**
     * Gets the value of property `text`.
     *
     *  The text string of iconfont is read via {@link sap.ui.IconPool.getIconInfo} passing Name and CollectionName
     * as parameters. To use the SAP openui5 predefined icons, don't set the property CollectionName. To use
     * the icons in other collections, you need register first. For example, after calling function sap.ushell.iconfonts.registerFiori2IconFont,
     * then you can use the icon collection with names "BusinessSuiteInAppSymbols", "Fiori2"...
     *
     *
     * @returns Value of property `text`.
     */
    getText(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getCollectionName collectionName}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCollectionName(
      /**
       * New value for property `collectionName`
       */
      sCollectionName: string
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Iconfont constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $IconfontSettings extends $TextSettings {
    name?: string | PropertyBindingInfo;

    collectionName?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/ext/Pentangle" {
  import {
    default as Polygon,
    $PolygonSettings,
  } from "sap/gantt/shape/Polygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Pentangle shape class using SVG tag 'polygon'. It's usually treated as a transient shape.
   *
   *  Following SVG image shows how the properties are designed:
   *
   *            time rotation Center radius radius2
   *
   * @deprecated (since 1.64)
   */
  export default class Pentangle extends Polygon {
    /**
     * Creates and initializes a new Pentangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $PentangleSettings
    );
    /**
     * Creates and initializes a new Pentangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $PentangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Pentangle with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Polygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Pentangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Pentangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  points attribute of the polygon element.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of d by using
     * properties `radius` and `radus2`. The value of these properties can be retrieved using the corresponding
     * getters (getRadius and getRadius2). If your application overwrites the value of d by configuration or
     * code, accurate results cannot be guaranteed.
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `radius`.
     *
     *  Radius of a pentangle shape.
     *
     * This property influences property `points`.
     *
     *
     * @returns Value of property `radius`.
     */
    getRadius(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `radius2`.
     *
     *  The second radius of a pentangle shape. If this property is not provided, radius2 is set to a value
     * making radius and radius2 fit the golden ratio.
     *
     * This property influences property `points`.
     *
     *
     * @returns Value of property `radius2`.
     */
    getRadius2(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getRadius radius}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius(
      /**
       * New value for property `radius`
       */
      fRadius?: float
    ): this;
    /**
     * Sets a new value for property {@link #getRadius2 radius2}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `undefined`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRadius2(
      /**
       * New value for property `radius2`
       */
      fRadius2?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Pentangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $PentangleSettings extends $PolygonSettings {
    radius?: float | PropertyBindingInfo | `{${string}}`;

    radius2?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/rls/Relationship" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import SelectedRelationship from "sap/gantt/shape/ext/rls/SelectedRelationship";

  import { shape } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Enables users to visualize the relationship between elements.
   *
   * Four types of relationships are supported and L-shaped lines are supported for the finish-to-start
   * type.
   *
   * @deprecated (since 1.64)
   */
  export default class Relationship extends Path {
    /**
     * Creates and initializes a Relationship object
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RelationshipSettings
    );
    /**
     * Creates and initializes a Relationship object
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RelationshipSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.rls.Relationship with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Relationship>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.rls.Relationship.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the selectedShape in the aggregation {@link #getSelectedShape selectedShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySelectedShape(): this;
    /**
     * Gets current value of property {@link #getArrowSideLength arrowSideLength}.
     *
     * Size of the arrow
     *
     * Default value is `5`.
     *
     *
     * @returns Value of property `arrowSideLength`
     */
    getArrowSideLength(): float;
    /**
     * Gets current value of property {@link #getCategory category}.
     *
     * Category name
     *
     * Default value is `sap.gantt.shape.ShapeCategory.Relationship`.
     *
     *
     * @returns Value of property `category`
     */
    getCategory(): string;
    /**
     * Gets current value of property {@link #getFill fill}.
     *
     * Fill color of the relationship shape (the color of the arrow and the square at the ends)
     *
     * Default value is `"#000000"`.
     *
     *
     * @returns Value of property `fill`
     */
    getFill(): string;
    /**
     * Gets the data of the predecessor element
     *
     *
     * @returns Data of predecessor
     */
    getFromDataId(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the expand row index of predecessor object
     *
     *
     * @returns Expand row index of predecessor element
     */
    getFromExpandRowIndex(
      /**
       * Raw data object
       */
      oData: object
    ): int;
    /**
     * Gets the path of predecessor object
     *
     *
     * @returns Path of predecessor element
     */
    getFromObjectPath(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the shape ID of the predecessor element
     *
     *
     * @returns Shape ID of the predecessor element
     */
    getFromShapeId(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the CSS class of the relationship shape
     *
     *
     * @returns CSS class name of the relationship shape
     */
    getHtmlClass(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets current value of property {@link #getIsClosed isClosed}.
     *
     * Indicates whether the shape is a closed path
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `isClosed`
     */
    getIsClosed(): boolean;
    /**
     * Gets current value of property {@link #getIsDuration isDuration}.
     *
     * Indicates whether the width of the polygon represents the duration of time
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `isDuration`
     */
    getIsDuration(): boolean;
    /**
     * Gets the'L' shape switch
     *
     *
     * @returns 'L' shape configuration (whether the system uses L-shaped lines to represent finish-start relationships)
     */
    getLShapeforTypeFS(
      /**
       * Raw data object
       */
      oData: object
    ): boolean;
    /**
     * Gets current value of property {@link #getMinXLen minXLen}.
     *
     * Minimum length for relationship lines
     *
     * Default value is `10`.
     *
     *
     * @returns Value of property `minXLen`
     */
    getMinXLen(): float;
    /**
     * Gets content of aggregation {@link #getSelectedShape selectedShape}.
     */
    getSelectedShape(): SelectedRelationship;
    /**
     * Gets whether the end shape is visible
     *
     *
     * @returns End shape configuration (whether the end shape is visible
     */
    getShowEnd(
      /**
       * Raw data object
       */
      oData: object
    ): boolean;
    /**
     * Gets whether the start shape is visible
     *
     *
     * @returns Start shape configuration (whether the start shape is visible)
     */
    getShowStart(
      /**
       * Raw data object
       */
      oData: object
    ): boolean;
    /**
     * Gets current value of property {@link #getStroke stroke}.
     *
     * Line color of the relationship shape
     *
     * Default value is `"#000000"`.
     *
     *
     * @returns Value of property `stroke`
     */
    getStroke(): string;
    /**
     * Gets the data of the successor element
     *
     *
     * @returns Data of the successor element
     */
    getToDataId(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the expand row index of successor object
     *
     *
     * @returns Expand row index of successor element
     */
    getToExpandRowIndex(
      /**
       * Raw data object
       */
      oData: object
    ): int;
    /**
     * Gets the path of the successor element
     *
     *
     * @returns Path of the successor element
     */
    getToObjectPath(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the shape ID of the successor element
     *
     *
     * @returns Shape ID of the successor element
     */
    getToShapeId(
      /**
       * Raw data object
       */
      oData: object
    ): string;
    /**
     * Gets the relationship type
     *
     *
     * @returns The type number (from 0 to 3)
     */
    getType(
      /**
       * Raw data object
       */
      oData: object
    ): number;
    /**
     * Sets a new value for property {@link #getArrowSideLength arrowSideLength}.
     *
     * Size of the arrow
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArrowSideLength(
      /**
       * New value for property `arrowSideLength`
       */
      fArrowSideLength?: float
    ): this;
    /**
     * Sets a new value for property {@link #getCategory category}.
     *
     * Category name
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `sap.gantt.shape.ShapeCategory.Relationship`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCategory(
      /**
       * New value for property `category`
       */
      sCategory?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFill fill}.
     *
     * Fill color of the relationship shape (the color of the arrow and the square at the ends)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#000000"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFill(
      /**
       * New value for property `fill`
       */
      sFill?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFromDataId fromDataId}.
     *
     * Data of predecessor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFromDataId(
      /**
       * New value for property `fromDataId`
       */
      sFromDataId: string
    ): this;
    /**
     * Sets a new value for property {@link #getFromExpandRowIndex fromExpandRowIndex}.
     *
     * Expand row index of predecessor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFromExpandRowIndex(
      /**
       * New value for property `fromExpandRowIndex`
       */
      iFromExpandRowIndex?: int
    ): this;
    /**
     * Sets a new value for property {@link #getFromObjectPath fromObjectPath}.
     *
     * Path of predecessor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFromObjectPath(
      /**
       * New value for property `fromObjectPath`
       */
      sFromObjectPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getFromShapeId fromShapeId}.
     *
     * Shape of predecessor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFromShapeId(
      /**
       * New value for property `fromShapeId`
       */
      sFromShapeId: string
    ): this;
    /**
     * Sets a new value for property {@link #getHtmlClass htmlClass}.
     *
     * CSS class name of the relationship shape
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"relationshipLine"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHtmlClass(
      /**
       * New value for property `htmlClass`
       */
      sHtmlClass?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * Indicates whether the shape is a closed path
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsDuration isDuration}.
     *
     * Indicates whether the width of the polygon represents the duration of time
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDuration(
      /**
       * New value for property `isDuration`
       */
      bIsDuration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLShapeforTypeFS lShapeforTypeFS}.
     *
     * Indicates whether an 'L' shape is used for the finish-to-start type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLShapeforTypeFS(
      /**
       * New value for property `lShapeforTypeFS`
       */
      bLShapeforTypeFS?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMinXLen minXLen}.
     *
     * Minimum length for relationship lines
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinXLen(
      /**
       * New value for property `minXLen`
       */
      fMinXLen?: float
    ): this;
    /**
     * Sets the aggregated {@link #getSelectedShape selectedShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedShape(
      /**
       * The selectedShape to set
       */
      oSelectedShape: SelectedRelationship
    ): this;
    /**
     * Sets a new value for property {@link #getShowEnd showEnd}.
     *
     * Indicates whether the end point (arrow) of the relationship shape is visible
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowEnd(
      /**
       * New value for property `showEnd`
       */
      bShowEnd?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowStart showStart}.
     *
     * Indicates whether the start point (square) of the relationship shape is visible
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowStart(
      /**
       * New value for property `showStart`
       */
      bShowStart?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * Line color of the relationship shape
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"#000000"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke?: string
    ): this;
    /**
     * Sets a new value for property {@link #getToDataId toDataId}.
     *
     * Data of successor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToDataId(
      /**
       * New value for property `toDataId`
       */
      sToDataId: string
    ): this;
    /**
     * Sets a new value for property {@link #getToExpandRowIndex toExpandRowIndex}.
     *
     * Expand row index of successor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToExpandRowIndex(
      /**
       * New value for property `toExpandRowIndex`
       */
      iToExpandRowIndex?: int
    ): this;
    /**
     * Sets a new value for property {@link #getToObjectPath toObjectPath}.
     *
     * Path of successor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToObjectPath(
      /**
       * New value for property `toObjectPath`
       */
      sToObjectPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getToShapeId toShapeId}.
     *
     * Shape of successor element
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setToShapeId(
      /**
       * New value for property `toShapeId`
       */
      sToShapeId: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Relationship type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `FinishToFinish`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?:
        | shape.ext.rls.RelationshipType
        | keyof typeof shape.ext.rls.RelationshipType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Relationship constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $RelationshipSettings extends $PathSettings {
    /**
     * CSS class name of the relationship shape
     */
    htmlClass?: string | PropertyBindingInfo;

    /**
     * Category name
     */
    category?: string | PropertyBindingInfo;

    /**
     * Indicates whether the shape is a closed path
     */
    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the width of the polygon represents the duration of time
     */
    isDuration?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Line color of the relationship shape
     */
    stroke?: string | PropertyBindingInfo;

    /**
     * Fill color of the relationship shape (the color of the arrow and the square at the ends)
     */
    fill?: string | PropertyBindingInfo;

    /**
     * Relationship type
     */
    type?:
      | (
          | shape.ext.rls.RelationshipType
          | keyof typeof shape.ext.rls.RelationshipType
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Path of predecessor element
     */
    fromObjectPath?: string | PropertyBindingInfo;

    /**
     * Expand row index of predecessor element
     */
    fromExpandRowIndex?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Shape of predecessor element
     */
    fromShapeId?: string | PropertyBindingInfo;

    /**
     * Data of predecessor element
     */
    fromDataId?: string | PropertyBindingInfo;

    /**
     * Path of successor element
     */
    toObjectPath?: string | PropertyBindingInfo;

    /**
     * Expand row index of successor element
     */
    toExpandRowIndex?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Shape of successor element
     */
    toShapeId?: string | PropertyBindingInfo;

    /**
     * Data of successor element
     */
    toDataId?: string | PropertyBindingInfo;

    /**
     * Indicates whether the start point (square) of the relationship shape is visible
     */
    showStart?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the end point (arrow) of the relationship shape is visible
     */
    showEnd?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether an 'L' shape is used for the finish-to-start type
     */
    lShapeforTypeFS?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Minimum length for relationship lines
     */
    minXLen?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Size of the arrow
     */
    arrowSideLength?: float | PropertyBindingInfo | `{${string}}`;

    selectedShape?: SelectedRelationship;
  }
}

declare module "sap/gantt/shape/ext/rls/SelectedRelationship" {
  import {
    default as Relationship,
    $RelationshipSettings,
  } from "sap/gantt/shape/ext/rls/Relationship";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   *  Provides an implementation of shape for drawing relationships with red and wider lines when they
   * are selected.
   *
   * @deprecated (since 1.64)
   */
  export default class SelectedRelationship extends Relationship {
    /**
     * Creates and initializes a SelectedRelationship object
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $SelectedRelationshipSettings
    );
    /**
     * Creates and initializes a SelectedRelationship object
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $SelectedRelationshipSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.rls.SelectedRelationship with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.rls.Relationship.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SelectedRelationship>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.rls.SelectedRelationship.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of `fill`.
     *
     *  See {@link sap.gantt.shape.Shape#getFill} for a detailed description of `fill`.
     *
     *
     * @returns Hard coded value: "red".
     */
    getFill(
      /**
       * Shape data.
       */
      oData?: object
    ): string;
    /**
     * Do not use! This method only exists for type compatibility reasons and always returns 0.
     *
     * @deprecated (since 1.90.0)
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object
    ): number;
    /**
     * Gets the value of `stroke`.
     *
     *  See {@link sap.gantt.shape.Shape#getStroke} for a detailed description of `stroke`.
     *
     *
     * @returns Hard coded value: "red".
     */
    getStroke(
      /**
       * Shape data.
       */
      oData?: object
    ): string;
    /**
     * Gets the value of `strokeWidth`.
     *
     *  See {@link sap.gantt.shape.Shape#getStrokeWidth} for a detailed description of `strokeWidth`.
     *
     *
     * @returns Hard coded value: 2.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object
    ): int;
    /**
     * Do not use! This method only exists for type compatibility reasons and does nothing.
     *
     * @deprecated (since 1.90.0)
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns this to allow method chaining
     */
    setHeight(
      /**
       * the height
       */
      height: number
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * Line color of the relationship.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke: string
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * Width of the relationship line.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      iStrokeWidth: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SelectedRelationship constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $SelectedRelationshipSettings extends $RelationshipSettings {
    /**
     * Line color of the relationship.
     */
    stroke?: string | PropertyBindingInfo;

    /**
     * Width of the relationship line.
     */
    strokeWidth?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/TextRepeat" {
  import {
    default as Definitions,
    $DefinitionsSettings,
  } from "sap/gantt/shape/Definitions";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A TextRepeat definition shape is used to define graphic objects which can be replicated ("tiled") at
   * fixed intervals in the x and y axes to cover the areas to be painted. The text patterns are defined using
   * a 'pattern' element and then referenced by the 'fill' and 'stroke' properties on a given graphics element
   * to indicate that the element will be filled or stroked with the referenced pattern.
   *
   * @deprecated (since 1.64)
   */
  export default class TextRepeat extends Definitions {
    /**
     * Creates and initializes a repeatable text pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $TextRepeatSettings
    );
    /**
     * Creates and initializes a repeatable text pattern defined for later reuse.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $TextRepeatSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.TextRepeat with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Definitions.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, TextRepeat>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.TextRepeat.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of the `childTagName` property.
     *
     *  Child element of 'defs' element. The default value is 'pattern'.
     *
     *
     * @returns Value of the `childTagName` property.
     */
    getChildTagName(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of the `dx` property.
     *
     *  dx value of the start position of text pattern tiles.
     *
     *
     * @returns Value of the `dx` property.
     */
    getDx(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of the `dy` property.
     *
     *  dy value of the start position of text pattern tiles.
     *
     *
     * @returns Value of the `dy` property.
     */
    getDy(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of the `fontFamily` property.
     *
     *  Text font family.
     *
     *
     * @returns Value of the `fontFamily` property.
     */
    getFontFamily(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of the `fontSize` property.
     *
     *  Text font size.
     *
     *
     * @returns Value of the `fontSize` property.
     */
    getFontSize(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): int;
    /**
     * Gets the value of the `height` property.
     *
     *  Height of a reference rectangle.
     *
     *
     * @returns Value of the `height` property.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): float;
    /**
     * Gets the value of the `text` property.
     *
     *  Text string.
     *
     *
     * @returns Value of the `text` property.
     */
    getText(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of the `width` property.
     *
     *  Width of a reference rectangle.
     *
     *
     * @returns Value of the `width` property.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): float;
    /**
     * Gets the value of the `x` property.
     *
     *  x coordinate of the text pattern tiles.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `time`
     * as a base.
     *
     *
     * @returns Value of the `x` property.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): float;
    /**
     * Gets the value of the `y` property.
     *
     *  y coordinate of the text pattern tiles.
     *
     *
     * @returns Value of the `y` property.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): float;
    /**
     * Sets a new value for property {@link #getChildTagName childTagName}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"pattern"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setChildTagName(
      /**
       * New value for property `childTagName`
       */
      sChildTagName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getDx dx}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDx(
      /**
       * New value for property `dx`
       */
      sDx: string
    ): this;
    /**
     * Sets a new value for property {@link #getDy dy}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDy(
      /**
       * New value for property `dy`
       */
      sDy: string
    ): this;
    /**
     * Sets a new value for property {@link #getFontFamily fontFamily}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontFamily(
      /**
       * New value for property `fontFamily`
       */
      sFontFamily: string
    ): this;
    /**
     * Sets a new value for property {@link #getFontSize fontSize}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontSize(
      /**
       * New value for property `fontSize`
       */
      iFontSize: int
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `15`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth: float
    ): this;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the TextRepeat constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $TextRepeatSettings extends $DefinitionsSettings {
    childTagName?: string | PropertyBindingInfo;

    x?: float | PropertyBindingInfo | `{${string}}`;

    y?: float | PropertyBindingInfo | `{${string}}`;

    width?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;

    dx?: string | PropertyBindingInfo;

    dy?: string | PropertyBindingInfo;

    text?: string | PropertyBindingInfo;

    fontSize?: int | PropertyBindingInfo | `{${string}}`;

    fontFamily?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/ext/Triangle" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Triangle shape class using SVG tag 'path'. It's usually treated as a transient shape.
   *
   *  The following image shows how the properties are designed:
   *
   *             time
   * rotation Center
   * height distanceOfyAxisHeight
   * base
   *
   * @deprecated (since 1.64)
   */
  export default class Triangle extends Path {
    /**
     * Creates and initializes a new Triangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $TriangleSettings
    );
    /**
     * Creates and initializes a new Triangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $TriangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.Triangle with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Triangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.Triangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `base`.
     *
     *  Base side of a triangle.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `base`.
     */
    getBase(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of path element.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of d by using
     * properties `time`, `base`, `height`, and `distanceOfyAxisHeight`. The value of these properties can be
     * retrieved from the corresponding getters (getTime, getBase, getHeight, and getDistanceOfyAxisHeight).
     *
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `distanceOfyAxisHeight`.
     *
     *  distanceOfyAxisHeight of a triangle, which refers to the distance between the left point to the altitude
     * of the triangle.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `distanceOfyAxisHeight`.
     */
    getDistanceOfyAxisHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  Height of a triangle.
     *
     * This property influences property `d`.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `isClosed`.
     *
     *
     * @returns Value of property `isClosed`.
     */
    getIsClosed(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Sets a new value for property {@link #getBase base}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBase(
      /**
       * New value for property `base`
       */
      fBase?: float
    ): this;
    /**
     * Sets a new value for property {@link #getDistanceOfyAxisHeight distanceOfyAxisHeight}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDistanceOfyAxisHeight(
      /**
       * New value for property `distanceOfyAxisHeight`
       */
      fDistanceOfyAxisHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Triangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $TriangleSettings extends $PathSettings {
    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    base?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;

    distanceOfyAxisHeight?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/ext/ubc/UbcBorderPath" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent a planned capacity line.
   *
   *  Graphic Effect is:
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcBorderPath extends Path {
    /**
     * Creates and initializes a fragment of the Utilization Bar Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcBorderPathSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Bar Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcBorderPathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcBorderPath with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcBorderPath>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcBorderPath.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of the path element.
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This property determines whether a shape is enabled for a selection behavior. The default value for
     * a Utilization Line Chart is false.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:**You can provide stroke with HTML colors and the URL reference
     * to a paint server can be provided. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "blue".
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 0.3.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UbcBorderPath constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcBorderPathSettings extends $PathSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcOverCapacityZonePolygon" {
  import {
    default as UbcPolygon,
    $UbcPolygonSettings,
  } from "sap/gantt/shape/ext/ubc/UbcPolygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent the background of an over capacity zone.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcOverCapacityZonePolygon extends UbcPolygon {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcOverCapacityZonePolygonSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcOverCapacityZonePolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcOverCapacityZonePolygon with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ubc.UbcPolygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcOverCapacityZonePolygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcOverCapacityZonePolygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide fill with HTML colors and the URL reference
     * to a paint server. Paint server definitions can be retrieved from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}. The default value of 'fill' is
     * the URL reference.
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `points`.
     *
     *  points attribute of the polygon element. The value of 'points' is calculated by the coordinates of
     * four vertices of a visible area.
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** You can provide stroke with HTML colors and the URL reference
     * to a paint server. Paint server definitions can be retrieved from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.  The default value is
     * "#CAC7BA".
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 0.3.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UbcOverCapacityZonePolygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcOverCapacityZonePolygonSettings
    extends $UbcPolygonSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcPolygon" {
  import {
    default as Polygon,
    $PolygonSettings,
  } from "sap/gantt/shape/Polygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Base class for ` sap.gantt.shape.ext.ubc.UbcOverCapacityZonePolygon`, ` sap.gantt.shape.ext.ubc.UbcUnderCapacityZonePolygon`,
   * ` sap.gantt.shape.ext.ubc.UbcShortagePolygon`, ` sap.gantt.shape.ext.ubc.UbcUsedPolygon`.
   *
   * This base class defines a number of shared methods.
   *
   * @deprecated (since 1.64)
   */
  export default abstract class UbcPolygon extends Polygon {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcPolygonSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcPolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcPolygon with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Polygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcPolygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcPolygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This property determines whether a shape is enabled for a selection behavior. The default value for
     * a Utilization Line Chart is false.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
  }
  /**
   * Describes the settings that can be provided to the UbcPolygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcPolygonSettings extends $PolygonSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcShortageCapacityPolygon" {
  import {
    default as UbcPolygon,
    $UbcPolygonSettings,
  } from "sap/gantt/shape/ext/ubc/UbcPolygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent a shortage capacity area.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcShortageCapacityPolygon extends UbcPolygon {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcShortageCapacityPolygonSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcShortageCapacityPolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcShortageCapacityPolygon with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ubc.UbcPolygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcShortageCapacityPolygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcShortageCapacityPolygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide the fill attribute with HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#FF0000".
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `points`.
     *
     *  points attribute of polygon element. The value of 'points' is calculated by using the coordinates
     * of all points for the shortage capacity area.
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** HTML color and url reference to paint server can be provided
     * to stroke. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.  The default value is "#CAC7BA".
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 0.3.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UbcShortageCapacityPolygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcShortageCapacityPolygonSettings
    extends $UbcPolygonSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcTooltipRectangle" {
  import {
    default as Rectangle,
    $RectangleSettings,
  } from "sap/gantt/shape/Rectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent an invisible rectangle with tooltips. Note that a tooltip appears only
   * when the title tag is specified on the rectangle.
   *
   *  Graphic Effect is:
   *
   *           Capacity:
   * 50
   * Required Capacity: 65 Capacity: 45
   * Required Capacity: 10
   * Capacity:
   * 65
   * Required Capacity: 75 Capacity: 75
   * Required Capacity: 35
   * Capacity:
   * 55
   * Required Capacity: 55 Capacity: 55
   * Required Capacity: 75
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcTooltipRectangle extends Rectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcTooltipRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcTooltipRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcTooltipRectangle with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Rectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcTooltipRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcTooltipRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This property determines whether a shape is enabled for a selection behavior. The default value for
     * the Utilization Line Chart is false.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `fillOpacity`.
     *
     *  Standard SVG 'fill-Opacity' attribute. The value of fillOpacity for a rectangle with tooltips must
     * be 0.  The default value is 0.
     *
     *
     * @returns Value of property `fillOpacity`.
     */
    getFillOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  Height of a rectangle.  The default value is the height of the row minus 1px, which is the
     * width of stroke.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `strokeOpacity`.
     *
     *  Standard SVG 'stroke-Opacity' attribute. The value of strokeOpacity for a rectangle with tooltips
     * must be 0.  The default value is 0.
     *
     *
     * @returns Value of property `strokeOpacity`.
     */
    getStrokeOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo?: object
    ): number;
    /**
     * Gets the value of property `title`.
     *
     * A title is visualized as a tooltip in web browsers. **Notes:** Use character entities to perform simple
     * text tabbing and breaking. (Use "	" for tab and "
     * " for break.)
     *
     *
     * @returns Value of property `title`.
     */
    getTitle(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `width`.
     *
     *  Width of a rectangle.
     *
     * Your application should not configure this value. Instead, the getter calculates the width by using property
     * `start_date` and property `end_date`. If your application overwrites the getter by configuration or code,
     * accurate results cannot be guaranteed.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x`.
     *
     *  x coordinate of the top-left point of a rectangle.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of x by using
     * property `start_date`.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y`.
     *
     *  y coordinate of the top-left point of a rectangle.
     *
     * Your application should not configure this value. Instead, the getter calculates the value of y by using
     * parameter `oRowInfo`.  The default value is the y coordinate of the top-left point of the row.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UbcTooltipRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcTooltipRectangleSettings extends $RectangleSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcUnderCapacityZonePolygon" {
  import {
    default as UbcPolygon,
    $UbcPolygonSettings,
  } from "sap/gantt/shape/ext/ubc/UbcPolygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent an unplanned capacity area.
   *
   *  Graphic Effect is:
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcUnderCapacityZonePolygon extends UbcPolygon {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcUnderCapacityZonePolygonSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcUnderCapacityZonePolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcUnderCapacityZonePolygon with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ubc.UbcPolygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcUnderCapacityZonePolygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcUnderCapacityZonePolygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide the fill attribute with HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#40d44c".
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `points`.
     *
     *  points attribute of the polygon element. The value of 'points' is calculated by using the coordinates
     * of all points of the unplanned capacity area.
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
  }
  /**
   * Describes the settings that can be provided to the UbcUnderCapacityZonePolygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcUnderCapacityZonePolygonSettings
    extends $UbcPolygonSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UbcUsedPolygon" {
  import {
    default as UbcPolygon,
    $UbcPolygonSettings,
  } from "sap/gantt/shape/ext/ubc/UbcPolygon";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to represent a healthy planned capacity area.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UbcUsedPolygon extends UbcPolygon {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcUsedPolygonSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UbcUsedPolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UbcUsedPolygon with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ubc.UbcPolygon.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UbcUsedPolygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UbcUsedPolygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide the fill attribute with HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#CAC7BA".
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `points`.
     *
     *  points attribute of polygon element. The value of 'points' is calculated by using the coordinates
     * of all points for the healthy planned capacity area.
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
  }
  /**
   * Describes the settings that can be provided to the UbcUsedPolygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UbcUsedPolygonSettings extends $UbcPolygonSettings {}
}

declare module "sap/gantt/shape/ext/ubc/UtilizationBarChart" {
  import { default as Group, $GroupSettings } from "sap/gantt/shape/Group";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * UBC is a complex shape. This class is the outer container with tag='g'. All fragments are aggregated
   * into this container. You can remove a fragment from the container if your application does not need it.
   *
   * The container has six aggregations:
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcOverCapacityZonePolygon}(used to represent the OverCapacity Zone
   *     area),
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcUnderCapacityZonePolygon}(used to represent the Unplanned Capacity
   *     area),
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcShortageCapacityPolygon}(used to the draw Shortage area),
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcUsedPolygon}(used to represent the HealthyPlanned Capacity area),
   *
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcBorderPath}(used to represent the planned capacity line),
   * 	 - {@link sap.gantt.shape.ext.ubc.UbcTooltipRectangle}(used to represent a rectangle with invisible
   *     tooltips for each period of capacity change).
   *
   * A super class ` sap.gantt.shape.ext.ubc.UbcPolygon` is abstracted because the four polygons in this
   * container (UbcOverCapacityZonePolygon, UbcUnderCapacityZonePolygon, UbcShortageCapacityPolygon, and UbcUsedPolygon)
   * share similar logic.
   *
   *  Graphic Effect is:
   *
   *            Capacity: 50
   * Required Capacity: 65 Capacity: 45
   * Required Capacity: 10 Capacity: 65
   * Required Capacity: 75
   * Capacity: 75
   * Required Capacity: 35
   * Capacity: 55
   * Required Capacity: 55
   * Capacity: 55
   * Required Capacity: 75
   *  OverCapacity Zone
   * Planned Capacity
   * Shortage HealthyPlanned
   * Capacity UnPlanned
   * Capacity
   *
   * An example of the structure of data to feed utilization bar chart:
   *  ` { bc_capacity: { id: "capacity_0", period: [ { start_date: "20160123000000", supply: "9", demand:
   * "7" },{ start_date: "20160127093400", supply: "8", demand: "8" } ] }, bc_tooltip: [ { start_date: "20160123000000",
   * supply: "9", demand: "7", end_date: "20160127093400" },{ start_date: "20160127093400", supply: "8", demand:
   * "8", start_date: "20160203134520" } ] } `
   *
   * @deprecated (since 1.64)
   */
  export default class UtilizationBarChart extends Group {
    /**
     * Creates and initializes a new Utilization Bar Chart (UBC) container class.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UtilizationBarChartSettings
    );
    /**
     * Creates and initializes a new Utilization Bar Chart (UBC) container class.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UtilizationBarChartSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ubc.UtilizationBarChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Group.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UtilizationBarChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ubc.UtilizationBarChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This property determines whether a shape is enabled for selection behavior. The default value for
     * the Utilization Line Chart is false.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
  }
  /**
   * Describes the settings that can be provided to the UtilizationBarChart constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UtilizationBarChartSettings extends $GroupSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcBorderPath" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to draw dimension lines.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcBorderPath extends Path {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcBorderPathSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcBorderPathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcBorderPath with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcBorderPath>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcBorderPath.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  'd' attribute of the path element. The 'd' attribute has powerful usages.
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** You can provide stroke with HTML colors and URL references
     * to paint servers. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 1.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcBorderPath constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcBorderPathSettings extends $PathSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcClipingPath" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to define path data inside {@link sap.gantt.shape.ext.ulc.UlcClipPath}.
   *
   * @deprecated (since 1.64)
   */
  export default class UlcClipingPath extends Path {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcClipingPathSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcClipingPathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcClipingPath with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcClipingPath>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcClipingPath.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  'd' attribute of path element. The 'd' attribute has powerful usages.
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
  }
  /**
   * Describes the settings that can be provided to the UlcClipingPath constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcClipingPathSettings extends $PathSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcClipPath" {
  import {
    default as ClipPath,
    $ClipPathSettings,
  } from "sap/gantt/shape/ClipPath";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is a container of {@link sap.gantt.shape.ext.ulc.UlcClipingPath}.
   *
   * @deprecated (since 1.64)
   */
  export default class UlcClipPath extends ClipPath {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcClipPathSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcClipPathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcClipPath with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ClipPath.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcClipPath>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcClipPath.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `htmlClass`.
     *
     * Customized HTML classes. To provide multiple classes, separate them using space. Note that each UlcClipPath
     * must have a unique HTML class or a unique set of HTML classes. The 'clip-path' property of UlcOverClipRectangle
     * and UlcUnderClipRectangle identifies HTML classes.
     *
     *
     * @returns Value of property `htmlClass`.
     */
    getHtmlClass(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
  }
  /**
   * Describes the settings that can be provided to the UlcClipPath constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcClipPathSettings extends $ClipPathSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcDimension" {
  import { default as Group, $GroupSettings } from "sap/gantt/shape/Group";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is a container for {@link sap.gantt.shape.ext.ulc.UlcBorderPath}, {@link sap.gantt.shape.ext.ulc.UlcOverClipRectangle},
   * {@link sap.gantt.shape.ext.ulc.UlcUnderClipRectangle}, {@link sap.gantt.shape.ext.ulc.UlcClipPath}, {@link sap.gantt.shape.ext.ulc.UlcClipingPath}.
   *
   * For each dimension, it has two colors, one is OverCapacity and the other is UnderCapacity. When the
   * `UlcClipPath` of a dimension and `UlcOverClipRectangle` overlap, which means the utilization rate is
   * above 100%, the overlapped part will be colored by OverCapacity. The overlapped part of `UlcClipPath`
   * and `UlcUnderClipRectangle` is colored by UnderCapacity.
   *
   * `UlcClipingPath` is aggregated in `UlcClipPath`. `UlcClipingPath` and `UlcBorderPath` share the same
   * value of property 'd'. `UlcBorderPath` is used to visualize the dimension line.
   *
   * @deprecated (since 1.64)
   */
  export default class UlcDimension extends Group {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcDimensionSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcDimensionSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcDimension with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Group.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcDimension>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcDimension.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
  }
  /**
   * Describes the settings that can be provided to the UlcDimension constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcDimensionSettings extends $GroupSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcMiddleLine" {
  import { default as Line, $LineSettings } from "sap/gantt/shape/Line";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to draw a middle line, which indicates the position of 50%.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcMiddleLine extends Line {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcMiddleLineSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcMiddleLineSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcMiddleLine with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Line.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcMiddleLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcMiddleLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** You can provide the stroke with HTML colors and the URL
     * reference to a paint server. Paint server definitions can be retrieved from paint servers rendered by
     * {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#CAC7BA".
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeDasharray`.
     *
     *  Standard SVG 'stroke-dasharray' attribute.  The default value is "5,5".
     *
     *
     * @returns Value of property `strokeDasharray`.
     */
    getStrokeDasharray(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 1.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x1`.
     *
     *  x coordinate of the start of the line.
     *
     * Usually an application does not configure this value. Instead, the getter calculates the value of x1
     * by using the view boundary for the visible area in the Gantt Chart.
     *
     *
     * @returns Value of property `x1`.
     */
    getX1(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x2`.
     *
     *  x coordinate of the end of the line.
     *
     * Usually an application does not configure this value. Instead, the getter calculates the value of 'x2'
     * by using the view boundary's terminal point, which is filtered by the visible area in a Gantt Chart.
     *
     *
     *
     *
     * @returns Value of property `x2`.
     */
    getX2(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y1`.
     *
     *  y coordinate of the start of the line.
     *
     * At the top of each row, a certain amount of space (in the shape of a rectangular frame) is reserved for
     * over capacity area. You can use 'maxVisibleRatio' in 'shapeConfig' to specify the amount of area to reserve.
     * With the reserved area deducted from a row, the height of the middle line is set to 50% of the row height.
     *
     *
     *
     * @returns Value of property `y1`.
     */
    getY1(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y2`.
     *
     *  y coordinate of the end of the line.
     *
     * y2 shares the same value with y1.
     *
     *
     * @returns Value of property `y2`.
     */
    getY2(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcMiddleLine constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcMiddleLineSettings extends $LineSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcOverCapacityZoneRectangle" {
  import {
    default as UlcRectangle,
    $UlcRectangleSettings,
  } from "sap/gantt/shape/ext/ulc/UlcRectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to draw the over capacity zone background.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcOverCapacityZoneRectangle extends UlcRectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcOverCapacityZoneRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcOverCapacityZoneRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcOverCapacityZoneRectangle with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ulc.UlcRectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcOverCapacityZoneRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcOverCapacityZoneRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide `fill` property with the HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     * The default value of 'fill' is a URL reference.
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** HTML colors and url reference to paint server can be provided
     * to stroke. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.  The default value is "#CAC7BA".
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.  The default value is 0.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcOverCapacityZoneRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcOverCapacityZoneRectangleSettings
    extends $UlcRectangleSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcOverClipRectangle" {
  import {
    default as UlcRectangle,
    $UlcRectangleSettings,
  } from "sap/gantt/shape/ext/ulc/UlcRectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to draw the over clipping rectangle.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcOverClipRectangle extends UlcRectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcOverClipRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcOverClipRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcOverClipRectangle with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ulc.UlcRectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcOverClipRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcOverClipRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `clipPath`.
     *
     *  Standard SVG 'clippath' attribute.
     *
     * The referred ID must be consistent with the HTML class generated by `UlcClipPath`.
     *
     *
     * @returns Value of property `clipPath`.
     */
    getClipPath(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide the `fill` property with HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#FF0000".
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
  }
  /**
   * Describes the settings that can be provided to the UlcOverClipRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcOverClipRectangleSettings
    extends $UlcRectangleSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcRectangle" {
  import {
    default as Rectangle,
    $RectangleSettings,
  } from "sap/gantt/shape/Rectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Base class for {@link sap.gantt.shape.ext.ulc.UlcOverCapacityZoneRectangle}, {@link sap.gantt.shape.ext.ulc.UlcOverClipRectangle},
   * {@link sap.gantt.shape.ext.ulc.UlcUnderClipRectangle}, {@link sap.gantt.shape.ext.ulc.UlcTooltipRectangle}.
   *
   * This base class defines a number of shared methods.
   *
   * @deprecated (since 1.64)
   */
  export default abstract class UlcRectangle extends Rectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcRectangle with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Rectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `height`.
     *
     *  Height of the rectangle. The default value of height is calculated by the over capacity rectangle.
     *
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `width`.
     *
     *  Width of the rectangle.
     *
     * Usually an application does not configure this value. Instead, the getter calculates the value of width
     * by using the view boundary for the visible area in a Gantt Chart.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x`.
     *
     *  x coordinate of the rectangle left-top point.
     *
     * Usually an application does not configure this value. Instead, the getter calculates the value of x by
     * using the view boundary for the visible area in a Gantt Chart.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y`.
     *
     *  y coordinate of a rectangle left-top point.
     *
     * Usually application does not configure this value. Instead getter calculates the value of y using parameter
     * `oRowInfo`.  The default value is y coordinate of the top-left point of the row.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcRectangleSettings extends $RectangleSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcTooltipRectangle" {
  import {
    default as UlcRectangle,
    $UlcRectangleSettings,
  } from "sap/gantt/shape/ext/ulc/UlcRectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to create invisible rectangles with tooltips enabled by tag 'title'.
   *
   *  Graphic Effect is:
   *
   *        dimention1: 0-150%
   * dimention2: 0-110%
   * dimention1:
   * 150%
   * dimention2: 110% dimention1: 150%-70%
   * dimention2: 110%-105%
   * dimention1:
   * 70%
   * dimention2: 105% dimention1: 70%-0
   * dimention2: 105%-0
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcTooltipRectangle extends UlcRectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcTooltipRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcTooltipRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcTooltipRectangle with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ulc.UlcRectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcTooltipRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcTooltipRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `fillOpacity`.
     *
     *  Standard SVG 'fill-Opacity' attribute. The value of fillOpacity for tooltip rectangles must be 0.
     *
     *
     *
     * @returns Value of property `fillOpacity`.
     */
    getFillOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  Height of the rectangle.  The default value is the height of the row.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `strokeOpacity`.
     *
     *  Standard SVG 'stroke-Opacity' attribute. The value of strokeOpacity for tooltip rectangles must be
     * 0.
     *
     *
     * @returns Value of property `strokeOpacity`.
     */
    getStrokeOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo?: object
    ): number;
    /**
     * Gets the value of property `title`.
     *
     * Title is visualized as a tooltip by browsers. **Notes:** Use character entities to perform simple text
     * tabbing and breaking. (Use "	" for tab and "
     * " for break.)
     *
     *
     * @returns Value of property `title`.
     */
    getTitle(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `width`.
     *
     *  Width of the rectangle.
     *
     * Usually an application does not configure this value. Instead, the getter calculates value of width by
     * using the `from` and `to` properties.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x`.
     *
     *  x coordinate of the rectangle left-top point.
     *
     * Usually an application does not configure this value. Instead, the getter calculates the value of x by
     * using property `from`.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcTooltipRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcTooltipRectangleSettings extends $UlcRectangleSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UlcUnderClipRectangle" {
  import {
    default as UlcRectangle,
    $UlcRectangleSettings,
  } from "sap/gantt/shape/ext/ulc/UlcRectangle";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This shape is used to draw the under clipping rectangle.
   *
   *  Graphic Effect is:
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class UlcUnderClipRectangle extends UlcRectangle {
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcUnderClipRectangleSettings
    );
    /**
     * Creates and initializes a fragment of the Utilization Line Chart.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings of the new control
       */
      mSettings?: $UlcUnderClipRectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UlcUnderClipRectangle with name `sClassName`
     * and enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.ext.ulc.UlcRectangle.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UlcUnderClipRectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UlcUnderClipRectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `clipPath`.
     *
     *  Standard SVG 'clippath' attribute.
     *
     * The referred ID must be consistent with the html class generated by `UlcClipPath`.
     *
     *
     * @returns Value of property `clipPath`.
     */
    getClipPath(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** You can provide the `fill` property with HTML colors and
     * the URL reference to a paint server. Paint server definitions can be retrieved from paint servers rendered
     * by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *  The default value is "#F2F2F2".
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `fillOpacity`.
     *
     *  Standard SVG 'fill-Opacity' attribute.  The default value is 0.3.
     *
     *
     * @returns Value of property `fillOpacity`.
     */
    getFillOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  Height of the rectangle.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `strokeOpacity`.
     *
     *  Standard SVG 'stroke-Opacity' attribute.  The default value is 0.3.
     *
     *
     * @returns Value of property `strokeOpacity`.
     */
    getStrokeOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo?: object
    ): number;
    /**
     * Gets the value of property `y`.
     *
     *  y coordinate of the rectangle left-top point.
     *
     *
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): number;
  }
  /**
   * Describes the settings that can be provided to the UlcUnderClipRectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UlcUnderClipRectangleSettings
    extends $UlcRectangleSettings {}
}

declare module "sap/gantt/shape/ext/ulc/UtilizationLineChart" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * ULC is a complex shape. This class is the outer container with tag='g'. All fragments are aggregated
   * into this container. You can remove a fragment from the container if your application does not need it.
   *
   * The container has four aggregations:
   * 	 - {@link sap.gantt.shape.ext.ulc.UlcMiddleLine}(used to draw a middle line, which indicates the position
   *     of 50% utilization rate),
   * 	 - {@link sap.gantt.shape.ext.ulc.UlcOverCapacityZoneRectangle}(used to draw over capacity Zone),
   * 	 - {@link sap.gantt.shape.ext.ulc.UlcDimension}(used to draw Dimensions, OverCapacityClipping, and UnderCapacityClipping),
   *
   * 	 - {@link sap.gantt.shape.ext.ulc.UlcTooltipRectangle}(used to draw invisible tooltip rectangles for
   *     each period of capacity change).
   *
   *  Each dimension consists of `UlcOverClipRectangle`, `UlcUnderClipRectangle`, `UlcClipPath`, and `UlcBorderPath`.
   * `UlcClipingPath` is aggregated in `UlcClipPath`.
   *
   * A super class `sap.gantt.shape.ext.ulc.UlcRectangle` is abstracted because the other four rectangles(UlcOverCapacityZoneRectangle,
   * UlcOverClipRectangle, UlcUnderClipRectangle, and UlcTooltipRectangle) share similar logic.
   *
   *  Graphic Effect is:
   *
   *                  dimention1:
   * 0-150%
   * dimention2: 0-110% dimention1:
   * 150%
   * dimention2: 110% dimention1:
   * 150%-70%
   * dimention2: 110%-105% dimention1:
   * 70%
   * dimention2: 105% dimention1:
   * 70%-0
   * dimention2: 105%-0   >100% Zone OverCapacityClipping
   *  <100% Zone 50%
   * UnderCapacityClipping Dimensions
   *
   *
   * An example for the structure of data to feed utilization chart:
   *  ` { order: [{ id: "ulc_0", util: [ { dimension: "util_volumn", values:[ { from: "20160123000000", to:
   * "20160123000000", firstOne: true, value: 0 }, { from: "20160124071000", to: "20160124071000", value:
   * 97.6 }, { from: "20160124071000", to: "20160127051300", firstOne: true, value: 97.6 },{ from: "20160127051300",
   * to: "20160127051300", value: 97.6 },{ from: "20160128093312", to: "20160128093312", lastOne: true, value:
   * 0 } ] },{ dimension: "util_mass", values:[ { from: "20160123000000", to: "20160123000000", firstOne:
   * true, value: 0 } { from: "20160124071000", to: "20160124071000", value: 114.5 }, { from: "20160124071000",
   * to: "20160127051300", value: 114.5 },{ from: "20160127051300", to: "20160127051300", value: 114.5 },{
   * from: "20160128093312", to: "20160128093312", lastOne: true, value: 0 } ] } ] }], tooltip: [ { from:
   * "20160123000000", to: "20160124071000", firstOne: true, util_volumn: { previous: 0, next: 97.6 }, util_mass:{
   * previous: 0, next: 114.5 } },{ from: "20160124071000", to: "20160127051300", util_volumn: { val: 97.6
   * }, util_mass:{ val: 114.5 } },{ from: "20160127051300", to: "20160128093312", lastOne: true, util_volumn:
   * { previous: 97.6, next: 0 }, util_mass:{ previous: 114.5, next: 0 } } ] } `
   *
   * @deprecated (since 1.64)
   */
  export default class UtilizationLineChart extends Shape {
    /**
     * Creates and initializes a new Utilization Line Chart container class.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $UtilizationLineChartSettings
    );
    /**
     * Creates and initializes a new Utilization Line Chart container class.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $UtilizationLineChartSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ext.ulc.UtilizationLineChart with name `sClassName` and
     * enriches it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, UtilizationLineChart>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ext.ulc.UtilizationLineChart.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This value controls whether a shape is enabled for selection behavior. The default value for Utilization
     * Line Chart is false.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and row data.
       */
      oRowInfo: object
    ): boolean;
  }
  /**
   * Describes the settings that can be provided to the UtilizationLineChart constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $UtilizationLineChartSettings extends $ShapeSettings {}
}

declare module "sap/gantt/shape/Group" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Group shape class using SVG tag 'group'. It is a container shape. Any other shapes can be aggregated
   * under a group.
   *
   * @deprecated (since 1.64)
   */
  export default class Group extends Shape {
    /**
     * Creates and initializes a new Group class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupSettings
    );
    /**
     * Creates and initializes a new Group class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $GroupSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Group with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Group>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Group.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some shape to the aggregation {@link #getShapes shapes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addShape(
      /**
       * The shape to add; if empty, nothing is inserted
       */
      oShape: Shape
    ): this;
    /**
     * Destroys all the shapes in the aggregation {@link #getShapes shapes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyShapes(): this;
    /**
     * Generate a referenceId according to shape data.
     *
     *  'referenceId' is used to identify Definitions shapes. Aggregation shapes of a Group shape can retrieve
     * the 'referenceId' by their getParentReferenceId method and then consume the corresponding Definition
     * shape.
     *
     *
     * @returns Value of the `referenceId` property.
     */
    genReferenceId(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * To enable connections between in-row shapes, a custom Group class has to be implemented that extends
     * `sap.gantt.shape.Group`. Additionally, the `getRLSAnchors` method has to be implemented for the Relationship
     * class to know the coordinates of the connection points.
     *
     *
     * @returns Coordinates of the "from" shape (start) and "to" shape (end)
     */
    getRLSAnchors(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowObjectInfo: object
    ): object;
    /**
     * Gets content of aggregation {@link #getShapes shapes}.
     */
    getShapes(): Shape[];
    /**
     * Gets the value of the `tag` property.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of the `tag` property.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Checks for the provided `sap.gantt.shape.Shape` in the aggregation {@link #getShapes shapes}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfShape(
      /**
       * The shape whose index is looked for
       */
      oShape: Shape
    ): int;
    /**
     * Inserts a shape into the aggregation {@link #getShapes shapes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertShape(
      /**
       * The shape to insert; if empty, nothing is inserted
       */
      oShape: Shape,
      /**
       * The `0`-based index the shape should be inserted at; for a negative value of `iIndex`, the shape is inserted
       * at position 0; for a value greater than the current size of the aggregation, the shape is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getShapes shapes}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllShapes(): Shape[];
    /**
     * Removes a shape from the aggregation {@link #getShapes shapes}.
     *
     *
     * @returns The removed shape or `null`
     */
    removeShape(
      /**
       * The shape to remove or its index or id
       */
      vShape: int | string | Shape
    ): Shape | null;
    /**
     * Sets a new value for property {@link #getRLSAnchors RLSAnchors}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRLSAnchors(
      /**
       * New value for property `RLSAnchors`
       */
      oRLSAnchors: object
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"g"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Group constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $GroupSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    RLSAnchors?: object | PropertyBindingInfo | `{${string}}`;

    shapes?: Shape[] | Shape | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/Image" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Image shape class using SVG tag 'image'. This shape is usually used to represent points in time.
   *
   * @deprecated (since 1.64)
   */
  export default class Image extends Shape {
    /**
     * Creates and initializes a new Image class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ImageSettings
    );
    /**
     * Creates and initializes a new Image class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ImageSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Image with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Image>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Image.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `height`.
     *
     *  Height of the image.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `image`.
     *
     *  IRI reference of the image.
     *
     *
     * @returns Value of property `image`.
     */
    getImage(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `width`.
     *
     *  Width of the image.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the current value of property `x`.
     *
     *  x coordinate of the image rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `time`
     * as a base and makes some adjustments.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the current value of property `y`.
     *
     *  y coordinate of the image rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`
     * as a base and makes some adjustments to align the center of the row rectangle along the y axis. If you
     * override the default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `20`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getImage image}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImage(
      /**
       * New value for property `image`
       */
      sImage: string
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"image"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `20`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Image constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ImageSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    image?: string | PropertyBindingInfo;

    x?: float | PropertyBindingInfo | `{${string}}`;

    y?: float | PropertyBindingInfo | `{${string}}`;

    width?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/Line" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Line shape class using SVG tag 'line'. This shape is usually used to represent durations.
   *
   *
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Line extends Shape {
    /**
     * Creates and initializes a new Line class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $LineSettings
    );
    /**
     * Creates and initializes a new Line class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $LineSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Line with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Line>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Line.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `isDuration`.
     *
     *
     * @returns Value of property `isDuration`.
     */
    getIsDuration(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `x1`.
     *
     *  x coordinate of the start of the line.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `time`
     * as a base and makes some adjustments.
     *
     *
     * @returns Value of property `x1`.
     */
    getX1(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x2`.
     *
     *  x coordinate of the end of the line.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `endTime`
     * as a base and makes some adjustments.
     *
     *
     * @returns Value of property `x2`.
     */
    getX2(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y1`.
     *
     *  y coordinate of the start of the line.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`,
     * and makes some adjustments to align the center of the row rectangle along the y axis. If you override
     * the default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     * @returns Value of property `y1`.
     */
    getY1(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y2`.
     *
     *  y coordinate of the end of the line.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`
     * as a base and makes some adjustments to align the center of the row rectangle along the y axis. f you
     * override the default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     * @returns Value of property `y2`.
     */
    getY2(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getIsDuration isDuration}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDuration(
      /**
       * New value for property `isDuration`
       */
      bIsDuration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"line"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
    /**
     * Sets a new value for property {@link #getX1 x1}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX1(
      /**
       * New value for property `x1`
       */
      fX1: float
    ): this;
    /**
     * Sets a new value for property {@link #getX2 x2}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX2(
      /**
       * New value for property `x2`
       */
      fX2: float
    ): this;
    /**
     * Sets a new value for property {@link #getY1 y1}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY1(
      /**
       * New value for property `y1`
       */
      fY1: float
    ): this;
    /**
     * Sets a new value for property {@link #getY2 y2}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY2(
      /**
       * New value for property `y2`
       */
      fY2: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Line constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $LineSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    isDuration?: boolean | PropertyBindingInfo | `{${string}}`;

    x1?: float | PropertyBindingInfo | `{${string}}`;

    y1?: float | PropertyBindingInfo | `{${string}}`;

    x2?: float | PropertyBindingInfo | `{${string}}`;

    y2?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/Path" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Path shape class using SVG tag 'path'.
   *
   *
   *
   *
   *
   *
   *               M100,200 C100,100 250,100 250,200
   * S400,300 400,200
   *
   * @deprecated (since 1.64)
   */
  export default class Path extends Shape {
    /**
     * Creates and initializes a new Path class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PathSettings
    );
    /**
     * Creates and initializes a new Path class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PathSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Path with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Path>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Path.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of path element. The 'd' attribute has very powerful grammar. Rich extension of paths
     * is provided in namespace `sap.gantt.shape.ext`.
     *  This shape provides a default implementation of the d attribute:
     *
     *         time endTime
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property {@link #getFill fill}.
     *
     * Default value is `"none"`.
     *
     *
     * @returns Value of property `fill`
     */
    getFill(): string;
    /**
     * Gets the value of property `isClosed`.
     *
     *  When this value is true, the 'fill' attribute is applied. Otherwise, the 'fill' attribute is none.
     *
     *
     *
     * @returns Value of property `isClosed`.
     */
    getIsClosed(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getD d}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setD(
      /**
       * New value for property `d`
       */
      sD: string
    ): this;
    /**
     * Sets a new value for property {@link #getFill fill}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"none"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFill(
      /**
       * New value for property `fill`
       */
      sFill?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIsClosed isClosed}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsClosed(
      /**
       * New value for property `isClosed`
       */
      bIsClosed?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"path"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Path constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $PathSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    isClosed?: boolean | PropertyBindingInfo | `{${string}}`;

    fill?: string | PropertyBindingInfo;

    d?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/Polygon" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Polygon shape class using SVG tag 'polygon'.
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Polygon extends Shape {
    /**
     * Creates and initializes a new Polygon class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PolygonSettings
    );
    /**
     * Creates and initializes a new Polygon class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PolygonSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Polygon with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Polygon>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Polygon.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `points`.
     *
     *  Points attribute of the polygon element. Rich extension of paths is provided in namespace `sap.gantt.shape.ext`.
     *  This shape provides a default implementation of points:
     *
     *        time rotation Center
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getPoints points}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPoints(
      /**
       * New value for property `points`
       */
      sPoints: string
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"polygon"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Polygon constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $PolygonSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    points?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/Polyline" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Polyline shape class using SVG tag 'polyline'.
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Polyline extends Shape {
    /**
     * Creates and initializes a new Polyline class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $PolylineSettings
    );
    /**
     * Creates and initializes a new Polyline class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $PolylineSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Polyline with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Polyline>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Polyline.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getFill fill}.
     *
     * Default value is `"none"`.
     *
     *
     * @returns Value of property `fill`
     */
    getFill(): string;
    /**
     * Gets the value of property `points`.
     *
     *  points attribute of the polygon shape. This shape provides a default implementation of points:
     *
     *        time rotation Center
     *
     *
     * @returns Value of property `points`.
     */
    getPoints(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getFill fill}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"none"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFill(
      /**
       * New value for property `fill`
       */
      sFill?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPoints points}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPoints(
      /**
       * New value for property `points`
       */
      sPoints: string
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"polyline"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Polyline constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $PolylineSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    fill?: string | PropertyBindingInfo;

    points?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/Rectangle" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Rectangle shape class using SVG tag 'rect'. This shape is usually used to represent durations.
   *
   *
   *
   *
   *
   *
   *
   *
   *
   *
   * @deprecated (since 1.64)
   */
  export default class Rectangle extends Shape {
    /**
     * Creates and initializes a new Rectangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $RectangleSettings
    );
    /**
     * Creates and initializes a new Rectangle class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $RectangleSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Rectangle with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Rectangle>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Rectangle.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `height`.
     *
     *  Height of the rectangle.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `isDuration`.
     *
     *
     * @returns Value of property `isDuration`.
     */
    getIsDuration(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `rx`.
     *
     *  Rx of the rectangle.
     *
     *
     * @returns Value of property `rx`.
     */
    getRx(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `ry`.
     *
     *  Ry of the rectangle.
     *
     *
     * @returns Value of property `ry`.
     */
    getRy(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** TWe do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `width`.
     *
     *  Width of the rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using properties
     * `time` and `endTime`. If you override the default value calculated by the getter, proper rendering is
     * not guaranteed.
     *
     *
     * @returns Value of property `width`.
     */
    getWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x`.
     *
     *  x coordinate of the top-left corner of the rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `time`
     * as a base.
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y`.
     *
     *  y coordinate of the top-left corner of the rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`
     * as a base and uses property `height` as an offset to align the center of the row rectangle along the
     * y axis. If you override the default value calculated by the getter, the alignment of the center is not
     * guaranteed.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `15`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      fHeight?: float
    ): this;
    /**
     * Sets a new value for property {@link #getIsDuration isDuration}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDuration(
      /**
       * New value for property `isDuration`
       */
      bIsDuration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRx rx}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRx(
      /**
       * New value for property `rx`
       */
      sRx?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRy ry}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"0"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRy(
      /**
       * New value for property `ry`
       */
      sRy?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"rect"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      fWidth: float
    ): this;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Rectangle constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $RectangleSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    isDuration?: boolean | PropertyBindingInfo | `{${string}}`;

    x?: float | PropertyBindingInfo | `{${string}}`;

    y?: float | PropertyBindingInfo | `{${string}}`;

    width?: float | PropertyBindingInfo | `{${string}}`;

    height?: float | PropertyBindingInfo | `{${string}}`;

    rx?: string | PropertyBindingInfo;

    ry?: string | PropertyBindingInfo;
  }
}

declare module "sap/gantt/shape/ResizeShadowShape" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   *  Provides an implementation of shadow shapes, allowing you to create a highlighting effect by drawing
   * the shadow shapes with thicker strokes in red.
   *
   * @deprecated (since 1.64)
   */
  export default class ResizeShadowShape extends Path {
    /**
     * Constructor for a new ResizeShadowShape.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial instance for the new control
       */
      mSettings?: $ResizeShadowShapeSettings
    );
    /**
     * Constructor for a new ResizeShadowShape.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the ResizeShadowShape instance
       */
      sId?: string,
      /**
       * Initial instance for the new control
       */
      mSettings?: $ResizeShadowShapeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.ResizeShadowShape with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ResizeShadowShape>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.ResizeShadowShape.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * Default value is `15`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): int;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `15`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      iHeight?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ResizeShadowShape constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ResizeShadowShapeSettings extends $PathSettings {
    height?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/SelectedShape" {
  import { default as Path, $PathSettings } from "sap/gantt/shape/Path";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   *  Provides an implementation of selected shapes, allowing you to create a highlighting effect by drawing
   * the selected shapes with red and thicker strokes.
   *
   * @deprecated (since 1.64)
   */
  export default class SelectedShape extends Path {
    /**
     * Constructor for a new SelectedShape.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $SelectedShapeSettings
    );
    /**
     * Constructor for a new SelectedShape.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $SelectedShapeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.SelectedShape with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Path.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, SelectedShape>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.SelectedShape.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `d`.
     *
     *  d attribute of the path element.
     *
     * Usually applications do not set this value. This getter carries out the calculation using properties
     * `time`, `endTime`, `tailLength`, `headLength`, and `height`.
     *
     *
     * @returns Value of property `d` or null if the generated d is invalid according to the given data.
     */
    getD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `enableDnD`.
     *
     *  This value determines whether the selectedShape of a shape is enabled for drag-and-drop.
     *
     *
     * @returns Value of property `enableDnD`.
     */
    getEnableDnD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `enableSelection`.
     *
     *  This value determines whether the selectedShape of a shape is enabled for selection.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** HTML color and url reference to paint server can be provided
     * to fill. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData?: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo?: object
    ): string;
    /**
     * Gets current value of property `fillOpacity`.
     *
     *  Standard SVG 'fill-Opacity' attribute.
     *
     *
     * @returns Value of property `fillOpacity`.
     */
    getFillOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo?: object
    ): number;
    /**
     * Gets the value of property `height`.
     *
     *  This value determines the height of the selectedShape.
     *
     *
     * @returns Value of property `height`.
     */
    getHeight(
      /**
       * Shape data.
       */
      oData: object
    ): number;
    /**
     * Gets current value of property `isDuration`.
     *
     *  When this flag is set to true, the shape is called 'duration shape'. And `time` stands for startTime,
     * `endTime` stands for end time. When this flag is set to be false, the shape is called 'transient shape'.
     * And only `time` is used. Usually these 3 properties are used to determine x position of one shape.
     *
     *
     * @returns Value of property `isDuration`.
     */
    getIsDuration(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets the value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** An HTML color and URL reference to an SVG definition can
     * be provided for strokes. SVG definitions usually come from SVG definitions rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable}, or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `strokeOpacity`.
     *
     *  Standard SVG 'stroke-Opacity' attribute.
     *
     *
     * @returns Value of property `strokeOpacity`.
     */
    getStrokeOpacity(
      /**
       * Shape data.
       */
      oData: object
    ): number;
    /**
     * Gets the value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `transform`.
     *
     *  Standard SVG 'transform' attribute. The implementation of getTransform() provides some logic to enable
     * properties `rotationCenter` and `rotationAngle`. If you override the default value calculated by the
     * getter, proper rotation is not guaranteed.
     *
     *
     * @returns Value of property `transform`.
     */
    getTransform(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Sets a new value for property {@link #getFill fill}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"none"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFill(
      /**
       * New value for property `fill`
       */
      sFill?: string
    ): this;
    /**
     * Sets a new value for property {@link #getFillOpacity fillOpacity}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFillOpacity(
      /**
       * New value for property `fillOpacity`
       */
      fFillOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `15`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      iHeight?: int
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeOpacity strokeOpacity}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeOpacity(
      /**
       * New value for property `strokeOpacity`
       */
      fStrokeOpacity?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the SelectedShape constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $SelectedShapeSettings extends $PathSettings {
    fill?: string | PropertyBindingInfo;

    fillOpacity?: float | PropertyBindingInfo | `{${string}}`;

    strokeOpacity?: float | PropertyBindingInfo | `{${string}}`;

    height?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/shape/Shape" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import ResizeShadowShape from "sap/gantt/shape/ResizeShadowShape";

  import SelectedShape from "sap/gantt/shape/SelectedShape";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Base class for all shape classes.
   *
   *  Shape class is designed to describe how data should be visualized by an SVG tag. Most shape classes
   * contain only properties and only one aggregation:
   * 	 - Some properties come from standard SVG attribute. Examples are `fill`, `stroke` etc.
   * 	 - Some properties designed to put Shape class into Gantt chart's coordinate system, especially the
   *     X axis called `sap.gantt.misc.AxisTime`. Examples are `time`, `endTime` etc.
   * 	 - Some properties are designed to provide some geometry attributes. Examples are `side`, `center` in
   *     some extend shapes.
   * 	 - Every shape has aggregation called selectedShape to provide a way to specify how selection of the
   *     shape should be designed.
   * 	 - Some container shapes like `g` and `clippath` has aggregation to aggregate other shapes in.
   *
   * Because d3 is used underneath and d3 use array to do batch data-binding, therefore Shape classes are
   * not designed in the way of SAPUI5 standard data-binding (one shape instance per data). Instead, each
   * Shape instance stands for a particular way of visualize one data structure. And one Shape instance is
   * used to draw a list of data by Drawers in Gantt chart.
   *
   * Because of this specialty, application cannot instantiate a shape class directly. Instead they can use
   * configuration {@link sap.gantt.config.Shape} to describe which Shape class is used to draw which data
   * in what way. And pass this configuration to Gantt chart control by property `shapes`. Gantt chart control
   * use these configurations to instatiate Shape instances and Drawers. Drawers consumes Shape instances
   * to draw real SVG shapes.
   *
   * Each shape classes are designed to support 'configuration-first' principle. So called configure is the
   * `shapeProperties` property of `sap.gantt.config.Shape`. In this object property, application can provide
   * following things:
   * 	 - A value. Example: `{tooltip: 'svg rocks'}.`
   * 	 - An attribute from data. Example: `{time: {startTime}}`
   * 	 - A formatted attribute from data. Example: `{tooltip: "{time:Timestamp} the stock price falls to {price:Number}."}`
   *     The typed numeric values for the key number are formatted by the configurations provided by {@link sap.ui.core.format.NumberFormat},
   *     and the date and time values for the key timestamp are formatted by the configurations provided by {@link sap.gantt.misc.Format}.
   *
   *
   * In many applications, simple configuration or even binding cannot meet business requriement. Therefore
   * applications are allowed to extend shapes and provide their own getter methods to effect all properties
   * by data. For in row shapes, two parameters are injected to help application to do coding. All the shapes
   * provided by Gantt chart follows 'configuration first' principle by invoking method `_configFirst()`.
   * Meaning if application provide value by sap.gantt.config.Shape, the configuration over-write code logic
   * in getters.
   *
   * **Note:** Setter methods are only used for set default values. Because a Shape instance stands for a
   * way of drawing. The instance self does not hold any status (property values). Meanwhile, all getter are
   * injected with actual data and related informations to adapt to d3 paradigm.
   *
   * @deprecated (since 1.64)
   */
  export default abstract class Shape extends UI5Element {
    /**
     * Creates and initializes a new Shape class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ShapeSettings
    );
    /**
     * Creates and initializes a new Shape class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ShapeSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Shape with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Shape>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Shape.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * This method must be used to ensure 'configuration-first' principle for extended shapes.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Resolved attribute.
     */
    _configFirst(
      /**
       * Attribute name.
       */
      sAttrName: string,
      /**
       * Shape data.
       */
      oData: object,
      /**
       * whether scale by size mode or not
       */
      bScaleBySapUiSizeMode: boolean
    ): string;
    /**
     * Rotate Shape
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _rotate(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Shape Row Info.
       */
      oRowInfo: object,
      /**
       * Return Value.
       */
      aRetVal: object
    ): void;
    /**
     * Provide logic for rotation considering RTL.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Actual rotation angle.
     */
    _rtlRotation(
      /**
       * Rotation angle.
       */
      nAngle: number
    ): number;
    /**
     * Translate Shape
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _translate(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Shape Row Info.
       */
      oRowInfo: object,
      /**
       * Return Value.
       */
      aRetVal: object
    ): void;
    /**
     * Destroys the resizeShadowShape in the aggregation {@link #getResizeShadowShape resizeShadowShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyResizeShadowShape(): this;
    /**
     * Destroys the selectedShape in the aggregation {@link #getSelectedShape selectedShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySelectedShape(): this;
    /**
     * Gets current value of property `ariaLabel`.
     *
     * Arial Label enables screen readers.
     *
     *
     * @returns Value of property `ariaLabel`.
     */
    getAriaLabel(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `arrayAttribute`.
     *
     *  Specify which attribute is child array.
     *
     *
     * @returns Value of property `arrayAttribute`.
     */
    getArrayAttribute(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Get the AxisTime of gantt chart instance
     *
     *
     * @returns the AxisTime instance
     */
    getAxisTime(): object;
    /**
     * Gets current value of property `category`.
     *
     * Values are in enum {@link sap.gantt.shape.ShapeCategory}.
     *
     *
     * @returns Value of property `category`.
     */
    getCategory(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `clipPath`.
     *
     *  Standard SVG 'clippath' attribute.
     *
     *
     * @returns Value of property `clipPath`.
     */
    getClipPath(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `enableDnD`.
     *
     *  This value controls whether a shape is enabled for drag-and-drop behavior.
     *
     *
     * @returns Value of property `enableDnD`.
     */
    getEnableDnD(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `enableHover`.
     *
     *  This value controls whether a shape is enabled to fire mouse enter and leave event.
     *
     *
     * @returns Value of property `enableHover`.
     */
    getEnableHover(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `enableResize`.
     *
     *  This value controls whether a shape is enabled for the resize behavior.
     *
     *
     * @returns Value of property `enableResize`.
     */
    getEnableResize(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `enableSelection`.
     *
     *  This value controls whether a shape is enabled for selection behavior.
     *
     *
     * @returns Value of property `enableSelection`.
     */
    getEnableSelection(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `endTime`.
     *
     * End timestamp for duration shape.
     *
     *
     * @returns Value of property `endTime`.
     */
    getEndTime(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `endTimeFilterAttribute`.
     *
     *  Specify which is end time attribute of items in child array.
     *
     *
     * @returns Value of property `endTimeFilterAttribute`.
     */
    getEndTimeFilterAttribute(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `fill`.
     *
     *  Standard SVG 'fill' attribute. **Note:** HTML color and url reference to paint server can be provided
     * to fill. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `fill`.
     */
    getFill(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `fillOpacity`.
     *
     *  Standard SVG 'fill-Opacity' attribute.
     *
     *
     * @returns Value of property `fillOpacity`.
     */
    getFillOpacity(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `filter`.
     *
     *  Standard SVG 'filter' attribute. Usually value of filter is an url referenced from paint server definition
     * rendered by {@link sap.gantt.GanttChartContainer}, {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     *
     * @returns Value of property `filter`.
     */
    getFilter(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `htmlClass`.
     *
     * Customized html classes. Multiple classes can be provided and seperated by space.
     *
     *
     * @returns Value of property `htmlClass`.
     */
    getHtmlClass(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `isBulk`.
     *
     *  Gantt chart do filtering of data by timestamp for performance sake. For simple shapes which has `time`
     * or `endTime` provided, set this flag to false. For shapes (path or polygon) which connect a list of data,
     * set this value to false. And if filtering is required to next level data, provide `arrayAttribute`, `timeFilterAttribute`
     * and `endTimeFilterAttribute` in combination.
     *
     *
     * @returns Value of property `isBulk`.
     */
    getIsBulk(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets current value of property `isDuration`.
     *
     *  When this flag is set to true, the shape is called 'duration shape'. And `time` stands for startTime,
     * `endTime` stands for end time. When this flag is set to be false, the shape is called 'transient shape'.
     * And only `time` is used. Usually these 3 properties are used to determine x position of one shape.
     *
     *
     * @returns Value of property `isDuration`.
     */
    getIsDuration(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): boolean;
    /**
     * Gets legend value of property `legend`.
     *
     *  Specifies the legend text of the shape.
     *
     *
     * @returns Value of property `legend`.
     */
    getLegend(
      /**
       * Shape data.
       */
      oData: object
    ): string;
    /**
     * Retrieves the parent shape's referenceId.
     *
     *  The referenceId, which is related to shape data, is generated by a Group shape. Aggregation shapes
     * can use this method to retrieve the referenceId.
     *
     *
     * @returns Value of `referenceId`.
     */
    getParentReferenceId(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets content of aggregation {@link #getResizeShadowShape resizeShadowShape}.
     *
     * Resize Shadow Shape.
     *
     * Resize Shadow shape specifies how to draw the shadow highlight when resizing. Applications can implement
     * it by extending `sap.gantt.shape.ResizeShadowShape` and configure it in `sap.gantt.config.Shape`.
     */
    getResizeShadowShape(): ResizeShadowShape;
    /**
     * Gets current value of property `rotationAngle`.
     *
     *  This value is used in combination of property `rotationCenter`. By providing both shape can be rotated
     * with any angle around rotation center.
     *
     *
     * @returns Value of property `rotationAngle`.
     */
    getRotationAngle(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `rotationCenter`.
     *
     *  This value is used in combination of property `rotationAngle`. By providing both shape can be rotated
     * with any angle around rotation center. Default implementation is the coordinate at `time` in x coordinate,
     * and `rowYCenter` in y coordinate. If application over-write this property by configuration or code, the
     * logic cannot be guaranteed.
     *
     *
     * @returns Value of property `rotationCenter`.
     */
    getRotationCenter(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): any[];
    /**
     * Gets current value of property `rowYCenter`.
     *
     *  Default implementation is return the middle position of the row in y direction. If application over-write
     * this property by configuration or code, the logic cannot be guaranteed.
     *
     *
     * @returns Value of property `rowYCenter`.
     */
    getRowYCenter(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): any[];
    /**
     * Gets content of aggregation {@link #getSelectedShape selectedShape}.
     *
     * Selected Shape.
     *
     * Selected shape specifies how to draw the selection high-light. Application can implement it by extending
     * `sap.gantt.shape.SelectedShape` and configure it in `sap.gantt.config.Shape`.
     */
    getSelectedShape(): SelectedShape;
    /**
     * This method is used to get view boundary for visible area in Gantt Chart. The view boundary is a range
     * of x-coordinate for visible area.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns View boundary for visible area in Gantt Chart.
     */
    getShapeViewBoundary(): any[];
    /**
     * Gets current value of property `stroke`.
     *
     *  Standard SVG 'stroke' attribute. **Note:** HTML color and url reference to paint server can be provided
     * to stroke. Paint server definitions usually comes from paint servers rendered by {@link sap.gantt.GanttChartContainer},
     * {@link sap.gantt.GanttChartWithTable} or {@link sap.gantt.GanttChart}.
     *
     *
     * @returns Value of property `stroke`.
     */
    getStroke(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `strokeDasharray`.
     *
     *  Standard SVG 'stroke-dasharray' attribute.
     *
     *
     * @returns Value of property `strokeDasharray`.
     */
    getStrokeDasharray(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `strokeOpacity`.
     *
     *  Standard SVG 'stroke-Opacity' attribute.
     *
     *
     * @returns Value of property `strokeOpacity`.
     */
    getStrokeOpacity(
      /**
       * Shape data.
       */
      oData: object
    ): number;
    /**
     * Gets current value of property `strokeWidth`.
     *
     *  Standard SVG 'stroke-width' attribute.
     *
     *
     * @returns Value of property `strokeWidth`.
     */
    getStrokeWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Get the shape style string
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns shape styles
     */
    getStyle(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** This value is not recommended to be over-written by configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `time`.
     *
     * Timestamp for transient shape or start timestamp for duration shape.
     *
     *
     * @returns Value of property `time`.
     */
    getTime(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `timeFilterAttribute`.
     *
     *  Specify which is time attribute of items in child array.
     *
     *
     * @returns Value of property `timeFilterAttribute`.
     */
    getTimeFilterAttribute(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `title`.
     *
     * Title is visualized as tooltip by browser. **Notes:** Use character entity to do simple text tabbing
     * and breaking. (Use "	" for tab and "
     * " for break.)
     *
     *
     * @returns Value of property `title`.
     */
    getTitle(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `transform`.
     *
     *  Standard SVG 'transform' attribute. Some logic in getTransform() is provided to enable property `rotationCenter`
     * and `rotationAngle`. If application over-write this property by configuration or coding, rotation behavior
     * cannot be guaranteed.
     *
     *
     * @returns Value of property `transform`.
     */
    getTransform(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets current value of property `xBias`.
     *
     *  Fine-tune x coordinate. This value only works for category `inRowShape`. Shape usually determines
     * position in x coordinate by property `isDuration`, `time` and `endTime`. Application can use this property
     * to do some x coordinate adjustment in pixel. The xBias will be automatically mirrored for RTL mode. It
     * means if you set 10 to property xBias, in RTL mode, the value of the xBias will be -10.
     *
     *
     * @returns Value of property `xBias`.
     */
    getXBias(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets current value of property `yBias`.
     *
     *  Fine-tune y coordinate. This value only works for category `inRowShape`. Y coordinate is automatically
     * determined by row. Application can use this property to do some y coordinate adjustment in pixel.
     *
     *
     * @returns Value of property `yBias`.
     */
    getYBias(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information of the row and row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getAriaLabel ariaLabel}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaLabel(
      /**
       * New value for property `ariaLabel`
       */
      sAriaLabel: string
    ): this;
    /**
     * Sets a new value for property {@link #getArrayAttribute arrayAttribute}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArrayAttribute(
      /**
       * New value for property `arrayAttribute`
       */
      sArrayAttribute: string
    ): this;
    /**
     * Sets a new value for property {@link #getCategory category}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `library.shape.ShapeCategory.InRowShape`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCategory(
      /**
       * New value for property `category`
       */
      sCategory?: string
    ): this;
    /**
     * Sets a new value for property {@link #getClipPath clipPath}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setClipPath(
      /**
       * New value for property `clipPath`
       */
      sClipPath: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnableDnD enableDnD}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableDnD(
      /**
       * New value for property `enableDnD`
       */
      bEnableDnD?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableHover enableHover}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableHover(
      /**
       * New value for property `enableHover`
       */
      bEnableHover?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableResize enableResize}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableResize(
      /**
       * New value for property `enableResize`
       */
      bEnableResize?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableSelection enableSelection}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableSelection(
      /**
       * New value for property `enableSelection`
       */
      bEnableSelection?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEndTime endTime}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndTime(
      /**
       * New value for property `endTime`
       */
      sEndTime: string
    ): this;
    /**
     * Sets a new value for property {@link #getEndTimeFilterAttribute endTimeFilterAttribute}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndTimeFilterAttribute(
      /**
       * New value for property `endTimeFilterAttribute`
       */
      sEndTimeFilterAttribute: string
    ): this;
    /**
     * Sets a new value for property {@link #getFill fill}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFill(
      /**
       * New value for property `fill`
       */
      sFill: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getFillOpacity fillOpacity}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFillOpacity(
      /**
       * New value for property `fillOpacity`
       */
      fFillOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFilter filter}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilter(
      /**
       * New value for property `filter`
       */
      sFilter: string
    ): this;
    /**
     * Sets a new value for property {@link #getHtmlClass htmlClass}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHtmlClass(
      /**
       * New value for property `htmlClass`
       */
      sHtmlClass: string
    ): this;
    /**
     * Sets a new value for property {@link #getIsBulk isBulk}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsBulk(
      /**
       * New value for property `isBulk`
       */
      bIsBulk?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIsDuration isDuration}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsDuration(
      /**
       * New value for property `isDuration`
       */
      bIsDuration?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getLegend legend}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLegend(
      /**
       * New value for property `legend`
       */
      sLegend: string
    ): this;
    /**
     * Sets the aggregated {@link #getResizeShadowShape resizeShadowShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResizeShadowShape(
      /**
       * The resizeShadowShape to set
       */
      oResizeShadowShape: ResizeShadowShape
    ): this;
    /**
     * Sets a new value for property {@link #getRotationAngle rotationAngle}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRotationAngle(
      /**
       * New value for property `rotationAngle`
       */
      fRotationAngle: float
    ): this;
    /**
     * Sets a new value for property {@link #getRotationCenter rotationCenter}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRotationCenter(
      /**
       * New value for property `rotationCenter`
       */
      sRotationCenter: float[]
    ): this;
    /**
     * Sets a new value for property {@link #getRowYCenter rowYCenter}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `7.5`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRowYCenter(
      /**
       * New value for property `rowYCenter`
       */
      fRowYCenter?: float
    ): this;
    /**
     * Sets the aggregated {@link #getSelectedShape selectedShape}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedShape(
      /**
       * The selectedShape to set
       */
      oSelectedShape: SelectedShape
    ): this;
    /**
     * Sets a new value for property {@link #getStroke stroke}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStroke(
      /**
       * New value for property `stroke`
       */
      sStroke: ValueSVGPaintServer
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeDasharray strokeDasharray}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeDasharray(
      /**
       * New value for property `strokeDasharray`
       */
      sStrokeDasharray: string
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeOpacity strokeOpacity}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeOpacity(
      /**
       * New value for property `strokeOpacity`
       */
      fStrokeOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getStrokeWidth strokeWidth}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStrokeWidth(
      /**
       * New value for property `strokeWidth`
       */
      fStrokeWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag: string
    ): this;
    /**
     * Sets a new value for property {@link #getTime time}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTime(
      /**
       * New value for property `time`
       */
      sTime: string
    ): this;
    /**
     * Sets a new value for property {@link #getTimeFilterAttribute timeFilterAttribute}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimeFilterAttribute(
      /**
       * New value for property `timeFilterAttribute`
       */
      sTimeFilterAttribute: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle: string
    ): this;
    /**
     * Sets a new value for property {@link #getTransform transform}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTransform(
      /**
       * New value for property `transform`
       */
      sTransform: string
    ): this;
    /**
     * Sets a new value for property {@link #getXBias xBias}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setXBias(
      /**
       * New value for property `xBias`
       */
      fXBias?: float
    ): this;
    /**
     * Sets a new value for property {@link #getYBias yBias}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setYBias(
      /**
       * New value for property `yBias`
       */
      fYBias?: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Shape constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $ShapeSettings extends $ElementSettings {
    tag?: string | PropertyBindingInfo;

    category?: string | PropertyBindingInfo;

    htmlClass?: string | PropertyBindingInfo;

    isDuration?: boolean | PropertyBindingInfo | `{${string}}`;

    time?: string | PropertyBindingInfo;

    endTime?: string | PropertyBindingInfo;

    title?: string | PropertyBindingInfo;

    ariaLabel?: string | PropertyBindingInfo;

    xBias?: float | PropertyBindingInfo | `{${string}}`;

    yBias?: float | PropertyBindingInfo | `{${string}}`;

    fill?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    strokeOpacity?: float | PropertyBindingInfo | `{${string}}`;

    fillOpacity?: float | PropertyBindingInfo | `{${string}}`;

    stroke?: ValueSVGPaintServer | PropertyBindingInfo | `{${string}}`;

    strokeWidth?: float | PropertyBindingInfo | `{${string}}`;

    strokeDasharray?: string | PropertyBindingInfo;

    clipPath?: string | PropertyBindingInfo;

    transform?: string | PropertyBindingInfo;

    filter?: string | PropertyBindingInfo;

    enableHover?: boolean | PropertyBindingInfo | `{${string}}`;

    enableDnD?: boolean | PropertyBindingInfo | `{${string}}`;

    enableSelection?: boolean | PropertyBindingInfo | `{${string}}`;

    enableResize?: boolean | PropertyBindingInfo | `{${string}}`;

    rowYCenter?: float | PropertyBindingInfo | `{${string}}`;

    rotationCenter?: float[] | PropertyBindingInfo | `{${string}}`;

    rotationAngle?: float | PropertyBindingInfo | `{${string}}`;

    isBulk?: boolean | PropertyBindingInfo | `{${string}}`;

    arrayAttribute?: string | PropertyBindingInfo;

    timeFilterAttribute?: string | PropertyBindingInfo;

    endTimeFilterAttribute?: string | PropertyBindingInfo;

    legend?: string | PropertyBindingInfo;

    /**
     * Selected Shape.
     *
     * Selected shape specifies how to draw the selection high-light. Application can implement it by extending
     * `sap.gantt.shape.SelectedShape` and configure it in `sap.gantt.config.Shape`.
     */
    selectedShape?: SelectedShape;

    /**
     * Resize Shadow Shape.
     *
     * Resize Shadow shape specifies how to draw the shadow highlight when resizing. Applications can implement
     * it by extending `sap.gantt.shape.ResizeShadowShape` and configure it in `sap.gantt.config.Shape`.
     */
    resizeShadowShape?: ResizeShadowShape;
  }
}

declare module "sap/gantt/shape/Text" {
  import { default as Shape, $ShapeSettings } from "sap/gantt/shape/Shape";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Text shape class using SVG tag 'text'. This shape is usually used to represent points in time.
   *
   *
   *  Hello, out there
   *
   *
   *
   *   Normal text Text with line-through Underlined text  One  word  has  different  underlining
   *
   * @deprecated (since 1.64)
   */
  export default class Text extends Shape {
    /**
     * Creates and initializes a new Text class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $TextSettings
    );
    /**
     * Creates and initializes a new Text class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $TextSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.shape.Text with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.shape.Shape.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Text>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.shape.Text.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the value of property `ellipsisWidth`.
     *
     *  Ellipsis width if truncate happens. Default value 12 indicates 12px length reserved for ellipsis.
     * If the value is -1, no ellipsis appears even truncate happens. If the value is bigger than -1, ellipsis
     * will be 3 dots in length of this value.
     *
     *
     * @returns Value of property `ellipsisWidth`.
     */
    getEllipsisWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `fontFamily`.
     *
     *  Text font family.
     *
     *
     * @returns Value of property `fontFamily`.
     */
    getFontFamily(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `fontSize`.
     *
     *  Text font size.
     *
     *
     * @returns Value of property `fontSize`.
     */
    getFontSize(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `tag`.
     *
     * SVG tag name of the shape. **Note:** We do not recommend that you change this value using a configuration
     * or coding.
     *
     *
     * @returns Value of property `tag`.
     */
    getTag(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `text`.
     *
     *  Text string.
     *
     *
     * @returns Value of property `text`.
     */
    getText(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `textAnchor`.
     *
     *  Text anchor. Possible values are 'start', 'middle', and 'end'.
     *
     *
     * @returns Value of property `textAnchor`.
     */
    getTextAnchor(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): string;
    /**
     * Gets the value of property `truncateWidth`.
     *
     *  Truncating width. Default value -1 indicates truncating function is not activated. To enable truncating,
     * give a truncate width here. If text length exceeds truncate width, text is truncated.
     *
     *
     * @returns Value of property `truncateWidth`.
     */
    getTruncateWidth(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `x`.
     *
     *  x coordinate of the bottom-left corner of the rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using property `time`.
     * If you override the default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     *
     * @returns Value of property `x`.
     */
    getX(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Gets the value of property `y`.
     *
     *  y coordinate of the bottom-left corner of the rectangle.
     *
     * Usually applications do not set this value. This getter carries out the calculation using parameter `oRowInfo`
     * and property `height` to align the center of the row rectangle along the y axis. If you override the
     * default value calculated by the getter, the alignment of the center is not guaranteed.
     *
     *
     * @returns Value of property `y`.
     */
    getY(
      /**
       * Shape data.
       */
      oData: object,
      /**
       * Information about the row and the row data.
       */
      oRowInfo: object
    ): number;
    /**
     * Sets a new value for property {@link #getEllipsisWidth ellipsisWidth}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `12`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEllipsisWidth(
      /**
       * New value for property `ellipsisWidth`
       */
      fEllipsisWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getFontFamily fontFamily}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontFamily(
      /**
       * New value for property `fontFamily`
       */
      sFontFamily: string
    ): this;
    /**
     * Sets a new value for property {@link #getFontSize fontSize}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `10`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFontSize(
      /**
       * New value for property `fontSize`
       */
      iFontSize?: int
    ): this;
    /**
     * Sets a new value for property {@link #getTag tag}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"text"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTag(
      /**
       * New value for property `tag`
       */
      sTag?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextAnchor textAnchor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"start"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextAnchor(
      /**
       * New value for property `textAnchor`
       */
      sTextAnchor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTruncateWidth truncateWidth}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTruncateWidth(
      /**
       * New value for property `truncateWidth`
       */
      fTruncateWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getWrapDy wrapDy}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `20`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrapDy(
      /**
       * New value for property `wrapDy`
       */
      fWrapDy?: float
    ): this;
    /**
     * Sets a new value for property {@link #getWrapWidth wrapWidth}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrapWidth(
      /**
       * New value for property `wrapWidth`
       */
      fWrapWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getX x}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setX(
      /**
       * New value for property `x`
       */
      fX: float
    ): this;
    /**
     * Sets a new value for property {@link #getY y}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setY(
      /**
       * New value for property `y`
       */
      fY: float
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Text constructor.
   *
   * @deprecated (since 1.64)
   */
  export interface $TextSettings extends $ShapeSettings {
    tag?: string | PropertyBindingInfo;

    text?: string | PropertyBindingInfo;

    x?: float | PropertyBindingInfo | `{${string}}`;

    y?: float | PropertyBindingInfo | `{${string}}`;

    fontSize?: int | PropertyBindingInfo | `{${string}}`;

    textAnchor?: string | PropertyBindingInfo;

    fontFamily?: string | PropertyBindingInfo;

    wrapWidth?: float | PropertyBindingInfo | `{${string}}`;

    wrapDy?: float | PropertyBindingInfo | `{${string}}`;

    truncateWidth?: float | PropertyBindingInfo | `{${string}}`;

    ellipsisWidth?: float | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/gantt/simple/AdhocDiamond" {
  import {
    default as BaseDiamond,
    $BaseDiamondSettings,
  } from "sap/gantt/simple/BaseDiamond";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The AdhocDiamond class contains properties to draw an AdhocDimond on the Gantt header for every AdhocLine
   * present in the Gantt chart
   *
   * @since 1.84
   */
  export default class AdhocDiamond extends BaseDiamond {
    /**
     * Creates and initializes a new Adhoc Diamond class.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocDiamondSettings
    );
    /**
     * Creates and initializes a new Adhoc Diamond class.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocDiamondSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.simple.AdhocDiamond with name `sClassName` and enriches it
     * with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.gantt.simple.BaseDiamond.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AdhocDiamond>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.simple.AdhocDiamond.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:mouseEnter mouseEnter} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the adhocdiamond is hovered.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMouseEnter(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:mouseEnter mouseEnter} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the adhocdiamond is hovered.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMouseEnter(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:mouseLeave mouseLeave} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the mouse leaves adhocdiamond.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMouseLeave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:mouseLeave mouseLeave} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the mouse leaves adhocdiamond.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMouseLeave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the adhocdiamond is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocDiamond` itself.
     *
     * Fires when the adhocdiamond is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocDiamond` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:mouseEnter mouseEnter} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMouseEnter(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:mouseLeave mouseLeave} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMouseLeave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.gantt.simple.AdhocDiamond`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:mouseEnter mouseEnter} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMouseEnter(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:mouseLeave mouseLeave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMouseLeave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
  }
  /**
   * Describes the settings that can be provided to the AdhocDiamond constructor.
   */
  export interface $AdhocDiamondSettings extends $BaseDiamondSettings {
    /**
     * Fires when the adhocdiamond is pressed.
     */
    press?: (oEvent: Event) => void;

    /**
     * Fires when the adhocdiamond is hovered.
     */
    mouseEnter?: (oEvent: Event) => void;

    /**
     * Fires when the mouse leaves adhocdiamond.
     */
    mouseLeave?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the AdhocDiamond#mouseEnter event.
   */
  export interface AdhocDiamond$MouseEnterEventParameters {}

  /**
   * Event object of the AdhocDiamond#mouseEnter event.
   */
  export type AdhocDiamond$MouseEnterEvent = Event<
    AdhocDiamond$MouseEnterEventParameters,
    AdhocDiamond
  >;

  /**
   * Parameters of the AdhocDiamond#mouseLeave event.
   */
  export interface AdhocDiamond$MouseLeaveEventParameters {}

  /**
   * Event object of the AdhocDiamond#mouseLeave event.
   */
  export type AdhocDiamond$MouseLeaveEvent = Event<
    AdhocDiamond$MouseLeaveEventParameters,
    AdhocDiamond
  >;

  /**
   * Parameters of the AdhocDiamond#press event.
   */
  export interface AdhocDiamond$PressEventParameters {}

  /**
   * Event object of the AdhocDiamond#press event.
   */
  export type AdhocDiamond$PressEvent = Event<
    AdhocDiamond$PressEventParameters,
    AdhocDiamond
  >;
}

declare module "sap/gantt/simple/AdhocLine" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Event from "sap/ui/base/Event";

  import MarkerType from "sap/gantt/simple/MarkerType";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ValueSVGPaintServer } from "sap/gantt/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The AdhocLine class contains properties to draw an additional vertical line at specific time points in
   * the chart area. You can use this line to mark milestones, such as the start of a project start, and special
   * events, such as holidays.
   *
   * @since 1.84
   */
  export default class AdhocLine extends UI5Element {
    /**
     * Creates and initializes a new AdhocLine class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocLineSettings
    );
    /**
     * Creates and initializes a new AdhocLine class.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID of the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AdhocLineSettings
    );

    /**
     * Creates a new subclass of class sap.gantt.simple.AdhocLine with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, AdhocLine>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.gantt.simple.AdhocLine.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:adhoclineDrop adhoclineDrop} event of this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires during drag and drop of the adhoc line.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAdhoclineDrop(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AdhocLine$AdhoclineDropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:adhoclineDrop adhoclineDrop} event of this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires during drag and drop of the adhoc line.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAdhoclineDrop(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: AdhocLine$AdhoclineDropEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerMouseEnter markerMouseEnter} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the adhoc marker is hovered.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerMouseEnter(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerMouseEnter markerMouseEnter} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the adhoc marker is hovered.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerMouseEnter(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerMouseLeave markerMouseLeave} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the mouse leaves adhoc marker.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerMouseLeave(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerMouseLeave markerMouseLeave} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the mouse leaves adhoc marker.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerMouseLeave(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerPress markerPress} event of this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the adhoc marker is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:markerPress markerPress} event of this `sap.gantt.simple.AdhocLine`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.gantt.simple.AdhocLine` itself.
     *
     * Fires when the adhoc marker is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachMarkerPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.gantt.simple.AdhocLine` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:adhoclineDrop adhoclineDrop} event of this
     * `sap.gantt.simple.AdhocLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAdhoclineDrop(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: AdhocLine$AdhoclineDropEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:markerMouseEnter markerMouseEnter} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMarkerMouseEnter(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:markerMouseLeave markerMouseLeave} event of
     * this `sap.gantt.simple.AdhocLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMarkerMouseLeave(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:markerPress markerPress} event of this `sap.gantt.simple.AdhocLine`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachMarkerPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:adhoclineDrop adhoclineDrop} to attached listeners.
     *
     * @since 1.88
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAdhoclineDrop(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: AdhocLine$AdhoclineDropEventParameters
    ): this;
    /**
     * Fires event {@link #event:markerMouseEnter markerMouseEnter} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMarkerMouseEnter(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:markerMouseLeave markerMouseLeave} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMarkerMouseLeave(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:markerPress markerPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireMarkerPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getDescription description}.
     *
     * Description of the time stamp
     *
     *
     * @returns Value of property `description`
     */
    getDescription(): string;
    /**
     * Gets current value of property {@link #getDraggable draggable}.
     *
     * Specifies whether the adhoc line is draggable.
     *
     * Default value is `false`.
     *
     * @since 1.88
     *
     * @returns Value of property `draggable`
     */
    getDraggable(): boolean;
    /**
     * Gets current value of property {@link #getMarkerPopoverDelay markerPopoverDelay}.
     *
     * Delay in milliseconds for the marker popover to show up
     *
     * Default value is `300`.
     *
     * @deprecated (since 1.97) - **Note:**With the new implementation, this property won't have any effect.
     *
     * @returns Value of property `markerPopoverDelay`
     */
    getMarkerPopoverDelay(): int;
    /**
     * Gets current value of property {@link #getMarkerType markerType}.
     *
     * Marker Type for Adhoc Line
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `markerType`
     */
    getMarkerType(): MarkerType | keyof typeof MarkerType;
    /**
     * Gets current value of property {@link #getStroke stroke}.
     *
     * Standard SVG 'stroke' attribute. You can provide the stroke attribute with HTML colors and the URL reference
     * to the paint server. Paint server definitions usually come from paint servers rendered by {@link sap.gantt.simple.GanttChartContainer},
 