import DotLibraryLinter from "./DotLibraryLinter.js";
export default async function lintDotLibrary({ context, filePathsWorkspace }) {
    const dotLibraryResources = await filePathsWorkspace.byGlob("**/.library");
    await Promise.all(dotLibraryResources.map(async (resource) => {
        const linter = new DotLibraryLinter(resource.getPath(), resource.getStream(), context);
        await linter.lint();
    }));
}
//# sourceMappingURL=linter.js.map