/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codemods.migrate.angular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.codemods.migrate.angular.NodeBasedRecipe;

public final class ApplyAngularCLI
extends NodeBasedRecipe {
    @Option(displayName="Angular version", description="Which version of Angular to upgrade", example="17")
    private final @Nullable String version;

    public String getDisplayName() {
        return "Upgrade Angular versions";
    }

    public String getDescription() {
        return "Run `ng update` to upgrade Angular CLI and Angular Core to the specified version.";
    }

    @Override
    protected List<String> getCommand(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        return ApplyAngularCLI.ngCommand("${nodeModules}/node_modules/.bin/", "update", this.getAngularCliPackage(acc, ctx), "@angular/core@" + this.getVersion(), "--force", "--verbose", "--allow-dirty");
    }

    private String getVersion() {
        return Optional.ofNullable(this.version).orElse("latest");
    }

    private static List<String> ngCommand(String nodeModules, String ... args) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodeModules + (ApplyAngularCLI.isWindows() ? "ng.cmd" : "ng"));
        command.addAll(Arrays.asList(args));
        return command;
    }

    @Override
    protected String getAngularCliPackage(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        return "@angular/cli@" + this.getVersion();
    }

    @Override
    protected boolean useNvmExec(NodeBasedRecipe.Accumulator acc, ExecutionContext ctx) {
        return Integer.parseInt(Optional.ofNullable(this.version).orElse("0")) < 15;
    }

    @Generated
    public ApplyAngularCLI(@Nullable String version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "ApplyAngularCLI(version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplyAngularCLI)) {
            return false;
        }
        ApplyAngularCLI other = (ApplyAngularCLI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplyAngularCLI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

