/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { createInputSignal } from './input_signal';
import { REQUIRED_UNSET_VALUE } from './input_signal_node';
export function inputFunction(initialValue, opts) {
    return createInputSignal(initialValue, opts);
}
export function inputRequiredFunction(opts) {
    return createInputSignal(REQUIRED_UNSET_VALUE, opts);
}
/**
 * The `input` function allows declaration of inputs in directives and
 * components.
 *
 * Initializes an input with an initial value. If no explicit value
 * is specified, Angular will use `undefined`.
 *
 * Consider using `input.required` for inputs that don't need an
 * initial value.
 *
 * @usageNotes
 * Initialize an input in your directive or component by declaring a
 * class field and initializing it with the `input()` function.
 *
 * ```ts
 * @Directive({..})
 * export class MyDir {
 *   firstName = input<string>();            // string|undefined
 *   lastName = input.required<string>();    // string
 *   age = input(0);                         // number
 * }
 * ```
 *
 * @developerPreview
 */
export const input = (() => {
    // Note: This may be considered a side-effect, but nothing will depend on
    // this assignment, unless this `input` constant export is accessed. It's a
    // self-contained side effect that is local to the user facing`input` export.
    inputFunction.required = inputRequiredFunction;
    return inputFunction;
})();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5wdXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9hdXRob3JpbmcvaW5wdXQvaW5wdXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUgsT0FBTyxFQUFDLGlCQUFpQixFQUErRyxNQUFNLGdCQUFnQixDQUFDO0FBQy9KLE9BQU8sRUFBQyxvQkFBb0IsRUFBQyxNQUFNLHFCQUFxQixDQUFDO0FBRXpELE1BQU0sVUFBVSxhQUFhLENBQ3pCLFlBQW9CLEVBQ3BCLElBQWtDO0lBQ3BDLE9BQU8saUJBQWlCLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDO0FBQy9DLENBQUM7QUFFRCxNQUFNLFVBQVUscUJBQXFCLENBQWdCLElBQWtDO0lBRXJGLE9BQU8saUJBQWlCLENBQUMsb0JBQTZCLEVBQUUsSUFBSSxDQUFDLENBQUM7QUFDaEUsQ0FBQztBQXdERDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBd0JHO0FBQ0gsTUFBTSxDQUFDLE1BQU0sS0FBSyxHQUFrQixDQUFDLEdBQUcsRUFBRTtJQUN4Qyx5RUFBeUU7SUFDekUsMkVBQTJFO0lBQzNFLDZFQUE2RTtJQUM1RSxhQUFxQixDQUFDLFFBQVEsR0FBRyxxQkFBcUIsQ0FBQztJQUN4RCxPQUFPLGFBQWdGLENBQUM7QUFDMUYsQ0FBQyxDQUFDLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQge2NyZWF0ZUlucHV0U2lnbmFsLCBJbnB1dE9wdGlvbnMsIElucHV0T3B0aW9uc1dpdGhvdXRUcmFuc2Zvcm0sIElucHV0T3B0aW9uc1dpdGhUcmFuc2Zvcm0sIElucHV0U2lnbmFsLCBJbnB1dFNpZ25hbFdpdGhUcmFuc2Zvcm19IGZyb20gJy4vaW5wdXRfc2lnbmFsJztcbmltcG9ydCB7UkVRVUlSRURfVU5TRVRfVkFMVUV9IGZyb20gJy4vaW5wdXRfc2lnbmFsX25vZGUnO1xuXG5leHBvcnQgZnVuY3Rpb24gaW5wdXRGdW5jdGlvbjxSZWFkVCwgV3JpdGVUPihcbiAgICBpbml0aWFsVmFsdWU/OiBSZWFkVCxcbiAgICBvcHRzPzogSW5wdXRPcHRpb25zPFJlYWRULCBXcml0ZVQ+KTogSW5wdXRTaWduYWxXaXRoVHJhbnNmb3JtPFJlYWRUfHVuZGVmaW5lZCwgV3JpdGVUPiB7XG4gIHJldHVybiBjcmVhdGVJbnB1dFNpZ25hbChpbml0aWFsVmFsdWUsIG9wdHMpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaW5wdXRSZXF1aXJlZEZ1bmN0aW9uPFJlYWRULCBXcml0ZVQ+KG9wdHM/OiBJbnB1dE9wdGlvbnM8UmVhZFQsIFdyaXRlVD4pOlxuICAgIElucHV0U2lnbmFsV2l0aFRyYW5zZm9ybTxSZWFkVCwgV3JpdGVUPiB7XG4gIHJldHVybiBjcmVhdGVJbnB1dFNpZ25hbChSRVFVSVJFRF9VTlNFVF9WQUxVRSBhcyBuZXZlciwgb3B0cyk7XG59XG5cbi8qKlxuICogVGhlIGBpbnB1dGAgZnVuY3Rpb24gYWxsb3dzIGRlY2xhcmF0aW9uIG9mIGlucHV0cyBpbiBkaXJlY3RpdmVzIGFuZFxuICogY29tcG9uZW50cy5cbiAqXG4gKiBUaGUgZnVuY3Rpb24gZXhwb3NlcyBhbiBBUEkgZm9yIGFsc28gZGVjbGFyaW5nIHJlcXVpcmVkIGlucHV0cyB2aWEgdGhlXG4gKiBgaW5wdXQucmVxdWlyZWRgIGZ1bmN0aW9uLlxuICpcbiAqIEB1c2FnZU5vdGVzXG4gKiBJbml0aWFsaXplIGFuIGlucHV0IGluIHlvdXIgZGlyZWN0aXZlIG9yIGNvbXBvbmVudCBieSBkZWNsYXJpbmcgYVxuICogY2xhc3MgZmllbGQgYW5kIGluaXRpYWxpemluZyBpdCB3aXRoIHRoZSBgaW5wdXQoKWAgb3IgYGlucHV0LnJlcXVpcmVkKClgXG4gKiBmdW5jdGlvbi5cbiAqXG4gKiBgYGB0c1xuICogQERpcmVjdGl2ZSh7Li59KVxuICogZXhwb3J0IGNsYXNzIE15RGlyIHtcbiAqICAgZmlyc3ROYW1lID0gaW5wdXQ8c3RyaW5nPigpOyAgICAgICAgICAgIC8vIHN0cmluZ3x1bmRlZmluZWRcbiAqICAgbGFzdE5hbWUgPSBpbnB1dC5yZXF1aXJlZDxzdHJpbmc+KCk7ICAgIC8vIHN0cmluZ1xuICogICBhZ2UgPSBpbnB1dCgwKTsgICAgICAgICAgICAgICAgICAgICAgICAgLy8gbnVtYmVyXG4gKiB9XG4gKiBgYGBcbiAqXG4gKiBAZGV2ZWxvcGVyUHJldmlld1xuICovXG5leHBvcnQgaW50ZXJmYWNlIElucHV0RnVuY3Rpb24ge1xuICAvKipcbiAgICogSW5pdGlhbGl6ZXMgYW4gaW5wdXQgd2l0aCBhbiBpbml0aWFsIHZhbHVlLiBJZiBubyBleHBsaWNpdCB2YWx1ZVxuICAgKiBpcyBzcGVjaWZpZWQsIEFuZ3VsYXIgd2lsbCB1c2UgYHVuZGVmaW5lZGAuXG4gICAqXG4gICAqIENvbnNpZGVyIHVzaW5nIGBpbnB1dC5yZXF1aXJlZGAgZm9yIGlucHV0cyB0aGF0IGRvbid0IG5lZWQgYW5cbiAgICogaW5pdGlhbCB2YWx1ZS5cbiAgICpcbiAgICogQGRldmVsb3BlclByZXZpZXdcbiAgICovXG4gIDxSZWFkVD4oKTogSW5wdXRTaWduYWw8UmVhZFR8dW5kZWZpbmVkPjtcbiAgPFJlYWRUPihpbml0aWFsVmFsdWU6IFJlYWRULCBvcHRzPzogSW5wdXRPcHRpb25zV2l0aG91dFRyYW5zZm9ybTxSZWFkVD4pOiBJbnB1dFNpZ25hbDxSZWFkVD47XG4gIDxSZWFkVCwgV3JpdGVUPihpbml0aWFsVmFsdWU6IFJlYWRULCBvcHRzOiBJbnB1dE9wdGlvbnNXaXRoVHJhbnNmb3JtPFJlYWRULCBXcml0ZVQ+KTpcbiAgICAgIElucHV0U2lnbmFsV2l0aFRyYW5zZm9ybTxSZWFkVCwgV3JpdGVUPjtcblxuICAvKipcbiAgICogSW5pdGlhbGl6ZXMgYSByZXF1aXJlZCBpbnB1dC5cbiAgICpcbiAgICogVXNlcnMgb2YgeW91ciBkaXJlY3RpdmUvY29tcG9uZW50IG5lZWQgdG8gYmluZCB0byB0aGlzXG4gICAqIGlucHV0LiBJZiB1bnNldCwgYSBjb21waWxlIHRpbWUgZXJyb3Igd2lsbCBiZSByZXBvcnRlZC5cbiAgICpcbiAgICogQGRldmVsb3BlclByZXZpZXdcbiAgICovXG4gIHJlcXVpcmVkOiB7XG4gICAgPFJlYWRUPihvcHRzPzogSW5wdXRPcHRpb25zV2l0aG91dFRyYW5zZm9ybTxSZWFkVD4pOiBJbnB1dFNpZ25hbDxSZWFkVD47XG5cbiAgICA8UmVhZFQsIFdyaXRlVD4ob3B0czogSW5wdXRPcHRpb25zV2l0aFRyYW5zZm9ybTxSZWFkVCwgV3JpdGVUPik6XG4gICAgICAgIElucHV0U2lnbmFsV2l0aFRyYW5zZm9ybTxSZWFkVCwgV3JpdGVUPjtcbiAgfTtcbn1cblxuLyoqXG4gKiBUaGUgYGlucHV0YCBmdW5jdGlvbiBhbGxvd3MgZGVjbGFyYXRpb24gb2YgaW5wdXRzIGluIGRpcmVjdGl2ZXMgYW5kXG4gKiBjb21wb25lbnRzLlxuICpcbiAqIEluaXRpYWxpemVzIGFuIGlucHV0IHdpdGggYW4gaW5pdGlhbCB2YWx1ZS4gSWYgbm8gZXhwbGljaXQgdmFsdWVcbiAqIGlzIHNwZWNpZmllZCwgQW5ndWxhciB3aWxsIHVzZSBgdW5kZWZpbmVkYC5cbiAqXG4gKiBDb25zaWRlciB1c2luZyBgaW5wdXQucmVxdWlyZWRgIGZvciBpbnB1dHMgdGhhdCBkb24ndCBuZWVkIGFuXG4gKiBpbml0aWFsIHZhbHVlLlxuICpcbiAqIEB1c2FnZU5vdGVzXG4gKiBJbml0aWFsaXplIGFuIGlucHV0IGluIHlvdXIgZGlyZWN0aXZlIG9yIGNvbXBvbmVudCBieSBkZWNsYXJpbmcgYVxuICogY2xhc3MgZmllbGQgYW5kIGluaXRpYWxpemluZyBpdCB3aXRoIHRoZSBgaW5wdXQoKWAgZnVuY3Rpb24uXG4gKlxuICogYGBgdHNcbiAqIEBEaXJlY3RpdmUoey4ufSlcbiAqIGV4cG9ydCBjbGFzcyBNeURpciB7XG4gKiAgIGZpcnN0TmFtZSA9IGlucHV0PHN0cmluZz4oKTsgICAgICAgICAgICAvLyBzdHJpbmd8dW5kZWZpbmVkXG4gKiAgIGxhc3ROYW1lID0gaW5wdXQucmVxdWlyZWQ8c3RyaW5nPigpOyAgICAvLyBzdHJpbmdcbiAqICAgYWdlID0gaW5wdXQoMCk7ICAgICAgICAgICAgICAgICAgICAgICAgIC8vIG51bWJlclxuICogfVxuICogYGBgXG4gKlxuICogQGRldmVsb3BlclByZXZpZXdcbiAqL1xuZXhwb3J0IGNvbnN0IGlucHV0OiBJbnB1dEZ1bmN0aW9uID0gKCgpID0+IHtcbiAgLy8gTm90ZTogVGhpcyBtYXkgYmUgY29uc2lkZXJlZCBhIHNpZGUtZWZmZWN0LCBidXQgbm90aGluZyB3aWxsIGRlcGVuZCBvblxuICAvLyB0aGlzIGFzc2lnbm1lbnQsIHVubGVzcyB0aGlzIGBpbnB1dGAgY29uc3RhbnQgZXhwb3J0IGlzIGFjY2Vzc2VkLiBJdCdzIGFcbiAgLy8gc2VsZi1jb250YWluZWQgc2lkZSBlZmZlY3QgdGhhdCBpcyBsb2NhbCB0byB0aGUgdXNlciBmYWNpbmdgaW5wdXRgIGV4cG9ydC5cbiAgKGlucHV0RnVuY3Rpb24gYXMgYW55KS5yZXF1aXJlZCA9IGlucHV0UmVxdWlyZWRGdW5jdGlvbjtcbiAgcmV0dXJuIGlucHV0RnVuY3Rpb24gYXMgKHR5cGVvZiBpbnB1dEZ1bmN0aW9uJntyZXF1aXJlZDogdHlwZW9mIGlucHV0UmVxdWlyZWRGdW5jdGlvbn0pO1xufSkoKTtcbiJdfQ==