/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Provider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.SourceSetContainer;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.RewriteDiscoverTask;
import org.openrewrite.gradle.RewriteDryRunTask;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.RewriteRunTask;

public class RewritePlugin
implements Plugin<Project> {
    private Set<File> resolvedDependencies;

    public void apply(Project project) {
        boolean isRootProject;
        boolean bl = isRootProject = project == project.getRootProject();
        if (!isRootProject && project.getRootProject().getPluginManager().hasPlugin("org.openrewrite.rewrite")) {
            return;
        }
        if (project.getRootProject().getPluginManager().hasPlugin("io.moderne.rewrite")) {
            return;
        }
        RewriteExtension extension = (RewriteExtension)project.getExtensions().create("rewrite", RewriteExtension.class, new Object[]{project});
        Configuration rewriteConf = (Configuration)project.getConfigurations().maybeCreate("rewrite");
        org.gradle.api.provider.Provider resolvedDependenciesProvider = project.provider(() -> this.getResolvedDependencies(project, extension, rewriteConf));
        RewriteRunTask rewriteRun = (RewriteRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteRunTask)project.getTasks().create("rewriteRun", RewriteRunTask.class)).setExtension(extension))).setResolvedDependencies((org.gradle.api.provider.Provider<Set<File>>)resolvedDependenciesProvider));
        rewriteRun.dependsOn(new Object[]{rewriteConf});
        RewriteDryRunTask rewriteDryRun = (RewriteDryRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteDryRunTask)project.getTasks().create("rewriteDryRun", RewriteDryRunTask.class)).setExtension(extension))).setResolvedDependencies((org.gradle.api.provider.Provider<Set<File>>)resolvedDependenciesProvider));
        rewriteDryRun.dependsOn(new Object[]{rewriteConf});
        RewriteDiscoverTask rewriteDiscover = (RewriteDiscoverTask)((Object)((AbstractRewriteTask)((Object)((RewriteDiscoverTask)project.getTasks().create("rewriteDiscover", RewriteDiscoverTask.class)).setExtension(extension))).setResolvedDependencies((org.gradle.api.provider.Provider<Set<File>>)resolvedDependenciesProvider));
        rewriteDiscover.dependsOn(new Object[]{rewriteConf});
        if (isRootProject) {
            project.allprojects(subproject -> RewritePlugin.configureProject(subproject, extension, rewriteDryRun, rewriteRun));
        } else {
            RewritePlugin.configureProject(project, extension, rewriteDryRun, rewriteRun);
        }
    }

    private static void configureProject(Project project, RewriteExtension extension, RewriteDryRunTask rewriteDryRun, RewriteRunTask rewriteRun) {
        project.getPlugins().all(plugin -> {
            SourceSetContainer sourceSets;
            if (plugin instanceof CheckstylePlugin) {
                CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
                extension.setCheckstyleConfigProvider((Provider<File>)((Provider)() -> ((CheckstyleExtension)checkstyleExtension).getConfigFile()));
                extension.setCheckstylePropertiesProvider((Provider<Map<String, Object>>)((Provider)() -> ((CheckstyleExtension)checkstyleExtension).getConfigProperties()));
            }
            if (!(plugin instanceof JavaBasePlugin)) {
                return;
            }
            if (project.getGradle().getGradleVersion().compareTo("7.1") >= 0) {
                sourceSets = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets();
            } else {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                sourceSets = javaConvention.getSourceSets();
            }
            sourceSets.all(sourceSet -> {
                Task compileTask = project.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
                rewriteRun.dependsOn(new Object[]{compileTask});
                rewriteDryRun.dependsOn(new Object[]{compileTask});
            });
            HashSet sourceDirs = new HashSet();
            project.afterEvaluate(unused -> sourceSets.stream().sorted(Comparator.comparingInt(sourceSet -> {
                if ("main".equals(sourceSet.getName())) {
                    return 0;
                }
                if ("test".equals(sourceSet.getName())) {
                    return 1;
                }
                return 2;
            })).forEach(sourceSet -> {
                for (File file : sourceSet.getAllJava().getSourceDirectories().getFiles()) {
                    if (sourceDirs.add(file.getAbsolutePath())) continue;
                    Task compileTask = project.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
                    compileTask.setEnabled(false);
                }
            }));
        });
    }

    private Set<File> getResolvedDependencies(Project project, RewriteExtension extension, Configuration rewriteConf) {
        if (this.resolvedDependencies == null) {
            Dependency[] dependencies = (Dependency[])Stream.concat(RewritePlugin.knownRewriteDependencies(extension, project.getDependencies()), rewriteConf.getDependencies().stream()).toArray(Dependency[]::new);
            Configuration detachedConf = project.getConfigurations().detachedConfiguration(dependencies);
            try {
                ObjectFactory objectFactory = project.getObjects();
                detachedConf.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "library")));
                    attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
                    attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "jar")));
                    attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
                    try {
                        attributes.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)((TargetJvmEnvironment)objectFactory.named(TargetJvmEnvironment.class, "standard-jvm")));
                    }
                    catch (NoClassDefFoundError e) {
                        attributes.attribute(Attribute.of((String)"org.gradle.jvm.environment", String.class), (Object)"standard-jvm");
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.resolvedDependencies = detachedConf.resolve();
        }
        return this.resolvedDependencies;
    }

    private static Stream<Dependency> knownRewriteDependencies(RewriteExtension extension, DependencyHandler deps) {
        String rewriteVersion = extension.getRewriteVersion();
        return Stream.of(deps.create((Object)("org.openrewrite:rewrite-core:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-groovy:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-gradle:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-hcl:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-json:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-kotlin:" + extension.getRewriteKotlinVersion())), deps.create((Object)("org.openrewrite:rewrite-java:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-21:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-17:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-11:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-8:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-maven:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-properties:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-protobuf:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-xml:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-yaml:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-polyglot:" + extension.getRewritePolyglotVersion())), deps.create((Object)("org.openrewrite.gradle.tooling:model:" + extension.getRewriteGradleModelVersion())), deps.create((Object)("com.puppycrawl.tools:checkstyle:" + extension.getCheckstyleToolsVersion())), deps.create((Object)("com.fasterxml.jackson.module:jackson-module-kotlin:" + extension.getJacksonModuleKotlinVersion())), deps.create((Object)("com.fasterxml.jackson.datatype:jackson-datatype-jsr310:" + extension.getJacksonModuleKotlinVersion())));
    }
}

