/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.dataflow.AdditionalFlowStepPredicate;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.internal.csv.CsvLoader;
import org.openrewrite.analysis.dataflow.internal.csv.GenericExternalModel;
import org.openrewrite.analysis.dataflow.internal.csv.Mergeable;
import org.openrewrite.analysis.trait.expr.Call;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.24.1")
final class ExternalFlowModels {
    private static final String CURSOR_MESSAGE_KEY = "OPTIMIZED_FLOW_MODELS";
    private static final ExternalFlowModels instance = new ExternalFlowModels();
    private WeakReference<FullyQualifiedNameToFlowModels> fullyQualifiedNameToFlowModels;

    public static ExternalFlowModels instance() {
        return instance;
    }

    FullyQualifiedNameToFlowModels getFullyQualifiedNameToFlowModels() {
        FullyQualifiedNameToFlowModels f;
        if (this.fullyQualifiedNameToFlowModels == null) {
            f = Loader.create().load();
            this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
        } else {
            f = (FullyQualifiedNameToFlowModels)this.fullyQualifiedNameToFlowModels.get();
            if (f == null) {
                f = Loader.create().load();
                this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
            }
        }
        return f;
    }

    private OptimizedFlowModels getOptimizedFlowModelsForTypesInUse(TypesInUse typesInUse) {
        return Optimizer.optimize(this.getFullyQualifiedNameToFlowModels().forTypesInUse(typesInUse));
    }

    private OptimizedFlowModels getOrComputeOptimizedFlowModels(Cursor cursor) {
        Cursor cuCursor = cursor.dropParentUntil(JavaSourceFile.class::isInstance);
        return (OptimizedFlowModels)cuCursor.computeMessageIfAbsent(CURSOR_MESSAGE_KEY, __ -> this.getOptimizedFlowModelsForTypesInUse(((JavaSourceFile)cuCursor.getValue()).getTypesInUse()));
    }

    boolean isAdditionalFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
        for (AdditionalFlowStepPredicate value : this.getOrComputeOptimizedFlowModels(srcNode.getCursor()).getValuePredicates()) {
            if (!value.isAdditionalFlowStep(srcNode, sinkNode)) continue;
            return true;
        }
        return false;
    }

    boolean isAdditionalTaintStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
        for (AdditionalFlowStepPredicate taint : this.getOrComputeOptimizedFlowModels(srcNode.getCursor()).getTaintPredicates()) {
            if (!taint.isAdditionalFlowStep(srcNode, sinkNode)) continue;
            return true;
        }
        return false;
    }

    private ExternalFlowModels() {
    }

    private static class Loader {
        private Loader() {
        }

        private static Loader create() {
            return new Loader();
        }

        FullyQualifiedNameToFlowModels load() {
            return this.loadModelFromFile();
        }

        private FullyQualifiedNameToFlowModels loadModelFromFile() {
            return CsvLoader.loadFromFile("model.csv", FullyQualifiedNameToFlowModels.empty(), Loader::createFullyQualifiedNameToFlowModels, tokens -> new FlowModel(tokens[0], tokens[1], Boolean.parseBoolean(tokens[2]), tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[8], tokens[9]));
        }

        private static FullyQualifiedNameToFlowModels createFullyQualifiedNameToFlowModels(Iterable<FlowModel> flowModels) {
            HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>();
            HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>();
            for (FlowModel model : flowModels) {
                if ("value".equals(model.kind)) {
                    value.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                    continue;
                }
                if ("taint".equals(model.kind)) {
                    taint.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                    continue;
                }
                throw new IllegalArgumentException("Unknown kind: " + model.kind);
            }
            return new FullyQualifiedNameToFlowModels(value, taint);
        }
    }

    static class FullyQualifiedNameToFlowModels
    implements Mergeable<FullyQualifiedNameToFlowModels> {
        private final Map<String, List<FlowModel>> value;
        private final Map<String, List<FlowModel>> taint;

        boolean isEmpty() {
            return this.value.isEmpty() && this.taint.isEmpty();
        }

        @Override
        public FullyQualifiedNameToFlowModels merge(FullyQualifiedNameToFlowModels other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>(this.value);
            other.value.forEach((k, v) -> value.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>(this.taint);
            other.taint.forEach((k, v) -> taint.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            return new FullyQualifiedNameToFlowModels(value, taint);
        }

        FlowModels forAll() {
            return new FlowModels(this.value.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), this.taint.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        FlowModels forTypesInUse(TypesInUse typesInUse) {
            HashSet<FlowModel> value = new HashSet<FlowModel>();
            HashSet<FlowModel> taint = new HashSet<FlowModel>();
            typesInUse.getUsedMethods().stream().map(JavaType.Method::getDeclaringType).filter(o -> o != null && !(o instanceof JavaType.Unknown)).flatMap(FullyQualifiedNameToFlowModels::getAllTypesInHierarchy).map(JavaType.FullyQualified::getFullyQualifiedName).distinct().forEach(fqn -> {
                value.addAll(this.value.getOrDefault(fqn, Collections.emptyList()));
                taint.addAll(this.taint.getOrDefault(fqn, Collections.emptyList()));
            });
            return new FlowModels(value, taint);
        }

        static Stream<JavaType.FullyQualified> getAllTypesInHierarchy(JavaType.FullyQualified type) {
            if (type.getSupertype() == null) {
                return Stream.concat(Stream.of(type), type.getInterfaces().stream().flatMap(FullyQualifiedNameToFlowModels::getAllTypesInHierarchy));
            }
            return Stream.concat(Stream.of(type), Stream.concat(type.getInterfaces().stream().flatMap(FullyQualifiedNameToFlowModels::getAllTypesInHierarchy), FullyQualifiedNameToFlowModels.getAllTypesInHierarchy(type.getSupertype())));
        }

        static FullyQualifiedNameToFlowModels empty() {
            return new FullyQualifiedNameToFlowModels(new HashMap<String, List<FlowModel>>(0), new HashMap<String, List<FlowModel>>(0));
        }

        public FullyQualifiedNameToFlowModels(Map<String, List<FlowModel>> value, Map<String, List<FlowModel>> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class FlowModels {
        Set<FlowModel> value;
        Set<FlowModel> taint;

        public FlowModels(Set<FlowModel> value, Set<FlowModel> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class Optimizer {
        private AdditionalFlowStepPredicate forFlowFromArgumentIndexToReturn(int argumentIndex, Collection<? extends InvocationMatcher> methodMatchers) {
            InvocationMatcher callMatcher = InvocationMatcher.from(methodMatchers);
            if (argumentIndex == -1) {
                return (srcNode, sinkNode) -> (Boolean)sinkNode.asExprParent(Call.class).map(call -> call.matches(callMatcher)).orSome((Object)false) != false && callMatcher.advanced().isSelect(srcNode.getCursor());
            }
            return (srcNode, sinkNode) -> (Boolean)sinkNode.asExprParent(Call.class).map(call -> call.matches(callMatcher)).orSome((Object)false) != false && callMatcher.advanced().isParameter(srcNode.getCursor(), argumentIndex);
        }

        private AdditionalFlowStepPredicate forFlowFromArgumentIndexToQualifier(int argumentIndex, Collection<? extends InvocationMatcher> methodMatchers) {
            InvocationMatcher callMatcher = InvocationMatcher.from(methodMatchers);
            assert (argumentIndex != -1) : "Argument[-1] is the 'select' or 'qualifier' of a method call. Flow would be cyclic.";
            return (srcNode, sinkNode) -> callMatcher.advanced().isSelect(sinkNode.getCursor()) && callMatcher.advanced().isParameter(srcNode.getCursor(), argumentIndex);
        }

        private AdditionalFlowStepPredicate forFlowFromArgumentIndexToArgumentIndex(ArgumentIndices argumentIndices, Collection<? extends InvocationMatcher> methodMatchers) {
            InvocationMatcher callMatcher = InvocationMatcher.from(methodMatchers);
            if (argumentIndices.inputIndex == -1) {
                return (srcNode, sinkNode) -> callMatcher.advanced().isSelect(srcNode.getCursor()) && callMatcher.advanced().isParameter(sinkNode.getCursor(), argumentIndices.outputIndex);
            }
            return (srcNode, sinkNode) -> callMatcher.advanced().isParameter(srcNode.getCursor(), argumentIndices.inputIndex) && callMatcher.advanced().isParameter(sinkNode.getCursor(), argumentIndices.outputIndex);
        }

        private Map<AdditionalFlowStepPredicate, Set<FlowModel>> optimize(Collection<FlowModel> models) {
            HashMap flowFromArgumentIndexToReturn = new HashMap();
            HashMap flowFromArgumentIndexToQualifier = new HashMap();
            HashMap flowFromArgumentIndexToArgumentIndex = new HashMap();
            models.forEach(model -> {
                if ("ReturnValue".equals(model.output) || model.isConstructor()) {
                    model.getArgumentRange().ifPresent(argumentRange -> {
                        for (int i = argumentRange.getStart(); i <= argumentRange.getEnd(); ++i) {
                            flowFromArgumentIndexToReturn.computeIfAbsent(i, __ -> new HashSet()).add(model);
                        }
                    });
                }
                if ("Argument[-1]".equals(model.output) && !model.isConstructor()) {
                    model.getArgumentRange().ifPresent(argumentRange -> {
                        for (int i = argumentRange.getStart(); i <= argumentRange.getEnd(); ++i) {
                            flowFromArgumentIndexToQualifier.computeIfAbsent(i, __ -> new HashSet()).add(model);
                        }
                    });
                }
                Optional<GenericExternalModel.ArgumentRange> inputRange = GenericExternalModel.computeArgumentRange(model.input);
                Optional<GenericExternalModel.ArgumentRange> outputRange = GenericExternalModel.computeArgumentRange(model.output);
                if (inputRange.isPresent() && outputRange.isPresent()) {
                    for (int i = inputRange.get().getStart(); i <= inputRange.get().getEnd(); ++i) {
                        for (int j = outputRange.get().getStart(); j <= outputRange.get().getEnd(); ++j) {
                            if (j < 0) continue;
                            flowFromArgumentIndexToArgumentIndex.computeIfAbsent(new ArgumentIndices(i, j), __ -> new HashSet()).add(model);
                        }
                    }
                }
            });
            Stream<PredicateToFlowModels> flowFromArgumentIndexToReturnStream = flowFromArgumentIndexToReturn.entrySet().stream().map(entry -> new PredicateToFlowModels(this.forFlowFromArgumentIndexToReturn((Integer)entry.getKey(), (Collection)entry.getValue()), (Set)entry.getValue()));
            Stream<PredicateToFlowModels> flowFromArgumentIndexToQualifierStream = flowFromArgumentIndexToQualifier.entrySet().stream().map(entry -> new PredicateToFlowModels(this.forFlowFromArgumentIndexToQualifier((Integer)entry.getKey(), (Collection)entry.getValue()), (Set)entry.getValue()));
            Stream<PredicateToFlowModels> flowFromArgumentIndexToArgumentIndexStream = flowFromArgumentIndexToArgumentIndex.entrySet().stream().map(entry -> new PredicateToFlowModels(this.forFlowFromArgumentIndexToArgumentIndex((ArgumentIndices)entry.getKey(), (Collection)entry.getValue()), (Set)entry.getValue()));
            Stream<PredicateToFlowModels> s1 = Stream.concat(flowFromArgumentIndexToReturnStream, flowFromArgumentIndexToQualifierStream);
            return Stream.concat(s1, flowFromArgumentIndexToArgumentIndexStream).collect(Collectors.toMap(PredicateToFlowModels::getPredicate, PredicateToFlowModels::getModels, (a, b) -> {
                throw new IllegalStateException("Not expecting duplicate keys");
            }, IdentityHashMap::new));
        }

        static OptimizedFlowModels optimize(FlowModels flowModels) {
            Optimizer optimizer = new Optimizer();
            return new OptimizedFlowModels(optimizer.optimize(flowModels.value), optimizer.optimize(flowModels.taint));
        }

        private Optimizer() {
        }

        static final class ArgumentIndices {
            private final int inputIndex;
            private final int outputIndex;

            public ArgumentIndices(int inputIndex, int outputIndex) {
                this.inputIndex = inputIndex;
                this.outputIndex = outputIndex;
            }

            public int getInputIndex() {
                return this.inputIndex;
            }

            public int getOutputIndex() {
                return this.outputIndex;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ArgumentIndices)) {
                    return false;
                }
                ArgumentIndices other = (ArgumentIndices)o;
                if (this.getInputIndex() != other.getInputIndex()) {
                    return false;
                }
                return this.getOutputIndex() == other.getOutputIndex();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getInputIndex();
                result = result * 59 + this.getOutputIndex();
                return result;
            }

            @NonNull
            public String toString() {
                return "ExternalFlowModels.Optimizer.ArgumentIndices(inputIndex=" + this.getInputIndex() + ", outputIndex=" + this.getOutputIndex() + ")";
            }
        }

        static final class PredicateToFlowModels {
            private final AdditionalFlowStepPredicate predicate;
            private final Set<FlowModel> models;

            public PredicateToFlowModels(AdditionalFlowStepPredicate predicate, Set<FlowModel> models) {
                this.predicate = predicate;
                this.models = models;
            }

            public AdditionalFlowStepPredicate getPredicate() {
                return this.predicate;
            }

            public Set<FlowModel> getModels() {
                return this.models;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PredicateToFlowModels)) {
                    return false;
                }
                PredicateToFlowModels other = (PredicateToFlowModels)o;
                AdditionalFlowStepPredicate this$predicate = this.getPredicate();
                AdditionalFlowStepPredicate other$predicate = other.getPredicate();
                if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
                    return false;
                }
                Set<FlowModel> this$models = this.getModels();
                Set<FlowModel> other$models = other.getModels();
                return !(this$models == null ? other$models != null : !((Object)this$models).equals(other$models));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AdditionalFlowStepPredicate $predicate = this.getPredicate();
                result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
                Set<FlowModel> $models = this.getModels();
                result = result * 59 + ($models == null ? 43 : ((Object)$models).hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "ExternalFlowModels.Optimizer.PredicateToFlowModels(predicate=" + this.getPredicate() + ", models=" + this.getModels() + ")";
            }
        }
    }

    static final class OptimizedFlowModels {
        private final Map<AdditionalFlowStepPredicate, Set<FlowModel>> value;
        private final Map<AdditionalFlowStepPredicate, Set<FlowModel>> taint;

        Set<AdditionalFlowStepPredicate> getValuePredicates() {
            return this.value.keySet();
        }

        Set<AdditionalFlowStepPredicate> getTaintPredicates() {
            return this.taint.keySet();
        }

        Set<FlowModel> getValueFlowModels() {
            return this.value.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        Set<FlowModel> getTaintFlowModels() {
            return this.taint.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public OptimizedFlowModels(Map<AdditionalFlowStepPredicate, Set<FlowModel>> value, Map<AdditionalFlowStepPredicate, Set<FlowModel>> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class FlowModel
    implements GenericExternalModel {
        String namespace;
        String type;
        boolean subtypes;
        String name;
        String signature;
        String ext;
        String input;
        String output;
        String kind;
        String provenance;

        @Override
        public String getArguments() {
            return this.input;
        }

        public FlowModel(String namespace, String type, boolean subtypes, String name, String signature, String ext, String input, String output, String kind, String provenance) {
            this.namespace = namespace;
            this.type = type;
            this.subtypes = subtypes;
            this.name = name;
            this.signature = signature;
            this.ext = ext;
            this.input = input;
            this.output = output;
            this.kind = kind;
            this.provenance = provenance;
        }

        @NonNull
        public String toString() {
            return "ExternalFlowModels.FlowModel(namespace=" + this.getNamespace() + ", type=" + this.getType() + ", subtypes=" + this.isSubtypes() + ", name=" + this.getName() + ", signature=" + this.getSignature() + ", ext=" + this.ext + ", input=" + this.input + ", output=" + this.output + ", kind=" + this.kind + ", provenance=" + this.provenance + ")";
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isSubtypes() {
            return this.subtypes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }
    }
}

