/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.controlflow.BarrierGuardPredicate;
import org.openrewrite.analysis.controlflow.ControlFlowNode;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;

@Incubating(since="7.25.0")
public final class ControlFlowSummary {
    private final ControlFlowNode.Start start;
    private final ControlFlowNode.End end;
    private final AtomicReference<Object> allNodes = new AtomicReference();

    private static Set<ControlFlowNode> getAllControlFlowNodes(ControlFlowNode.Start start, ControlFlowNode.End end) {
        LinkedHashSet<ControlFlowNode> all = new LinkedHashSet<ControlFlowNode>();
        ControlFlowSummary.recurseGetAllControlFlowNodes(start, all, ControlFlowNode::getSuccessors);
        ControlFlowSummary.recurseGetAllControlFlowNodes(end, all, ControlFlowNode::getPredecessors);
        return all;
    }

    private static void recurseGetAllControlFlowNodes(ControlFlowNode current, Set<ControlFlowNode> visited, Function<ControlFlowNode, Set<ControlFlowNode>> getNext) {
        visited.add(current);
        LinkedList toVisit = new LinkedList(getNext.apply(current));
        toVisit.removeAll(visited);
        toVisit.forEach(node -> ControlFlowSummary.recurseGetAllControlFlowNodes(node, visited, getNext));
    }

    public Set<ControlFlowNode.BasicBlock> getBasicBlocks() {
        return this.getAllNodes().stream().filter(ControlFlowNode.BasicBlock.class::isInstance).map(ControlFlowNode.BasicBlock.class::cast).collect(Collectors.toSet());
    }

    public Set<ControlFlowNode.ConditionNode> getConditionNodes() {
        return this.getAllNodes().stream().filter(ControlFlowNode.ConditionNode.class::isInstance).map(ControlFlowNode.ConditionNode.class::cast).collect(Collectors.toSet());
    }

    public Set<Expression> computeReachableExpressions(BarrierGuardPredicate predicate) {
        return this.computeExecutableCodePoints(predicate).stream().filter(cursor -> cursor.getValue() instanceof Expression).map(cursor -> (Expression)cursor.getValue()).collect(Collectors.toSet());
    }

    public Set<Cursor> computeExecutableCodePoints(BarrierGuardPredicate predicate) {
        return this.computeReachableBasicBlock(predicate).stream().flatMap(b -> b.getNodeCursors().stream()).collect(Collectors.toSet());
    }

    public Set<ControlFlowNode.BasicBlock> computeReachableBasicBlock(BarrierGuardPredicate predicate) {
        LinkedHashSet<ControlFlowNode> reachable = new LinkedHashSet<ControlFlowNode>();
        this.recurseComputeReachableBasicBlock(this.start, predicate, reachable);
        return reachable.stream().filter(ControlFlowNode.BasicBlock.class::isInstance).map(ControlFlowNode.BasicBlock.class::cast).collect(Collectors.toSet());
    }

    private void recurseComputeReachableBasicBlock(ControlFlowNode visit, BarrierGuardPredicate predicate, Set<ControlFlowNode> reachable) {
        reachable.add(visit);
        LinkedList<ControlFlowNode> toVisit = new LinkedList<ControlFlowNode>();
        if (visit instanceof ControlFlowNode.ConditionNode) {
            toVisit.addAll(((ControlFlowNode.ConditionNode)visit).visit(predicate));
        } else if (!(visit instanceof ControlFlowNode.End)) {
            toVisit.addAll(visit.getSuccessors());
        } else {
            return;
        }
        toVisit.removeAll(reachable);
        toVisit.forEach(n -> this.recurseComputeReachableBasicBlock((ControlFlowNode)n, predicate, reachable));
    }

    int getBasicBlockCount() {
        return this.getBasicBlocks().size();
    }

    int getConditionNodeCount() {
        return this.getConditionNodes().size();
    }

    int getExitCount() {
        return this.end.getPredecessors().size();
    }

    @Generated
    private ControlFlowSummary(ControlFlowNode.Start start, ControlFlowNode.End end) {
        this.start = start;
        this.end = end;
    }

    @NonNull
    @Generated
    static ControlFlowSummary forGraph(ControlFlowNode.Start start, ControlFlowNode.End end) {
        return new ControlFlowSummary(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Set<ControlFlowNode> getAllNodes() {
        Object $value = this.allNodes.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.allNodes;
            synchronized (atomicReference) {
                $value = this.allNodes.get();
                if ($value == null) {
                    Set<ControlFlowNode> actualValue = ControlFlowSummary.getAllControlFlowNodes(this.start, this.end);
                    $value = actualValue == null ? this.allNodes : actualValue;
                    this.allNodes.set($value);
                }
            }
        }
        return (Set)($value == this.allNodes ? null : $value);
    }
}

