/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

@FunctionalInterface
@Incubating(since="8.1.3")
public interface InvocationMatcher {
    public boolean matches(@Nullable JavaType.Method var1);

    default public boolean matches(@Nullable MethodCall methodCall) {
        if (methodCall == null) {
            return false;
        }
        return this.matches(methodCall.getMethodType());
    }

    default public boolean matches(@Nullable Expression maybeMethod) {
        return maybeMethod instanceof MethodCall && this.matches(((MethodCall)maybeMethod).getMethodType());
    }

    public static InvocationMatcher from(Collection<? extends InvocationMatcher> matchers) {
        if (matchers.isEmpty()) {
            return expression -> false;
        }
        if (matchers.size() == 1) {
            return e -> ((InvocationMatcher)matchers.iterator().next()).matches(e);
        }
        return expression -> matchers.stream().anyMatch(matcher -> matcher.matches(expression));
    }

    public static InvocationMatcher fromMethodMatcher(MethodMatcher methodMatcher) {
        return arg_0 -> ((MethodMatcher)methodMatcher).matches(arg_0);
    }

    public static InvocationMatcher fromMethodMatchers(MethodMatcher ... matchers) {
        return InvocationMatcher.fromMethodMatchers(Arrays.asList(matchers));
    }

    public static InvocationMatcher fromMethodMatchers(Collection<? extends MethodMatcher> matchers) {
        return InvocationMatcher.from(matchers.stream().map(InvocationMatcher::fromMethodMatcher).collect(Collectors.toSet()));
    }

    default public AdvancedInvocationMatcher advanced() {
        return new AdvancedInvocationMatcher(this);
    }

    public static final class AdvancedInvocationMatcher {
        private InvocationMatcher matcher;

        public boolean isSelect(Cursor cursor) {
            return AdvancedInvocationMatcher.asExpression(cursor, expression -> {
                assert (expression == cursor.getValue()) : "expression != cursor.getValue()";
                J.MethodInvocation maybeMethodInvocation = (J.MethodInvocation)cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class);
                return maybeMethodInvocation != null && maybeMethodInvocation.getSelect() == expression && this.matcher.matches((MethodCall)maybeMethodInvocation);
            });
        }

        public boolean isAnyArgument(Cursor cursor) {
            return AdvancedInvocationMatcher.asExpression(cursor, expression -> AdvancedInvocationMatcher.nearestMethodCall(cursor).map(call -> call.getArguments().contains(expression) && this.matcher.matches((MethodCall)call)).orElse(false));
        }

        public boolean isFirstParameter(Cursor cursor) {
            return this.isParameter(cursor, 0);
        }

        public boolean isParameter(Cursor cursor, int parameterIndex) {
            if (parameterIndex < 0) {
                throw new IllegalArgumentException("parameterIndex < 0");
            }
            return AdvancedInvocationMatcher.asExpression(cursor, expression -> AdvancedInvocationMatcher.nearestMethodCall(cursor).map(call -> {
                int finalParameterIndex;
                List arguments = call.getArguments();
                if (parameterIndex >= arguments.size()) {
                    return false;
                }
                if (AdvancedInvocationMatcher.doesMethodHaveVarargs(call) && (finalParameterIndex = AdvancedInvocationMatcher.getType(call).map(JavaType.Method::getParameterTypes).map(List::size).map(size -> size - 1).orElse(-1).intValue()) == parameterIndex) {
                    List varargs = arguments.subList(finalParameterIndex, arguments.size());
                    return varargs.contains(expression) && this.matcher.matches((MethodCall)call);
                }
                return arguments.get(parameterIndex) == expression && this.matcher.matches((MethodCall)call);
            }).orElse(false));
        }

        private static boolean doesMethodHaveVarargs(MethodCall expression) {
            return AdvancedInvocationMatcher.getType(expression).map(type -> type.hasFlags(new Flag[]{Flag.Varargs})).orElse(false);
        }

        private static Optional<JavaType.Method> getType(MethodCall expression) {
            return Optional.ofNullable(expression.getMethodType());
        }

        private static Optional<MethodCall> nearestMethodCall(Cursor cursor) {
            Tree closestJ = (Tree)cursor.getParentTreeCursor().getValue();
            if (closestJ instanceof MethodCall) {
                return Optional.of((MethodCall)closestJ);
            }
            return Optional.empty();
        }

        private static boolean asExpression(Cursor cursor, Predicate<Expression> expressionPredicate) {
            return cursor.getValue() instanceof Expression && expressionPredicate.test((Expression)cursor.getValue());
        }

        private AdvancedInvocationMatcher(InvocationMatcher matcher) {
            this.matcher = matcher;
        }
    }
}

