/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.search;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.dataflow.FindLocalFlowPaths;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.analysis.dataflow.LocalTaintFlowSpec;
import org.openrewrite.analysis.dataflow.internal.InvocationMatcher;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesAllMethods;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class FindFlowBetweenMethods
extends Recipe {
    @Option(displayName="Start method pattern", description="A method pattern that is used to find matching the start point's method invocations.", example="java.util.List add(..)")
    private final String startMethodPattern;
    @Option(displayName="Match start method on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean startMatchOverrides;
    @Option(displayName="End method pattern", description="A method pattern that is used to find matching the end point's method invocations.", example="java.util.List add(..)")
    private final String endMethodPattern;
    @Option(displayName="Match end method on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean endMatchOverrides;
    @Option(displayName="To target", description="The part of the method flow should traverse to", required=true, valid={"Select", "Arguments", "Both"})
    private final String target;
    @Option(displayName="Show flow", description="When enabled, show the data or taint flow of the method invocation.", valid={"Data", "Taint"}, required=true)
    @Nullable
    private final String flow;

    public String getDisplayName() {
        return "Finds flow between two methods";
    }

    public String getDescription() {
        return "Takes two patterns for the start/end methods to find flow between.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher startMethodMatcher = new MethodMatcher(this.startMethodPattern, this.startMatchOverrides);
        final MethodMatcher endMethodMatcher = new MethodMatcher(this.endMethodPattern, this.endMatchOverrides);
        return Preconditions.check((TreeVisitor)new UsesAllMethods(new MethodMatcher[]{new MethodMatcher(this.startMethodPattern, this.startMatchOverrides), new MethodMatcher(this.endMethodPattern, this.endMatchOverrides)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (startMethodMatcher.matches(method)) {
                    this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec((Expression)method, endMethodMatcher)));
                }
                return m;
            }

            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J.MemberReference m = super.visitMemberReference(memberRef, (Object)ctx);
                if (startMethodMatcher.matches(m.getMethodType())) {
                    this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec((Expression)memberRef, endMethodMatcher)));
                }
                return m;
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass n = super.visitNewClass(newClass, (Object)ctx);
                if (startMethodMatcher.matches(newClass)) {
                    this.doAfterVisit((TreeVisitor)new FindLocalFlowPaths(this.getFlowSpec((Expression)newClass, endMethodMatcher)));
                }
                return n;
            }

            private boolean conditional(InvocationMatcher sinkMatcher, Cursor cursor) {
                switch (FindFlowBetweenMethods.this.target) {
                    case "Select": {
                        return sinkMatcher.advanced().isSelect(cursor);
                    }
                    case "Arguments": {
                        return sinkMatcher.advanced().isAnyArgument(cursor);
                    }
                    case "Both": {
                        return sinkMatcher.advanced().isAnyArgument(cursor) || sinkMatcher.advanced().isSelect(cursor);
                    }
                }
                throw new IllegalStateException("Unknown target: " + FindFlowBetweenMethods.this.target);
            }

            private LocalFlowSpec<Expression, Expression> getFlowSpec(final Expression source, MethodMatcher sink) {
                final InvocationMatcher sinkMatcher = InvocationMatcher.fromMethodMatcher(sink);
                switch (FindFlowBetweenMethods.this.flow) {
                    case "Data": {
                        return new LocalFlowSpec<Expression, Expression>(){

                            @Override
                            public boolean isSource(Expression expression, Cursor cursor) {
                                return expression == source;
                            }

                            @Override
                            public boolean isSink(Expression expression, Cursor cursor) {
                                return this.conditional(sinkMatcher, cursor);
                            }
                        };
                    }
                    case "Taint": {
                        return new LocalTaintFlowSpec<Expression, Expression>(){

                            @Override
                            public boolean isSource(Expression expression, Cursor cursor) {
                                return expression == source;
                            }

                            @Override
                            public boolean isSink(Expression expression, Cursor cursor) {
                                return this.conditional(sinkMatcher, cursor);
                            }
                        };
                    }
                }
                throw new IllegalStateException("Unknown flow: " + FindFlowBetweenMethods.this.flow);
            }
        });
    }

    public FindFlowBetweenMethods(String startMethodPattern, @Nullable Boolean startMatchOverrides, String endMethodPattern, @Nullable Boolean endMatchOverrides, String target, @Nullable String flow) {
        this.startMethodPattern = startMethodPattern;
        this.startMatchOverrides = startMatchOverrides;
        this.endMethodPattern = endMethodPattern;
        this.endMatchOverrides = endMatchOverrides;
        this.target = target;
        this.flow = flow;
    }

    public String getStartMethodPattern() {
        return this.startMethodPattern;
    }

    @Nullable
    public Boolean getStartMatchOverrides() {
        return this.startMatchOverrides;
    }

    public String getEndMethodPattern() {
        return this.endMethodPattern;
    }

    @Nullable
    public Boolean getEndMatchOverrides() {
        return this.endMatchOverrides;
    }

    public String getTarget() {
        return this.target;
    }

    @Nullable
    public String getFlow() {
        return this.flow;
    }

    @NonNull
    public String toString() {
        return "FindFlowBetweenMethods(startMethodPattern=" + this.getStartMethodPattern() + ", startMatchOverrides=" + this.getStartMatchOverrides() + ", endMethodPattern=" + this.getEndMethodPattern() + ", endMatchOverrides=" + this.getEndMatchOverrides() + ", target=" + this.getTarget() + ", flow=" + this.getFlow() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFlowBetweenMethods)) {
            return false;
        }
        FindFlowBetweenMethods other = (FindFlowBetweenMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$startMatchOverrides = this.getStartMatchOverrides();
        Boolean other$startMatchOverrides = other.getStartMatchOverrides();
        if (this$startMatchOverrides == null ? other$startMatchOverrides != null : !((Object)this$startMatchOverrides).equals(other$startMatchOverrides)) {
            return false;
        }
        Boolean this$endMatchOverrides = this.getEndMatchOverrides();
        Boolean other$endMatchOverrides = other.getEndMatchOverrides();
        if (this$endMatchOverrides == null ? other$endMatchOverrides != null : !((Object)this$endMatchOverrides).equals(other$endMatchOverrides)) {
            return false;
        }
        String this$startMethodPattern = this.getStartMethodPattern();
        String other$startMethodPattern = other.getStartMethodPattern();
        if (this$startMethodPattern == null ? other$startMethodPattern != null : !this$startMethodPattern.equals(other$startMethodPattern)) {
            return false;
        }
        String this$endMethodPattern = this.getEndMethodPattern();
        String other$endMethodPattern = other.getEndMethodPattern();
        if (this$endMethodPattern == null ? other$endMethodPattern != null : !this$endMethodPattern.equals(other$endMethodPattern)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        return !(this$flow == null ? other$flow != null : !this$flow.equals(other$flow));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindFlowBetweenMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $startMatchOverrides = this.getStartMatchOverrides();
        result = result * 59 + ($startMatchOverrides == null ? 43 : ((Object)$startMatchOverrides).hashCode());
        Boolean $endMatchOverrides = this.getEndMatchOverrides();
        result = result * 59 + ($endMatchOverrides == null ? 43 : ((Object)$endMatchOverrides).hashCode());
        String $startMethodPattern = this.getStartMethodPattern();
        result = result * 59 + ($startMethodPattern == null ? 43 : $startMethodPattern.hashCode());
        String $endMethodPattern = this.getEndMethodPattern();
        result = result * 59 + ($endMethodPattern == null ? 43 : $endMethodPattern.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        return result;
    }
}

