/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow.analysis;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.analysis.dataflow.analysis.FlowGraph;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class SinkFlowSummary<Source extends Expression, Sink extends J> {
    private final SinkFlowSummaryFlowGraphWalker<Source, Sink> flowGraphWalker;
    private final Cursor sourceCursor;
    private final AtomicReference<Object> flows = new AtomicReference();
    private final AtomicReference<Object> sinkCursors = new AtomicReference();
    private final AtomicReference<Object> sinks = new AtomicReference();
    private final AtomicReference<Object> flowCursorParticipants = new AtomicReference();
    private final AtomicReference<Object> flowParticipants = new AtomicReference();

    private List<Cursor> computeSinkCursors() {
        List<List<Cursor>> flows = this.getFlows();
        ArrayList<Cursor> sinkCursors = new ArrayList<Cursor>(flows.size());
        for (List<Cursor> flow : flows) {
            sinkCursors.add(flow.get(flow.size() - 1));
        }
        return sinkCursors;
    }

    public Source getSource() {
        return (Source)((Expression)this.getSourceCursor().getValue());
    }

    public boolean isEmpty() {
        return this.getSinks().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public static <Source extends Expression, Sink extends J> SinkFlowSummary create(FlowGraph start, LocalFlowSpec<Source, Sink> spec, Set<Expression> reachable) {
        return new SinkFlowSummary<Source, Sink>(SinkFlowSummaryFlowGraphWalker.create(spec, reachable, start), start.getCursor());
    }

    public SinkFlowSummary(SinkFlowSummaryFlowGraphWalker<Source, Sink> flowGraphWalker, Cursor sourceCursor) {
        this.flowGraphWalker = flowGraphWalker;
        this.sourceCursor = sourceCursor;
    }

    public Cursor getSourceCursor() {
        return this.sourceCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Cursor>> getFlows() {
        Object value = this.flows.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.flows;
            synchronized (atomicReference) {
                value = this.flows.get();
                if (value == null) {
                    List<List<Cursor>> actualValue = this.flowGraphWalker.computeFlows();
                    value = actualValue == null ? this.flows : actualValue;
                    this.flows.set(value);
                }
            }
        }
        return (List)(value == this.flows ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cursor> getSinkCursors() {
        Object value = this.sinkCursors.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.sinkCursors;
            synchronized (atomicReference) {
                value = this.sinkCursors.get();
                if (value == null) {
                    List<Cursor> actualValue = this.computeSinkCursors();
                    value = actualValue == null ? this.sinkCursors : actualValue;
                    this.sinkCursors.set(value);
                }
            }
        }
        return (List)(value == this.sinkCursors ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sink> getSinks() {
        Object value = this.sinks.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.sinks;
            synchronized (atomicReference) {
                value = this.sinks.get();
                if (value == null) {
                    List actualValue = this.getSinkCursors().stream().map(Cursor::getValue).collect(Collectors.toList());
                    value = actualValue == null ? this.sinks : actualValue;
                    this.sinks.set(value);
                }
            }
        }
        return (List)(value == this.sinks ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Cursor> getFlowCursorParticipants() {
        Object value = this.flowCursorParticipants.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.flowCursorParticipants;
            synchronized (atomicReference) {
                value = this.flowCursorParticipants.get();
                if (value == null) {
                    Set actualValue = this.getFlows().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
                    value = actualValue == null ? this.flowCursorParticipants : actualValue;
                    this.flowCursorParticipants.set(value);
                }
            }
        }
        return (Set)(value == this.flowCursorParticipants ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Expression> getFlowParticipants() {
        Object value = this.flowParticipants.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.flowParticipants;
            synchronized (atomicReference) {
                value = this.flowParticipants.get();
                if (value == null) {
                    Set actualValue = this.getFlowCursorParticipants().stream().map(Cursor::getValue).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
                    value = actualValue == null ? this.flowParticipants : actualValue;
                    this.flowParticipants.set(value);
                }
            }
        }
        return (Set)(value == this.flowParticipants ? null : value);
    }

    private static class SinkFlowSummaryFlowGraphWalker<Source extends Expression, Sink extends J> {
        private final LocalFlowSpec<Source, Sink> spec;
        private final Set<Expression> reachable;
        private final FlowGraph start;

        public List<List<Cursor>> computeFlows() {
            ArrayList<List<Cursor>> flows = new ArrayList<List<Cursor>>();
            ArrayDeque<Cursor> path = new ArrayDeque<Cursor>();
            path.push(this.start.getCursor());
            this.recurseGetFlows(this.start, path, flows);
            return flows;
        }

        private void recurseGetFlows(FlowGraph flowGraph, Deque<Cursor> pathToHere, List<List<Cursor>> pathsToSinks) {
            Cursor cursor = flowGraph.getCursor();
            if (cursor.getValue() instanceof Expression && !this.reachable.contains(cursor.getValue())) {
                return;
            }
            boolean isSinkType = this.spec.getSinkType().isAssignableFrom(cursor.getValue().getClass());
            if (isSinkType && this.spec.isSink((J)cursor.getValue(), cursor)) {
                ArrayList<Cursor> flow = new ArrayList<Cursor>(pathToHere);
                flow.add(cursor);
                pathsToSinks.add(flow);
            }
            for (FlowGraph edge : flowGraph.getEdges()) {
                Cursor edgeCursor = edge.getCursor();
                pathToHere.push(edgeCursor);
                this.recurseGetFlows(edge, pathToHere, pathsToSinks);
                Cursor poppedCursor = pathToHere.pop();
                assert (poppedCursor == edgeCursor) : "Expected " + edgeCursor + " but got " + poppedCursor;
            }
        }

        private SinkFlowSummaryFlowGraphWalker(LocalFlowSpec<Source, Sink> spec, Set<Expression> reachable, FlowGraph start) {
            this.spec = spec;
            this.reachable = reachable;
            this.start = start;
        }

        @NonNull
        private static <Source extends Expression, Sink extends J> SinkFlowSummaryFlowGraphWalker<Source, Sink> create(LocalFlowSpec<Source, Sink> spec, Set<Expression> reachable, FlowGraph start) {
            return new SinkFlowSummaryFlowGraphWalker<Source, Sink>(spec, reachable, start);
        }
    }
}

