/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.invocation.DefaultGradle;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleProjectBuilder;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.gradle.marker.GradleSettingsBuilder;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelImpl;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelProxy;

public class ToolingApiOpenRewriteModelPlugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;
    private static final ObjectMapper mapper = new RecipeSerializer().getMapper();

    @Inject
    public ToolingApiOpenRewriteModelPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.registry.register((ToolingModelBuilder)new OpenRewriteModelBuilder());
    }

    private static class OpenRewriteModelBuilder
    implements ToolingModelBuilder {
        private OpenRewriteModelBuilder() {
        }

        public boolean canBuild(String modelName) {
            return modelName.equals(OpenRewriteModelProxy.class.getName());
        }

        public Object buildAll(String modelName, Project project) {
            try {
                GradleProject gradleProject = GradleProjectBuilder.gradleProject((Project)project);
                byte[] gradleProjectBytes = mapper.writeValueAsBytes((Object)gradleProject);
                byte[] gradleSettingsBytes = null;
                if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) >= 0 && (new File(project.getProjectDir(), "settings.gradle").exists() || new File(project.getProjectDir(), "settings.gradle.kts").exists())) {
                    GradleSettings gradleSettings = GradleSettingsBuilder.gradleSettings((Settings)((DefaultGradle)project.getGradle()).getSettings());
                    gradleSettingsBytes = mapper.writeValueAsBytes((Object)gradleSettings);
                }
                return new OpenRewriteModelImpl(gradleProjectBytes, gradleSettingsBytes);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize Gradle model to JSON", e);
            }
        }
    }
}

