/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.RefineServlet;
import com.google.refine.model.Recon;
import com.google.refine.model.ReconCandidate;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    @JsonProperty(value="recons")
    protected final Map<String, Recon> recons = new HashMap<String, Recon>();
    protected final Map<String, ReconCandidate> candidates = new HashMap<String, ReconCandidate>();

    private void pool(ReconCandidate candidate) {
        this.candidates.put(candidate.id, candidate);
    }

    public void pool(Recon recon) {
        this.recons.put(Long.toString(recon.id), recon);
        this.poolReconCandidates(recon);
    }

    public void poolReconCandidates(Recon recon) {
        if (recon.match != null) {
            this.pool(recon.match);
        }
        if (recon.candidates != null) {
            for (ReconCandidate candidate : recon.candidates) {
                this.pool(candidate);
            }
        }
    }

    public Recon getRecon(String id) {
        return this.recons.get(id);
    }

    public ReconCandidate getReconCandidate(String topicID) {
        return this.candidates.get(topicID);
    }

    public void save(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        try {
            this.save(writer);
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    public void save(Writer writer) throws IOException {
        writer.write(RefineServlet.VERSION);
        writer.write(10);
        Collection<Recon> recons2 = this.recons.values();
        writer.write("reconCount=" + recons2.size());
        writer.write(10);
        for (Recon recon : recons2) {
            ParsingUtilities.saveWriter.writeValue(writer, (Object)recon);
            writer.write(10);
        }
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public void load(Reader reader) throws IOException {
        String line;
        LineNumberReader reader2 = new LineNumberReader(reader);
        reader2.readLine();
        while ((line = reader2.readLine()) != null) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("reconCandidateCount".equals(field)) {
                count = Integer.parseInt(value);
                for (i = 0; i < count; ++i) {
                    ReconCandidate candidate;
                    line = reader2.readLine();
                    if (line == null || (candidate = ReconCandidate.loadStreaming(line)) == null) continue;
                    this.pool(candidate);
                }
                continue;
            }
            if (!"reconCount".equals(field)) continue;
            count = Integer.parseInt(value);
            for (i = 0; i < count; ++i) {
                Recon recon;
                line = reader2.readLine();
                if (line == null || (recon = Recon.loadStreaming(line)) == null) continue;
                this.pool(recon);
            }
        }
    }
}

