/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.refine.util.JsonViews;
import com.google.refine.util.SerializationFilters;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;

public class ParsingUtilities {
    public static JsonFactory jsonFactory = new JsonFactory();
    public static final ObjectMapper mapper;
    public static final FilterProvider defaultFilters;
    public static final FilterProvider saveFilters;
    public static final ObjectWriter saveWriter;
    public static final ObjectWriter defaultWriter;
    public static final DateTimeFormatter ISO8601;
    private static final ZoneId defaultZone;
    private static final URLCodec codec;

    public static Map<String, String> parseParameters(HttpServletRequest request) {
        return request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String[])entry.getValue())[0]));
    }

    @Deprecated
    public static Properties parseUrlParameters(HttpServletRequest request) {
        Properties options = new Properties();
        String query = request.getQueryString();
        if (query != null) {
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            ParsingUtilities.parseParameters(options, query);
        }
        return options;
    }

    @Deprecated
    public static Properties parseParameters(Properties p, String str) {
        if (str != null) {
            String[] pairs;
            for (String pairString : pairs = str.split("&")) {
                int equal = pairString.indexOf(61);
                String name = equal >= 0 ? pairString.substring(0, equal) : "";
                String value = equal >= 0 ? ParsingUtilities.decode(pairString.substring(equal + 1)) : "";
                p.put(name, value);
            }
        }
        return p;
    }

    @Deprecated
    public static Properties parseParameters(String str) {
        return str == null ? null : ParsingUtilities.parseParameters(new Properties(), str);
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        return ParsingUtilities.inputStreamToString(is, "UTF-8");
    }

    public static String inputStreamToString(InputStream is, String encoding) throws IOException {
        InputStream uncompressedStream = is;
        if ("gzip".equals(encoding)) {
            uncompressedStream = new GZIPInputStream(is);
            encoding = "UTF-8";
        }
        return IOUtils.toString((InputStream)uncompressedStream, (String)encoding);
    }

    public static String encode(String s) {
        try {
            return codec.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String decode(String s) {
        try {
            return codec.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        catch (DecoderException e) {
            return s;
        }
    }

    public static String dateToString(OffsetDateTime d) {
        return d.format(ISO8601);
    }

    public static String localDateToString(LocalDateTime d) {
        OffsetDateTime odt = OffsetDateTime.of(d, OffsetDateTime.now().getOffset());
        return odt.withOffsetSameInstant(ZoneOffset.of("Z")).format(ISO8601);
    }

    public static OffsetDateTime stringToDate(String s) {
        try {
            return OffsetDateTime.parse(s);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                LocalDateTime localTime = LocalDateTime.parse(s);
                return OffsetDateTime.of(localTime, ZoneId.systemDefault().getRules().getOffset(localTime));
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return null;
            }
        }
    }

    public static LocalDateTime stringToLocalDate(String s) {
        OffsetDateTime parsed = ParsingUtilities.stringToDate(s);
        if (parsed == null) {
            return null;
        }
        return parsed.withOffsetSameInstant(OffsetDateTime.now().getOffset()).toLocalDateTime();
    }

    public static OffsetDateTime calendarToOffsetDateTime(Calendar calendar) {
        return calendar.toInstant().atOffset(ZoneOffset.of("Z"));
    }

    public static Calendar offsetDateTimeToCalendar(OffsetDateTime offsetDateTime) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("Z"));
        cal.setTimeInMillis(offsetDateTime.toInstant().toEpochMilli());
        return cal;
    }

    public static boolean isDate(Object o) {
        return o instanceof OffsetDateTime;
    }

    public static OffsetDateTime toDate(Date date) {
        return date.toInstant().atZone(defaultZone).toOffsetDateTime();
    }

    public static OffsetDateTime toDate(Calendar date) {
        return date.toInstant().atZone(defaultZone).toOffsetDateTime();
    }

    public static ObjectNode evaluateJsonStringToObjectNode(String optionsString) {
        try {
            JsonNode tree = mapper.readTree(optionsString);
            if (tree instanceof ObjectNode) {
                return (ObjectNode)tree;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayNode evaluateJsonStringToArrayNode(String parameter) {
        try {
            JsonNode tree = mapper.readTree(parameter);
            if (tree instanceof ArrayNode) {
                return (ArrayNode)tree;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build());
        mapper = new ObjectMapper(jsonFactory);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Double.class, (JsonSerializer)new SerializationFilters.DoubleSerializer());
        module.addSerializer(Double.TYPE, (JsonSerializer)new SerializationFilters.DoubleSerializer());
        module.addSerializer(OffsetDateTime.class, (JsonSerializer)new SerializationFilters.OffsetDateSerializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new SerializationFilters.LocalDateSerializer());
        module.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new SerializationFilters.OffsetDateDeserializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new SerializationFilters.LocalDateDeserializer());
        module.addSerializer(Instant.class, (JsonSerializer)new SerializationFilters.InstantSerializer());
        module.addDeserializer(Instant.class, (JsonDeserializer)new SerializationFilters.InstantDeserializer());
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)new Jdk8Module());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        defaultFilters = new SimpleFilterProvider().addFilter("reconCandidateFilter", SerializationFilters.reconCandidateFilter);
        saveFilters = new SimpleFilterProvider().addFilter("reconCandidateFilter", SerializationFilters.noFilter);
        saveWriter = mapper.writerWithView(JsonViews.SaveMode.class).with(saveFilters);
        defaultWriter = mapper.writerWithView(JsonViews.NonSaveMode.class).with(defaultFilters);
        ISO8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        defaultZone = ZoneId.systemDefault();
        codec = new URLCodec();
    }
}

