/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.refine.expr.util.JsonValueConverter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JSONUtilities {
    public static ObjectNode getObject(ObjectNode obj, String key) {
        JsonNode node = obj.get(key);
        if (node != null && node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        return null;
    }

    public static String getString(JsonNode obj, String key, String def) {
        if (obj.has(key)) {
            return obj.get(key).textValue();
        }
        return def;
    }

    public static int getInt(JsonNode obj, String key, int def) {
        if (obj.has(key)) {
            return obj.get(key).asInt(def);
        }
        return def;
    }

    public static boolean getBoolean(JsonNode obj, String key, boolean def) {
        if (obj.has(key)) {
            return obj.get(key).asBoolean(def);
        }
        return def;
    }

    public static ArrayNode getArray(ObjectNode obj, String key) {
        if (obj.has(key) && obj.get(key) instanceof ArrayNode) {
            return (ArrayNode)obj.get(key);
        }
        return null;
    }

    public static List<JsonNode> getArray(JsonNode obj, String key) {
        if (obj.has(key) && obj.get(key).getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            return Lists.newArrayList((Iterator)obj.get(key).elements());
        }
        return null;
    }

    public static int[] getIntArray(ObjectNode obj, String key) {
        ArrayNode a = JSONUtilities.getArray(obj, key);
        if (a == null) {
            return new int[0];
        }
        int[] r = new int[a.size()];
        int i = 0;
        for (JsonNode n : a) {
            r[i] = n.asInt();
            ++i;
        }
        return r;
    }

    public static String[] getStringArray(ObjectNode obj, String key) {
        ArrayNode a = JSONUtilities.getArray(obj, key);
        if (a == null) {
            return new String[0];
        }
        String[] r = new String[a.size()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = a.get(i).asText();
        }
        return r;
    }

    public static ObjectNode getObjectElement(ArrayNode a, int i) {
        JsonNode n = a.get(i);
        if (n != null && n instanceof ObjectNode) {
            return (ObjectNode)n;
        }
        return null;
    }

    public static List<ObjectNode> getObjectList(ArrayNode a) {
        ArrayList<ObjectNode> result = new ArrayList<ObjectNode>(a.size());
        for (JsonNode n : a) {
            if (n == null || !(n instanceof ObjectNode)) continue;
            result.add((ObjectNode)n);
        }
        return result;
    }

    public static int getIntElement(ArrayNode a, int i, int def) {
        if (a.get(i) != null) {
            return a.get(i).asInt(def);
        }
        return def;
    }

    public static void append(ArrayNode sheetRecords, ObjectNode sheetRecord) {
        sheetRecords.add((JsonNode)sheetRecord);
    }

    public static void append(ArrayNode array, int v) {
        array.add(v);
    }

    public static void append(ArrayNode a, String element) {
        a.add(element);
    }

    public static void safePut(ObjectNode options, String key, JsonNode rootElement) {
        options.set(key, rootElement);
    }

    public static void safeInc(ObjectNode obj, String key) {
        int currentValue = JSONUtilities.getInt((JsonNode)obj, key, 0);
        JSONUtilities.safePut(obj, key, currentValue + 1);
    }

    public static void safePut(ObjectNode obj, String key, long value) {
        obj.put(key, value);
    }

    public static void safePut(ObjectNode obj, String key, double value) {
        obj.put(key, value);
    }

    public static void safePut(ObjectNode obj, String key, boolean value) {
        obj.put(key, value);
    }

    public static void safePut(ObjectNode obj, String key, String value) {
        obj.put(key, value);
    }

    public static Object[] toArray(ArrayNode v) {
        if (v == null) {
            return null;
        }
        Object[] result = new Object[v.size()];
        for (int i = 0; i != v.size(); ++i) {
            result[i] = JsonValueConverter.convert(v.get(i));
        }
        return result;
    }

    public static Comparable[] toSortableArray(ArrayNode v) {
        if (v == null) {
            return null;
        }
        Comparable[] result = new Comparable[v.size()];
        for (int i = 0; i != v.size(); ++i) {
            result[i] = JsonValueConverter.convertComparable(v.get(i));
        }
        return result;
    }
}

