/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter {
    private static final int s_max = 20;
    private static String[] s_indents = new String[20];
    private Writer m_writer;
    private int m_count = 0;
    private boolean m_indent = true;

    public IndentWriter(Writer writer) {
        this.m_writer = writer;
    }

    public void close() throws IOException {
        this.m_writer.close();
    }

    public void flush() throws IOException {
        this.m_writer.flush();
    }

    public void print(Object o) throws IOException {
        this.printIndent();
        this.m_writer.write(o.toString());
        this.m_indent = false;
    }

    public void println() throws IOException {
        this.printIndent();
        this.m_writer.write("\n");
        this.m_indent = true;
    }

    public void println(Object o) throws IOException {
        this.printIndent();
        this.m_writer.write(o.toString());
        this.m_writer.write("\n");
        this.m_indent = true;
    }

    public void indent() {
        ++this.m_count;
    }

    public void unindent() {
        --this.m_count;
    }

    private void printIndent() throws IOException {
        if (this.m_indent) {
            this.m_writer.write(s_indents[this.m_count]);
        }
    }

    static {
        for (int i = 0; i < 20; ++i) {
            StringBuffer sb = new StringBuffer(20);
            for (int j = 0; j < i; ++j) {
                sb.append('\t');
            }
            IndentWriter.s_indents[i] = sb.toString();
        }
    }
}

