/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.browsing.RowVisitor;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.sorting.BaseSorter;
import com.google.refine.sorting.Criterion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortingRowVisitor
extends BaseSorter
implements RowVisitor {
    protected final RowVisitor _visitor;
    protected List<IndexedRow> _indexedRows;

    public SortingRowVisitor(RowVisitor visitor) {
        this._visitor = visitor;
    }

    @Override
    public void start(Project project) {
        int count = project.rows.size();
        this._indexedRows = new ArrayList<IndexedRow>(count);
        this._keys = new ArrayList(count);
    }

    @Override
    public void end(Project project) {
        this._visitor.start(project);
        Collections.sort(this._indexedRows, new Comparator<IndexedRow>(){
            Project project;

            Comparator<IndexedRow> init(Project project) {
                this.project = project;
                return this;
            }

            @Override
            public int compare(IndexedRow o1, IndexedRow o2) {
                return SortingRowVisitor.this.compare(this.project, o1.row, o1.index, o2.row, o2.index);
            }
        }.init(project));
        int sortedIndex = 0;
        for (IndexedRow indexedRow : this._indexedRows) {
            this._visitor.visit(project, indexedRow.index, sortedIndex, indexedRow.row);
            ++sortedIndex;
        }
        this._visitor.end(project);
    }

    @Override
    public boolean visit(Project project, int rowIndex, Row row) {
        this._indexedRows.add(new IndexedRow(rowIndex, row));
        return false;
    }

    @Override
    protected Object makeKey(Project project, Criterion.KeyMaker keyMaker, Criterion c, Object o, int index) {
        return keyMaker.makeKey(project, (Row)o, index);
    }

    protected static class IndexedRow {
        final int index;
        final Row row;

        IndexedRow(int index, Row row) {
            this.index = index;
            this.row = row;
        }
    }
}

