/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.browsing.RecordVisitor;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.sorting.BaseSorter;
import com.google.refine.sorting.Criterion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortingRecordVisitor
extends BaseSorter
implements RecordVisitor {
    protected final RecordVisitor _visitor;
    protected List<Record> _records;

    public SortingRecordVisitor(RecordVisitor visitor) {
        this._visitor = visitor;
    }

    @Override
    public void start(Project project) {
        int count = project.recordModel.getRecordCount();
        this._records = new ArrayList<Record>(count);
        this._keys = new ArrayList(count);
    }

    @Override
    public void end(Project project) {
        this._visitor.start(project);
        Collections.sort(this._records, new Comparator<Record>(){
            Project project;

            Comparator<Record> init(Project project) {
                this.project = project;
                return this;
            }

            @Override
            public int compare(Record o1, Record o2) {
                return SortingRecordVisitor.this.compare(this.project, o1, o1.recordIndex, o2, o2.recordIndex);
            }
        }.init(project));
        int sortedIndex = 0;
        for (Record record : this._records) {
            this._visitor.visit(project, sortedIndex, record);
            sortedIndex += record.toRowIndex - record.fromRowIndex;
        }
        this._visitor.end(project);
    }

    @Override
    public boolean visit(Project project, Record record) {
        this._records.add(record);
        return false;
    }

    @Override
    protected Object makeKey(Project project, Criterion.KeyMaker keyMaker, Criterion c, Object o, int index) {
        return keyMaker.makeKey(project, (Record)o);
    }
}

