/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.sorting.Criterion;
import java.time.OffsetDateTime;

public class NumberCriterion
extends Criterion {
    protected static final EvalError s_error = new EvalError("Not a number");

    @Override
    public Criterion.KeyMaker createKeyMaker() {
        return new Criterion.KeyMaker(){

            @Override
            protected Object makeKey(Object value) {
                if (ExpressionUtils.isNonBlankData(value)) {
                    if (value instanceof Number) {
                        return value;
                    }
                    if (value instanceof Boolean) {
                        return (Boolean)value != false ? 1 : 0;
                    }
                    if (value instanceof OffsetDateTime) {
                        return ((OffsetDateTime)value).toInstant().toEpochMilli();
                    }
                    if (value instanceof String) {
                        try {
                            double d = Double.parseDouble((String)value);
                            if (!Double.isNaN(d)) {
                                return d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return s_error;
                }
                return null;
            }

            @Override
            public int compareKeys(Object key1, Object key2) {
                double d2;
                double d1 = ((Number)key1).doubleValue();
                return d1 < (d2 = ((Number)key2).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
            }
        };
    }

    @Override
    public String getValueType() {
        return "number";
    }
}

