/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.sorting.Criterion;
import java.time.Instant;
import java.time.OffsetDateTime;

public class DateCriterion
extends Criterion {
    protected static final EvalError s_error = new EvalError("Not a date");

    @Override
    public Criterion.KeyMaker createKeyMaker() {
        return new Criterion.KeyMaker(){

            @Override
            protected Object makeKey(Object value) {
                if (ExpressionUtils.isNonBlankData(value)) {
                    if (value instanceof OffsetDateTime) {
                        return ((OffsetDateTime)value).toInstant();
                    }
                    return s_error;
                }
                return null;
            }

            @Override
            public int compareKeys(Object key1, Object key2) {
                return ((Instant)key1).compareTo((Instant)key2);
            }
        };
    }

    @Override
    public String getValueType() {
        return "date";
    }
}

