/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Record;
import com.google.refine.model.Row;
import com.google.refine.sorting.BooleanCriterion;
import com.google.refine.sorting.DateCriterion;
import com.google.refine.sorting.NumberCriterion;
import com.google.refine.sorting.StringCriterion;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="valueType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BooleanCriterion.class, name="boolean"), @JsonSubTypes.Type(value=DateCriterion.class, name="date"), @JsonSubTypes.Type(value=NumberCriterion.class, name="number"), @JsonSubTypes.Type(value=StringCriterion.class, name="string")})
public abstract class Criterion {
    @JsonProperty(value="column")
    public String columnName;
    @JsonIgnore
    protected int cellIndex = -2;
    @JsonProperty(value="blankPosition")
    public int blankPosition = 1;
    @JsonProperty(value="errorPosition")
    public int errorPosition = 2;
    @JsonProperty(value="reverse")
    public boolean reverse = false;

    @JsonIgnore
    public abstract String getValueType();

    protected int getCellIndex(Project project) {
        if (this.cellIndex == -2) {
            Column column = project.columnModel.getColumnByName(this.columnName);
            this.cellIndex = column != null ? column.getCellIndex() : -1;
        }
        return this.cellIndex;
    }

    public abstract KeyMaker createKeyMaker();

    public abstract class KeyMaker {
        public Object makeKey(Project project, Record record) {
            Object error = null;
            Object finalKey = null;
            for (int r = record.fromRowIndex; r < record.toRowIndex; ++r) {
                Object key = this.makeKey(project, project.rows.get(r), r);
                if (ExpressionUtils.isError(key)) {
                    error = key;
                    continue;
                }
                if (!ExpressionUtils.isNonBlankData(key)) continue;
                if (finalKey == null) {
                    finalKey = key;
                    continue;
                }
                int c = this.compareKeys(finalKey, key);
                if (Criterion.this.reverse) {
                    if (c >= 0) continue;
                    finalKey = key;
                    continue;
                }
                if (c <= 0) continue;
                finalKey = key;
            }
            if (finalKey != null) {
                return finalKey;
            }
            if (error != null) {
                return error;
            }
            return null;
        }

        public Object makeKey(Project project, Row row, int rowIndex) {
            if (Criterion.this.getCellIndex(project) < 0) {
                return null;
            }
            Object value = row.getCellValue(Criterion.this.getCellIndex(project));
            return this.makeKey(value);
        }

        public abstract int compareKeys(Object var1, Object var2);

        protected abstract Object makeKey(Object var1);
    }
}

