/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.sorting;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.sorting.Criterion;

public class BooleanCriterion
extends Criterion {
    protected static final EvalError s_error = new EvalError("Not a boolean");

    @Override
    public Criterion.KeyMaker createKeyMaker() {
        return new Criterion.KeyMaker(){

            @Override
            protected Object makeKey(Object value) {
                if (ExpressionUtils.isNonBlankData(value)) {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Boolean.parseBoolean((String)value);
                    }
                    return s_error;
                }
                return null;
            }

            @Override
            public int compareKeys(Object key1, Object key2) {
                return ((Boolean)key1).compareTo((Boolean)key2);
            }
        };
    }

    @Override
    public String getValueType() {
        return "boolean";
    }
}

