/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.process;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;

public abstract class QuickHistoryEntryProcess
extends Process {
    protected final Project _project;
    protected final String _briefDescription;
    protected HistoryEntry _historyEntry;
    boolean _done = false;

    public QuickHistoryEntryProcess(Project project, String briefDescription) {
        this._project = project;
        this._briefDescription = briefDescription;
    }

    @Override
    public void cancel() {
        throw new RuntimeException("Not a long-running process");
    }

    @Override
    @JsonProperty(value="immediate")
    public boolean isImmediate() {
        return true;
    }

    @Override
    public boolean isRunning() {
        throw new RuntimeException("Not a long-running process");
    }

    @Override
    public HistoryEntry performImmediate() throws Exception {
        if (this._historyEntry == null) {
            this._historyEntry = this.createHistoryEntry(HistoryEntry.allocateID());
        }
        this._project.history.addEntry(this._historyEntry);
        this._done = true;
        return this._historyEntry;
    }

    @Override
    public void startPerforming(ProcessManager manager) {
        throw new RuntimeException("Not a long-running process");
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this._done ? "done" : "pending";
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this._historyEntry != null ? this._historyEntry.description : this._briefDescription;
    }

    @Override
    public boolean isDone() {
        return this._done;
    }

    protected abstract HistoryEntry createHistoryEntry(long var1) throws Exception;
}

