/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.history.HistoryEntry;
import com.google.refine.process.Process;
import com.google.refine.process.ProcessManager;

public abstract class LongRunningProcess
extends Process {
    @JsonProperty(value="description")
    protected final String _description;
    @JsonIgnore
    protected ProcessManager _manager;
    @JsonIgnore
    protected Thread _thread;
    @JsonProperty(value="progress")
    protected int _progress;
    @JsonIgnore
    protected boolean _canceled;

    protected LongRunningProcess(String description) {
        this._description = description;
    }

    @Override
    public void cancel() {
        this._canceled = true;
        if (this._thread != null && this._thread.isAlive()) {
            this._thread.interrupt();
        }
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this._thread == null ? "pending" : (this._thread.isAlive() ? "running" : "done");
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return this._thread != null && this._thread.isAlive();
    }

    @Override
    public boolean isDone() {
        return this._thread != null && !this._thread.isAlive();
    }

    @Override
    public HistoryEntry performImmediate() {
        throw new RuntimeException("Not an immediate process");
    }

    @Override
    public void startPerforming(ProcessManager manager) {
        if (this._thread == null) {
            this._manager = manager;
            this._thread = new Thread(this.getRunnable());
            this._thread.start();
        }
    }

    protected abstract Runnable getRunnable();
}

