/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.browsing.FilteredRows;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.history.Change;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.changes.CellChange;
import com.google.refine.model.changes.MassCellChange;
import com.google.refine.operations.EngineDependentOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class EngineDependentMassCellOperation
extends EngineDependentOperation {
    @JsonIgnore
    protected final String _columnName;
    @JsonIgnore
    protected final boolean _updateRowContextDependencies;

    protected EngineDependentMassCellOperation(EngineConfig engineConfig, String columnName, boolean updateRowContextDependencies) {
        super(engineConfig);
        this._columnName = columnName;
        this._updateRowContextDependencies = updateRowContextDependencies;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notNull((Object)this._columnName, (String)"Missing column name");
    }

    @Override
    protected HistoryEntry createHistoryEntry(Project project, long historyEntryID) throws Exception {
        Engine engine = this.createEngine(project);
        Column column = project.columnModel.getColumnByName(this._columnName);
        if (column == null) {
            throw new Exception("No column named " + this._columnName);
        }
        ArrayList<CellChange> cellChanges = new ArrayList<CellChange>(project.rows.size());
        FilteredRows filteredRows = engine.getAllFilteredRows();
        try {
            filteredRows.accept(project, this.createRowVisitor(project, cellChanges, historyEntryID));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String description = this.createDescription(column, cellChanges);
        return new HistoryEntry(historyEntryID, project, description, (AbstractOperation)this, this.createChange(project, column, cellChanges));
    }

    protected Change createChange(Project project, Column column, List<CellChange> cellChanges) {
        return new MassCellChange(cellChanges, column.getName(), this._updateRowContextDependencies);
    }

    @JsonProperty(value="columnName")
    protected String getColumnName() {
        return this._columnName;
    }

    protected abstract RowVisitor createRowVisitor(Project var1, List<CellChange> var2, long var3) throws Exception;

    protected abstract String createDescription(Column var1, List<CellChange> var2);
}

