/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.recon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.ReconCandidate;
import com.google.refine.model.ReconType;
import com.google.refine.model.RecordModel;
import com.google.refine.model.Row;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.ReconJob;
import com.google.refine.util.HttpClient;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardReconConfig
extends ReconConfig {
    static final Logger logger = LoggerFactory.getLogger((String)"refine-standard-recon");
    private static final String DEFAULT_SCHEMA_SPACE = "http://localhost/schema";
    private static final String DEFAULT_IDENTIFIER_SPACE = "http://localhost/identifier";
    private static final int DEFAULT_BATCH_SIZE = 10;
    @JsonProperty(value="service")
    public final String service;
    @JsonProperty(value="identifierSpace")
    public final String identifierSpace;
    @JsonProperty(value="schemaSpace")
    public final String schemaSpace;
    @JsonIgnore
    public final String typeID;
    @JsonIgnore
    public final String typeName;
    @JsonProperty(value="autoMatch")
    public final boolean autoMatch;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonProperty(value="batchSize")
    public final Optional<Integer> batchSize;
    @JsonProperty(value="columnDetails")
    public final List<ColumnDetail> columnDetails;
    @JsonProperty(value="limit")
    private final int limit;
    private HttpClient httpClient = null;
    protected static final Set<String> s_stopWords = new HashSet<String>();

    public static StandardReconConfig reconstruct(String json) throws IOException {
        return (StandardReconConfig)ParsingUtilities.mapper.readValue(json, StandardReconConfig.class);
    }

    @JsonCreator
    public StandardReconConfig(@JsonProperty(value="service") String service, @JsonProperty(value="identifierSpace") String identifierSpace, @JsonProperty(value="schemaSpace") String schemaSpace, @JsonProperty(value="type") ReconType type, @JsonProperty(value="autoMatch") boolean autoMatch, @JsonProperty(value="batchSize") Optional<Integer> batchSize, @JsonProperty(value="columnDetails") List<ColumnDetail> columnDetails, @JsonProperty(value="limit") int limit) {
        this(service, identifierSpace, schemaSpace, type != null ? type.id : null, type != null ? type.name : null, autoMatch, batchSize, columnDetails, limit);
    }

    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, ReconType type, boolean autoMatch, List<ColumnDetail> columnDetails, int limit) {
        this(service, identifierSpace, schemaSpace, type != null ? type.id : null, type != null ? type.name : null, autoMatch, columnDetails, limit);
    }

    @Deprecated(since="3.8.3")
    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, ReconType type, boolean autoMatch, int batchSize, List<ColumnDetail> columnDetails, int limit) {
        this(service, identifierSpace, schemaSpace, type != null ? type.id : null, type != null ? type.name : null, autoMatch, Optional.of(batchSize), columnDetails, limit);
    }

    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, String typeID, String typeName, boolean autoMatch, List<ColumnDetail> columnDetails) {
        this(service, identifierSpace, schemaSpace, typeID, typeName, autoMatch, Optional.empty(), columnDetails, 0);
    }

    @Deprecated(since="3.8.3")
    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, String typeID, String typeName, boolean autoMatch, int batchSize, List<ColumnDetail> columnDetails) {
        this(service, identifierSpace, schemaSpace, typeID, typeName, autoMatch, Optional.of(batchSize), columnDetails, 0);
    }

    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, String typeID, String typeName, boolean autoMatch, List<ColumnDetail> columnDetails, int limit) {
        this(service, identifierSpace, schemaSpace, typeID, typeName, autoMatch, Optional.empty(), columnDetails, limit);
    }

    public StandardReconConfig(String service, String identifierSpace, String schemaSpace, String typeID, String typeName, boolean autoMatch, Optional<Integer> batchSize, List<ColumnDetail> columnDetails, int limit) {
        this.service = service;
        this.identifierSpace = identifierSpace != null ? identifierSpace : DEFAULT_IDENTIFIER_SPACE;
        this.schemaSpace = schemaSpace != null ? schemaSpace : DEFAULT_SCHEMA_SPACE;
        this.typeID = typeID;
        this.typeName = typeName;
        this.autoMatch = autoMatch;
        this.batchSize = batchSize;
        this.columnDetails = columnDetails;
        this.limit = limit;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReconType getReconType() {
        if (this.typeID != null) {
            return new ReconType(this.typeID, this.typeName);
        }
        return null;
    }

    @Override
    @Deprecated
    @JsonIgnore
    public int getBatchSize() {
        return 10;
    }

    @Override
    @JsonIgnore
    public int getBatchSize(int rowCount) {
        if (this.batchSize.isEmpty()) {
            return 10;
        }
        return Math.min(Math.max(rowCount / 10, 10), this.batchSize.get());
    }

    @Override
    public String getBriefDescription(Project project, String columnName) {
        return "Reconcile cells in column " + columnName + " to type " + this.typeID;
    }

    public ReconJob createSimpleJob(String query) {
        StandardReconJob job = new StandardReconJob();
        try {
            String queryJson = ParsingUtilities.defaultWriter.writeValueAsString(Collections.singletonMap("query", query));
            job.text = query;
            job.code = queryJson;
            return job;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ReconJob createJob(Project project, int rowIndex, Row row, String columnName, Cell cell) {
        StandardReconJob job = new StandardReconJob();
        ArrayList<QueryProperty> properties = new ArrayList<QueryProperty>();
        for (ColumnDetail c : this.columnDetails) {
            int detailCellIndex = project.columnModel.getColumnByName(c.columnName).getCellIndex();
            Cell cell2 = row.getCell(detailCellIndex);
            if (cell2 == null || !ExpressionUtils.isNonBlankData(cell2.value)) {
                int contextRowIndex;
                int cellIndex = project.columnModel.getColumnByName(columnName).getCellIndex();
                RecordModel.RowDependency rd = project.recordModel.getRowDependency(rowIndex);
                if (rd != null && rd.cellDependencies != null && (contextRowIndex = rd.cellDependencies[cellIndex].rowIndex) >= 0 && contextRowIndex < project.rows.size()) {
                    Row row2 = project.rows.get(contextRowIndex);
                    cell2 = row2.getCell(detailCellIndex);
                }
            }
            if (cell2 == null || !ExpressionUtils.isNonBlankData(cell2.value)) continue;
            HashMap<String, String> v = null;
            if (cell2.recon != null && cell2.recon.match != null) {
                HashMap<String, String> recon = new HashMap<String, String>();
                recon.put("id", cell2.recon.match.id);
                recon.put("name", cell2.recon.match.name);
                v = recon;
            } else {
                v = cell2.value;
            }
            properties.add(new QueryProperty(c.propertyID, v));
        }
        ReconQuery query = new ReconQuery(cell.value.toString(), this.typeID, properties, this.limit);
        job.text = cell.value.toString();
        try {
            job.code = ParsingUtilities.defaultWriter.writeValueAsString((Object)query);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        return job;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        return this.httpClient;
    }

    private String postQueries(String url, String queriesString) throws IOException {
        return this.getHttpClient().postNameValue(url, "queries", queriesString);
    }

    @Override
    public List<Recon> batchRecon(List<ReconJob> jobs, long historyEntryID) {
        ArrayList<Recon> recons = new ArrayList<Recon>(jobs.size());
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("{");
        for (int i = 0; i < jobs.size(); ++i) {
            StandardReconJob job = (StandardReconJob)jobs.get(i);
            if (i > 0) {
                stringWriter.write(",");
            }
            stringWriter.write("\"q" + i + "\":");
            stringWriter.write(job.code);
        }
        stringWriter.write("}");
        String queriesString = stringWriter.toString();
        String responseString = "";
        ObjectNode o = null;
        try {
            responseString = this.postQueries(this.service, queriesString);
            o = (ObjectNode)ParsingUtilities.mapper.readValue(responseString, ObjectNode.class);
        }
        catch (IOException e) {
            Recon recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
            recon.error = e.getMessage();
            recon.judgment = Recon.Judgment.Error;
            recons.add(recon);
        }
        if (o == null) {
            Recon recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
            recon.error = "The reconciliation service returned an invalid response";
            recon.judgment = Recon.Judgment.Error;
            recons.add(recon);
        } else {
            for (int i = 0; i < jobs.size(); ++i) {
                StandardReconJob job = (StandardReconJob)jobs.get(i);
                Recon recon = null;
                String text = job.text;
                String key = "q" + i;
                if (o.has(key) && o.get(key) instanceof ObjectNode) {
                    ObjectNode o2 = (ObjectNode)o.get(key);
                    if (o2.has("result") && o2.get("result") instanceof ArrayNode) {
                        ArrayNode results = (ArrayNode)o2.get("result");
                        recon = this.createReconServiceResults(text, results, historyEntryID);
                    } else {
                        recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
                        recon.error = "The service returned a JSON response without \"result\" field for query " + key;
                        recon.judgment = Recon.Judgment.Error;
                    }
                } else {
                    recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
                    recon.error = "The service returned a JSON response without \"" + key + "\" field ";
                    recon.judgment = Recon.Judgment.Error;
                }
                if (recon != null) {
                    recon.service = this.service;
                }
                recons.add(recon);
            }
        }
        while (recons.size() < jobs.size()) {
            Recon recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
            recon.error = "No. of recon objects was less than no. of jobs";
            recon.judgment = Recon.Judgment.Error;
            recons.add(recon);
        }
        return recons;
    }

    @Override
    public Recon createNewRecon(long historyEntryID) {
        Recon recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
        recon.service = this.service;
        return recon;
    }

    protected Recon createReconServiceResults(String text, ArrayNode resultsList, long historyEntryID) {
        Recon recon = new Recon(historyEntryID, this.identifierSpace, this.schemaSpace);
        List results = (List)ParsingUtilities.mapper.convertValue((Object)resultsList, (TypeReference)new TypeReference<List<ReconResult>>(){});
        results.sort(new Comparator<ReconResult>(){

            @Override
            public int compare(ReconResult a, ReconResult b) {
                return Double.compare(b.score, a.score);
            }
        });
        int length = results.size();
        for (int i = 0; i < length; ++i) {
            ReconResult result = (ReconResult)results.get(i);
            ReconCandidate candidate = result.toCandidate();
            if (this.autoMatch && i == 0 && result.match) {
                recon.match = candidate;
                recon.matchRank = 0;
                recon.judgment = Recon.Judgment.Matched;
                recon.judgmentAction = "auto";
            }
            recon.addCandidate(candidate);
        }
        this.computeFeatures(recon, text);
        return recon;
    }

    public void computeFeatures(Recon recon, String text) {
        if (recon.candidates != null && !recon.candidates.isEmpty() && text != null) {
            ReconCandidate candidate = recon.candidates.get(0);
            if (candidate.name != null) {
                recon.setFeature(1, text.equalsIgnoreCase(candidate.name));
                recon.setFeature(2, StringUtils.getLevenshteinDistance((CharSequence)StringUtils.lowerCase((String)text), (CharSequence)StringUtils.lowerCase((String)candidate.name)));
                recon.setFeature(3, StandardReconConfig.wordDistance(text, candidate.name));
            }
            recon.setFeature(0, false);
            if (this.typeID != null) {
                for (String typeID : candidate.types) {
                    if (!this.typeID.equals(typeID)) continue;
                    recon.setFeature(0, true);
                    break;
                }
            }
        } else {
            recon.features = new Object[4];
        }
    }

    protected static double wordDistance(String s1, String s2) {
        Set<String> words1 = StandardReconConfig.breakWords(s1);
        Set<String> words2 = StandardReconConfig.breakWords(s2);
        return words1.size() >= words2.size() ? StandardReconConfig.wordDistance(words1, words2) : StandardReconConfig.wordDistance(words2, words1);
    }

    protected static double wordDistance(Set<String> longWords, Set<String> shortWords) {
        if (longWords.size() == 0) {
            return 0.0;
        }
        double common = 0.0;
        for (String word : shortWords) {
            if (!longWords.contains(word)) continue;
            common += 1.0;
        }
        return common / (double)longWords.size();
    }

    protected static Set<String> breakWords(String s) {
        String[] words = s.toLowerCase().split("\\s+");
        HashSet<String> set = new HashSet<String>(words.length);
        for (String word : words) {
            if (s_stopWords.contains(word)) continue;
            set.add(word);
        }
        return set;
    }

    @Override
    public String getMode() {
        return "standard-service";
    }

    static {
        s_stopWords.add("the");
        s_stopWords.add("a");
        s_stopWords.add("and");
        s_stopWords.add("of");
        s_stopWords.add("on");
        s_stopWords.add("in");
        s_stopWords.add("at");
        s_stopWords.add("by");
    }

    protected static class StandardReconJob
    extends ReconJob {
        String text;
        String code;

        protected StandardReconJob() {
        }

        @Override
        public int getKey() {
            return this.code.hashCode();
        }

        public String toString() {
            return this.code;
        }
    }

    public static class ColumnDetail {
        @JsonProperty(value="column")
        public final String columnName;
        @JsonProperty(value="propertyName")
        public final String propertyName;
        @JsonProperty(value="propertyID")
        public final String propertyID;

        @JsonCreator
        public ColumnDetail(@JsonProperty(value="column") String columnName, @JsonProperty(value="propertyName") String propertyName, @JsonProperty(value="propertyID") String propertyID, @JsonProperty(value="property") ReconType property) {
            this.columnName = columnName;
            this.propertyName = property == null ? propertyName : property.name;
            this.propertyID = property == null ? propertyID : property.id;
        }

        public String toString() {
            try {
                return ParsingUtilities.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }

    protected static class QueryProperty {
        @JsonProperty(value="pid")
        String pid;
        @JsonProperty(value="v")
        Object v;

        protected QueryProperty(String pid, Object v) {
            this.pid = pid;
            this.v = v;
        }

        public String toString() {
            try {
                return ParsingUtilities.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }

    protected static class ReconQuery {
        @JsonProperty(value="query")
        protected String query;
        @JsonProperty(value="type")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected String typeID;
        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected List<QueryProperty> properties;
        @JsonProperty(value="limit")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        protected int limit;

        @JsonProperty(value="type_strict")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String isTypeStrict() {
            if (this.typeID != null) {
                return "should";
            }
            return null;
        }

        public ReconQuery() {
            this.query = "";
            this.typeID = null;
            this.properties = null;
            this.limit = 0;
        }

        @JsonCreator
        public ReconQuery(String query, String typeID, List<QueryProperty> properties, int limit) {
            this.query = query;
            this.typeID = typeID;
            this.properties = properties;
            this.limit = limit;
        }

        public String toString() {
            try {
                return ParsingUtilities.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }

    public static class ReconResult {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="id")
        public String id;
        @JsonProperty(value="type")
        public List<ReconType> types = Collections.emptyList();
        @JsonProperty(value="score")
        public double score;
        @JsonProperty(value="match")
        public boolean match = false;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="error")
        public ReconCandidate error = null;

        @JsonIgnore
        public ReconCandidate toCandidate() {
            String[] bareTypes = new String[this.types.size()];
            for (int i = 0; i != this.types.size(); ++i) {
                bareTypes[i] = this.types.get((int)i).id;
            }
            ReconCandidate result = new ReconCandidate(this.id, this.name, bareTypes, this.score);
            return result;
        }

        public String toString() {
            try {
                return ParsingUtilities.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                return super.toString();
            }
        }
    }
}

