/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.recon;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.model.ReconCandidate;
import com.google.refine.model.ReconType;
import com.google.refine.util.HttpClient;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.JsonViews;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReconciledDataExtensionJob {
    public final DataExtensionConfig extension;
    public final String endpoint;
    public final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    private static HttpClient httpClient = null;

    public ReconciledDataExtensionJob(DataExtensionConfig obj, String endpoint) {
        this.extension = obj;
        this.endpoint = endpoint;
    }

    public Map<String, DataExtension> extend(Set<String> ids, Map<String, ReconCandidate> reconCandidateMap) throws Exception {
        StringWriter writer = new StringWriter();
        ReconciledDataExtensionJob.formulateQuery(ids, this.extension, writer);
        String query = writer.toString();
        String response = ReconciledDataExtensionJob.postExtendQuery(this.endpoint, query);
        ObjectNode o = (ObjectNode)ParsingUtilities.mapper.readValue(response, ObjectNode.class);
        if (this.columns.size() == 0) {
            List newColumns = (List)ParsingUtilities.mapper.convertValue((Object)o.get("meta"), (TypeReference)new TypeReference<List<ColumnInfo>>(){});
            this.columns.addAll(newColumns);
        }
        HashMap<String, DataExtension> map = new HashMap<String, DataExtension>();
        if (o.has("rows") && o.get("rows") instanceof ObjectNode) {
            ObjectNode records = (ObjectNode)o.get("rows");
            for (String id : ids) {
                ObjectNode record;
                DataExtension ext;
                if (!records.has(id) || !(records.get(id) instanceof ObjectNode) || (ext = this.collectResult(record = (ObjectNode)records.get(id), reconCandidateMap)) == null) continue;
                map.put(id, ext);
            }
        }
        return map;
    }

    protected static String postExtendQuery(String endpoint, String query) throws IOException {
        return ReconciledDataExtensionJob.getHttpClient().postNameValue(endpoint, "extend", query);
    }

    private static HttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = new HttpClient();
        }
        return httpClient;
    }

    protected DataExtension collectResult(ObjectNode record, Map<String, ReconCandidate> reconCandidateMap) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int colindex = 0;
        for (ColumnInfo ci : this.columns) {
            String pid = ci.id;
            ArrayNode values = JSONUtilities.getArray(record, pid);
            if (values == null) continue;
            for (int rowindex = 0; rowindex < values.size(); ++rowindex) {
                if (!(values.get(rowindex) instanceof ObjectNode)) continue;
                ObjectNode val = (ObjectNode)values.get(rowindex);
                if (val.has("id")) {
                    this.storeCell(rows, rowindex, colindex, val, reconCandidateMap);
                    continue;
                }
                if (val.has("str")) {
                    String str = val.get("str").asText();
                    this.storeCell(rows, rowindex, colindex, str);
                    continue;
                }
                if (val.has("float")) {
                    double v = val.get("float").asDouble();
                    this.storeCell(rows, rowindex, colindex, v);
                    continue;
                }
                if (val.has("int")) {
                    int v = val.get("int").asInt();
                    this.storeCell(rows, rowindex, colindex, v);
                    continue;
                }
                if (val.has("date")) {
                    Object date;
                    try {
                        date = OffsetDateTime.parse(val.get("date").asText());
                    }
                    catch (DateTimeParseException e) {
                        date = val.get("date").asText();
                    }
                    this.storeCell(rows, rowindex, colindex, date);
                    continue;
                }
                if (!val.has("bool")) continue;
                boolean v = val.get("bool").asBoolean();
                this.storeCell(rows, rowindex, colindex, v);
            }
            ++colindex;
        }
        Object[][] data = new Object[rows.size()][this.columns.size()];
        rows.toArray((T[])data);
        return new DataExtension(data);
    }

    protected void storeCell(List<Object[]> rows, int row, int col, Object value) {
        while (row >= rows.size()) {
            rows.add(new Object[this.columns.size()]);
        }
        rows.get((int)row)[col] = value;
    }

    protected void storeCell(List<Object[]> rows, int row, int col, ObjectNode obj, Map<String, ReconCandidate> reconCandidateMap) {
        ReconCandidate rc;
        String id = obj.get("id").asText();
        if (reconCandidateMap.containsKey(id)) {
            rc = reconCandidateMap.get(id);
        } else {
            rc = new ReconCandidate(obj.get("id").asText(), obj.get("name").asText(), JSONUtilities.getStringArray(obj, "type"), 100.0);
            reconCandidateMap.put(id, rc);
        }
        this.storeCell(rows, row, col, rc);
    }

    protected static void formulateQuery(Set<String> ids, DataExtensionConfig node, Writer writer) throws IOException {
        DataExtensionQuery query = new DataExtensionQuery(ids.stream().filter(e -> e != null).collect(Collectors.toList()), node.properties);
        ParsingUtilities.saveWriter.writeValue(writer, (Object)query);
    }

    public static class DataExtensionConfig {
        @JsonProperty(value="properties")
        public final List<DataExtensionProperty> properties;

        @JsonCreator
        public DataExtensionConfig(@JsonProperty(value="properties") List<DataExtensionProperty> properties) {
            this.properties = properties;
        }

        public static DataExtensionConfig reconstruct(String json) throws IOException {
            return (DataExtensionConfig)ParsingUtilities.mapper.readValue(json, DataExtensionConfig.class);
        }
    }

    public static class DataExtension {
        public final Object[][] data;

        public DataExtension(Object[][] data) {
            this.data = data;
        }
    }

    public static class ColumnInfo {
        @JsonProperty(value="name")
        public final String name;
        @JsonProperty(value="id")
        public final String id;
        public final ReconType expectedType;

        @JsonCreator
        protected ColumnInfo(@JsonProperty(value="name") String name, @JsonProperty(value="id") String id, @JsonProperty(value="type") ReconType expectedType) {
            this.name = name;
            this.id = id;
            this.expectedType = expectedType;
        }
    }

    public static class DataExtensionQuery
    extends DataExtensionConfig {
        @JsonProperty(value="ids")
        public final List<String> ids;

        @JsonCreator
        public DataExtensionQuery(@JsonProperty(value="ids") List<String> ids, @JsonProperty(value="properties") List<DataExtensionProperty> properties) {
            super(properties);
            this.ids = ids;
        }
    }

    public static class DataExtensionProperty {
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="name")
        @JsonView(value={JsonViews.NonSaveMode.class})
        public final String name;
        @JsonProperty(value="settings")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Map<String, Object> settings;

        @JsonCreator
        public DataExtensionProperty(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="settings") Map<String, Object> settings) {
            this.id = id;
            this.name = name;
            this.settings = settings;
        }
    }
}

