/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Properties;

public class RowStarChange
implements Change {
    final int rowIndex;
    final boolean newStarred;
    Boolean oldStarred = null;

    public RowStarChange(int rowIndex, boolean newStarred) {
        this.rowIndex = rowIndex;
        this.newStarred = newStarred;
    }

    @Override
    public void apply(Project project) {
        Row row = project.rows.get(this.rowIndex);
        if (this.oldStarred == null) {
            this.oldStarred = row.starred;
        }
        row.starred = this.newStarred;
    }

    @Override
    public void revert(Project project) {
        Row row = project.rows.get(this.rowIndex);
        row.starred = this.oldStarred;
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("row=");
        writer.write(Integer.toString(this.rowIndex));
        writer.write(10);
        writer.write("newStarred=");
        writer.write(Boolean.toString(this.newStarred));
        writer.write(10);
        writer.write("oldStarred=");
        writer.write(Boolean.toString(this.oldStarred));
        writer.write(10);
        writer.write("/ec/\n");
    }

    public static RowStarChange load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        int row = -1;
        boolean oldStarred = false;
        boolean newStarred = false;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("row".equals(field)) {
                row = Integer.parseInt(value);
                continue;
            }
            if ("oldStarred".equals(field)) {
                oldStarred = Boolean.parseBoolean(value);
                continue;
            }
            if (!"newStarred".equals(field)) continue;
            newStarred = Boolean.parseBoolean(value);
        }
        RowStarChange change = new RowStarChange(row, newStarred);
        change.oldStarred = oldStarred;
        return change;
    }
}

