/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class RowReorderChange
implements Change {
    protected final List<Integer> _rowIndices;

    public RowReorderChange(List<Integer> rowIndices) {
        this._rowIndices = rowIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            List<Row> oldRows = project.rows;
            ArrayList<Row> newRows = new ArrayList<Row>(oldRows.size());
            for (Integer oldIndex : this._rowIndices) {
                newRows.add(oldRows.get(oldIndex));
            }
            project.rows.clear();
            project.rows.addAll(newRows);
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int count = project.rows.size();
            List<Row> newRows = project.rows;
            ArrayList<Row> oldRows = new ArrayList<Row>(count);
            for (int r = 0; r < count; ++r) {
                oldRows.add(null);
            }
            for (int newIndex = 0; newIndex < count; ++newIndex) {
                int oldIndex = this._rowIndices.get(newIndex);
                Row row = newRows.get(newIndex);
                oldRows.set(oldIndex, row);
            }
            project.rows.clear();
            project.rows.addAll(oldRows);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("rowIndexCount=");
        writer.write(Integer.toString(this._rowIndices.size()));
        writer.write(10);
        for (Integer index : this._rowIndices) {
            writer.write(index.toString());
            writer.write(10);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<Integer> rowIndices = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if (!"rowIndexCount".equals(field)) continue;
            int count = Integer.parseInt(line.substring(equal + 1));
            rowIndices = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                line = reader.readLine();
                if (line == null) continue;
                rowIndices.add(Integer.parseInt(line));
            }
        }
        RowReorderChange change = new RowReorderChange(rowIndices);
        return change;
    }
}

