/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class RowRemovalChange
implements Change {
    protected final List<Integer> _rowIndices;
    protected List<Row> _rows;

    public RowRemovalChange(List<Integer> rowIndices) {
        this._rowIndices = rowIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int count = this._rowIndices.size();
            this._rows = new ArrayList<Row>(count);
            int offset = 0;
            for (int i = 0; i < count; ++i) {
                int index = this._rowIndices.get(i);
                Row row = project.rows.remove(index + offset);
                this._rows.add(row);
                --offset;
            }
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            int count = this._rowIndices.size();
            for (int i = 0; i < count; ++i) {
                int index = this._rowIndices.get(i);
                Row row = this._rows.get(i);
                project.rows.add(index, row);
            }
            project.columnModel.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProject(project.id);
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("rowIndexCount=");
        writer.write(Integer.toString(this._rowIndices.size()));
        writer.write(10);
        for (Integer index : this._rowIndices) {
            writer.write(index.toString());
            writer.write(10);
        }
        writer.write("rowCount=");
        writer.write(Integer.toString(this._rows.size()));
        writer.write(10);
        for (Row row : this._rows) {
            row.save(writer, options);
            writer.write(10);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<Integer> rowIndices = null;
        ArrayList<Row> rows = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("rowIndexCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                rowIndices = new ArrayList<Integer>(count);
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    rowIndices.add(Integer.parseInt(line));
                }
                continue;
            }
            if (!"rowCount".equals(field)) continue;
            count = Integer.parseInt(line.substring(equal + 1));
            rows = new ArrayList<Row>(count);
            for (i = 0; i < count; ++i) {
                line = reader.readLine();
                if (line == null) continue;
                rows.add(Row.load(line, pool));
            }
        }
        RowRemovalChange change = new RowRemovalChange(rowIndices);
        change._rows = rows;
        return change;
    }
}

