/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Properties;

public class RowFlagChange
implements Change {
    final int rowIndex;
    final boolean newFlagged;
    Boolean oldFlagged = null;

    public RowFlagChange(int rowIndex, boolean newFlagged) {
        this.rowIndex = rowIndex;
        this.newFlagged = newFlagged;
    }

    @Override
    public void apply(Project project) {
        Row row = project.rows.get(this.rowIndex);
        if (this.oldFlagged == null) {
            this.oldFlagged = row.flagged;
        }
        row.flagged = this.newFlagged;
    }

    @Override
    public void revert(Project project) {
        Row row = project.rows.get(this.rowIndex);
        row.flagged = this.oldFlagged;
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("row=");
        writer.write(Integer.toString(this.rowIndex));
        writer.write(10);
        writer.write("newFlagged=");
        writer.write(Boolean.toString(this.newFlagged));
        writer.write(10);
        writer.write("oldFlagged=");
        writer.write(Boolean.toString(this.oldFlagged));
        writer.write(10);
        writer.write("/ec/\n");
    }

    public static RowFlagChange load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        int row = -1;
        boolean oldFlagged = false;
        boolean newFlagged = false;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("row".equals(field)) {
                row = Integer.parseInt(value);
                continue;
            }
            if ("oldFlagged".equals(field)) {
                oldFlagged = Boolean.parseBoolean(value);
                continue;
            }
            if (!"newFlagged".equals(field)) continue;
            newFlagged = Boolean.parseBoolean(value);
        }
        RowFlagChange change = new RowFlagChange(row, newFlagged);
        change.oldFlagged = oldFlagged;
        return change;
    }
}

