/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.ReconStats;
import com.google.refine.model.changes.CellChange;
import com.google.refine.model.changes.MassCellChange;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

public class ReconChange
extends MassCellChange {
    protected final ReconConfig _newReconConfig;
    protected ReconStats _newReconStats;
    protected ReconConfig _oldReconConfig;
    protected ReconStats _oldReconStats;

    public ReconChange(List<CellChange> cellChanges, String commonColumnName, ReconConfig newReconConfig, ReconStats newReconStats) {
        super(cellChanges, commonColumnName, false);
        this._newReconConfig = newReconConfig;
        this._newReconStats = newReconStats;
    }

    public ReconChange(CellChange[] cellChanges, String commonColumnName, ReconConfig newReconConfig, ReconStats newReconStats) {
        super(cellChanges, commonColumnName, false);
        this._newReconConfig = newReconConfig;
        this._newReconStats = newReconStats;
    }

    public ReconChange(CellChange cellChange, String commonColumnName, ReconConfig newReconConfig, ReconStats newReconStats) {
        super(cellChange, commonColumnName, false);
        this._newReconConfig = newReconConfig;
        this._newReconStats = newReconStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            super.apply(project);
            Column column = project.columnModel.getColumnByName(this._commonColumnName);
            if (this._newReconStats == null) {
                this._newReconStats = ReconStats.create(project, column.getCellIndex());
            }
            this._oldReconConfig = column.getReconConfig();
            this._oldReconStats = column.getReconStats();
            column.setReconConfig(this._newReconConfig);
            column.setReconStats(this._newReconStats);
            column.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._commonColumnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            super.revert(project);
            Column column = project.columnModel.getColumnByName(this._commonColumnName);
            column.setReconConfig(this._oldReconConfig);
            column.setReconStats(this._oldReconStats);
            column.clearPrecomputes();
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._commonColumnName);
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("newReconConfig=");
        if (this._newReconConfig != null) {
            this._newReconConfig.save(writer);
        }
        writer.write(10);
        writer.write("newReconStats=");
        if (this._newReconStats != null) {
            this._newReconStats.save(writer);
        }
        writer.write(10);
        writer.write("oldReconConfig=");
        if (this._oldReconConfig != null) {
            this._oldReconConfig.save(writer);
        }
        writer.write(10);
        writer.write("oldReconStats=");
        if (this._oldReconStats != null) {
            this._oldReconStats.save(writer);
        }
        writer.write(10);
        super.save(writer, options);
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ReconConfig newReconConfig = null;
        ReconStats newReconStats = null;
        ReconConfig oldReconConfig = null;
        ReconStats oldReconStats = null;
        String commonColumnName = null;
        CellChange[] cellChanges = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("newReconConfig".equals(field)) {
                if (value.length() <= 0) continue;
                newReconConfig = ReconConfig.reconstruct(value);
                continue;
            }
            if ("newReconStats".equals(field)) {
                if (value.length() <= 0) continue;
                newReconStats = (ReconStats)ParsingUtilities.mapper.readValue(value, ReconStats.class);
                continue;
            }
            if ("oldReconConfig".equals(field)) {
                if (value.length() <= 0) continue;
                oldReconConfig = ReconConfig.reconstruct(value);
                continue;
            }
            if ("oldReconStats".equals(field)) {
                if (value.length() <= 0) continue;
                oldReconStats = (ReconStats)ParsingUtilities.mapper.readValue(value, ReconStats.class);
                continue;
            }
            if ("commonColumnName".equals(field)) {
                commonColumnName = value;
                continue;
            }
            if (!"cellChangeCount".equals(field)) continue;
            int cellChangeCount = Integer.parseInt(value);
            cellChanges = new CellChange[cellChangeCount];
            for (int i = 0; i < cellChangeCount; ++i) {
                cellChanges[i] = CellChange.load(reader, pool);
            }
        }
        ReconChange change = new ReconChange(cellChanges, commonColumnName, newReconConfig, newReconStats);
        change._oldReconConfig = oldReconConfig;
        change._oldReconStats = oldReconStats;
        return change;
    }
}

