/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.CellChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

public class MassCellChange
implements Change {
    protected final CellChange[] _cellChanges;
    protected final String _commonColumnName;
    protected final boolean _updateRowContextDependencies;

    public MassCellChange(CellChange[] cellChanges, String commonColumnName, boolean updateRowContextDependencies) {
        this._cellChanges = cellChanges;
        this._commonColumnName = commonColumnName;
        this._updateRowContextDependencies = updateRowContextDependencies;
    }

    public MassCellChange(List<CellChange> cellChanges, String commonColumnName, boolean updateRowContextDependencies) {
        this._cellChanges = new CellChange[cellChanges.size()];
        this._commonColumnName = commonColumnName;
        cellChanges.toArray(this._cellChanges);
        this._updateRowContextDependencies = updateRowContextDependencies;
    }

    public MassCellChange(CellChange cellChange, String commonColumnName, boolean updateRowContextDependencies) {
        this._cellChanges = new CellChange[1];
        this._cellChanges[0] = cellChange;
        this._commonColumnName = commonColumnName;
        this._updateRowContextDependencies = updateRowContextDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            List<Row> rows = project.rows;
            for (CellChange cellChange : this._cellChanges) {
                rows.get(cellChange.row).setCell(cellChange.cellIndex, cellChange.newCell);
            }
            if (this._commonColumnName != null) {
                Column column = project.columnModel.getColumnByName(this._commonColumnName);
                column.clearPrecomputes();
                ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._commonColumnName);
            }
            if (this._updateRowContextDependencies) {
                project.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            List<Row> rows = project.rows;
            for (CellChange cellChange : this._cellChanges) {
                rows.get(cellChange.row).setCell(cellChange.cellIndex, cellChange.oldCell);
            }
            if (this._commonColumnName != null) {
                Column column = project.columnModel.getColumnByName(this._commonColumnName);
                column.clearPrecomputes();
                ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._commonColumnName);
            }
            if (this._updateRowContextDependencies) {
                project.update();
            }
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        if (this._commonColumnName != null) {
            writer.write("commonColumnName=");
            writer.write(this._commonColumnName);
            writer.write(10);
        }
        writer.write("updateRowContextDependencies=");
        writer.write(Boolean.toString(this._updateRowContextDependencies));
        writer.write(10);
        writer.write("cellChangeCount=");
        writer.write(Integer.toString(this._cellChanges.length));
        writer.write(10);
        for (CellChange c : this._cellChanges) {
            c.save(writer, options);
        }
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String commonColumnName = null;
        boolean updateRowContextDependencies = false;
        CellChange[] cellChanges = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("commonColumnName".equals(field)) {
                commonColumnName = line.substring(equal + 1);
                continue;
            }
            if ("updateRowContextDependencies".equals(field)) {
                updateRowContextDependencies = Boolean.parseBoolean(line.substring(equal + 1));
                continue;
            }
            if (!"cellChangeCount".equals(field)) continue;
            int cellChangeCount = Integer.parseInt(line.substring(equal + 1));
            cellChanges = new CellChange[cellChangeCount];
            for (int i = 0; i < cellChangeCount; ++i) {
                cellChanges[i] = CellChange.load(reader, pool);
            }
        }
        MassCellChange change = new MassCellChange(cellChanges, commonColumnName, updateRowContextDependencies);
        return change;
    }
}

