/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.history.Change;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.model.changes.CellAtRowCellIndex;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ColumnReorderChange
extends ColumnChange {
    protected final List<String> _columnNames;
    protected List<Column> _oldColumns;
    protected List<Column> _newColumns;
    protected List<Column> _removedColumns;
    protected List<ColumnGroup> _oldColumnGroups;
    protected CellAtRowCellIndex[] _oldCells;

    public ColumnReorderChange(List<String> columnNames) {
        this._columnNames = columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            if (this._newColumns == null) {
                this._newColumns = new ArrayList<Column>();
                this._oldColumns = new ArrayList<Column>(project.columnModel.columns);
                for (String n : this._columnNames) {
                    Column column = project.columnModel.getColumnByName(n);
                    if (column == null) continue;
                    this._newColumns.add(column);
                }
                this._oldColumnGroups = new ArrayList<ColumnGroup>(project.columnModel.columnGroups);
            }
            if (this._removedColumns == null) {
                this._removedColumns = new ArrayList<Column>();
                for (String n : project.columnModel.getColumnNames()) {
                    Column oldColumn = project.columnModel.getColumnByName(n);
                    if (this._newColumns.contains(oldColumn)) continue;
                    this._removedColumns.add(oldColumn);
                }
            }
            if (this._oldCells == null) {
                this._oldCells = new CellAtRowCellIndex[project.rows.size() * this._removedColumns.size()];
                int count = 0;
                for (int i = 0; i < project.rows.size(); ++i) {
                    for (int j = 0; j < this._removedColumns.size(); ++j) {
                        int cellIndex = this._removedColumns.get(j).getCellIndex();
                        Row row = project.rows.get(i);
                        Cell oldCell = null;
                        if (cellIndex < row.cells.size()) {
                            oldCell = row.cells.get(cellIndex);
                        }
                        this._oldCells[count++] = new CellAtRowCellIndex(i, cellIndex, oldCell);
                    }
                }
            }
            for (int i = 0; i < project.rows.size(); ++i) {
                for (int j = 0; j < this._removedColumns.size(); ++j) {
                    int cellIndex = this._removedColumns.get(j).getCellIndex();
                    Row row = project.rows.get(i);
                    row.setCell(cellIndex, null);
                }
            }
            project.columnModel.columns.clear();
            project.columnModel.columns.addAll(this._newColumns);
            project.columnModel.columnGroups.clear();
            project.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            project.columnModel.columns.clear();
            project.columnModel.columns.addAll(this._oldColumns);
            project.columnModel.columnGroups.clear();
            project.columnModel.columnGroups.addAll(this._oldColumnGroups);
            for (int i = 0; i < this._oldCells.length; ++i) {
                Row row = project.rows.get(this._oldCells[i].row);
                row.setCell(this._oldCells[i].cellIndex, this._oldCells[i].cell);
            }
            project.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("columnNameCount=");
        writer.write(Integer.toString(this._columnNames.size()));
        writer.write(10);
        for (String n : this._columnNames) {
            writer.write(n);
            writer.write(10);
        }
        writer.write("oldColumnCount=");
        writer.write(Integer.toString(this._oldColumns.size()));
        writer.write(10);
        for (Column c : this._oldColumns) {
            c.save(writer);
            writer.write(10);
        }
        writer.write("newColumnCount=");
        writer.write(Integer.toString(this._newColumns.size()));
        writer.write(10);
        for (Column c : this._newColumns) {
            c.save(writer);
            writer.write(10);
        }
        writer.write("removedColumnCount=");
        writer.write(Integer.toString(this._removedColumns.size()));
        writer.write(10);
        for (Column c : this._removedColumns) {
            c.save(writer);
            writer.write(10);
        }
        writer.write("oldCellCount=");
        writer.write(Integer.toString(this._oldCells.length));
        writer.write(10);
        for (Iterator<Object> iterator : this._oldCells) {
            ((CellAtRowCellIndex)((Object)iterator)).save(writer, options);
            writer.write(10);
        }
        ColumnReorderChange.writeOldColumnGroups(writer, options, this._oldColumnGroups);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Column> oldColumns = new ArrayList<Column>();
        ArrayList<Column> newColumns = new ArrayList<Column>();
        ArrayList<Column> removedColumns = new ArrayList<Column>();
        CellAtRowCellIndex[] oldCells = new CellAtRowCellIndex[]{};
        List<Object> oldColumnGroups = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            if ("columnNameCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    columnNames.add(line);
                }
                continue;
            }
            if ("oldColumnCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldColumns.add(Column.load(line));
                }
                continue;
            }
            if ("newColumnCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    newColumns.add(Column.load(line));
                }
                continue;
            }
            if ("removedColumnCount".equals(field)) {
                count = Integer.parseInt(line.substring(equal + 1));
                for (i = 0; i < count; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    removedColumns.add(Column.load(line));
                }
                continue;
            }
            if ("oldCellCount".equals(field)) {
                int oldCellCount = Integer.parseInt(line.substring(equal + 1));
                oldCells = new CellAtRowCellIndex[oldCellCount];
                for (i = 0; i < oldCellCount; ++i) {
                    line = reader.readLine();
                    if (line == null) continue;
                    oldCells[i] = CellAtRowCellIndex.load(line, pool);
                }
                continue;
            }
            if (!"oldColumnGroupCount".equals(field)) continue;
            int oldColumnGroupCount = Integer.parseInt(line.substring(equal + 1));
            oldColumnGroups = ColumnReorderChange.readOldColumnGroups(reader, oldColumnGroupCount);
        }
        ColumnReorderChange change = new ColumnReorderChange(columnNames);
        change._oldColumns = oldColumns;
        change._newColumns = newColumns;
        change._removedColumns = removedColumns;
        change._oldCells = oldCells;
        change._oldColumnGroups = oldColumnGroups != null ? oldColumnGroups : new LinkedList();
        return change;
    }
}

