/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model.changes;

import com.google.refine.ProjectManager;
import com.google.refine.history.Change;
import com.google.refine.model.Project;
import com.google.refine.model.changes.ColumnChange;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.Properties;

public class ColumnRenameChange
extends ColumnChange {
    protected final String _oldColumnName;
    protected final String _newColumnName;

    public ColumnRenameChange(String oldColumnName, String newColumnName) {
        this._oldColumnName = oldColumnName;
        this._newColumnName = newColumnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Project project) {
        Project project2 = project;
        synchronized (project2) {
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._oldColumnName);
            project.columnModel.getColumnByName(this._oldColumnName).setName(this._newColumnName);
            project.columnModel.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(Project project) {
        Project project2 = project;
        synchronized (project2) {
            ProjectManager.singleton.getLookupCacheManager().flushLookupsInvolvingProjectColumn(project.id, this._newColumnName);
            project.columnModel.getColumnByName(this._newColumnName).setName(this._oldColumnName);
            project.columnModel.update();
        }
    }

    @Override
    public void save(Writer writer, Properties options) throws IOException {
        writer.write("oldColumnName=");
        writer.write(this._oldColumnName);
        writer.write(10);
        writer.write("newColumnName=");
        writer.write(this._newColumnName);
        writer.write(10);
        writer.write("/ec/\n");
    }

    public static Change load(LineNumberReader reader, Pool pool) throws Exception {
        String line;
        String oldColumnName = null;
        String newColumnName = null;
        while ((line = reader.readLine()) != null && !"/ec/".equals(line)) {
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("oldColumnName".equals(field)) {
                oldColumnName = value;
                continue;
            }
            if (!"newColumnName".equals(field)) continue;
            newColumnName = value;
        }
        ColumnRenameChange change = new ColumnRenameChange(oldColumnName, newColumnName);
        return change;
    }
}

