/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.InjectableValues;
import com.google.common.base.CharMatcher;
import com.google.refine.expr.CellTuple;
import com.google.refine.expr.HasFields;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.Pool;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class Row
implements HasFields {
    public boolean flagged;
    public boolean starred;
    public final List<Cell> cells;
    private static final String FLAGGED = "flagged";
    private static final String STARRED = "starred";

    public Row(int cellCount) {
        this.cells = new ArrayList<Cell>(cellCount);
    }

    protected Row(List<Cell> cells, boolean flagged, boolean starred) {
        this.cells = cells;
        this.flagged = flagged;
        this.starred = starred;
    }

    public Row dup() {
        Row row = new Row(this.cells.size());
        row.flagged = this.flagged;
        row.starred = this.starred;
        row.cells.addAll(this.cells);
        return row;
    }

    public Row deepCopy() {
        Row row = new Row(this.cells.size());
        row.flagged = this.flagged;
        row.starred = this.starred;
        row.cells.addAll(this.cells.stream().map(cell -> cell == null ? null : cell.deepCopy()).collect(Collectors.toList()));
        return row;
    }

    @Override
    public Object getField(String name, Properties bindings) {
        if (FLAGGED.equals(name)) {
            return this.flagged;
        }
        if (STARRED.equals(name)) {
            return this.starred;
        }
        return null;
    }

    @Override
    public boolean fieldAlsoHasFields(String name) {
        return "cells".equals(name) || "record".equals(name);
    }

    @JsonIgnore
    public boolean isEmpty() {
        for (Cell cell : this.cells) {
            if (cell == null || cell.value == null || this.isValueBlank(cell.value)) continue;
            return false;
        }
        return true;
    }

    public Cell getCell(int cellIndex) {
        if (cellIndex >= 0 && cellIndex < this.cells.size()) {
            return this.cells.get(cellIndex);
        }
        return null;
    }

    public Object getCellValue(int cellIndex) {
        Cell cell;
        if (cellIndex >= 0 && cellIndex < this.cells.size() && (cell = this.cells.get(cellIndex)) != null) {
            return cell.value;
        }
        return null;
    }

    public boolean isCellBlank(int cellIndex) {
        return this.isValueBlank(this.getCellValue(cellIndex));
    }

    protected boolean isValueBlank(Object value) {
        return value == null || value instanceof String && CharMatcher.whitespace().trimFrom((CharSequence)((String)value)).length() == 0;
    }

    public void setCell(int cellIndex, Cell cell) {
        if (cellIndex < this.cells.size()) {
            this.cells.set(cellIndex, cell);
        } else {
            while (cellIndex > this.cells.size()) {
                this.cells.add(null);
            }
            this.cells.add(cell);
        }
    }

    public CellTuple getCellTuple(Project project) {
        return new CellTuple(project, this);
    }

    @JsonProperty(value="flagged")
    public boolean isFlagged() {
        return this.flagged;
    }

    @JsonProperty(value="starred")
    public boolean isStarred() {
        return this.starred;
    }

    @JsonProperty(value="cells")
    public List<Cell> getCells() {
        return this.cells;
    }

    public void save(Writer writer, Properties options) {
        if (options.containsKey("rowIndex")) {
            throw new IllegalArgumentException("Serializing with row indices is not supported anymore.");
        }
        try {
            ParsingUtilities.saveWriter.writeValue(writer, (Object)this);
            Pool pool = (Pool)options.get("pool");
            if (pool != null) {
                for (Cell c : this.cells) {
                    if (c == null || c.recon == null) continue;
                    pool.pool(c.recon);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Row load(String s, Pool pool) throws IOException {
        return s.length() == 0 ? null : Row.loadStreaming(s, pool);
    }

    @JsonCreator
    public static Row deserialize(@JsonProperty(value="starred") boolean starred, @JsonProperty(value="flagged") boolean flagged, @JsonProperty(value="cells") List<Cell> cells) {
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        return new Row(cells, flagged, starred);
    }

    public static Row loadStreaming(String s, Pool pool) throws IOException {
        InjectableValues.Std injectableValues = new InjectableValues.Std().addValue("pool", (Object)pool);
        return (Row)ParsingUtilities.mapper.setInjectableValues((InjectableValues)injectableValues).readValue(s, Row.class);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Cell cell : this.cells) {
            result.append(cell == null ? "null" : cell.toString());
            result.append(',');
        }
        return result.toString();
    }
}

