/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Writer;

public class ReconStats {
    @JsonProperty(value="nonBlanks")
    public final int nonBlanks;
    @JsonProperty(value="newTopics")
    public final int newTopics;
    @JsonProperty(value="matchedTopics")
    public final int matchedTopics;
    @JsonProperty(value="errorTopics")
    public final int errorTopics;

    @JsonCreator
    public ReconStats(@JsonProperty(value="nonBlanks") int nonBlanks, @JsonProperty(value="newTopics") int newTopics, @JsonProperty(value="matchedTopics") int matchedTopics, @JsonProperty(value="errorTopics") int errorTopics) {
        this.nonBlanks = nonBlanks;
        this.newTopics = newTopics;
        this.matchedTopics = matchedTopics;
        this.errorTopics = errorTopics;
    }

    public static ReconStats create(Project project, int cellIndex) {
        int nonBlanks = 0;
        int newTopics = 0;
        int matchedTopics = 0;
        int errorTopics = 0;
        for (Row row : project.rows) {
            Cell cell = row.getCell(cellIndex);
            if (cell == null || !ExpressionUtils.isNonBlankData(cell.value)) continue;
            ++nonBlanks;
            if (cell.recon == null) continue;
            if (cell.recon.judgment == Recon.Judgment.New) {
                ++newTopics;
                continue;
            }
            if (cell.recon.judgment == Recon.Judgment.Matched) {
                ++matchedTopics;
                continue;
            }
            if (cell.recon.judgment != Recon.Judgment.Error) continue;
            ++errorTopics;
        }
        return new ReconStats(nonBlanks, newTopics, matchedTopics, errorTopics);
    }

    public void save(Writer writer) {
        try {
            ParsingUtilities.defaultWriter.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

