/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.model.Column;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.ModelException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ColumnModel {
    @JsonProperty(value="columns")
    public final List<Column> columns = new LinkedList<Column>();
    @JsonProperty(value="columnGroups")
    public final List<ColumnGroup> columnGroups = new LinkedList<ColumnGroup>();
    private int _maxCellIndex = -1;
    private int _keyColumnIndex;
    protected transient Map<String, Column> _nameToColumn;
    protected transient Map<Integer, Column> _cellIndexToColumn;
    protected transient List<ColumnGroup> _rootColumnGroups;
    protected transient List<String> _columnNames;

    public ColumnModel() {
        this.internalInitialize();
    }

    public synchronized void setMaxCellIndex(int maxCellIndex) {
        this._maxCellIndex = Math.max(this._maxCellIndex, maxCellIndex);
    }

    @JsonIgnore
    public synchronized int getMaxCellIndex() {
        return this._maxCellIndex;
    }

    public synchronized int allocateNewCellIndex() {
        return ++this._maxCellIndex;
    }

    public synchronized void setKeyColumnIndex(int keyColumnIndex) {
        this._keyColumnIndex = keyColumnIndex;
    }

    @JsonIgnore
    public synchronized int getKeyColumnIndex() {
        return this._keyColumnIndex;
    }

    public synchronized void addColumnGroup(int startColumnIndex, int span, int keyColumnIndex) {
        for (ColumnGroup g : this.columnGroups) {
            if (g.startColumnIndex != startColumnIndex || g.columnSpan != span) continue;
            if (g.keyColumnIndex == keyColumnIndex) {
                return;
            }
            this.columnGroups.remove(g);
            break;
        }
        ColumnGroup cg = new ColumnGroup(startColumnIndex, span, keyColumnIndex);
        this.columnGroups.add(cg);
    }

    public void update() {
        this.internalInitialize();
    }

    public synchronized void addColumn(int index, Column column, boolean avoidNameCollision) throws ModelException {
        String name = column.getName();
        if (this._nameToColumn.containsKey(name)) {
            if (!avoidNameCollision) {
                throw new ModelException("Duplicated column name");
            }
            name = this.getUnduplicatedColumnName(name);
            column.setName(name);
        }
        this.columns.add(index < 0 ? this.columns.size() : index, column);
        this._nameToColumn.put(name, column);
    }

    public synchronized String getUnduplicatedColumnName(String baseName) {
        Object name = baseName;
        int i = 1;
        while (this._nameToColumn.containsKey(name)) {
            name = baseName + ++i;
        }
        return name;
    }

    public synchronized Column getColumnByName(String name) {
        return this._nameToColumn.get(name);
    }

    public synchronized int getColumnIndexByName(String name) {
        for (int i = 0; i < this._columnNames.size(); ++i) {
            String s = this._columnNames.get(i);
            if (!name.equals(s)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Column getColumnByCellIndex(int cellIndex) {
        return this._cellIndexToColumn.get(cellIndex);
    }

    @JsonIgnore
    public synchronized List<String> getColumnNames() {
        return this._columnNames;
    }

    @JsonProperty(value="keyCellIndex")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getJsonKeyCellIndex() {
        if (this.columns.size() > 0) {
            return this.getKeyColumnIndex();
        }
        return null;
    }

    @JsonProperty(value="keyColumnName")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getKeyColumnName() {
        if (this.columns.size() > 0) {
            return this.columns.get(this._keyColumnIndex).getName();
        }
        return null;
    }

    public synchronized void save(Writer writer, Properties options) throws IOException {
        writer.write("maxCellIndex=");
        writer.write(Integer.toString(this._maxCellIndex));
        writer.write(10);
        writer.write("keyColumnIndex=");
        writer.write(Integer.toString(this._keyColumnIndex));
        writer.write(10);
        writer.write("columnCount=");
        writer.write(Integer.toString(this.columns.size()));
        writer.write(10);
        for (Column column : this.columns) {
            column.save(writer);
            writer.write(10);
        }
        writer.write("columnGroupCount=");
        writer.write(Integer.toString(this.columnGroups.size()));
        writer.write(10);
        for (ColumnGroup group : this.columnGroups) {
            group.save(writer);
            writer.write(10);
        }
        writer.write("/e/\n");
    }

    public synchronized void load(LineNumberReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !"/e/".equals(line)) {
            int i;
            int count;
            int equal = line.indexOf(61);
            CharSequence field = line.subSequence(0, equal);
            String value = line.substring(equal + 1);
            if ("maxCellIndex".equals(field)) {
                this._maxCellIndex = Integer.parseInt(value);
                continue;
            }
            if ("keyColumnIndex".equals(field)) {
                this._keyColumnIndex = Integer.parseInt(value);
                continue;
            }
            if ("columnCount".equals(field)) {
                count = Integer.parseInt(value);
                for (i = 0; i < count; ++i) {
                    this.columns.add(Column.load(reader.readLine()));
                }
                continue;
            }
            if (!"columnGroupCount".equals(field)) continue;
            count = Integer.parseInt(value);
            for (i = 0; i < count; ++i) {
                this.columnGroups.add(ColumnGroup.load(reader.readLine()));
            }
        }
        this.internalInitialize();
    }

    protected synchronized void internalInitialize() {
        int i;
        this.generateMaps();
        this._rootColumnGroups = new LinkedList<ColumnGroup>(this.columnGroups);
        Collections.sort(this._rootColumnGroups, new Comparator<ColumnGroup>(){

            @Override
            public int compare(ColumnGroup o1, ColumnGroup o2) {
                int firstDiff = o1.startColumnIndex - o2.startColumnIndex;
                return firstDiff != 0 ? firstDiff : o2.columnSpan - o1.columnSpan;
            }
        });
        for (i = this._rootColumnGroups.size() - 1; i >= 0; --i) {
            ColumnGroup g = this._rootColumnGroups.get(i);
            for (int j = i + 1; j < this._rootColumnGroups.size(); ++j) {
                ColumnGroup g2 = this._rootColumnGroups.get(j);
                if (g2.parentGroup != null || !g.contains(g2)) continue;
                g2.parentGroup = g;
                g.subgroups.add(g2);
            }
        }
        for (i = this._rootColumnGroups.size() - 1; i >= 0; --i) {
            if (this._rootColumnGroups.get((int)i).parentGroup == null) continue;
            this._rootColumnGroups.remove(i);
        }
    }

    protected void generateMaps() {
        this._nameToColumn = new HashMap<String, Column>();
        this._cellIndexToColumn = new HashMap<Integer, Column>();
        this._columnNames = new ArrayList<String>();
        int maxCellIndex = -1;
        for (Column column : this.columns) {
            this._nameToColumn.put(column.getName(), column);
            int cidx = column.getCellIndex();
            if (cidx > maxCellIndex) {
                maxCellIndex = cidx;
            }
            this._cellIndexToColumn.put(cidx, column);
            this._columnNames.add(column.getName());
        }
        this._maxCellIndex = maxCellIndex;
    }

    public void clearPrecomputes() {
        for (Column column : this.columns) {
            column.clearPrecomputes();
        }
    }

    public void removeColumnByCellIndex(int index) {
        Column column = this.getColumnByCellIndex(index);
        this.columns.remove(column);
    }
}

