/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.refine.util.JsonViews;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class ColumnGroup {
    public final int startColumnIndex;
    public final int columnSpan;
    public final int keyColumnIndex;
    public transient ColumnGroup parentGroup;
    public transient List<ColumnGroup> subgroups;

    @JsonCreator
    public ColumnGroup(@JsonProperty(value="startColumnIndex") int startColumnIndex, @JsonProperty(value="columnSpan") int columnSpan, @JsonProperty(value="keyColumnIndex") int keyColumnIndex) {
        this.startColumnIndex = startColumnIndex;
        this.columnSpan = columnSpan;
        this.keyColumnIndex = keyColumnIndex;
        this.internalInitialize();
    }

    @JsonProperty(value="startColumnIndex")
    public int getStartColumnIndex() {
        return this.startColumnIndex;
    }

    @JsonProperty(value="columnSpan")
    public int getColumnSpan() {
        return this.columnSpan;
    }

    @JsonProperty(value="keyColumnIndex")
    public int getKeyColumnIndex() {
        return this.keyColumnIndex;
    }

    @JsonProperty(value="subgroups")
    @JsonView(value={JsonViews.NonSaveMode.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ColumnGroup> getSubGroups() {
        return this.subgroups;
    }

    public boolean contains(ColumnGroup g) {
        return g.startColumnIndex >= this.startColumnIndex && g.startColumnIndex < this.startColumnIndex + this.columnSpan;
    }

    public void save(Writer writer) {
        try {
            ParsingUtilities.defaultWriter.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ColumnGroup load(String s) throws IOException {
        return (ColumnGroup)ParsingUtilities.mapper.readValue(s, ColumnGroup.class);
    }

    protected void internalInitialize() {
        this.subgroups = new LinkedList<ColumnGroup>();
    }

    public String toString() {
        return String.format("%d:%d:k=%d", this.startColumnIndex, this.columnSpan, this.keyColumnIndex);
    }
}

