/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.model.ReconStats;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Column {
    private final int _cellIndex;
    private final String _originalName;
    private String _name;
    private ReconConfig _reconConfig;
    private ReconStats _reconStats;
    protected transient Map<String, Object> _precomputes;
    private ReconConfig _sourceReconConfig;

    @JsonCreator
    public Column(@JsonProperty(value="cellIndex") int cellIndex, @JsonProperty(value="originalName") String originalName) {
        this._cellIndex = cellIndex;
        this._originalName = this._name = originalName;
    }

    @JsonProperty(value="cellIndex")
    public int getCellIndex() {
        return this._cellIndex;
    }

    @JsonProperty(value="originalName")
    public String getOriginalHeaderLabel() {
        return this._originalName;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this._name = name;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this._name;
    }

    @JsonProperty(value="reconConfig")
    public void setReconConfig(ReconConfig config) {
        this._reconConfig = config;
    }

    @JsonProperty(value="reconConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReconConfig getReconConfig() {
        return this._reconConfig;
    }

    @JsonProperty(value="sourceReconConfig")
    public void setSourceReconConfig(ReconConfig sourceConfig) {
        this._sourceReconConfig = sourceConfig;
    }

    @JsonProperty(value="sourceReconConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReconConfig getSourceReconConfig() {
        return this._sourceReconConfig;
    }

    @JsonProperty(value="reconStats")
    public void setReconStats(ReconStats stats) {
        this._reconStats = stats;
    }

    @JsonProperty(value="reconStats")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ReconStats getReconStats() {
        return this._reconStats;
    }

    public void clearPrecomputes() {
        if (this._precomputes != null) {
            this._precomputes.clear();
        }
    }

    public Object getPrecompute(String key) {
        if (this._precomputes != null) {
            return this._precomputes.get(key);
        }
        return null;
    }

    public void setPrecompute(String key, Object value) {
        if (this._precomputes == null) {
            this._precomputes = new HashMap<String, Object>();
        }
        this._precomputes.put(key, value);
    }

    public void save(Writer writer) {
        try {
            ParsingUtilities.defaultWriter.writeValue(writer, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Column load(String s) throws IOException {
        return (Column)ParsingUtilities.mapper.readValue(s, Column.class);
    }

    public String toString() {
        return this._name;
    }
}

