/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Project;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.OperationResolver;
import com.google.refine.process.Process;
import com.google.refine.process.QuickHistoryEntryProcess;
import java.util.Properties;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="op", visible=true)
@JsonTypeIdResolver(value=OperationResolver.class)
public abstract class AbstractOperation {
    public void validate() throws IllegalArgumentException {
    }

    public Process createProcess(Project project, Properties options) throws Exception {
        return new QuickHistoryEntryProcess(project, this.getBriefDescription(null)){

            @Override
            protected HistoryEntry createHistoryEntry(long historyEntryID) throws Exception {
                return AbstractOperation.this.createHistoryEntry(this._project, historyEntryID);
            }
        };
    }

    protected HistoryEntry createHistoryEntry(Project project, long historyEntryID) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected String getBriefDescription(Project project) {
        throw new UnsupportedOperationException();
    }

    @JsonIgnore
    public String getOperationId() {
        return OperationRegistry.s_opClassToName.get(this.getClass());
    }

    @JsonProperty(value="description")
    public String getJsonDescription() {
        return this.getBriefDescription(null);
    }
}

