/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.google.refine.ProjectManager;
import com.google.refine.io.FileProjectManager;
import com.google.refine.model.Project;
import com.google.refine.util.Pool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUtilities {
    static final Logger logger = LoggerFactory.getLogger((String)"project_utilities");
    public static final String DATA_ZIP = "data.zip";
    public static final String DATA_TEMP_ZIP = "data.temp.zip";
    public static final String DATA_OLD_ZIP = "data.old.zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void save(Project project) throws IOException {
        Project project2 = project;
        synchronized (project2) {
            long id = project.id;
            File dir = ((FileProjectManager)ProjectManager.singleton).getProjectDir(id);
            File tempFile = new File(dir, DATA_TEMP_ZIP);
            try {
                ProjectUtilities.saveToFile(project, tempFile);
            }
            catch (IOException e) {
                logger.warn("Failed to save project {}", (Object)id, (Object)e);
                try {
                    tempFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            File file = new File(dir, DATA_ZIP);
            File oldFile = new File(dir, DATA_OLD_ZIP);
            if (file.exists()) {
                file.renameTo(oldFile);
            }
            tempFile.renameTo(file);
            if (oldFile.exists()) {
                oldFile.delete();
            }
            project.setLastSave();
            logger.info("Saved project '{}'", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveToFile(Project project, File file) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            Pool pool = new Pool();
            out.putNextEntry(new ZipEntry("data.txt"));
            try {
                project.saveToOutputStream(out, pool);
            }
            finally {
                out.closeEntry();
            }
            out.putNextEntry(new ZipEntry("pool.txt"));
            try {
                pool.save(out);
            }
            finally {
                out.closeEntry();
            }
        }
    }

    public static Project load(File dir, long id) {
        for (String filename : new String[]{DATA_ZIP, DATA_TEMP_ZIP, DATA_OLD_ZIP}) {
            try {
                File file = new File(dir, filename);
                if (!file.exists()) continue;
                return ProjectUtilities.loadFromFile(file, id);
            }
            catch (IOException e) {
                logger.warn("Failed to load from data file {} / {}", new Object[]{dir, filename, e});
            }
        }
        logger.error("All data files and backup data files failed to load");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Project loadFromFile(File file, long id) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Pool pool = new Pool();
            ZipEntry poolEntry = zipFile.getEntry("pool.txt");
            if (poolEntry != null) {
                pool.load(zipFile.getInputStream(poolEntry));
            }
            Project project = Project.loadFromInputStream(zipFile.getInputStream(zipFile.getEntry("data.txt")), id, pool);
            return project;
        }
    }
}

