/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.history.HistoryEntryManager;
import com.google.refine.io.FileHistoryEntryManager;
import com.google.refine.io.ProjectMetadataUtilities;
import com.google.refine.io.ProjectUtilities;
import com.google.refine.model.Project;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.preference.TopList;
import com.google.refine.util.LocaleUtils;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProjectManager
extends ProjectManager {
    protected static final String PROJECT_DIR_SUFFIX = ".project";
    public static final String WORKSPACE_JSON = "workspace.json";
    public static final String WORKSPACE_OLD_JSON = "workspace.old.json";
    public static final String WORKSPACE_TEMP_JSON = "workspace.temp.json";
    protected File _workspaceDir;
    protected static boolean projectRemoved = false;
    static final Logger logger = LoggerFactory.getLogger((String)"FileProjectManager");

    public static synchronized void initialize(File dir) {
        if (singleton != null) {
            logger.warn("Overwriting singleton already set: " + String.valueOf(singleton));
        }
        logger.info("Using workspace directory: {}", (Object)dir.getAbsolutePath());
        singleton = new FileProjectManager(dir);
        ((FileProjectManager)singleton).recover();
    }

    protected FileProjectManager(File dir) {
        this._workspaceDir = dir;
        if (!this._workspaceDir.exists() && !this._workspaceDir.mkdirs()) {
            logger.error("Failed to create directory : " + String.valueOf(this._workspaceDir));
            return;
        }
        this.load();
    }

    @JsonIgnore
    public File getWorkspaceDir() {
        return this._workspaceDir;
    }

    public static File getProjectDir(File workspaceDir, long projectID) {
        return FileProjectManager.getProjectDir(workspaceDir, projectID, true);
    }

    public static File getProjectDir(File workspaceDir, long projectID, boolean createIfMissing) {
        File dir = new File(workspaceDir, projectID + PROJECT_DIR_SUFFIX);
        if (!dir.exists()) {
            if (createIfMissing) {
                logger.warn("(Re)creating missing project directory - {}", (Object)dir.getAbsolutePath());
                dir.mkdir();
            } else {
                logger.error("Missing project directory {}", (Object)dir.getAbsolutePath());
                return null;
            }
        }
        return dir;
    }

    @JsonIgnore
    public File getProjectDir(long projectID) {
        return this.getProjectDir(projectID, true);
    }

    @JsonIgnore
    public File getProjectDir(long projectID, boolean createIfMissing) {
        return FileProjectManager.getProjectDir(this._workspaceDir, projectID, createIfMissing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadProjectMetadata(long projectID) {
        FileProjectManager fileProjectManager = this;
        synchronized (fileProjectManager) {
            ProjectMetadata metadata = ProjectMetadataUtilities.load(this.getProjectDir(projectID));
            if (metadata == null) {
                metadata = ProjectMetadataUtilities.recover(this.getProjectDir(projectID), projectID);
            }
            if (metadata != null) {
                this._projectsMetadata.put(projectID, metadata);
                this.addProjectTags(metadata.getTags());
                return true;
            }
            return false;
        }
    }

    @Override
    public void importProject(long projectID, InputStream inputStream, boolean gziped) throws IOException {
        File destDir = this.getProjectDir(projectID);
        destDir.mkdirs();
        if (gziped) {
            GZIPInputStream gis = new GZIPInputStream(inputStream);
            this.untar(destDir, gis);
        } else {
            this.untar(destDir, inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void untar(File destDir, InputStream inputStream) throws IOException {
        TarArchiveInputStream tin = new TarArchiveInputStream(inputStream);
        TarArchiveEntry tarEntry = null;
        while ((tarEntry = tin.getNextTarEntry()) != null) {
            File destEntry = new File(destDir, tarEntry.getName());
            if (!destEntry.toPath().normalize().startsWith(destDir.toPath().normalize())) {
                throw new IllegalArgumentException("Zip archives with files escaping their root directory are not allowed.");
            }
            File parent = destEntry.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (tarEntry.isDirectory()) {
                destEntry.mkdirs();
                continue;
            }
            try (FileOutputStream fout = new FileOutputStream(destEntry);){
                tin.transferTo((OutputStream)fout);
            }
        }
        tin.close();
    }

    @Override
    public void exportProject(long projectId, TarArchiveOutputStream tos) throws IOException {
        File dir = this.getProjectDir(projectId);
        this.tarDir("", dir, tos);
    }

    protected void tarDir(String relative, File dir, TarArchiveOutputStream tos) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null || file.isHidden()) continue;
            String path = relative + file.getName();
            if (file.isDirectory()) {
                this.tarDir(path + File.separator, file, tos);
                continue;
            }
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setMode(33188);
            entry.setSize(file.length());
            entry.setModTime(file.lastModified());
            tos.putArchiveEntry(entry);
            this.copyFile(file, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="3.9")
    protected void copyFile(File file, OutputStream os) throws IOException {
        int buffersize = 4096;
        try (FileInputStream fis = new FileInputStream(file);){
            int count;
            byte[] buf = new byte[4096];
            while ((count = fis.read(buf, 0, 4096)) != -1) {
                os.write(buf, 0, count);
            }
        }
    }

    @Override
    public void saveMetadata(ProjectMetadata metadata, long projectId) throws Exception {
        File projectDir = this.getProjectDir(projectId);
        ProjectMetadataUtilities.save(metadata, projectDir);
    }

    @Override
    protected void saveProject(Project project) throws IOException {
        ProjectUtilities.save(project);
    }

    @Override
    public Project loadProject(long id) {
        return ProjectUtilities.load(this.getProjectDir(id), id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveWorkspace() {
        FileProjectManager fileProjectManager = this;
        synchronized (fileProjectManager) {
            boolean saveNeeded;
            List<Long> modified = this.getModifiedProjectIds();
            boolean bl = saveNeeded = modified.size() > 0 || this._preferenceStore.isDirty() || projectRemoved;
            if (!saveNeeded) {
                logger.debug("Skipping unnecessary workspace save");
                return;
            }
            File tempFile = this.saveWorkspaceToTempFile();
            if (tempFile == null) {
                return;
            }
            File file = new File(this._workspaceDir, WORKSPACE_JSON);
            File oldFile = new File(this._workspaceDir, WORKSPACE_OLD_JSON);
            if (oldFile.exists() && !oldFile.delete()) {
                logger.warn("Failed to delete previous backup {}", (Object)oldFile.getAbsolutePath());
            }
            if (file.exists() && !file.renameTo(oldFile)) {
                logger.error("Failed to rename {} to {}", (Object)file.getAbsolutePath(), (Object)oldFile.getAbsolutePath());
            }
            if (!tempFile.renameTo(file)) {
                logger.error("Failed to rename new temp workspace file to {}", (Object)file.getAbsolutePath());
            }
            projectRemoved = false;
            logger.info("Saved workspace");
        }
    }

    private File saveWorkspaceToTempFile() {
        File tempFile = new File(this._workspaceDir, WORKSPACE_TEMP_JSON);
        try {
            this.saveToFile(tempFile);
        }
        catch (IOException e) {
            logger.warn("Failed to save workspace", (Throwable)e);
            return null;
        }
        tempFile.setReadable(false, false);
        tempFile.setReadable(true, true);
        return tempFile;
    }

    protected List<Long> getModifiedProjectIds() {
        List<Long> modified = this._projectsMetadata.entrySet().stream().filter(e -> {
            ProjectMetadata metadata = (ProjectMetadata)e.getValue();
            if (metadata == null) {
                logger.error("Missing metadata for project ID {}", e.getKey());
                return false;
            }
            return metadata.isDirty();
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        return modified;
    }

    protected void saveProjectMetadata(List<Long> modified) throws IOException {
        for (Long id : modified) {
            ProjectMetadata metadata = (ProjectMetadata)this._projectsMetadata.get(id);
            if (metadata != null) {
                ProjectMetadataUtilities.save(metadata, this.getProjectDir(id));
                continue;
            }
            logger.error("Missing metadata on save for project ID {}", (Object)id);
        }
    }

    protected void saveToFile(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            ParsingUtilities.defaultWriter.writeValue((OutputStream)stream, (Object)this);
            this.saveProjectMetadata(this.getModifiedProjectIds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProject(long projectID) {
        FileProjectManager fileProjectManager = this;
        synchronized (fileProjectManager) {
            String[] tags;
            ProjectMetadata metadata = this.getProjectMetadata(projectID);
            if (metadata != null && (tags = metadata.getTags()) != null) {
                this.removeProjectTags(tags);
            }
            this.removeProject(projectID);
            File dir = this.getProjectDir(projectID);
            if (dir.exists()) {
                FileProjectManager.deleteDir(dir);
            }
        }
        projectRemoved = true;
        this.saveWorkspace();
    }

    protected static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                FileProjectManager.deleteDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected void load() {
        for (String filename : new String[]{WORKSPACE_JSON, WORKSPACE_TEMP_JSON, WORKSPACE_OLD_JSON}) {
            if (!this.loadFromFile(new File(this._workspaceDir, filename))) continue;
            return;
        }
        logger.error("Failed to load workspace from any attempted alternatives.");
    }

    protected boolean loadFromFile(File file) {
        logger.info("Loading workspace: {}", (Object)file.getAbsolutePath());
        this._projectsMetadata.clear();
        if (file.exists() || file.canRead()) {
            try {
                ParsingUtilities.mapper.readerForUpdating((Object)this).readValue(file);
                LocaleUtils.setLocale((String)this.getPreferenceStore().get("userLang"));
                return true;
            }
            catch (IOException e) {
                logger.warn("Failed to load workspace", (Throwable)e);
            }
        }
        return false;
    }

    protected void recover() {
        boolean recovered = false;
        File[] files = this._workspaceDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file == null || !file.isDirectory() || file.isHidden()) continue;
            String dirName = file.getName();
            if (!file.getName().endsWith(PROJECT_DIR_SUFFIX)) continue;
            String idString = dirName.substring(0, dirName.length() - PROJECT_DIR_SUFFIX.length());
            long id = -1L;
            try {
                id = Long.parseLong(idString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id <= 0L || this._projectsMetadata.containsKey(id)) continue;
            if (this.loadProjectMetadata(id)) {
                logger.info("Recovered project named {} in directory {}", (Object)this.getProjectMetadata(id).getName(), (Object)dirName);
                recovered = true;
                continue;
            }
            logger.warn("Failed to recover project in directory {}", (Object)dirName);
            file.renameTo(new File(file.getParentFile(), dirName + ".corrupted"));
        }
        if (recovered) {
            this.saveWorkspace();
        }
    }

    @Override
    public HistoryEntryManager getHistoryEntryManager() {
        return new FileHistoryEntryManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gzipTarToOutputStream(Project project, OutputStream os) throws IOException {
        GZIPOutputStream gos = new GZIPOutputStream(os);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)gos);
        try {
            ProjectManager.singleton.exportProject(project.id, tos);
        }
        finally {
            tos.close();
            gos.close();
        }
    }

    @JsonProperty(value="projectIDs")
    public Set<Long> getProjectIds() {
        return this._projectsMetadata.keySet();
    }

    @JsonProperty(value="projectIDs")
    protected void loadProjects(List<Long> projectIDs) {
        for (Long id : projectIDs) {
            File projectDir = this.getProjectDir(id, false);
            if (projectDir == null) {
                logger.error("Missing project directory for project {}", (Object)id);
                continue;
            }
            ProjectMetadata metadata = ProjectMetadataUtilities.load(projectDir);
            this.mergeEmptyUserMetadata(metadata);
            this._projectsMetadata.put(id, metadata);
            if (metadata == null) continue;
            this.addProjectTags(metadata.getTags());
        }
    }

    @JsonProperty(value="preferences")
    protected void setPreferences(PreferenceStore preferences) {
        if (preferences != null) {
            this._preferenceStore = preferences;
        }
    }

    @JsonProperty(value="expressions")
    protected void setExpressions(TopList newExpressions) {
        if (newExpressions != null) {
            this._preferenceStore.put("scripting.expressions", newExpressions);
        }
    }
}

