/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.importing.EncodingGuesser;
import com.google.refine.importing.FormatGuesser;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.importing.UrlRewriter;
import com.google.refine.model.Project;
import com.google.refine.util.HttpClient;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.FilenameUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportingUtilities {
    protected static final Logger logger = LoggerFactory.getLogger((String)"importing-utilities");
    public static final List<String> allowedProtocols = Arrays.asList("http", "https", "ftp", "sftp");

    @Deprecated
    public static void loadDataAndPrepareJob(HttpServletRequest request, HttpServletResponse response, Properties parameters, ImportingJob job, ObjectNode config) throws IOException, ServletException {
        Map<String, String> parametersMap = ImportingUtilities.propsToMap(parameters);
        ImportingUtilities.loadDataAndPrepareJob(request, response, parametersMap, job, config);
    }

    private static Map<String, String> propsToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
    }

    public static void loadDataAndPrepareJob(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters, final ImportingJob job, ObjectNode config) throws IOException, ServletException {
        ObjectNode retrievalRecord = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut(config, "retrievalRecord", (JsonNode)retrievalRecord);
        JSONUtilities.safePut(config, "state", "loading-raw-data");
        final ObjectNode progress = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut(config, "progress", (JsonNode)progress);
        try {
            ImportingUtilities.retrieveContentFromPostRequest(request, parameters, job.getRawDataDir(), retrievalRecord, new Progress(){

                @Override
                public void setProgress(String message, int percent) {
                    if (message != null) {
                        JSONUtilities.safePut(progress, "message", message);
                    }
                    JSONUtilities.safePut(progress, "percent", percent);
                }

                @Override
                public boolean isCanceled() {
                    return job.canceled;
                }
            });
        }
        catch (Exception e) {
            JSONUtilities.safePut(config, "state", "error");
            JSONUtilities.safePut(config, "error", "Error uploading data");
            JSONUtilities.safePut(config, "errorDetails", String.valueOf(e.getCause()));
            throw new IOException(e);
        }
        ArrayNode fileSelectionIndexes = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.safePut(config, "fileSelection", (JsonNode)fileSelectionIndexes);
        EncodingGuesser.guess(job);
        String bestFormat = ImportingUtilities.autoSelectFiles(job, retrievalRecord, fileSelectionIndexes);
        bestFormat = ImportingUtilities.guessBetterFormat(job, bestFormat);
        ArrayNode rankedFormats = ParsingUtilities.mapper.createArrayNode();
        ImportingUtilities.rankFormats(job, bestFormat, rankedFormats);
        JSONUtilities.safePut(config, "rankedFormats", (JsonNode)rankedFormats);
        JSONUtilities.safePut(config, "state", "ready");
        JSONUtilities.safePut(config, "hasData", true);
        config.remove("progress");
    }

    public static void updateJobWithNewFileSelection(ImportingJob job, ArrayNode fileSelectionArray) {
        job.setFileSelection(fileSelectionArray);
        String bestFormat = ImportingUtilities.getCommonFormatForSelectedFiles(job, fileSelectionArray);
        bestFormat = ImportingUtilities.guessBetterFormat(job, bestFormat);
        ArrayNode rankedFormats = ParsingUtilities.mapper.createArrayNode();
        ImportingUtilities.rankFormats(job, bestFormat, rankedFormats);
        job.setRankedFormats(rankedFormats);
    }

    @Deprecated
    public static void retrieveContentFromPostRequest(HttpServletRequest request, Properties parameters, File rawDataDir, ObjectNode retrievalRecord, Progress progress) throws IOException, FileUploadException {
        Map<String, String> parametersMap = ImportingUtilities.propsToMap(parameters);
        ImportingUtilities.retrieveContentFromPostRequest(request, parametersMap, rawDataDir, retrievalRecord, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retrieveContentFromPostRequest(HttpServletRequest request, Map<String, String> parameters, final File rawDataDir, ObjectNode retrievalRecord, final Progress progress) throws IOException, FileUploadException {
        final ArrayNode fileRecords = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.safePut(retrievalRecord, "files", (JsonNode)fileRecords);
        int clipboardCount = 0;
        int uploadCount = 0;
        int downloadCount = 0;
        int archiveCount = 0;
        final SavingUpdate update = new SavingUpdate(){

            @Override
            public void savedMore() {
                progress.setProgress(null, ImportingUtilities.calculateProgressPercent(this.totalExpectedSize, this.totalRetrievedSize));
            }

            @Override
            public boolean isCanceled() {
                return progress.isCanceled();
            }
        };
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        upload.setProgressListener(new ProgressListener(){
            boolean setContentLength = false;
            long lastBytesRead = 0L;

            public void update(long bytesRead, long contentLength, int itemCount) {
                if (!this.setContentLength && contentLength >= 0L) {
                    update.totalExpectedSize += contentLength;
                    this.setContentLength = true;
                }
                if (this.setContentLength) {
                    update.totalRetrievedSize += bytesRead - this.lastBytesRead;
                    this.lastBytesRead = bytesRead;
                    update.savedMore();
                }
            }
        });
        List tempFiles = upload.parseRequest(request);
        progress.setProgress("Uploading data ...", -1);
        block3: for (FileItem fileItem : tempFiles) {
            if (progress.isCanceled()) break;
            InputStream stream = fileItem.getInputStream();
            String name = fileItem.getFieldName().toLowerCase();
            if (fileItem.isFormField()) {
                ObjectNode fileRecord;
                if (name.equals("clipboard")) {
                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                    File file = ImportingUtilities.allocateFile(rawDataDir, "clipboard.txt");
                    fileRecord = ParsingUtilities.mapper.createObjectNode();
                    JSONUtilities.safePut(fileRecord, "origin", "clipboard");
                    JSONUtilities.safePut(fileRecord, "declaredEncoding", encoding);
                    JSONUtilities.safePut(fileRecord, "declaredMimeType", (String)null);
                    JSONUtilities.safePut(fileRecord, "fileName", "(clipboard)");
                    JSONUtilities.safePut(fileRecord, "location", ImportingUtilities.getRelativePath(file, rawDataDir));
                    progress.setProgress("Uploading pasted clipboard text", ImportingUtilities.calculateProgressPercent(update.totalExpectedSize, update.totalRetrievedSize));
                    JSONUtilities.safePut(fileRecord, "size", ImportingUtilities.saveStreamToFile(stream, file, null));
                    JSONUtilities.safePut(fileRecord, "format", ImportingUtilities.guessBetterFormat(file, fileRecord));
                    JSONUtilities.append(fileRecords, fileRecord);
                    ++clipboardCount;
                } else if (name.equals("download")) {
                    String urlString = Streams.asString((InputStream)stream).trim();
                    URL url = new URL(urlString);
                    if (!allowedProtocols.contains(url.getProtocol().toLowerCase())) {
                        throw new IOException("Unsupported protocol: " + url.getProtocol());
                    }
                    fileRecord = ParsingUtilities.mapper.createObjectNode();
                    JSONUtilities.safePut(fileRecord, "origin", "download");
                    JSONUtilities.safePut(fileRecord, "url", urlString);
                    for (UrlRewriter rewriter : ImportingManager.urlRewriters) {
                        UrlRewriter.Result result = rewriter.rewrite(urlString);
                        if (result == null) continue;
                        urlString = result.rewrittenUrl;
                        url = new URL(urlString);
                        JSONUtilities.safePut(fileRecord, "url", urlString);
                        JSONUtilities.safePut(fileRecord, "format", result.format);
                        if (result.download) continue;
                        ++downloadCount;
                        JSONUtilities.append(fileRecords, fileRecord);
                        continue block3;
                    }
                    if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                        HttpClient httpClient = new HttpClient();
                        final URL lastUrl = url;
                        HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

                            public String handleResponse(ClassicHttpResponse response) throws IOException {
                                int status = response.getCode();
                                if (status >= 200 && status < 300) {
                                    HttpEntity entity = response.getEntity();
                                    if (entity == null) {
                                        throw new IOException("No content found in " + lastUrl.toExternalForm());
                                    }
                                    try {
                                        InputStream stream2 = entity.getContent();
                                        String mimeType = null;
                                        String charset = null;
                                        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
                                        if (contentType != null) {
                                            mimeType = contentType.getMimeType();
                                            Charset cs = contentType.getCharset();
                                            if (cs != null) {
                                                charset = cs.toString();
                                            }
                                        }
                                        JSONUtilities.safePut(fileRecord, "declaredMimeType", mimeType);
                                        JSONUtilities.safePut(fileRecord, "declaredEncoding", charset);
                                        if (ImportingUtilities.saveStream(stream2, lastUrl, rawDataDir, progress, update, fileRecord, fileRecords, entity.getContentLength())) {
                                            return "saved";
                                        }
                                    }
                                    catch (IOException ex) {
                                        throw new ClientProtocolException((Throwable)ex);
                                    }
                                    return null;
                                }
                                throw new ClientProtocolException(String.format("HTTP error %d : %s for URL %s", status, response.getReasonPhrase(), lastUrl.toExternalForm()));
                            }
                        };
                        if (httpClient.getResponse(urlString, null, responseHandler) != null) {
                            ++archiveCount;
                        }
                        ++downloadCount;
                    } else {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setConnectTimeout(5000);
                        urlConnection.connect();
                        InputStream stream2 = urlConnection.getInputStream();
                        JSONUtilities.safePut(fileRecord, "declaredEncoding", urlConnection.getContentEncoding());
                        JSONUtilities.safePut(fileRecord, "declaredMimeType", urlConnection.getContentType());
                        try {
                            if (ImportingUtilities.saveStream(stream2, url, rawDataDir, progress, update, fileRecord, fileRecords, urlConnection.getContentLength())) {
                                ++archiveCount;
                            }
                            ++downloadCount;
                        }
                        finally {
                            stream2.close();
                        }
                    }
                } else {
                    String value = Streams.asString((InputStream)stream);
                    parameters.put(name, value);
                }
            } else {
                String fileName = fileItem.getName();
                if (fileName.length() > 0) {
                    long fileSize = fileItem.getSize();
                    File file = ImportingUtilities.allocateFile(rawDataDir, fileName);
                    ObjectNode fileRecord = ParsingUtilities.mapper.createObjectNode();
                    JSONUtilities.safePut(fileRecord, "origin", "upload");
                    JSONUtilities.safePut(fileRecord, "declaredEncoding", request.getCharacterEncoding());
                    JSONUtilities.safePut(fileRecord, "declaredMimeType", fileItem.getContentType());
                    JSONUtilities.safePut(fileRecord, "fileName", fileName);
                    JSONUtilities.safePut(fileRecord, "location", ImportingUtilities.getRelativePath(file, rawDataDir));
                    progress.setProgress("Saving file " + fileName + " locally (" + ImportingUtilities.formatBytes(fileSize) + " bytes)", ImportingUtilities.calculateProgressPercent(update.totalExpectedSize, update.totalRetrievedSize));
                    JSONUtilities.safePut(fileRecord, "size", ImportingUtilities.saveStreamToFile(stream, file, null));
                    if (ImportingUtilities.postProcessRetrievedFile(rawDataDir, file, fileRecord, fileRecords, progress)) {
                        ++archiveCount;
                    }
                    ++uploadCount;
                }
            }
            stream.close();
        }
        for (FileItem fileItem : tempFiles) {
            fileItem.delete();
        }
        JSONUtilities.safePut(retrievalRecord, "uploadCount", uploadCount);
        JSONUtilities.safePut(retrievalRecord, "downloadCount", downloadCount);
        JSONUtilities.safePut(retrievalRecord, "clipboardCount", clipboardCount);
        JSONUtilities.safePut(retrievalRecord, "archiveCount", archiveCount);
    }

    private static boolean saveStream(InputStream stream, URL url, File rawDataDir, Progress progress, SavingUpdate update, ObjectNode fileRecord, ArrayNode fileRecords, long length) throws IOException {
        Object localname = url.getPath();
        if (((String)localname).isEmpty() || ((String)localname).endsWith("/")) {
            localname = (String)localname + "temp";
        }
        File file = ImportingUtilities.allocateFile(rawDataDir, (String)localname);
        JSONUtilities.safePut(fileRecord, "fileName", file.getName());
        JSONUtilities.safePut(fileRecord, "location", ImportingUtilities.getRelativePath(file, rawDataDir));
        update.totalExpectedSize += length;
        progress.setProgress("Downloading " + String.valueOf(url), ImportingUtilities.calculateProgressPercent(update.totalExpectedSize, update.totalRetrievedSize));
        long actualLength = ImportingUtilities.saveStreamToFile(stream, file, update);
        JSONUtilities.safePut(fileRecord, "size", actualLength);
        if (actualLength == 0L) {
            throw new IOException("No content found in " + String.valueOf(url));
        }
        update.totalExpectedSize = length >= 0L ? (update.totalExpectedSize += actualLength - length) : (update.totalExpectedSize += actualLength);
        progress.setProgress("Saving " + String.valueOf(url) + " locally", ImportingUtilities.calculateProgressPercent(update.totalExpectedSize, update.totalRetrievedSize));
        return ImportingUtilities.postProcessRetrievedFile(rawDataDir, file, fileRecord, fileRecords, progress);
    }

    public static String getRelativePath(File file, File dir) {
        String location = file.getAbsolutePath().substring(dir.getAbsolutePath().length());
        return location.startsWith(File.separator) ? location.substring(1) : location;
    }

    public static String normalizePath(String path) {
        String[] paths;
        FileSystem currentFileSystem = FileSystem.getCurrent();
        if (currentFileSystem != FileSystem.WINDOWS) {
            return path;
        }
        Object normalizedLocalName = "";
        String pathWithWSeparator = FilenameUtils.separatorsToWindows((String)path);
        String separator = String.format("\\%c", Character.valueOf(File.separatorChar));
        for (String p : paths = pathWithWSeparator.split(separator)) {
            if (p.equals("")) continue;
            p = currentFileSystem.toLegalFileName(p, '-');
            normalizedLocalName = (String)normalizedLocalName + String.format("%c%s", Character.valueOf(File.separatorChar), p);
        }
        return normalizedLocalName;
    }

    public static File allocateFile(File dir, String name) {
        File file;
        Path normalizedFile;
        int q = name.indexOf(63);
        if (q > 0) {
            name = name.substring(0, q);
        }
        if (!(normalizedFile = (file = new File(dir, name = ImportingUtilities.normalizePath(name))).toPath().normalize()).startsWith(String.valueOf(dir.toPath().normalize()) + File.separator)) {
            throw new IllegalArgumentException("Zip archives with files escaping their root directory are not allowed.");
        }
        Path normalizedParent = normalizedFile.getParent();
        String fileName = normalizedFile.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        String prefix = dot < 0 ? fileName : fileName.substring(0, dot);
        String suffix = dot < 0 ? "" : fileName.substring(dot);
        int index = 2;
        while (file.exists()) {
            file = normalizedParent.resolve(prefix + "-" + index++ + suffix).toFile();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    public static Reader getFileReader(ImportingJob job, ObjectNode fileRecord, String commonEncoding) throws FileNotFoundException {
        return ImportingUtilities.getFileReader(ImportingUtilities.getFile(job, JSONUtilities.getString((JsonNode)fileRecord, "location", "")), fileRecord, commonEncoding);
    }

    public static Reader getFileReader(File file, ObjectNode fileRecord, String commonEncoding) throws FileNotFoundException {
        return ImportingUtilities.getReaderFromStream(new FileInputStream(file), fileRecord, commonEncoding);
    }

    public static Reader getReaderFromStream(InputStream inputStream, ObjectNode fileRecord, String commonEncoding) {
        String encoding = ImportingUtilities.getEncoding(fileRecord);
        if (commonEncoding != null && !commonEncoding.equals(encoding)) {
            logger.info("Overriding guessed encoding {} with user's choice: {}", (Object)encoding, (Object)commonEncoding);
            encoding = commonEncoding;
        }
        try {
            return ImportingUtilities.getInputStreamReader(inputStream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + encoding, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception from UnicodeBOMInputStream", e);
        }
    }

    public static File getFile(ImportingJob job, ObjectNode fileRecord) {
        return ImportingUtilities.getFile(job, JSONUtilities.getString((JsonNode)fileRecord, "location", ""));
    }

    public static File getFile(ImportingJob job, String location) {
        return new File(job.getRawDataDir(), location);
    }

    public static String getFileSource(ObjectNode fileRecord) {
        return JSONUtilities.getString((JsonNode)fileRecord, "url", JSONUtilities.getString((JsonNode)fileRecord, "fileName", "unknown"));
    }

    public static String getFileName(ObjectNode fileRecord) {
        return JSONUtilities.getString((JsonNode)fileRecord, "fileName", "unknown");
    }

    public static String getArchiveFileName(ObjectNode fileRecord) {
        return JSONUtilities.getString((JsonNode)fileRecord, "archiveFileName", null);
    }

    public static boolean hasArchiveFileField(List<ObjectNode> fileRecords) {
        List filterResults = fileRecords.stream().filter(fileRecord -> ImportingUtilities.getArchiveFileName(fileRecord) != null).collect(Collectors.toList());
        return filterResults.size() > 0;
    }

    private static long saveStreamToFile(InputStream stream, File file, SavingUpdate update) throws IOException {
        long length = 0L;
        try (FileOutputStream fos = new FileOutputStream(file);){
            int c;
            byte[] bytes = new byte[16384];
            while (!(update != null && update.isCanceled() || (c = stream.read(bytes)) <= 0)) {
                fos.write(bytes, 0, c);
                length += (long)c;
                if (update == null) continue;
                update.totalRetrievedSize += (long)c;
                update.savedMore();
            }
            long l = length;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean postProcessRetrievedFile(File rawDataDir, File file, ObjectNode fileRecord, ArrayNode fileRecords, Progress progress) throws IOException {
        InputStream uncompressedIS;
        String contentEncoding;
        String mimeType = JSONUtilities.getString((JsonNode)fileRecord, "declaredMimeType", null);
        InputStream archiveIS = ImportingUtilities.tryOpenAsArchive(file, mimeType, contentEncoding = JSONUtilities.getString((JsonNode)fileRecord, "declaredEncoding", null));
        if (archiveIS != null) {
            try {
                if (ImportingUtilities.explodeArchive(rawDataDir, archiveIS, fileRecord, fileRecords, progress)) {
                    file.delete();
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                try {
                    archiveIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((uncompressedIS = ImportingUtilities.tryOpenAsCompressedFile(file, mimeType, contentEncoding)) != null) {
            try {
                File file2 = ImportingUtilities.uncompressFile(rawDataDir, uncompressedIS, fileRecord, progress);
                file.delete();
                file = file2;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    uncompressedIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        ImportingUtilities.postProcessSingleRetrievedFile(file, fileRecord);
        JSONUtilities.append(fileRecords, fileRecord);
        return false;
    }

    public static void postProcessSingleRetrievedFile(File file, ObjectNode fileRecord) {
        if (!fileRecord.has("format")) {
            JSONUtilities.safePut(fileRecord, "format", ImportingUtilities.guessBetterFormat(file, fileRecord));
        }
    }

    public static InputStream tryOpenAsArchive(File file, String mimeType) throws IOException {
        return ImportingUtilities.tryOpenAsArchive(file, mimeType, null);
    }

    public static InputStream tryOpenAsArchive(File file, String mimeType, String contentType) throws IOException {
        String fileName = file.getName();
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz") || ImportingUtilities.isFileGZipped(file)) {
            return new TarArchiveInputStream((InputStream)new GZIPInputStream(new FileInputStream(file)));
        }
        if (fileName.endsWith(".tar.bz2")) {
            return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(file)));
        }
        if (fileName.endsWith(".tar") || "application/x-tar".equals(contentType)) {
            return new TarArchiveInputStream((InputStream)new FileInputStream(file));
        }
        if (fileName.endsWith(".zip") || "application/x-zip-compressed".equals(contentType) || "application/zip".equals(contentType) || "application/x-compressed".equals(contentType) || "multipart/x-zip".equals(contentType)) {
            return new ZipInputStream(new FileInputStream(ImportingUtilities.checkValidZip(file)));
        }
        if (fileName.endsWith(".kmz")) {
            return new ZipInputStream(new FileInputStream(ImportingUtilities.checkValidZip(file)));
        }
        return null;
    }

    private static File checkValidZip(File file) throws IOException {
        try (ZipFile zf = new ZipFile(file);){
            if (!zf.entries().hasMoreElements()) {
                throw new IOException("Empty Zip file");
            }
        }
        return file;
    }

    private static boolean isFileGZipped(File file) {
        int magic = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return magic == 35615;
    }

    public static boolean isCompressed(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] magic = new byte[4];
            int count = ((InputStream)is).read(magic);
            if (count == 4 && Arrays.equals(magic, new byte[]{80, 75, 3, 4}) || Arrays.equals(magic, new byte[]{80, 75, 7, 8}) || magic[0] == 31 && magic[1] == -117 || magic[0] == 66 && magic[1] == 90 && magic[2] == 104) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean explodeArchive(File rawDataDir, InputStream archiveIS, ObjectNode archiveFileRecord, ArrayNode fileRecords, Progress progress) throws IOException {
        if (archiveIS instanceof TarArchiveInputStream) {
            TarArchiveInputStream tis = (TarArchiveInputStream)archiveIS;
            try {
                TarArchiveEntry te;
                while (!progress.isCanceled() && (te = tis.getNextEntry()) != null) {
                    if (te.isDirectory()) continue;
                    String fileName2 = te.getName();
                    File file2 = ImportingUtilities.allocateFile(rawDataDir, fileName2);
                    progress.setProgress("Extracting " + fileName2, -1);
                    ObjectNode fileRecord2 = ParsingUtilities.mapper.createObjectNode();
                    JSONUtilities.safePut(fileRecord2, "origin", JSONUtilities.getString((JsonNode)archiveFileRecord, "origin", null));
                    JSONUtilities.safePut(fileRecord2, "declaredEncoding", (String)null);
                    JSONUtilities.safePut(fileRecord2, "declaredMimeType", (String)null);
                    JSONUtilities.safePut(fileRecord2, "fileName", fileName2);
                    JSONUtilities.safePut(fileRecord2, "archiveFileName", JSONUtilities.getString((JsonNode)archiveFileRecord, "fileName", null));
                    JSONUtilities.safePut(fileRecord2, "location", ImportingUtilities.getRelativePath(file2, rawDataDir));
                    JSONUtilities.safePut(fileRecord2, "size", ImportingUtilities.saveStreamToFile((InputStream)tis, file2, null));
                    ImportingUtilities.postProcessSingleRetrievedFile(file2, fileRecord2);
                    JSONUtilities.append(fileRecords, fileRecord2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        if (archiveIS instanceof ZipInputStream) {
            ZipEntry ze;
            ZipInputStream zis = (ZipInputStream)archiveIS;
            while (!progress.isCanceled() && (ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                String fileName2 = ze.getName();
                File file2 = ImportingUtilities.allocateFile(rawDataDir, fileName2);
                progress.setProgress("Extracting " + fileName2, -1);
                ObjectNode fileRecord2 = ParsingUtilities.mapper.createObjectNode();
                JSONUtilities.safePut(fileRecord2, "origin", JSONUtilities.getString((JsonNode)archiveFileRecord, "origin", null));
                JSONUtilities.safePut(fileRecord2, "declaredEncoding", (String)null);
                JSONUtilities.safePut(fileRecord2, "declaredMimeType", (String)null);
                JSONUtilities.safePut(fileRecord2, "fileName", fileName2);
                JSONUtilities.safePut(fileRecord2, "archiveFileName", JSONUtilities.getString((JsonNode)archiveFileRecord, "fileName", null));
                JSONUtilities.safePut(fileRecord2, "location", ImportingUtilities.getRelativePath(file2, rawDataDir));
                JSONUtilities.safePut(fileRecord2, "size", ImportingUtilities.saveStreamToFile(zis, file2, null));
                ImportingUtilities.postProcessSingleRetrievedFile(file2, fileRecord2);
                JSONUtilities.append(fileRecords, fileRecord2);
            }
            return true;
        }
        return false;
    }

    public static InputStream tryOpenAsCompressedFile(File file, String mimeType) {
        return ImportingUtilities.tryOpenAsCompressedFile(file, mimeType, null);
    }

    public static InputStream tryOpenAsCompressedFile(File file, String mimeType, String contentEncoding) {
        String fileName = file.getName();
        try {
            if (fileName.endsWith(".gz") || ImportingUtilities.isFileGZipped(file) || "gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding) || "application/x-gzip".equals(mimeType)) {
                return new GZIPInputStream(new FileInputStream(file));
            }
            if (fileName.endsWith(".bz2") || "application/x-bzip2".equals(mimeType)) {
                return new BZip2CompressorInputStream((InputStream)new FileInputStream(file), true);
            }
        }
        catch (IOException e) {
            logger.warn("Something that looked like a compressed file gave an error on open: " + String.valueOf(file), (Throwable)e);
        }
        return null;
    }

    public static File uncompressFile(File rawDataDir, InputStream uncompressedIS, ObjectNode fileRecord, Progress progress) throws IOException {
        String fileName = JSONUtilities.getString((JsonNode)fileRecord, "location", "unknown");
        for (String ext : new String[]{".gz", ".bz2"}) {
            if (!fileName.endsWith(ext)) continue;
            fileName = fileName.substring(0, fileName.length() - ext.length());
            break;
        }
        File file2 = ImportingUtilities.allocateFile(rawDataDir, fileName);
        progress.setProgress("Uncompressing " + fileName, -1);
        ImportingUtilities.saveStreamToFile(uncompressedIS, file2, null);
        JSONUtilities.safePut(fileRecord, "declaredEncoding", (String)null);
        JSONUtilities.safePut(fileRecord, "declaredMimeType", (String)null);
        JSONUtilities.safePut(fileRecord, "location", ImportingUtilities.getRelativePath(file2, rawDataDir));
        return file2;
    }

    private static int calculateProgressPercent(long totalExpectedSize, long totalRetrievedSize) {
        return totalExpectedSize == 0L ? -1 : (int)(totalRetrievedSize * 100L / totalExpectedSize);
    }

    private static String formatBytes(long bytes) {
        return NumberFormat.getIntegerInstance().format(bytes);
    }

    public static String getEncoding(ObjectNode firstFileRecord) {
        String encoding = JSONUtilities.getString((JsonNode)firstFileRecord, "encoding", null);
        if (encoding == null || encoding.isEmpty()) {
            encoding = JSONUtilities.getString((JsonNode)firstFileRecord, "declaredEncoding", null);
        }
        return encoding;
    }

    public static String autoSelectFiles(ImportingJob job, ObjectNode retrievalRecord, ArrayNode fileSelectionIndexes) {
        String bestFormat;
        block6: {
            int i;
            int count;
            ArrayNode fileRecords;
            block5: {
                final HashMap<String, Integer> formatToCount = new HashMap<String, Integer>();
                ArrayList<String> formats = new ArrayList<String>();
                fileRecords = JSONUtilities.getArray(retrievalRecord, "files");
                count = fileRecords.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    ObjectNode fileRecord = JSONUtilities.getObjectElement(fileRecords, i2);
                    String format = JSONUtilities.getString((JsonNode)fileRecord, "format", null);
                    if (format == null) continue;
                    if (formatToCount.containsKey(format)) {
                        formatToCount.put(format, (Integer)formatToCount.get(format) + 1);
                        continue;
                    }
                    formatToCount.put(format, 1);
                    formats.add(format);
                }
                Collections.sort(formats, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return (Integer)formatToCount.get(o2) - (Integer)formatToCount.get(o1);
                    }
                });
                String string = bestFormat = formats.size() > 0 ? (String)formats.get(0) : "text";
                if (JSONUtilities.getInt((JsonNode)retrievalRecord, "archiveCount", 0) != 0) break block5;
                for (int i3 = 0; i3 < count; ++i3) {
                    JSONUtilities.append(fileSelectionIndexes, i3);
                }
                break block6;
            }
            for (i = 0; i < count; ++i) {
                ObjectNode fileRecord = JSONUtilities.getObjectElement(fileRecords, i);
                String format = JSONUtilities.getString((JsonNode)fileRecord, "format", null);
                if (format == null || !format.equals(bestFormat)) continue;
                JSONUtilities.append(fileSelectionIndexes, i);
            }
            if (fileSelectionIndexes.size() != 0 || count <= 0) break block6;
            for (i = 0; i < count; ++i) {
                JSONUtilities.append(fileSelectionIndexes, i);
            }
        }
        return bestFormat;
    }

    public static String getCommonFormatForSelectedFiles(ImportingJob job, ArrayNode fileSelectionIndexes) {
        ObjectNode retrievalRecord = job.getRetrievalRecord();
        final HashMap<String, Integer> formatToCount = new HashMap<String, Integer>();
        ArrayList<String> formats = new ArrayList<String>();
        ArrayNode fileRecords = JSONUtilities.getArray(retrievalRecord, "files");
        int count = fileSelectionIndexes.size();
        for (int i = 0; i < count; ++i) {
            ObjectNode fileRecord;
            String format;
            int index = JSONUtilities.getIntElement(fileSelectionIndexes, i, -1);
            if (index < 0 || index >= fileRecords.size() || (format = JSONUtilities.getString((JsonNode)(fileRecord = JSONUtilities.getObjectElement(fileRecords, index)), "format", null)) == null) continue;
            if (formatToCount.containsKey(format)) {
                formatToCount.put(format, (Integer)formatToCount.get(format) + 1);
                continue;
            }
            formatToCount.put(format, 1);
            formats.add(format);
        }
        Collections.sort(formats, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (Integer)formatToCount.get(o2) - (Integer)formatToCount.get(o1);
            }
        });
        return formats.size() > 0 ? (String)formats.get(0) : null;
    }

    static String guessBetterFormat(ImportingJob job, String bestFormat) {
        ObjectNode retrievalRecord = job.getRetrievalRecord();
        return retrievalRecord != null ? ImportingUtilities.guessBetterFormat(job, retrievalRecord, bestFormat) : bestFormat;
    }

    static String guessBetterFormat(ImportingJob job, ObjectNode retrievalRecord, String bestFormat) {
        ArrayNode fileRecords = JSONUtilities.getArray(retrievalRecord, "files");
        return fileRecords != null ? ImportingUtilities.guessBetterFormat(job, fileRecords, bestFormat) : bestFormat;
    }

    static String guessBetterFormat(ImportingJob job, ArrayNode fileRecords, String bestFormat) {
        if (bestFormat != null && fileRecords != null && fileRecords.size() > 0) {
            ObjectNode firstFileRecord = JSONUtilities.getObjectElement(fileRecords, 0);
            String encoding = ImportingUtilities.getEncoding(firstFileRecord);
            String location = JSONUtilities.getString((JsonNode)firstFileRecord, "location", null);
            if (location != null) {
                File file = new File(job.getRawDataDir(), location);
                bestFormat = ImportingUtilities.guessBetterFormat(file, encoding, bestFormat);
            }
        }
        return bestFormat;
    }

    static String guessBetterFormat(File file, String fileEncoding, String bestFormat) {
        if (bestFormat != null && file != null) {
            while (true) {
                String betterFormat = null;
                List<FormatGuesser> guessers = ImportingManager.formatToGuessers.get(bestFormat);
                if (guessers != null) {
                    FormatGuesser guesser;
                    Iterator<FormatGuesser> iterator = guessers.iterator();
                    while (iterator.hasNext() && (betterFormat = (guesser = iterator.next()).guess(file, fileEncoding, bestFormat)) == null) {
                    }
                }
                if (betterFormat == null || betterFormat.equals(bestFormat)) break;
                bestFormat = betterFormat;
            }
        }
        return bestFormat;
    }

    static String guessBetterFormat(File file, ObjectNode fileRecord) {
        String encoding = JSONUtilities.getString((JsonNode)fileRecord, "declaredEncoding", null);
        String bestFormat = ImportingManager.getFormat(file.getName(), JSONUtilities.getString((JsonNode)fileRecord, "declaredMimeType", null));
        bestFormat = bestFormat == null ? "text" : bestFormat;
        return ImportingUtilities.guessBetterFormat(file, encoding, bestFormat);
    }

    static void rankFormats(ImportingJob job, final String bestFormat, ArrayNode rankedFormats) {
        final HashMap<String, String[]> formatToSegments = new HashMap<String, String[]>();
        boolean download = bestFormat == null ? true : ImportingManager.formatToRecord.get((Object)bestFormat).download;
        ArrayList<String> formats = new ArrayList<String>(ImportingManager.formatToRecord.keySet().size());
        for (String format : ImportingManager.formatToRecord.keySet()) {
            ImportingManager.Format record = ImportingManager.formatToRecord.get(format);
            if (record.uiClass == null || record.parser == null || record.download != download) continue;
            formats.add(format);
            formatToSegments.put(format, format.split("/"));
        }
        if (bestFormat == null) {
            Collections.sort(formats);
        } else {
            Collections.sort(formats, new Comparator<String>(){

                @Override
                public int compare(String format1, String format2) {
                    if (format1.equals(bestFormat)) {
                        return -1;
                    }
                    if (format2.equals(bestFormat)) {
                        return 1;
                    }
                    return this.compareBySegments(format1, format2);
                }

                int compareBySegments(String format1, String format2) {
                    int c = this.commonSegments(format2) - this.commonSegments(format1);
                    return c != 0 ? c : format1.compareTo(format2);
                }

                int commonSegments(String format) {
                    int i;
                    String[] bestSegments = (String[])formatToSegments.get(bestFormat);
                    String[] segments = (String[])formatToSegments.get(format);
                    if (bestSegments == null || segments == null) {
                        return 0;
                    }
                    for (i = 0; i < bestSegments.length && i < segments.length && bestSegments[i].equals(segments[i]); ++i) {
                    }
                    return i;
                }
            });
        }
        for (String format : formats) {
            rankedFormats.add(format);
        }
    }

    public static void previewParse(ImportingJob job, String format, ObjectNode optionObj, List<Exception> exceptions) {
        ImportingManager.Format record = ImportingManager.formatToRecord.get(format);
        if (record == null || record.parser == null) {
            return;
        }
        job.prepareNewProject();
        record.parser.parse(job.project, job.metadata, job, job.getSelectedFileRecords(), format, 100, optionObj, exceptions);
        job.project.update();
    }

    public static long createProject(final ImportingJob job, final String format, final ObjectNode optionObj, final List<Exception> exceptions, boolean synchronous) {
        final ImportingManager.Format record = ImportingManager.formatToRecord.get(format);
        if (record == null || record.parser == null) {
            return -1L;
        }
        job.setState("creating-project");
        final Project project = new Project();
        if (synchronous) {
            ImportingUtilities.createProjectSynchronously(job, format, optionObj, exceptions, record, project);
        } else {
            new Thread(){

                @Override
                public void run() {
                    ImportingUtilities.createProjectSynchronously(job, format, optionObj, exceptions, record, project);
                }
            }.start();
        }
        return project.id;
    }

    private static void createProjectSynchronously(ImportingJob job, String format, ObjectNode optionObj, List<Exception> exceptions, ImportingManager.Format record, Project project) {
        ProjectMetadata pm = ImportingUtilities.createProjectMetadata(optionObj);
        record.parser.parse(project, pm, job, job.getSelectedFileRecords(), format, -1, optionObj, exceptions);
        if (!job.canceled) {
            if (exceptions.size() == 0) {
                project.update();
                ProjectManager.singleton.registerProject(project, pm);
                job.setProjectID(project.id);
                job.setState("created-project");
            } else {
                job.setError(exceptions);
            }
            job.touch();
            job.updating = false;
        }
    }

    public static ProjectMetadata createProjectMetadata(ObjectNode optionObj) {
        ProjectMetadata pm = new ProjectMetadata();
        pm.setName(JSONUtilities.getString((JsonNode)optionObj, "projectName", "Untitled"));
        pm.setTags(JSONUtilities.getStringArray(optionObj, "projectTags"));
        pm.setDescription(JSONUtilities.getString((JsonNode)optionObj, "projectDescription", ""));
        pm.setCreator(JSONUtilities.getString((JsonNode)optionObj, "projectCreator", ""));
        String encoding = JSONUtilities.getString((JsonNode)optionObj, "encoding", "UTF-8");
        if ("".equals(encoding)) {
            encoding = "UTF-8";
        }
        pm.setEncoding(encoding);
        return pm;
    }

    public static InputStreamReader getInputStreamReader(InputStream is, String encoding) throws IOException {
        if (encoding == null) {
            return new InputStreamReader(is);
        }
        if ("UTF-8-BOM".equals(encoding)) {
            return new InputStreamReader((InputStream)new UnicodeBOMInputStream(is, true), StandardCharsets.UTF_8);
        }
        return new InputStreamReader(is, encoding);
    }

    public static interface Progress {
        public void setProgress(String var1, int var2);

        public boolean isCanceled();
    }

    private static abstract class SavingUpdate {
        public long totalExpectedSize = 0L;
        public long totalRetrievedSize = 0L;

        private SavingUpdate() {
        }

        public abstract void savedMore();

        public abstract boolean isCanceled();
    }
}

