/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.util.JSONUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.universalchardet.UnicodeBOMInputStream;
import org.mozilla.universalchardet.UniversalDetector;

public final class EncodingGuesser {
    public static final String UTF_8_BOM = "UTF-8-BOM";

    public static void guess(ImportingJob job) throws IOException {
        ArrayNode fileRecords;
        ObjectNode retrievalRecord = job.getRetrievalRecord();
        if (retrievalRecord != null && (fileRecords = JSONUtilities.getArray(retrievalRecord, "files")) != null) {
            EncodingGuesser.guessFilesEncodings(job, fileRecords);
        }
    }

    private static void guessFilesEncodings(ImportingJob job, ArrayNode fileRecords) throws IOException {
        for (int i = 0; i < fileRecords.size(); ++i) {
            String detected;
            String location;
            ObjectNode record = JSONUtilities.getObjectElement(fileRecords, i);
            String encoding = ImportingUtilities.getEncoding(record);
            if (!StringUtils.isBlank((CharSequence)encoding) || (location = JSONUtilities.getString((JsonNode)record, "location", null)) == null || (detected = EncodingGuesser.guessEncoding(job.getRawDataDir(), location)) == null) continue;
            JSONUtilities.safePut(record, "encoding", detected);
        }
    }

    public static String guessEncoding(File dir, String location) throws IOException {
        try (UnicodeBOMInputStream is = new UnicodeBOMInputStream((InputStream)new FileInputStream(new File(dir, location)), false);){
            String detected = UniversalDetector.detectCharset((InputStream)is);
            if (UnicodeBOMInputStream.BOM.UTF_8.equals(is.getBOM())) {
                detected = UTF_8_BOM;
            }
            String string = detected;
            return string;
        }
    }

    public static void guessInitialEncoding(List<ObjectNode> fileRecords, ObjectNode options) {
        if (fileRecords != null) {
            for (ObjectNode record : fileRecords) {
                String encoding = JSONUtilities.getString((JsonNode)record, "encoding", null);
                if (StringUtils.isBlank((CharSequence)encoding)) continue;
                JSONUtilities.safePut(options, "encoding", encoding);
                break;
            }
        }
    }
}

