/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.RefineServlet;
import com.google.refine.commands.Command;
import com.google.refine.importing.ImportingController;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultImportingController
extends Command
implements ImportingController {
    protected RefineServlet servlet;

    @Override
    public void init(RefineServlet servlet) {
        this.servlet = servlet;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("GET verb not implemented");
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> parameters = ParsingUtilities.parseParameters(request);
        String subCommand = parameters.get("subCommand");
        if ("load-raw-data".equals(subCommand)) {
            this.doLoadRawData(request, response, parameters);
        } else if ("update-file-selection".equals(subCommand)) {
            this.doUpdateFileSelection(request, response, parameters);
        } else if ("initialize-parser-ui".equals(subCommand)) {
            this.doInitializeParserUI(request, response, parameters);
        } else if ("update-format-and-options".equals(subCommand)) {
            this.doUpdateFormatAndOptions(request, response, parameters);
        } else if ("create-project".equals(subCommand)) {
            this.doCreateProject(request, response, parameters);
        } else {
            DefaultImportingController.respondStatusError(response, "No such sub command");
        }
    }

    private void doLoadRawData(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws ServletException, IOException {
        long jobID = Long.parseLong(parameters.get("jobID"));
        ImportingJob job = ImportingManager.getJob(jobID);
        if (job == null) {
            DefaultImportingController.respondStatusError(response, "No such import job");
            return;
        }
        job.updating = true;
        ObjectNode config = job.getOrCreateDefaultConfig();
        if (!"new".equals(JSONUtilities.getString((JsonNode)config, "state", null))) {
            DefaultImportingController.respondStatusError(response, "Job already started; cannot load more data");
            return;
        }
        ImportingUtilities.loadDataAndPrepareJob(request, response, parameters, job, config);
        job.touch();
        job.updating = false;
    }

    private void doUpdateFileSelection(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws ServletException, IOException {
        ArrayNode fileRecords;
        ObjectNode retrievalRecord;
        long jobID = Long.parseLong(parameters.get("jobID"));
        ImportingJob job = ImportingManager.getJob(jobID);
        if (job == null) {
            DefaultImportingController.respondStatusError(response, "No such import job");
            return;
        }
        job.updating = true;
        ObjectNode config = job.getOrCreateDefaultConfig();
        if (!"ready".equals(JSONUtilities.getString((JsonNode)config, "state", null))) {
            DefaultImportingController.respondStatusError(response, "Job not ready");
            return;
        }
        ArrayNode fileSelectionArray = ParsingUtilities.evaluateJsonStringToArrayNode(request.getParameter("fileSelection"));
        String sortCriteria = request.getParameter("sortCriteria");
        String sortOrder = request.getParameter("sortOrder");
        if (sortCriteria != null && sortOrder != null && (retrievalRecord = job.getRetrievalRecord()) != null && (fileRecords = JSONUtilities.getArray(retrievalRecord, "files")) != null) {
            ArrayList<ObjectNode> fileList = new ArrayList<ObjectNode>();
            for (int i = 0; i < fileRecords.size(); ++i) {
                fileList.add((ObjectNode)fileRecords.get(i));
            }
            fileList.sort((o1, o2) -> {
                int comparison = 0;
                switch (sortCriteria) {
                    case "fileName": {
                        comparison = o1.get("fileName").asText().compareTo(o2.get("fileName").asText());
                        break;
                    }
                    case "fileSize": {
                        comparison = Long.compare(o1.get("size").asLong(), o2.get("size").asLong());
                    }
                }
                return "desc".equals(sortOrder) ? -comparison : comparison;
            });
            fileRecords.removeAll();
            for (ObjectNode fileObject : fileList) {
                fileRecords.add((JsonNode)fileObject);
            }
        }
        ImportingUtilities.updateJobWithNewFileSelection(job, fileSelectionArray);
        this.replyWithJobData(request, response, job);
        job.touch();
        job.updating = false;
    }

    private void doUpdateFormatAndOptions(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws ServletException, IOException {
        long jobID = Long.parseLong(parameters.get("jobID"));
        ImportingJob job = ImportingManager.getJob(jobID);
        if (job == null) {
            DefaultImportingController.respondStatusError(response, "No such import job");
            return;
        }
        job.updating = true;
        ObjectNode config = job.getOrCreateDefaultConfig();
        if (!"ready".equals(JSONUtilities.getString((JsonNode)config, "state", null))) {
            DefaultImportingController.respondStatusError(response, "Job not ready");
            return;
        }
        String format = request.getParameter("format");
        ObjectNode optionObj = ParsingUtilities.evaluateJsonStringToObjectNode(request.getParameter("options"));
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        ImportingUtilities.previewParse(job, format, optionObj, exceptions);
        try {
            if (exceptions.size() == 0) {
                job.project.update();
                DefaultImportingController.respondStatusOk(response);
            } else {
                DefaultImportingController.respondStatusErrors(response, exceptions);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        job.touch();
        job.updating = false;
    }

    private void doInitializeParserUI(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws ServletException, IOException {
        long jobID = Long.parseLong(parameters.get("jobID"));
        ImportingJob job = ImportingManager.getJob(jobID);
        if (job == null) {
            DefaultImportingController.respondStatusError(response, "No such import job");
            return;
        }
        String format = request.getParameter("format");
        ImportingManager.Format formatRecord = ImportingManager.formatToRecord.get(format);
        if (formatRecord != null && formatRecord.parser != null) {
            ObjectNode options = formatRecord.parser.createParserUIInitializationData(job, job.getSelectedFileRecords(), format);
            String error = JSONUtilities.getString((JsonNode)options, "error", null);
            if (error != null) {
                DefaultImportingController.respondStatusError(response, "Error during initialization - " + error);
            } else {
                DefaultImportingController.respondJSON(response, Map.of("status", "ok", "options", options));
            }
        } else {
            DefaultImportingController.respondStatusError(response, "Unrecognized format or format has no parser");
        }
    }

    private void doCreateProject(HttpServletRequest request, HttpServletResponse response, Map<String, String> parameters) throws ServletException, IOException {
        long jobID = Long.parseLong(parameters.get("jobID"));
        ImportingJob job = ImportingManager.getJob(jobID);
        if (job == null) {
            DefaultImportingController.respondStatusError(response, "No such import job");
            return;
        }
        job.updating = true;
        job.touch();
        ObjectNode config = job.getOrCreateDefaultConfig();
        if (!"ready".equals(JSONUtilities.getString((JsonNode)config, "state", null))) {
            DefaultImportingController.respondStatusError(response, "Job not ready");
            return;
        }
        String format = request.getParameter("format");
        ObjectNode optionObj = ParsingUtilities.evaluateJsonStringToObjectNode(request.getParameter("options"));
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        ImportingUtilities.createProject(job, format, optionObj, exceptions, false);
        DefaultImportingController.respondOkDone(response);
    }

    private void replyWithJobData(HttpServletRequest request, HttpServletResponse response, ImportingJob job) throws ServletException, IOException {
        DefaultImportingController.respondJSON(response, new JobResponse("ok", job));
    }

    @Deprecated
    public static void writeErrors(JsonGenerator writer, List<Exception> exceptions) throws IOException {
        for (Exception e : exceptions) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            writer.writeStartObject();
            writer.writeStringField("message", e.getLocalizedMessage());
            writer.writeStringField("stack", sw.toString());
            writer.writeEndObject();
        }
    }

    public static ArrayNode convertErrorsToJsonArray(List<Exception> exceptions) {
        ArrayNode a = ParsingUtilities.mapper.createArrayNode();
        for (Exception e : exceptions) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ObjectNode o = ParsingUtilities.mapper.createObjectNode();
            JSONUtilities.safePut(o, "message", e.getLocalizedMessage());
            JSONUtilities.safePut(o, "stack", sw.toString());
            JSONUtilities.append(a, o);
        }
        return a;
    }

    protected static class JobResponse {
        @JsonProperty(value="code")
        protected String code;
        @JsonProperty(value="job")
        protected ImportingJob job;

        protected JobResponse(String code, ImportingJob job) {
            this.code = code;
            this.job = job;
        }
    }
}

