/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers.tree;

import com.google.refine.importers.tree.ImportColumn;
import com.google.refine.importers.tree.ImportVertical;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ImportColumnGroup
extends ImportVertical {
    public Map<String, ImportColumnGroup> subgroups = new LinkedHashMap<String, ImportColumnGroup>();
    public Map<String, ImportColumn> columns = new LinkedHashMap<String, ImportColumn>();
    public int nextRowIndex;

    @Override
    void tabulate() {
        for (ImportColumn c : this.columns.values()) {
            c.tabulate();
            this.nonBlankCount = Math.max(this.nonBlankCount, c.nonBlankCount);
        }
        for (ImportColumnGroup g : this.subgroups.values()) {
            g.tabulate();
            this.nonBlankCount = Math.max(this.nonBlankCount, g.nonBlankCount);
        }
    }

    @Override
    public String toString() {
        return String.format("name=%s, nextRowIndex=%d, columns={%s}, subgroups={{%s}}", this.name, this.nextRowIndex, StringUtils.join(this.columns.keySet(), (char)','), StringUtils.join(this.subgroups.keySet(), (char)','));
    }
}

