/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.common.base.CharMatcher;
import com.google.refine.importing.FormatGuesser;
import com.google.refine.importing.ImportingUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;

public class TextFormatGuesser
implements FormatGuesser {
    private static final int XML_BRACKETS_THRESHOLD = 5;
    private static final int JSON_BRACES_THRESHOLD = 5;
    private static final long CONTROLS_THRESHOLD = 10L;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String guess(File file, String encoding, String seedFormat) {
        try (FileInputStream fis = new FileInputStream(file);){
            BufferedReader reader;
            block34: {
                int firstChar;
                block37: {
                    int trailingPeriods;
                    int closeAngleBrackets;
                    int openAngleBrackets;
                    block36: {
                        int closeBraces;
                        long openBraces;
                        block35: {
                            boolean foundFirstChar;
                            int wikiTableRow;
                            int wikiTableEnd;
                            int wikiTableBegin;
                            block33: {
                                String string;
                                if (ImportingUtilities.isCompressed(file)) {
                                    String string2 = "binary";
                                    return string2;
                                }
                                BoundedInputStream bis = new BoundedInputStream((InputStream)fis, 65536L);
                                reader = new BufferedReader(ImportingUtilities.getInputStreamReader((InputStream)bis, encoding));
                                try {
                                    String line;
                                    int totalChars = 0;
                                    openBraces = 0L;
                                    closeBraces = 0;
                                    openAngleBrackets = 0;
                                    closeAngleBrackets = 0;
                                    wikiTableBegin = 0;
                                    wikiTableEnd = 0;
                                    wikiTableRow = 0;
                                    trailingPeriods = 0;
                                    int controls = 0;
                                    firstChar = 32;
                                    foundFirstChar = false;
                                    while ((line = reader.readLine()) != null && (long)controls < 10L) {
                                        line = CharMatcher.whitespace().trimFrom((CharSequence)line);
                                        controls += CharMatcher.javaIsoControl().and(CharMatcher.whitespace().negate()).countIn((CharSequence)line);
                                        openBraces += line.chars().filter(ch -> ch == 123).count();
                                        closeBraces += StringUtils.countMatches((CharSequence)line, (CharSequence)"}");
                                        openAngleBrackets += StringUtils.countMatches((CharSequence)line, (CharSequence)"<");
                                        closeAngleBrackets += StringUtils.countMatches((CharSequence)line, (CharSequence)">");
                                        if (line.startsWith("{|")) {
                                            ++wikiTableBegin;
                                        } else if (line.startsWith("|}")) {
                                            ++wikiTableEnd;
                                        } else if (line.startsWith("|-")) {
                                            ++wikiTableRow;
                                        }
                                        if (line.endsWith(".")) {
                                            ++trailingPeriods;
                                        }
                                        if (!foundFirstChar && line.length() > 0) {
                                            firstChar = line.charAt(0);
                                            foundFirstChar = true;
                                        }
                                        totalChars += line.length();
                                    }
                                    if ((long)controls < 10L) break block33;
                                    string = "binary";
                                }
                                catch (Throwable throwable) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                reader.close();
                                return string;
                            }
                            if (!foundFirstChar) break block34;
                            if (wikiTableBegin < true || wikiTableBegin - wikiTableEnd > 1 || wikiTableRow < 2) break block35;
                            String string = "text/wiki";
                            reader.close();
                            return string;
                        }
                        if (firstChar != 123 && firstChar != 91 || openBraces < 5L || closeBraces < 5) break block36;
                        String string = "text/json";
                        reader.close();
                        return string;
                    }
                    if (openAngleBrackets < 5 || closeAngleBrackets < 5) break block34;
                    if (trailingPeriods <= 0) break block37;
                    String string = "text/rdf/n3";
                    reader.close();
                    return string;
                }
                if (firstChar != 60) break block34;
                String string = "text/xml";
                reader.close();
                return string;
            }
            String string = "text/line-based";
            reader.close();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

